/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.sys.bill.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.redis.JedisClientWrapper;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisTracker;
import kd.bos.redis.wrapper.ClusterJedisClient;
import kd.bos.redis.wrapper.CommonJedisClient;
import kd.bos.redis.wrapper.ShardedJedisClient;
import org.apache.commons.lang3.StringUtils;

public class CacheHelper {
    private static final Log LOG = LogFactory.getLog(CacheHelper.class);
    private static LocalMemoryCache localcache = null;
    public static final String EMPTY_STR = "\u25cf\u25c6\u25a0";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("imc");

    private static LocalMemoryCache getLocalMemoryCache() {
        if (localcache != null) {
            return localcache;
        }
        CacheConfigInfo localConfig = new CacheConfigInfo();
        localConfig.setMaxItemSize(5000);
        localConfig.setTimeout(180);
        localConfig.setTimeToLive(true);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("imc_region", "bdm", localConfig);
    }

    public static <T> T getLocalCache(String key) {
        localcache = CacheHelper.getLocalMemoryCache();
        return (T)localcache.get(CacheHelper.getCachePrefix() + key);
    }

    public static void putLocalCache(String key, Object val) {
        localcache = CacheHelper.getLocalMemoryCache();
        localcache.put(CacheHelper.getCachePrefix() + key, val);
    }

    public static void removeLocalCache(String key) {
        localcache = CacheHelper.getLocalMemoryCache();
        localcache.remove(new String[]{CacheHelper.getCachePrefix() + key});
    }

    public static String getCachePrefix() {
        return RequestContext.get().getTenantId() + '_' + RequestContext.get().getAccountId() + '_';
    }

    public static void put(String key, String content, int timeOut) {
        cache.put(CacheHelper.getCachePrefix() + key, (Object)content, timeOut);
    }

    public static void put(String key, String content) {
        cache.put(CacheHelper.getCachePrefix() + key, (Object)content);
    }

    public static String get(String key) {
        return CacheHelper.get(key, false);
    }

    public static String get(String key, boolean loadLocal) {
        String val;
        if (!loadLocal) {
            return (String)cache.get(CacheHelper.getCachePrefix() + key);
        }
        if (localcache == null) {
            localcache = CacheHelper.getLocalMemoryCache();
        }
        if (EMPTY_STR.equals(val = (String)localcache.get(key = CacheHelper.getCachePrefix() + key))) {
            return "{}";
        }
        if (StringUtils.isNotBlank((CharSequence)val)) {
            return val;
        }
        val = (String)cache.get(key);
        if (StringUtils.isBlank((CharSequence)val)) {
            return val;
        }
        localcache.put(key, (Object)val);
        return val;
    }

    public static void remove(String key) {
        cache.remove(CacheHelper.getCachePrefix() + key);
    }

    public static int addToSet(String key, String[] arr) {
        return cache.addToSet(CacheHelper.getCachePrefix() + key, arr);
    }

    public static String[] getSetValues(String key) {
        return cache.getSetValues(CacheHelper.getCachePrefix() + key);
    }

    public static void removeAllSetValues(String key) {
        key = CacheHelper.getCachePrefix() + key;
        String[] setValues = cache.getSetValues(key);
        if (setValues != null && setValues.length != 0) {
            cache.removeSetValues(key, setValues);
        }
    }

    private static JedisClient getJedisClient(String cacheKey) {
        String className = null;
        try {
            Class<?> classType = cache.getClass();
            className = classType.getName();
            if (CacheHelper.isXCacheWhiteListCacheWrapper(className)) {
                Method chooseCache = classType.getDeclaredMethod("chooseCache", String.class);
                ReflectionUtils.makeAccessible((Method)chooseCache);
                DistributeSessionlessCache distributeSessionlessCache = (DistributeSessionlessCache)chooseCache.invoke((Object)cache, cacheKey);
                return CacheHelper.getJedisClient(distributeSessionlessCache);
            }
            return CacheHelper.getJedisClient(cache);
        }
        catch (Exception e) {
            LOG.info("\u5ba2\u6237\u7aef\u83b7\u53d6\u5931\u8d25{},{}", (Object)className, (Object)e);
            return null;
        }
    }

    private static boolean isXCacheWhiteListCacheWrapper(String className) {
        return "kd.bos.cache.XCacheWhiteListCacheWrapper".equals(className);
    }

    private static JedisClient getJedisClient(DistributeSessionlessCache distributeSessionlessCache) {
        String className = null;
        try {
            Class<?> classType = distributeSessionlessCache.getClass();
            className = classType.getName();
            Class<?> superclassType = classType.getSuperclass();
            Method method = superclassType.getDeclaredMethod("getJedis", new Class[0]);
            ReflectionUtils.makeAccessible((Method)method);
            JedisClient client = (JedisClient)method.invoke((Object)distributeSessionlessCache, new Object[0]);
            if (client instanceof JedisClientWrapper) {
                JedisClientWrapper jedisClientWrapper = (JedisClientWrapper)client;
                Class<JedisClientWrapper> jedisClientWrapperClass = JedisClientWrapper.class;
                Field field = jedisClientWrapperClass.getDeclaredField("jedis");
                ReflectionUtils.makeAccessible((Field)field);
                Object jedis = field.get(jedisClientWrapper);
                Object originalObject = RedisTracker.getOriginalObject((Object)jedis);
                if (originalObject instanceof CommonJedisClient) {
                    return (CommonJedisClient)originalObject;
                }
                if (originalObject instanceof ShardedJedisClient) {
                    return (ShardedJedisClient)originalObject;
                }
                if (originalObject instanceof ClusterJedisClient) {
                    return (ClusterJedisClient)originalObject;
                }
                LOG.info("\u5ba2\u6237\u7aef\u7c7b\u578b\u9519\u8bef{}", originalObject);
            }
        }
        catch (Exception e) {
            LOG.info("\u5ba2\u6237\u7aef\u83b7\u53d6\u5931\u8d25{},{}", (Object)className, (Object)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long lpush(String cachekey, String ... string) {
        try (JedisClient jedisClient = CacheHelper.getJedisClient(cachekey);){
            Long var23;
            if (jedisClient != null) {
                cachekey = CacheHelper.getCachePrefix() + cachekey;
                if (jedisClient instanceof CommonJedisClient) {
                    Long var22;
                    Long l = var22 = ((CommonJedisClient)jedisClient).lpush(cachekey, string);
                    return l;
                }
                if (jedisClient instanceof ShardedJedisClient) {
                    Long var21;
                    Long l = var21 = ((ShardedJedisClient)jedisClient).lpush(cachekey, string);
                    return l;
                }
                if (jedisClient instanceof ClusterJedisClient) {
                    Long var4;
                    Long l = var4 = ((ClusterJedisClient)jedisClient).lpush(cachekey, string);
                    return l;
                }
                LOG.info("\u5ba2\u6237\u7aef\u83b7\u53d6\u5931\u8d25{}", (Object)jedisClient.getClass().getName());
            } else {
                LOG.info("\u5ba2\u6237\u7aef\u83b7\u53d6\u4e3a\u7a7a");
            }
            Long l = var23 = Long.valueOf(-1L);
            return l;
        }
        catch (Exception e) {
            LOG.info("\u5ba2\u6237\u7aef\u83b7\u53d6\u5931\u8d25" + e);
            return -1L;
        }
    }

    public static String rpop(String cachekey) {
        try (JedisClient jedisClient = CacheHelper.getJedisClient(cachekey);){
            if (jedisClient != null) {
                cachekey = CacheHelper.getCachePrefix() + cachekey;
                if (jedisClient instanceof CommonJedisClient) {
                    String string = jedisClient.rpop(cachekey);
                    return string;
                }
                if (jedisClient instanceof ShardedJedisClient) {
                    String string = jedisClient.rpop(cachekey);
                    return string;
                }
                if (jedisClient instanceof ClusterJedisClient) {
                    String string = jedisClient.rpop(cachekey);
                    return string;
                }
            }
            String string = null;
            return string;
        }
    }
}

