/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.sys.bill.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;

public class DateUtils {
    public static final String YYYYMM = "yyyyMM";
    public static final String YYYY_MM = "yyyy-MM";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String YYYY = "yyyy";
    public static final String MM = "MM";
    public static final String DD = "dd";

    public static Date trunc(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date addDay(Date date, int iday) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(5, iday);
        return cd.getTime();
    }

    public static Date addHour(Date date, int hour) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(11, hour);
        return cd.getTime();
    }

    public static Date addMinute(Date date, int minute) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(12, minute);
        return cd.getTime();
    }

    public static Date addMonth(Date date, int imonth) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(2, imonth);
        return cd.getTime();
    }

    public static Date addYear(Date date, int iyear) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(1, iyear);
        return cd.getTime();
    }

    public static Date getFirstDateOfMonth(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getFirstDateOfThreeMonth(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -2);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getFirstDateOfYear(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastDateOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date stringToDate(String datestr) {
        return DateUtils.stringToDate(datestr, YYYY_MM_DD);
    }

    public static Date stringToDate(String datestr, String dateformat) {
        if (StringUtils.isBlank((CharSequence)datestr)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(dateformat);
        try {
            Date date = df.parse(datestr);
            return date;
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f[%1$s]\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%2$s", (String)"DateUtils_2", (String)"imc-bdm-common", (Object[])new Object[0]), datestr, dateformat), e);
        }
    }

    public static String dateFormatStringToString(String dateStr, String dateFormatBefore, String dateFormatAfter) {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        SimpleDateFormat beforeFormat = new SimpleDateFormat(dateFormatBefore);
        SimpleDateFormat afterFormat = new SimpleDateFormat(dateFormatAfter);
        try {
            Date date = beforeFormat.parse(dateStr);
            return afterFormat.format(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f[%1$s]\u8f6c\u5316\u9519\u8bef,\u8f6c\u6362\u524d\u683c\u5f0f[%2$s],\u8f6c\u6362\u540e\u683c\u5f0f:[%3$s]", (String)"DateUtils_0", (String)"imc-bdm-common", (Object[])new Object[0]), dateStr, dateFormatBefore, dateFormatAfter), e);
        }
    }

    public static String format(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static String format(Date date) {
        return DateUtils.format(date, YYYY_MM_DD);
    }

    public static Date getFirstDayOfWeek() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek);
        return DateUtils.getDayStartTime(cal.getTime());
    }

    public static Timestamp getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Date getDayStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDayEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, 1);
        return calendar.getTime();
    }

    public static int compare(Date date1, Date date2) {
        String date1Str = DateUtils.format(date1, YYYYMMDD);
        String date2Str = DateUtils.format(date2, YYYYMMDD);
        return Integer.parseInt(date1Str) - Integer.parseInt(date2Str);
    }

    public static long timeDifference(Date date1, Date date2) {
        return date2.getTime() - date1.getTime();
    }

    public static int timeDifferenceDay(Date date1, Date date2) {
        return (int)((date2.getTime() - date1.getTime()) / 86400000L);
    }

    public static int timeDifferenceSecond(Date date1, Date date2) {
        return (int)((date2.getTime() - date1.getTime()) / 1000L);
    }

    public static Date handleDate(String issueTimeStr) {
        switch (issueTimeStr.length()) {
            case 6: {
                return DateUtils.stringToDate(issueTimeStr, YYYYMM);
            }
            case 7: {
                return DateUtils.stringToDate(issueTimeStr, YYYY_MM);
            }
            case 8: {
                return DateUtils.stringToDate(issueTimeStr, YYYYMMDD);
            }
            default: {
                return DateUtils.stringToDate(issueTimeStr, YYYY_MM_DD_HH_MM_SS);
            }
            case 10: {
                return DateUtils.stringToDate(issueTimeStr, YYYY_MM_DD);
            }
            case 14: 
        }
        return DateUtils.stringToDate(issueTimeStr, YYYYMMDDHHMMSS);
    }

    public static boolean isNullOrStartOfDay(Date date) {
        if (date == null) {
            return true;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(11) == 0 && cal.get(12) == 0 && cal.get(13) == 0 && cal.get(14) == 0;
    }
}

