/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.sys.bill.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.shmjs.sys.bill.util.BeanFieldAnnotation;
import yem.shmjs.sys.bill.util.BigDecimalUtil;
import yem.shmjs.sys.bill.util.DateUtils;

public class DynamicObjectUtil {
    private static final Log log = LogFactory.getLog(DynamicObjectUtil.class);

    public static <T> T dynamicObject2Bean(Class<T> clazz, DynamicObject dynamicObject) {
        T entity = null;
        try {
            DataEntityPropertyCollection collect = dynamicObject.getDataEntityType().getProperties();
            entity = clazz.newInstance();
            for (Field field : DynamicObjectUtil.getDeclaredFields(entity)) {
                try {
                    String name;
                    ReflectionUtils.makeAccessible((Field)field);
                    BeanFieldAnnotation beanField = field.getAnnotation(BeanFieldAnnotation.class);
                    if (beanField == null || !collect.containsKey((Object)(name = beanField.dynamicFiled()))) continue;
                    DynamicObjectUtil.setField(dynamicObject, beanField, field, entity);
                }
                catch (Exception var9) {
                    log.info(MessageFormat.format("dynamicObject\u8f6c\u6362\u5931\u8d25,\u5b9e\u4f53\u540d:[{0}],\u5b57\u6bb5\u540d:[{1}]", dynamicObject.getDataEntityType().getName(), field.getName()));
                }
            }
        }
        catch (Exception e) {
            log.info("dynamicObject\u8f6c\u6362\u5931\u8d25,\u5b9e\u4f53\u540d:[" + dynamicObject.getDataEntityType().getName() + "]", (Object)e);
        }
        return entity;
    }

    private static <T> List<Field> getDeclaredFields(T bean) {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(bean.getClass().getDeclaredFields()));
        if (bean.getClass().getClassLoader() != null) {
            fields.addAll(Arrays.asList(bean.getClass().getSuperclass().getDeclaredFields()));
        }
        return fields;
    }

    public static <T> DynamicObject bean2DynamicObject(T bean, DynamicObject dynamicObject) {
        DataEntityPropertyCollection collect = dynamicObject.getDataEntityType().getProperties();
        for (Field field : DynamicObjectUtil.getDeclaredFields(bean)) {
            try {
                String name;
                IDataEntityProperty property;
                ReflectionUtils.makeAccessible((Field)field);
                BeanFieldAnnotation beanField = field.getAnnotation(BeanFieldAnnotation.class);
                if (beanField == null || (property = (IDataEntityProperty)collect.get((Object)(name = beanField.dynamicFiled()))) == null) continue;
                Object value = DynamicObjectUtil.getValue(beanField, field, dynamicObject, bean);
                if (property.getPropertyType() != null && Date.class.getSimpleName().equals(property.getPropertyType().getSimpleName()) && value instanceof String && StringUtils.isNotBlank((Object)value)) {
                    value = DateUtils.handleDate((String)value);
                }
                dynamicObject.set(name, value);
            }
            catch (Exception var10) {
                log.info(MessageFormat.format("bean\u8f6cDynamicObject\u5931\u8d25, \u5b57\u6bb5\u540d:{0},bean\u7c7b\u578b:{1}", field.getName(), bean.getClass()));
            }
        }
        return dynamicObject;
    }

    public static void map2DynamicObject(Map<String, Object> map, DynamicObject dynamicObject) {
        for (IDataEntityProperty property : dynamicObject.getDataEntityType().getProperties()) {
            String field = property.getName();
            Object value = map.get(field);
            if (StringUtils.isBlank((Object)value)) {
                dynamicObject.set(field, null);
                continue;
            }
            if (property instanceof EntryProp) {
                DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection(field);
                List list = (List)map.get(field);
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                list.forEach(o -> DynamicObjectUtil.map2DynamicObject(o, collection.addNew()));
                continue;
            }
            if (property instanceof BasedataProp && value instanceof Map) {
                dynamicObject.set(field, ((Map)value).get("id"));
                continue;
            }
            if (BigDecimal.class.getSimpleName().equals(property.getPropertyType().getSimpleName()) && StringUtils.isNotBlank((Object)value) && value instanceof String) {
                if (!BigDecimalUtil.isNumber((String)value)) {
                    dynamicObject.set(field, (Object)BigDecimal.ZERO);
                    continue;
                }
                dynamicObject.set(field, value);
                continue;
            }
            if (property instanceof DateTimeProp && StringUtils.isNotBlank((Object)value)) {
                String date = String.valueOf(value);
                String dateFormat = "yyyy-MM-dd";
                if (date.length() == 19) {
                    dateFormat = "yyyy-MM-dd HH:mm:ss";
                } else if (date.length() == 8) {
                    dateFormat = "yyyyMMdd";
                } else if (date.length() == 7) {
                    dateFormat = "yyyy-MM";
                }
                if (date.length() != 10 && date.length() != 19 && date.length() != 8 && date.length() != 7) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e5\u671f[%1$s]\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%2$s", (String)"DynamicObjectUtil_2", (String)"imc-bdm-common", (Object[])new Object[0]), date, "yyyy-MM-dd"));
                }
                dynamicObject.set(field, (Object)DateUtils.stringToDate(date, dateFormat));
                continue;
            }
            dynamicObject.set(field, value);
        }
    }

    public static Map<String, Object> dynamicObject2Map(DynamicObject dynamicObject) {
        DataEntityPropertyCollection collect = dynamicObject.getDataEntityType().getProperties();
        HashMap map = Maps.newHashMapWithExpectedSize((int)collect.size());
        for (IDataEntityProperty property : collect) {
            String field = property.getName();
            map.put(field, dynamicObject.get(field));
        }
        return map;
    }

    public static Map<String, Object> dynamicObjectToMap(DynamicObject obj, boolean id2String) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(obj.getDynamicObjectType().getProperties().size());
        for (IDataEntityProperty property : obj.getDynamicObjectType().getProperties()) {
            String field = property.getName();
            if (property instanceof EntryProp) {
                DynamicObjectCollection collection = obj.getDynamicObjectCollection(field);
                map.put(field, DynamicObjectUtil.dynamicObjectCollection2ListMap(collection, id2String));
                continue;
            }
            Object fieldObj = obj.get(field);
            if (id2String && (property.getPropertyType() == Long.class || property.getPropertyType() == Long.TYPE || fieldObj instanceof Long)) {
                if (fieldObj == null) continue;
                map.put(field, String.valueOf(fieldObj));
                continue;
            }
            if (fieldObj instanceof DynamicObject) {
                Object pkValue = ((DynamicObject)fieldObj).getPkValue();
                map.put(field, id2String ? pkValue.toString() : pkValue);
                continue;
            }
            if (fieldObj instanceof String) {
                String value = (String)fieldObj;
                map.put(field, DynamicObjectUtil.htmlEncode(value));
                continue;
            }
            map.put(field, obj.get(field));
        }
        map.put("tableName", obj.getDataEntityType().getName());
        return map;
    }

    public static String htmlEncode(String source) {
        if (source == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        block8: for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            switch (c) {
                case '\"': {
                    buffer.append('\u201c');
                    continue block8;
                }
                case '#': {
                    buffer.append('\uff03');
                    continue block8;
                }
                case '&': {
                    buffer.append('\uff06');
                    continue block8;
                }
                case '<': {
                    buffer.append('\uff1c');
                    continue block8;
                }
                case '>': {
                    buffer.append('\uff1e');
                    continue block8;
                }
                case '\\': {
                    buffer.append('\uff3c');
                    continue block8;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public static Map<String, Object> dynamicObjectToMap(DynamicObject obj) {
        return DynamicObjectUtil.dynamicObjectToMap(obj, false);
    }

    public static List<Map<String, Object>> dynamicObjectslist2ListMap(List<DynamicObject> objs) {
        ArrayList list = Lists.newArrayListWithCapacity((int)objs.size());
        for (DynamicObject obj : objs) {
            list.add(DynamicObjectUtil.dynamicObjectToMap(obj, true));
        }
        return list;
    }

    public static List<Map<String, Object>> dynamicObjectCollection2ListMap(DynamicObjectCollection collection, boolean long2String) {
        ArrayList list = Lists.newArrayListWithCapacity((int)collection.size());
        for (DynamicObject obj : collection) {
            list.add(DynamicObjectUtil.dynamicObjectToMap(obj, long2String));
        }
        return list;
    }

    public static List<Map<String, Object>> dynamicObjects2ListMap(List<DynamicObject> objs, boolean long2String) {
        ArrayList list = Lists.newArrayListWithCapacity((int)objs.size());
        for (DynamicObject obj : objs) {
            list.add(DynamicObjectUtil.dynamicObjectToMap(obj, long2String));
        }
        return list;
    }

    public static List<Map<String, Object>> dynamicObjects2ListMap(DynamicObject[] objs, boolean long2String) {
        ArrayList list = Lists.newArrayListWithCapacity((int)objs.length);
        for (DynamicObject obj : objs) {
            list.add(DynamicObjectUtil.dynamicObjectToMap(obj, long2String));
        }
        return list;
    }

    public static DynamicObject copyDynamicObject(DynamicObject source) {
        DynamicObject newObj = (DynamicObject)source.getDataEntityType().createInstance();
        DynamicObjectUtil.copyDynamicObject(source, newObj, true);
        return newObj;
    }

    public static void copyDynamicObject(DynamicObject source, DynamicObject target) {
        DynamicObjectUtil.copyDynamicObject(source, target, false);
    }

    public static void copyDynamicObject(DynamicObject source, DynamicObject target, boolean containId) {
        DynamicObjectUtil.copyDynamicObject(source, target, containId, true, false);
    }

    public static void copyDynamicObject(DynamicObject source, DynamicObject target, boolean containId, boolean nullOvrride, boolean copyBaseData) {
        DataEntityPropertyCollection sourceCollect = source.getDataEntityType().getProperties();
        for (IDataEntityProperty property : target.getDataEntityType().getProperties()) {
            if (property instanceof AttachmentProp || !copyBaseData && (property instanceof BasedataProp || property instanceof CreateDateProp) || !containId && "id".equals(property.getName())) continue;
            String field = property.getName();
            if (property instanceof EntryProp && sourceCollect.containsKey((Object)field)) {
                for (DynamicObject dynamicObject : source.getDynamicObjectCollection(field)) {
                    DynamicObjectUtil.copyDynamicObject(dynamicObject, target.getDynamicObjectCollection(field).addNew(), containId, nullOvrride, copyBaseData);
                }
                continue;
            }
            if (!sourceCollect.containsKey((Object)field)) continue;
            Object value = source.get(field);
            if (!nullOvrride && DynamicObjectUtil.checkValueIsNull(value)) continue;
            target.set(field, value);
        }
    }

    private static boolean checkValueIsNull(Object value) {
        if (value == null) {
            return true;
        }
        Class<?> clazz = value.getClass();
        if (clazz == BigDecimal.class && ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0) {
            return true;
        }
        return clazz == Long.class && value.equals(0L) ? true : StringUtils.isBlank((Object)value);
    }

    public static void copyDynamicObject2View(DynamicObject source, AbstractFormPlugin formPlugin, boolean isItem, int index) {
        for (IDataEntityProperty property : source.getDataEntityType().getProperties()) {
            String field;
            Control control;
            if ("id".equals(property.getName()) || (control = formPlugin.getControl(field = property.getName())) == null) continue;
            if (isItem) {
                formPlugin.getView().getModel().setValue(field, source.get(field), index);
                continue;
            }
            formPlugin.getView().getModel().setValue(field, source.get(field));
        }
    }

    public static void copyDynamicObjectWithOutItems(DynamicObject source, DynamicObject target) {
        DataEntityPropertyCollection sourceCollect = source.getDataEntityType().getProperties();
        for (IDataEntityProperty property : target.getDataEntityType().getProperties()) {
            String field = property.getName();
            if (!sourceCollect.containsKey((Object)field) || property instanceof CreateDateProp) continue;
            if (property instanceof BasedataProp) {
                target.set(field, (Object)DynamicObjectUtil.getDynamicObjectLongValue(source.get(field)));
            }
            if (property instanceof EntryProp || !sourceCollect.containsKey((Object)field)) continue;
            target.set(field, source.get(field));
        }
    }

    private static <T> Object getValue(BeanFieldAnnotation beanField, Field field, DynamicObject dynamicObject, T entity) {
        try {
            Class<?> fieldType = field.getType();
            if (List.class != fieldType) {
                return null != fieldType.getClassLoader() ? DynamicObjectUtil.bean2DynamicObject(field.get(entity), dynamicObject.getDynamicObject(beanField.dynamicFiled())) : field.get(entity);
            }
            List list = (List)field.get(entity);
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection(beanField.dynamicFiled());
            if (list != null) {
                for (Object o : list) {
                    DynamicObjectUtil.bean2DynamicObject(o, collection.addNew());
                }
            }
            return collection;
        }
        catch (Exception e) {
            log.info("getValue\u5931\u8d25, \u5b57\u6bb5\u540d" + field.getName(), (Object)e);
            return null;
        }
    }

    private static <T> void setField(DynamicObject dynamicObject, BeanFieldAnnotation beanField, Field field, T entity) throws IllegalAccessException {
        Class<?> fieldType = field.getType();
        if (String.class == fieldType) {
            if (beanField.classType() == BigDecimal.class) {
                field.set(entity, dynamicObject.getBigDecimal(beanField.dynamicFiled()).setScale(beanField.scale(), 4).stripTrailingZeros().toPlainString());
            } else if (dynamicObject.get(beanField.dynamicFiled()) instanceof DynamicObject) {
                field.set(entity, dynamicObject.getDynamicObject(beanField.dynamicFiled()).getPkValue().toString());
            } else {
                Object value = dynamicObject.get(beanField.dynamicFiled());
                if (value instanceof BigDecimal) {
                    field.set(entity, dynamicObject.getBigDecimal(beanField.dynamicFiled()).stripTrailingZeros().toPlainString());
                } else {
                    field.set(entity, dynamicObject.getString(beanField.dynamicFiled()));
                }
            }
        } else if (Integer.TYPE != fieldType && Integer.class != fieldType) {
            if (Long.TYPE != fieldType && Long.class != fieldType) {
                if (BigDecimal.class == fieldType) {
                    field.set(entity, DynamicObjectUtil.getBigDecimalVal(dynamicObject, beanField));
                } else if (Date.class == fieldType) {
                    field.set(entity, dynamicObject.getDate(beanField.dynamicFiled()));
                } else if (LocalDateTime.class == fieldType) {
                    Date date = dynamicObject.getDate(beanField.dynamicFiled());
                    if (date != null) {
                        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
                        field.set(entity, localDateTime);
                    }
                } else if (BigInteger.class == fieldType) {
                    field.set(entity, DynamicObjectUtil.getBigIntegerVal(dynamicObject, beanField));
                } else if (List.class == fieldType) {
                    DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection(beanField.dynamicFiled());
                    ArrayList<T> newList = new ArrayList<T>();
                    for (DynamicObject obj : collection) {
                        newList.add(DynamicObjectUtil.dynamicObject2Bean(beanField.classType(), obj));
                    }
                    field.set(entity, newList);
                } else if (fieldType.getClassLoader() != null) {
                    DynamicObject obj = dynamicObject.getDynamicObject(beanField.dynamicFiled());
                    field.set(entity, DynamicObjectUtil.dynamicObject2Bean(fieldType, obj));
                } else {
                    field.set(entity, dynamicObject.get(beanField.dynamicFiled()));
                }
            } else if (dynamicObject.get(beanField.dynamicFiled()) instanceof DynamicObject) {
                field.set(entity, dynamicObject.getDynamicObject(beanField.dynamicFiled()).getPkValue());
            } else {
                field.set(entity, dynamicObject.getLong(beanField.dynamicFiled()));
            }
        } else {
            field.set(entity, dynamicObject.getInt(beanField.dynamicFiled()));
        }
    }

    private static BigInteger getBigIntegerVal(DynamicObject dynamicObject, BeanFieldAnnotation beanField) {
        BigInteger integer = BigInteger.ZERO;
        try {
            Object valObject = dynamicObject.get(beanField.dynamicFiled());
            if (valObject != null) {
                String val = String.valueOf(valObject);
                integer = new BigInteger(val);
            }
        }
        catch (Exception e) {
            log.info("BigInteger\u8f6c\u6362\u5931\u8d25,\u5b57\u6bb5\u540d:" + beanField.dynamicFiled(), (Object)e);
        }
        return integer;
    }

    private static BigDecimal getBigDecimalVal(DynamicObject obj, BeanFieldAnnotation beanField) {
        BigDecimal val = obj.getBigDecimal(beanField.dynamicFiled());
        if (val != null) {
            val = val.compareTo(BigDecimal.ZERO) == 0 ? new BigDecimal("0.00") : (beanField.scale() != 2 ? new BigDecimal(val.setScale(beanField.scale(), 4).stripTrailingZeros().toPlainString()) : val.setScale(beanField.scale(), 4));
        }
        return val;
    }

    public static JSONObject dynamicObject2Json(DynamicObject dynamicObject) {
        JSONObject jsonObject = new JSONObject();
        IDataEntityType entityType = dynamicObject.getDataEntityType();
        DataEntityPropertyCollection collect = entityType.getProperties();
        for (IDataEntityProperty property : collect) {
            String fieldName = property.getName();
            if (dynamicObject.get(fieldName) == null || collect.get((Object)property.getName()) instanceof EntryProp) continue;
            Object value = dynamicObject.get(fieldName);
            jsonObject.put(fieldName, value);
        }
        return jsonObject;
    }

    public static JSONObject dynamicObject2JsonContainItems(DynamicObject dynamicObject) {
        JSONObject json = new JSONObject();
        DynamicObjectUtil.dynamicObject2JsonContainItems(dynamicObject, json);
        return json;
    }

    public static JSONObject dynamicObject2JsonContainItems(DynamicObject dynamicObject, JSONObject jsonObject) {
        IDataEntityType entityType = dynamicObject.getDataEntityType();
        DataEntityPropertyCollection collect = entityType.getProperties();
        for (IDataEntityProperty property : collect) {
            String fieldName = property.getName();
            if (dynamicObject.get(fieldName) == null) continue;
            if (!(collect.get((Object)property.getName()) instanceof EntryProp)) {
                Object value = dynamicObject.get(fieldName);
                jsonObject.put(fieldName, value);
                continue;
            }
            DynamicObjectCollection items = dynamicObject.getDynamicObjectCollection(fieldName);
            JSONArray itemArray = new JSONArray();
            for (DynamicObject item : items) {
                JSONObject itemJson = new JSONObject();
                DynamicObjectUtil.dynamicObject2JsonContainItems(item, itemJson);
                itemArray.add((Object)itemJson);
            }
            jsonObject.put(fieldName, (Object)itemArray);
        }
        return jsonObject;
    }

    public static DynamicObject json2DynamicObject(DynamicObject dynamicObject, JSONObject jsonObject) {
        IDataEntityType entityType = dynamicObject.getDataEntityType();
        for (IDataEntityProperty property : entityType.getProperties()) {
            String fieldName = property.getName();
            if (null == jsonObject.get((Object)fieldName) || kd.bos.util.StringUtils.isEmpty((String)String.valueOf(jsonObject.get((Object)fieldName))) || "id".equals(fieldName) || "items".equals(fieldName)) continue;
            dynamicObject.set(fieldName, jsonObject.get((Object)fieldName));
        }
        return dynamicObject;
    }

    public static List<DynamicObject> jsonArray2DynamicObject(List<DynamicObject> dynamicObjectList, JSONArray jsonArray) {
        for (Object o : jsonArray) {
            DynamicObject dynamicObject = new DynamicObject();
            DynamicObjectUtil.json2DynamicObject(dynamicObject, (JSONObject)o);
            dynamicObjectList.add(dynamicObject);
        }
        return dynamicObjectList;
    }

    public static long getDynamicObjectLongValue(Object value) {
        try {
            return value instanceof DynamicObject ? Long.parseLong(((DynamicObject)value).getPkValue().toString()) : Long.parseLong(String.valueOf(value));
        }
        catch (Exception var2) {
            return 0L;
        }
    }

    public static void json2DynamicObjectContainItems(JSONObject json, DynamicObject dynamicObject, boolean isContainId) {
        DataEntityPropertyCollection collect = dynamicObject.getDataEntityType().getProperties();
        Set fields = collect.stream().map(IMetadata::getName).collect(Collectors.toSet());
        for (Map.Entry entry : json.entrySet()) {
            try {
                if (!isContainId && "id".equals(entry.getKey()) || !fields.contains(entry.getKey())) continue;
                if ("null".equals(entry.getValue())) {
                    dynamicObject.set((String)entry.getKey(), null);
                    continue;
                }
                Class clazz = ((IDataEntityProperty)collect.get(entry.getKey())).getPropertyType();
                if (clazz == String.class) {
                    dynamicObject.set((String)entry.getKey(), entry.getValue());
                    continue;
                }
                if (clazz == Date.class && StringUtils.isNotBlank(entry.getValue())) {
                    String value = (String)entry.getValue();
                    dynamicObject.set((String)entry.getKey(), (Object)DateUtils.stringToDate(value, value.length() == 10 ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss"));
                    continue;
                }
                if (clazz == BigDecimal.class && StringUtils.isBlank(entry.getValue())) {
                    dynamicObject.set((String)entry.getKey(), (Object)BigDecimal.ZERO);
                    continue;
                }
                if (clazz == Integer.class && StringUtils.isBlank(entry.getValue())) {
                    dynamicObject.set((String)entry.getKey(), (Object)0);
                    continue;
                }
                if (clazz == Long.class && StringUtils.isBlank(entry.getValue())) {
                    dynamicObject.set((String)entry.getKey(), (Object)0L);
                    continue;
                }
                if (collect.get(entry.getKey()) instanceof BasedataProp && entry.getValue() instanceof JSONObject) {
                    DynamicObject object;
                    JSONObject baseDataJson = (JSONObject)entry.getValue();
                    String entityId = ((BasedataProp)collect.get(entry.getKey())).getBaseEntityId();
                    try {
                        object = BusinessDataServiceHelper.newDynamicObject((String)entityId);
                        DynamicObjectUtil.json2DynamicObjectContainItems(baseDataJson, object, true);
                    }
                    catch (Exception var12) {
                        object = BusinessDataServiceHelper.loadSingleFromCache((Object)baseDataJson.get((Object)"id"), (String)entityId);
                    }
                    dynamicObject.set((String)entry.getKey(), (Object)object);
                    continue;
                }
                if (collect.get(entry.getKey()) instanceof EntryProp) {
                    for (Object object : (JSONArray)entry.getValue()) {
                        DynamicObject obj = dynamicObject.getDynamicObjectCollection((String)entry.getKey()).addNew();
                        DynamicObjectUtil.json2DynamicObjectContainItems((JSONObject)object, obj, isContainId);
                    }
                    continue;
                }
                dynamicObject.set((String)entry.getKey(), entry.getValue());
            }
            catch (Exception e) {
                log.error(MessageFormat.format("json\u8f6c\u6362DynamicObject\u5931\u8d25{0}, key\u4e3a{1}, \u503c\u4e3a{2}", e.getMessage(), entry.getKey(), entry.getValue()), (Throwable)e);
            }
        }
    }

    public static void json2DynamicObjectContainItems(JSONObject json, DynamicObject dynamicObject) {
        DynamicObjectUtil.json2DynamicObjectContainItems(json, dynamicObject, false);
    }

    public static List<DynamicObject> array2DynamicListContainItems(JSONArray jsonArray, String entityName) {
        ArrayList dynamicObjectList = Lists.newArrayListWithCapacity((int)4);
        if (jsonArray != null && jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                DynamicObjectUtil.json2DynamicObjectContainItems(jsonObject, dynamicObject);
                dynamicObjectList.add(dynamicObject);
            }
        }
        return dynamicObjectList;
    }

    public static boolean checkDynamicObjectHasField(DynamicObject dynamicObject, String field) {
        DynamicObjectType dynamicObjectType = dynamicObject.getDynamicObjectType();
        return dynamicObjectType != null && dynamicObjectType.getProperty(field) != null;
    }
}

