/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.sys.bill.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.tuple.Pair;
import yem.shmjs.sys.bill.util.ImcSaveServiceHelper;
import yem.shmjs.sys.bill.util.InvoiceQFilterUtil;
import yem.shmjs.sys.bill.util.MathUtils;

public class OriginalBillHelper {
    public static void invalidBillDelete(List<Pair<String, String>> invalidInvoiceCodeNo) {
        DynamicObject[] invoices;
        if (!CollectionUtils.isEmpty(invalidInvoiceCodeNo) && (invoices = OriginalBillHelper.queryInvoice(invalidInvoiceCodeNo)).length != 0) {
            for (DynamicObject invoice : invoices) {
                invoice.set("occupystatus", (Object)"0");
            }
            ImcSaveServiceHelper.update(Arrays.asList(invoices));
        }
    }

    public static DynamicObject[] queryInvoice(List<Pair<String, String>> invoiceCodeNoList) {
        QFilter qFilter = new QFilter("invoicecode", "=", (Object)"-1").and("invoiceno", "=", (Object)"-1");
        for (Pair<String, String> invoiceCodeNo : invoiceCodeNoList) {
            qFilter.or(InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)invoiceCodeNo.getKey(), (String)invoiceCodeNo.getValue()));
        }
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "occupystatus", "billstatus", "invoicecode", "invoiceno", "itemremainredamount", "itemremainredtax"), (QFilter[])qFilter.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void redBillDelete(List<DynamicObject> redBills, List<Pair<String, String>> invalidInvoiceCodeNo) {
        if (!CollectionUtils.isEmpty(redBills)) {
            invalidInvoiceCodeNo.clear();
            HashMap<String, DynamicObjectCollection> redBillItems = new HashMap<String, DynamicObjectCollection>(redBills.size());
            for (DynamicObject redBill : redBills) {
                invalidInvoiceCodeNo.add((Pair<String, String>)Pair.of((Object)redBill.getString("blueinvoicecode"), (Object)redBill.getString("blueinvoiceno")));
                DynamicObjectCollection collection = redBillItems.computeIfAbsent(redBill.getString("blueinvoicecode") + "blueinvoicecode" + redBill.getString("blueinvoiceno"), k -> new DynamicObjectCollection());
                collection.addAll((Collection)redBill.getDynamicObjectCollection("sim_original_bill_item"));
            }
            DLock lock = DLock.create((String)"deleteRed");
            lock.lock();
            try {
                DynamicObject[] invoices = OriginalBillHelper.queryInvoice(invalidInvoiceCodeNo);
                if (invoices.length != 0) {
                    for (DynamicObject invoice : invoices) {
                        invoice.set("occupystatus", (Object)"0");
                        DynamicObjectCollection items = (DynamicObjectCollection)redBillItems.get(invoice.getString("invoicecode") + "blueinvoicecode" + invoice.getString("invoiceno"));
                        if (CollectionUtils.isEmpty((Collection)items)) continue;
                        Map<Long, List<DynamicObject>> billItems = items.stream().filter(item -> item.getLong("blueinvoiceitemid") != 0L).collect(Collectors.groupingBy(k -> k.getLong("blueinvoiceitemid")));
                        for (DynamicObject invoiceItem : invoice.getDynamicObjectCollection("items")) {
                            List<DynamicObject> billItemList = billItems.get(invoiceItem.getLong("id"));
                            if (CollectionUtils.isEmpty(billItemList)) continue;
                            BigDecimal amount = BigDecimal.ZERO;
                            BigDecimal tax = BigDecimal.ZERO;
                            for (DynamicObject billItem : billItemList) {
                                amount = amount.add(billItem.getBigDecimal("amount"));
                                tax = tax.add(billItem.getBigDecimal("tax"));
                            }
                            if (MathUtils.isNullOrZero(amount)) continue;
                            invoiceItem.set("itemremainredamount", (Object)invoiceItem.getBigDecimal("itemremainredamount").subtract(amount));
                            invoiceItem.set("itemremainredtax", (Object)invoiceItem.getBigDecimal("itemremainredtax").subtract(tax));
                        }
                    }
                    ImcSaveServiceHelper.update(Arrays.asList(invoices));
                    return;
                }
            }
            finally {
                lock.unlock();
            }
        }
    }
}

