/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.fw.bill.purinbill.form;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportEntryEventArgs;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.importentry.resolving.ImportEntryData;
import kd.bos.mvc.bill.BillViewForWebApi;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.de.meta.utils.MetaPropertyHelper;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.YEM;

public class TargetImportEntryEdit
extends AbstractBillPlugIn {
    private static final String importEntryKey = "billentry";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        String entityId = view.getEntityId();
        Map<String, Object> queryTemplate = TargetImportEntryEdit.queryTemplate(entityId);
        String type = (String)queryTemplate.get("type");
        queryTemplate.remove("type");
        boolean invokeRefresh = this.invokeRefresh(view);
        for (String entryKey : queryTemplate.keySet()) {
            Object impRow2;
            List impRows;
            IDataModel model = this.getModel();
            DynamicObjectCollection entry = model.getEntryEntity(entryKey);
            if ("A".equals(type) && invokeRefresh) {
                List fields;
                DynamicObjectType dynamicObjectType = entry.getDynamicObjectType();
                Object object = queryTemplate.get(entryKey);
                if (object instanceof List && (fields = (List)object) != null && fields.size() > 0) {
                    int entryRowCount = model.getEntryRowCount(entryKey);
                    for (int i = 0; i < entryRowCount; ++i) {
                        DynamicObject entryRowEntity = model.getEntryRowEntity(entryKey, i);
                        DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
                        DynamicObjectUtil.copyDynamicObject((DynamicObject)entryRowEntity, (DynamicObject)dynamicObject);
                        for (String key : fields) {
                            Object value = dynamicObject.get(key);
                            if (value == null || value instanceof BigDecimal && ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0 || value instanceof String && ((String)value).isEmpty()) continue;
                            model.setValue(key, null, i);
                            model.setValue(key, value, i);
                        }
                    }
                }
            }
            if (!"B".equals(type) || !invokeRefresh || (impRows = entry.stream().filter(x -> x.getInt("uav6_importseq") != 0).collect(Collectors.toList())).size() <= 0) continue;
            HashMap<Long, Object> impMap = new HashMap<Long, Object>();
            Map<Integer, DynamicObject> srcRows = entry.stream().filter(x -> x.getInt("uav6_importseq") == 0).collect(Collectors.toMap(x -> x.getInt("seq"), y -> y));
            ArrayList<DynamicObject> finalRows = new ArrayList<DynamicObject>();
            for (Object impRow2 : impRows) {
                int uav6_importseq = impRow2.getInt("uav6_importseq");
                DynamicObject srcRow = srcRows.get(uav6_importseq);
                if (srcRow == null) continue;
                DynamicObjectType dynamicObjectType = srcRow.getDynamicObjectType();
                long genLongId = ORM.create().genLongId((IDataEntityType)dynamicObjectType);
                DynamicObject newRow = new DynamicObject(dynamicObjectType);
                DynamicObjectUtil.copyDynamicObject((DynamicObject)srcRow, (DynamicObject)newRow);
                newRow.set("uav6_importseq", (Object)0);
                newRow.set("id", (Object)genLongId);
                impMap.put(genLongId, impRow2);
                finalRows.add(newRow);
            }
            int seq = 1;
            entry.clear();
            impRow2 = finalRows.iterator();
            while (impRow2.hasNext()) {
                DynamicObject row = (DynamicObject)impRow2.next();
                row.set("seq", (Object)seq++);
                entry.add((Object)row);
            }
            view.updateView(entryKey);
            int entryRowCount = model.getEntryRowCount(entryKey);
            for (int i = 0; i < entryRowCount; ++i) {
                Object object;
                DynamicObject entryRowEntity = model.getEntryRowEntity(entryKey, i);
                long fentryId = entryRowEntity.getLong("id");
                DynamicObject impRow3 = (DynamicObject)impMap.get(fentryId);
                if (impRow3 == null || (object = queryTemplate.get(entryKey)) == null || !(object instanceof List)) continue;
                List fields = (List)object;
                for (String key : fields) {
                    if ("uav6_importseq".equals(key)) continue;
                    model.setValue(key, impRow3.get(key), i);
                }
            }
        }
    }

    private boolean invokeRefresh(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String yem_imp_refresh = pageCache.get(importEntryKey);
        if (yem_imp_refresh != null && Boolean.valueOf(yem_imp_refresh).booleanValue()) {
            pageCache.remove(importEntryKey);
            return true;
        }
        return false;
    }

    public static boolean isImportEntry(IFormView view) {
        return view instanceof BillViewForWebApi;
    }

    public void beforeImportEntry(BeforeImportEntryEventArgs e) {
        super.beforeImportEntry(e);
        Map source = (Map)e.getSource();
        Map entryDataMap = e.getEntryDataMap();
        IFormView view = this.getView();
        String entityId = view.getEntityId();
        IPageCache pageCache = view.getPageCache();
        Map<String, Object> queryTemplate = TargetImportEntryEdit.queryTemplate(entityId);
        String type = (String)queryTemplate.get("type");
        queryTemplate.remove("type");
        if ("A".equals(type)) {
            for (String entryKey : queryTemplate.keySet()) {
                List entries;
                if (!source.containsKey(entryKey) || !(entries = (List)source.get(entryKey)).isEmpty()) continue;
                return;
            }
            pageCache.put(importEntryKey, "true");
        }
        if ("B".equals(type)) {
            for (String entryKey : queryTemplate.keySet()) {
                DynamicObjectCollection entry = this.getModel().getEntryEntity(entryKey);
                List seqs = entry.stream().map(x -> x.getInt("seq")).collect(Collectors.toList());
                if (!source.containsKey(entryKey)) continue;
                ArrayList<ImportEntryData> dels = new ArrayList<ImportEntryData>();
                List entries = (List)source.get(entryKey);
                if (entries.isEmpty()) {
                    return;
                }
                ImportLogger importLogger = (ImportLogger)((List)entryDataMap.get(entryKey)).get(0);
                for (ImportEntryData importEntryData : entries) {
                    JSONObject data = importEntryData.getData();
                    if (!data.containsKey((Object)"uav6_importseq")) continue;
                    Integer uav6_importseq = data.getInteger("uav6_importseq");
                    Integer rowNum = data.getInteger("rowNum");
                    if (seqs.contains(uav6_importseq) && uav6_importseq != 0) continue;
                    importLogger.log(rowNum, "\u3010\u5f15\u5165\u5173\u8054\u884c\u5e8f\u53f7\u3011\u6709\u8bef\uff0c\u4e3a\u96f6\u6216\u4e0d\u5b58\u5728\u3002");
                    importLogger.fail();
                    importLogger.setTotal(importLogger.getTotal() + 1);
                    dels.add(importEntryData);
                }
                entries.removeAll(dels);
            }
            pageCache.put(importEntryKey, "true");
        }
    }

    public static Map<String, Object> queryTemplate(String entityNumber) {
        String KEY_TPL = "yem_de_impentryset";
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and(new QFilter("yem_requirebill.number", "=", (Object)entityNumber));
        String selectFields = DynamicObjectUtil.getSelectfields((String)"yem_de_impentryset", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"yem_de_impentryset", (String)"yem_colsmap", (boolean)false);
        Map templates = BusinessDataServiceHelper.loadFromCache((String)"yem_de_impentryset", (QFilter[])qFilter.toArray());
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (DynamicObject template : templates.values()) {
            String yem_selectentity = template.getString("yem_selectentity");
            String yem_colmap = template.getString("yem_colmap");
            String yem_type = template.getString("yem_type");
            if (YEM.isNotEmpty((Object)yem_selectentity)) {
                ArrayList<String> list = new ArrayList<String>();
                JSONObject colsEntry = JSON.parseObject((String)yem_colmap);
                if (colsEntry != null) {
                    JSONArray colValues = colsEntry.getJSONArray("yem_billcolno");
                    for (Object col : colValues) {
                        String entityKeyWithLang;
                        String key = String.valueOf(col);
                        if (key.equals(entityKeyWithLang = MetaPropertyHelper.getEntityLangName((String)entityNumber, (String)key))) continue;
                        list.add(key);
                    }
                }
                map.put(yem_selectentity, list);
            }
            map.put("type", yem_type);
        }
        return map;
    }
}

