/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.fw.bill.salesdeliver.form;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class SalesdeliverBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit uav6_payer = (BasedataEdit)this.getControl("uav6_payer");
        if (uav6_payer != null) {
            uav6_payer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        switch (e.getProperty().getName()) {
            case "uav6_payer": {
                this.payerF7Select(e);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        String operateKey = e.getOperateKey();
        if ("splitrow".equals(operateKey)) {
            DynamicObjectCollection matchEntry = model.getEntryEntity("uav6_fwb_match");
            if (!matchEntry.isEmpty()) {
                return;
            }
            EntryGrid materialEntryGrid = (EntryGrid)view.getControl("yem_materialentry");
            int[] selectRows = materialEntryGrid.getSelectRows();
            if (selectRows.length != 1) {
                view.showTipNotification("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002");
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setCaption("\u62c6\u5206\u884c\u8bbe\u7f6e");
            formShowParameter.setFormId("uav6_fw_entryrowopparam");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "splitrow"));
            view.showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (!"splitrow".equals(actionId)) {
            return;
        }
        Map map = returnData = e.getReturnData() instanceof Map ? (Map)e.getReturnData() : null;
        if (Objects.isNull(returnData)) {
            return;
        }
        this.splitRow(returnData);
    }

    private void splitRow(Map<String, Object> returnData) {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        Integer rowcount = (Integer)returnData.get("rowcount");
        EntryGrid materialEntryGrid = (EntryGrid)view.getControl("yem_materialentry");
        int selectRow = materialEntryGrid.getSelectRows()[0];
        DynamicObject materialRow = model.getEntryRowEntity("yem_materialentry", selectRow);
        boolean isPass = false;
        for (int i = 0; i < rowcount - 1; ++i) {
            if (!isPass) {
                isPass = true;
                model.copyEntryRow("yem_materialentry", new int[]{selectRow}, true, true);
                model.setValue("yem_qty", (Object)BigDecimal.ZERO, selectRow + 1);
                model.setValue("yem_cobillkey", materialRow.get("yem_cobillkey"), selectRow + 1);
                model.setValue("yem_cobillno", materialRow.get("yem_cobillno"), selectRow + 1);
                model.setValue("yem_cobillid", materialRow.get("yem_cobillid"), selectRow + 1);
                model.setValue("yem_coentryid", materialRow.get("yem_coentryid"), selectRow + 1);
                model.setValue("yem_srcbillkey", materialRow.get("yem_srcbillkey"), selectRow + 1);
                model.setValue("yem_srcbillno", materialRow.get("yem_srcbillno"), selectRow + 1);
                model.setValue("yem_srcbillid", materialRow.get("yem_srcbillid"), selectRow + 1);
                model.setValue("yem_srcentryid", materialRow.get("yem_srcentryid"), selectRow + 1);
                model.setValue("yem_rowclosestatus", materialRow.get("yem_rowclosestatus"), selectRow + 1);
                continue;
            }
            model.copyEntryRow("yem_materialentry", new int[]{selectRow + 1}, true, true);
            model.setValue("yem_cobillkey", materialRow.get("yem_cobillkey"), selectRow + 2);
            model.setValue("yem_cobillno", materialRow.get("yem_cobillno"), selectRow + 2);
            model.setValue("yem_cobillid", materialRow.get("yem_cobillid"), selectRow + 2);
            model.setValue("yem_coentryid", materialRow.get("yem_coentryid"), selectRow + 2);
            model.setValue("yem_srcbillkey", materialRow.get("yem_srcbillkey"), selectRow + 2);
            model.setValue("yem_srcbillno", materialRow.get("yem_srcbillno"), selectRow + 2);
            model.setValue("yem_srcbillid", materialRow.get("yem_srcbillid"), selectRow + 2);
            model.setValue("yem_srcentryid", materialRow.get("yem_srcentryid"), selectRow + 2);
            model.setValue("yem_rowclosestatus", materialRow.get("yem_rowclosestatus"), selectRow + 2);
        }
    }

    private void payerF7Select(BeforeF7SelectEvent e) {
        QFilter filter = new QFilter("uav6_cusorsupn", "=", (Object)"bd_customer");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("status", "=", (Object)"C"));
        DynamicObjectCollection dsfsfkksbaCollection = QueryServiceHelper.query((String)"uav6_bd_dsfsfkksba", (String)"uav6_tradername", (QFilter[])filter.toArray());
        List tradernameList = dsfsfkksbaCollection.stream().map(row -> row.getLong("uav6_tradername")).collect(Collectors.toList());
        filter = new QFilter("id", "in", tradernameList);
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(filter);
    }
}

