/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.fw.bill.salesdeliver.op.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.YEM;
import yem.shmjs.fw.bill.salesdeliver.op.validator.GoodsRightsSubmitValidator;
import yem.wm.cr.service.common.utils.CreditapplyforUtils;

public class SalesdeliverOpPlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new GoodsRightsSubmitValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(DynamicObjectUtil.addFieldKey((String)this.billEntityType.getName(), (boolean)true));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(e);
        String key = e.getOperationKey();
        block12: for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            if ("audit".equals(key)) {
                this.generateSalesoutbill(dataEntity);
                continue;
            }
            Long pkValue = (Long)dataEntity.getPkValue();
            DynamicObject org = dataEntity.getDynamicObject("org");
            DynamicObject yemSalescontnum = dataEntity.getDynamicObject("yem_salescontnum");
            String billstatus = dataEntity.getString("billstatus");
            String relationship = null != yemSalescontnum ? yemSalescontnum.getString("uav6_relationship") : "";
            DynamicObject yemCustomer = dataEntity.getDynamicObject("yem_customer");
            DynamicObject yemFromcurr = dataEntity.getDynamicObject("yem_fromcurr");
            BigDecimal yemAmount = dataEntity.getBigDecimal("yem_amounttaxbase");
            boolean falg = CreditapplyforUtils.WhetherMaincrapps((DynamicObject)yemCustomer, (String)"A");
            switch (key) {
                case "submit": {
                    if (null == org || null == yemCustomer || null == yemFromcurr || !falg) continue block12;
                    CreditapplyforUtils.consumes((DynamicObject)dataEntity, (String)"A", (DynamicObject)yemCustomer, (DynamicObject)yemFromcurr, (BigDecimal)yemAmount);
                    continue block12;
                }
                case "unsubmit": {
                    if (null == org || null == yemCustomer || null == yemFromcurr || !falg) continue block12;
                    CreditapplyforUtils.releases((DynamicObject)dataEntity, (DynamicObject)yemCustomer, null, (BigDecimal)yemAmount, (DynamicObject)yemFromcurr);
                    continue block12;
                }
                case "unaudit": {
                    if (null == org || null == yemCustomer || null == yemFromcurr || !falg) continue block12;
                    CreditapplyforUtils.releases((DynamicObject)dataEntity, (DynamicObject)yemCustomer, null, (BigDecimal)yemAmount, (DynamicObject)yemFromcurr);
                    continue block12;
                }
                case "occupyorrelease": {
                    boolean zy = CreditapplyforUtils.IsitGenerateds((Long)pkValue, (DynamicObject)yemCustomer, null, (String)"A");
                    boolean sf = CreditapplyforUtils.IsitGenerateds((Long)pkValue, (DynamicObject)yemCustomer, null, (String)"B");
                    if ("B".equals(billstatus) || "C".equals(billstatus)) {
                        BigDecimal remainLines = CreditapplyforUtils.quireRemainLiness((String)"A", (DynamicObject)yemCustomer, (DynamicObject)yemFromcurr);
                        if (null == org || null == yemCustomer || null == yemFromcurr || !falg || !zy) continue block12;
                        if (remainLines.compareTo(yemAmount) >= 0) {
                            CreditapplyforUtils.consumes((DynamicObject)dataEntity, (String)"A", (DynamicObject)yemCustomer, (DynamicObject)yemFromcurr, (BigDecimal)yemAmount);
                            continue block12;
                        }
                        throw new KDBizException("\u5ba2\u5546\u4e3a" + yemCustomer.getString("name") + "\u7684\u6388\u4fe1\u989d\u5ea6\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5!");
                    }
                    if (!sf) continue block12;
                    CreditapplyforUtils.releases((DynamicObject)dataEntity, (DynamicObject)yemCustomer, null, (BigDecimal)yemAmount, (DynamicObject)yemFromcurr);
                }
            }
        }
    }

    private void generateSalesoutbill(DynamicObject dataEntity) {
        String name = dataEntity.getDataEntityType().getName();
        dataEntity.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
        ConvertOperationResult pushResult = this.push(dataEntity, "yem_materialentry", "yem_fwb_salesdeliver", "im_saloutbill", "2296559884642051072");
        if (!pushResult.isSuccess()) {
            dataEntity.set("billstatus", (Object)"B");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
            throw new KDBizException(String.format("\u9500\u552e\u53d1\u8d27\u5355\u5ba1\u6838\u751f\u6210\u9500\u552e\u51fa\u5e93\u5355\u5931\u8d25: %s", pushResult.getMessage()));
        }
        String stocktype = dataEntity.getString("yem_stocktype");
        DynamicObject warehouse = null;
        if ("A".equals(stocktype)) {
            QFilter filter = new QFilter("number", "=", (Object)"ZYCK");
            warehouse = BusinessDataServiceHelper.loadSingle((String)"bd_warehouse", (QFilter[])filter.toArray());
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"im_saloutbill");
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        for (DynamicObject targetBillObj : targetBillObjs) {
            Object successPkId = targetBillObj.getPkValue();
            if ("A".equals(stocktype)) {
                DynamicObjectCollection billEntry = targetBillObj.getDynamicObjectCollection("billentry");
                for (DynamicObject billRow : billEntry) {
                    billRow.set("lotnumber", (Object)"-");
                    billRow.set("warehouse", (Object)warehouse);
                }
            }
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"im_saloutbill", (DynamicObject[])new DynamicObject[]{targetBillObj}, (OperateOption)OperateOption.create());
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"im_saloutbill", (Object[])new Object[]{successPkId}, (OperateOption)OperateOption.create());
            if (!submitResult.isSuccess()) {
                OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"im_saloutbill", (Object[])new Object[]{successPkId}, (OperateOption)OperateOption.create());
                dataEntity.set("billstatus", (Object)"B");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
                throw new KDBizException(String.format("\u9500\u552e\u51fa\u5e93\u5355\u63d0\u4ea4\u5931\u8d25: %s", YEM.getOpMsg((OperationResult)submitResult)));
            }
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"im_saloutbill", (Object[])new Object[]{successPkId}, (OperateOption)OperateOption.create());
            if (auditResult.isSuccess()) continue;
            OperationResult unsubmitResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)"im_saloutbill", (Object[])new Object[]{successPkId}, (OperateOption)OperateOption.create());
            OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"im_saloutbill", (Object[])new Object[]{successPkId}, (OperateOption)OperateOption.create());
            dataEntity.set("billstatus", (Object)"B");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
            String opMsg = YEM.getOpMsg((OperationResult)auditResult);
            throw new KDBizException(String.format("\u9500\u552e\u51fa\u5e93\u5355\u5ba1\u6838\u5931\u8d25: %s", YEM.isEmpty((Object)opMsg) ? auditResult.getInteractionContext().getSimpleMessage() : opMsg));
        }
    }

    private ConvertOperationResult push(DynamicObject dataEntity, String subEntryEntityKey, String sourceEntityNumber, String targetEntityNumber, String loadRuleId) {
        if (Objects.isNull(dataEntity) || StringUtils.isEmpty((String)subEntryEntityKey) || StringUtils.isEmpty((String)sourceEntityNumber) || StringUtils.isEmpty((String)targetEntityNumber)) {
            throw new RuntimeException("\u53c2\u6570\u5f02\u5e38");
        }
        DynamicObjectCollection materiallist = dataEntity.getDynamicObjectCollection(subEntryEntityKey);
        ArrayList<ListSelectedRow> selectedRowsTwo = new ArrayList<ListSelectedRow>();
        if (!materiallist.isEmpty()) {
            for (DynamicObject dynamicObject : materiallist) {
                ListSelectedRow listSelectedRowTwo = new ListSelectedRow((Object)dataEntity.getLong("id"));
                listSelectedRowTwo.setSubEntryEntityKey(subEntryEntityKey);
                listSelectedRowTwo.setSubEntryPrimaryKeyValue((Object)dynamicObject.getLong("id"));
                selectedRowsTwo.add(listSelectedRowTwo);
            }
        }
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(sourceEntityNumber);
        pushArgs.setTargetEntityNumber(targetEntityNumber);
        pushArgs.setHasRight(true);
        pushArgs.setRuleId(loadRuleId);
        pushArgs.setAutoSave(false);
        pushArgs.setBuildConvReport(true);
        pushArgs.setSelectedRows(selectedRowsTwo);
        return ConvertServiceHelper.push((PushArgs)pushArgs);
    }
}

