/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.fw.bill.salesdeliver.op.validator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.YEM;
import yem.shmjs.cn.util.ContractPayReceUtil;
import yem.wm.cr.service.common.utils.CreditapplyforUtils;

public class GoodsRightsSubmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        ContractPayReceUtil contractPayReceUtil = new ContractPayReceUtil();
        String operateKey = this.getOperateKey();
        block6: for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject payer = bill.getDynamicObject("uav6_payer");
            DynamicObject yemSalescontnum = bill.getDynamicObject("yem_salescontnum");
            String relationship = "";
            String billkey = "";
            Long billid = 0L;
            if (null != yemSalescontnum) {
                relationship = yemSalescontnum.getString("uav6_relationship");
                billkey = yemSalescontnum.getString("yem_billkey");
                billid = yemSalescontnum.getLong("yem_billid");
            }
            BigDecimal amt = bill.getBigDecimal("yem_amounttaxbase");
            DynamicObject yemCustomer = bill.getDynamicObject("yem_customer");
            DynamicObject org = bill.getDynamicObject("org");
            DynamicObject yemFromcurr = bill.getDynamicObject("yem_fromcurr");
            String customerName = "";
            boolean remain = false;
            BigDecimal remainLines = BigDecimal.ZERO;
            if (null != yemCustomer && null != org) {
                customerName = yemCustomer.getLocaleString("name").getLocaleValue();
                remain = CreditapplyforUtils.WhetherMaincrapps((DynamicObject)yemCustomer, (String)"A");
                if (null != yemFromcurr) {
                    remainLines = CreditapplyforUtils.quireRemainLiness((String)"A", (DynamicObject)yemCustomer, (DynamicObject)yemFromcurr);
                }
            }
            switch (operateKey) {
                case "submit": {
                    if (YEM.isNotEmpty((Object)payer)) continue block6;
                    if ("A".equals(relationship)) {
                        DynamicObject[] yemFwbSalesdelivers;
                        BigDecimal saleReceipt = ContractPayReceUtil.getSaleReceipt((String)billkey, (Long)billid, (Boolean)true);
                        BigDecimal receipt = GoodsRightsSubmitValidator.getSaleReceipt(yemSalescontnum.getLong("id"));
                        saleReceipt = saleReceipt.add(receipt);
                        BigDecimal totalAmt = BigDecimal.ZERO;
                        String fwbSalesdeliverField = String.join((CharSequence)",", DynamicObjectUtil.addFieldKey((String)"yem_fwb_salesdeliver", (boolean)true));
                        QFilter qFilter = new QFilter("billstatus", "!=", (Object)"A");
                        qFilter.and("yem_corebillkey", "=", (Object)billkey);
                        qFilter.and("yem_corebillid", "=", (Object)billid);
                        for (DynamicObject yemFwbSalesdeliver : yemFwbSalesdelivers = BusinessDataServiceHelper.load((String)"yem_fwb_salesdeliver", (String)fwbSalesdeliverField, (QFilter[])qFilter.toArray())) {
                            totalAmt = totalAmt.add(yemFwbSalesdeliver.getBigDecimal("yem_amounttaxbase"));
                        }
                        totalAmt = totalAmt.add(amt);
                        BigDecimal difference = totalAmt.subtract(saleReceipt).setScale(2, RoundingMode.HALF_UP);
                        if (remain) {
                            if (saleReceipt.compareTo(totalAmt) < 0) {
                                this.addMessage(dataEntity, String.format("\u5408\u540c\u6536\u6b3e\u91d1\u989d\u4e0d\u8db3\uff0c\u5dee%s\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\uff01", difference));
                            }
                            if (remainLines.compareTo(amt) >= 0) continue block6;
                            this.addMessage(dataEntity, String.format("\u5ba2\u5546\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3\uff0c\u5dee%s\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\uff01", amt.subtract(remainLines).setScale(2, RoundingMode.HALF_UP)));
                            continue block6;
                        }
                        if (saleReceipt.compareTo(totalAmt) >= 0) continue block6;
                        this.addMessage(dataEntity, String.format("\u5408\u540c\u6536\u6b3e\u91d1\u989d\u4e0d\u8db3\uff0c\u5dee%s\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\uff01", difference));
                        continue block6;
                    }
                    if (!"B".equals(relationship)) continue block6;
                    if (remain) {
                        if (remainLines.compareTo(amt) >= 0) continue block6;
                        this.addMessage(dataEntity, String.format("\u5ba2\u5546" + customerName + "\u53ef\u7528\u6388\u4fe1\u989d\u5ea6\u4e0d\u8db3\uff0c\u5dee%s\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\uff01", amt.subtract(remainLines).setScale(2, RoundingMode.HALF_UP)));
                        continue block6;
                    }
                    this.addMessage(dataEntity, "\u672c\u6b21\u53d1\u8d27\u5b58\u5728\u6388\u4fe1\u5360\u7528\u60c5\u51b5\uff0c\u8bf7\u5148\u8fdb\u884c\u6388\u4fe1\u7533\u8bf7\uff01");
                    continue block6;
                }
            }
        }
    }

    public static BigDecimal getSaleReceipt(Long salescontnumId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        qFilters.add(new QFilter("entry.yem_salebillno", "=", (Object)salescontnumId));
        qFilters.add(new QFilter("yem_natureofpt.number", "=", (Object)"1001"));
        DynamicObjectCollection ar_receivedbill = QueryServiceHelper.query((String)"ar_receivedbill", (String)"id,entry.e_amount e_amount", (QFilter[])qFilters.toArray(new QFilter[0]));
        return ar_receivedbill.stream().map(x -> x.getBigDecimal("e_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

