/*
 * Decompiled with CFR 0.152.
 */
package yem.mjscm.bill.apbusbill.op;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.plugin.Plugin;

public class UpdateCreatorData
extends AbstractOperationServicePlugIn
implements Plugin {
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        if ("updatecretor".equals(operationKey)) {
            List selectedRows = e.getSelectedRows();
            StringBuilder executeMsg = new StringBuilder();
            ArrayList<DynamicObject> busBillDataEntity = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> purBillDataEntity = new ArrayList<DynamicObject>();
            for (ExtendedDataEntity selectedRow : selectedRows) {
                DynamicObject dataEntity = selectedRow.getDataEntity();
                dataEntity = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getLong("id"), (String)dataEntity.getDynamicObjectType().getName());
                String sourceBillType = dataEntity.getString("sourcebilltype");
                Boolean isAdjust = dataEntity.getBoolean("isadjust");
                if ("ap_busbill".equals(sourceBillType) && isAdjust.booleanValue()) {
                    busBillDataEntity.add(dataEntity);
                }
                if (!"im_purinbill".equals(sourceBillType) || isAdjust.booleanValue()) continue;
                purBillDataEntity.add(dataEntity);
            }
            this.updateData(purBillDataEntity, executeMsg, false, "im_purinbill");
            this.updateData(busBillDataEntity, executeMsg, true, "ap_busbill");
            if (executeMsg.length() > 0) {
                this.getOperationResult().setSuccess(false);
                this.getOperationResult().setMessage(executeMsg.toString());
                this.getOperationResult().setShowMessage(true);
            }
        }
    }

    private StringBuilder updateData(ArrayList<DynamicObject> busBillDataEntity, StringBuilder executeMsg, Boolean isAdjust, String formID) {
        String SelectFields = "id,creator,yem_stocktype,billentry entryid,billentry.warehouse warehouse";
        if (isAdjust.booleanValue()) {
            SelectFields = "id,creator,uav6_stocktype,entry entryid,entry.uav6_warehouse warehouse";
        }
        String entryEntityID = isAdjust != false ? "entry" : "billentry";
        for (DynamicObject dataEntity : busBillDataEntity) {
            Long sourceBillId = dataEntity.getLong("sourcebillid");
            String sourceBillType = dataEntity.getString("sourcebilltype");
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entry");
            Set collected = entry.stream().filter(x -> x.getLong("e_srcentryid") > 0L).map(x -> x.getLong("e_srcentryid")).collect(Collectors.toSet());
            QFilter filter = new QFilter("id", "=", (Object)sourceBillId);
            filter.and(entryEntityID, "in", collected);
            DynamicObjectCollection list = QueryServiceHelper.query((String)formID, (String)SelectFields, (QFilter[])new QFilter[]{filter});
            if (list.isEmpty()) continue;
            for (DynamicObject object : list) {
                Long warehouse = object.getLong("warehouse");
                Long billentryID = object.getLong("entryid");
                entry.stream().filter(x -> x.getLong("e_srcentryid") == billentryID.longValue()).forEach(x -> x.set("uav6_warehouse", (Object)warehouse));
            }
            Long creator = ((DynamicObject)list.get(0)).getLong("creator");
            String yem_stocktype = ((DynamicObject)list.get(0)).getString(isAdjust != false ? "uav6_stocktype" : "yem_stocktype");
            dataEntity.set("creator", (Object)creator);
            dataEntity.set("uav6_stocktype", (Object)yem_stocktype);
            OperateOption option = OperateOption.create();
            option.setVariableValue("ignorewarn", String.valueOf(true));
            option.setVariableValue("ignoreinteraction", String.valueOf(true));
            option.setVariableValue("strictvalidation", String.valueOf(true));
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("updateModifyDate", String.valueOf(false));
            option.setVariableValue("skipCheckDataPermission", String.valueOf(true));
            option.setVariableValue("skipCheckSpecialDataPermission", String.valueOf(true));
            OperationResult result = SaveServiceHelper.saveOperate((String)sourceBillType, (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)option);
            executeMsg.append(isAdjust != false ? "\u51b2\u56de\u5355:" : "\u975e\u51b2\u56de\u5355:").append(dataEntity.getString("billno")).append(",");
            if (!result.isSuccess()) {
                executeMsg.append("\u66f4\u65b0\u5931\u8d25").append(result.getAllErrorInfo().toString()).append("\n");
                continue;
            }
            executeMsg.append("\u66f4\u65b0\u6210\u529f").append("\n");
        }
        return executeMsg;
    }
}

