/*
 * Decompiled with CFR 0.152.
 */
package yem.mjscm.bill.partmentfundinterst.form;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.plugin.Plugin;
import yem.base.common.utils.BigDecimalUtils;

public class PartmentFundInterstBillPlugin
extends AbstractBillPlugIn
implements Plugin {
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "yem_bizdate": {
                this.init_bmzjlxd_mxxx();
                break;
            }
            case "yem_department": {
                this.init_bmzjlxd_mxxx();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "getmxxx": {
                this.init_bmzjlxd_mxxx();
                break;
            }
        }
    }

    public void init_bmzjlxd_mxxx() {
        IDataModel model = this.getModel();
        model.deleteEntryData("uav6_mjscm_bmzjlxd_mxxx");
        Date yem_bizdate = (Date)model.getValue("yem_bizdate");
        DynamicObject yem_department = (DynamicObject)model.getValue("yem_department");
        if (null != yem_bizdate && null != yem_department) {
            Calendar calendar_bg = Calendar.getInstance();
            calendar_bg.setTime(yem_bizdate);
            calendar_bg.set(5, 1);
            calendar_bg.set(11, 0);
            calendar_bg.set(12, 0);
            calendar_bg.set(13, 0);
            calendar_bg.set(14, 0);
            Calendar calendar_ed = Calendar.getInstance();
            calendar_ed.setTime(yem_bizdate);
            calendar_ed.set(11, 23);
            calendar_ed.set(12, 59);
            calendar_ed.set(13, 59);
            int days = calendar_ed.get(5);
            BigDecimal previous_occupiedamt = this.get_previous_occupiedamt(calendar_bg.getTime(), yem_department);
            Map rec_map = this.get_cas_recbill(yem_department, calendar_bg.getTime(), calendar_ed.getTime());
            Map pay_map = this.get_cas_paybill(yem_department, calendar_bg.getTime(), calendar_ed.getTime());
            Map rate_map = this.get_uav6_departmentfundrate(calendar_bg, calendar_ed);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            BigDecimal uav6_dailyocc_s = BigDecimal.ZERO;
            for (int i = 0; i < days; ++i) {
                Calendar calendar_now = Calendar.getInstance();
                calendar_now.setTime(calendar_bg.getTime());
                calendar_now.set(5, i + 1);
                String day_str = sdf.format(calendar_now.getTime());
                int index = model.createNewEntryRow("uav6_mjscm_bmzjlxd_mxxx");
                model.setValue("uav6_date", (Object)calendar_now.getTime(), index);
                BigDecimal uav6_bopoccmoney = BigDecimal.ZERO;
                uav6_bopoccmoney = i == 0 ? previous_occupiedamt : BigDecimalUtils.toBigDecimal((Object)model.getValue("uav6_occupiedamt", index - 1));
                model.setValue("uav6_bopoccmoney", (Object)uav6_bopoccmoney, index);
                BigDecimal uav6_todayproceed = rec_map.containsKey(day_str) ? BigDecimalUtils.toBigDecimal(rec_map.get(day_str)) : BigDecimal.ZERO;
                model.setValue("uav6_todayproceed", (Object)uav6_todayproceed, index);
                BigDecimal uav6_todaypay = pay_map.containsKey(day_str) ? BigDecimalUtils.toBigDecimal(pay_map.get(day_str)) : BigDecimal.ZERO;
                model.setValue("uav6_todaypay", (Object)uav6_todaypay, index);
                BigDecimal uav6_occupiedamt = BigDecimalUtils.sub((BigDecimal)uav6_bopoccmoney, (BigDecimal)uav6_todayproceed, (int)10);
                uav6_occupiedamt = BigDecimalUtils.add((BigDecimal)uav6_occupiedamt, (BigDecimal)uav6_todaypay, (int)10);
                model.setValue("uav6_occupiedamt", (Object)uav6_occupiedamt, index);
                Map rate_val_map = new HashMap();
                if (rate_map.containsKey(day_str)) {
                    rate_val_map = (Map)rate_map.get(day_str);
                }
                BigDecimal uav6_rate = BigDecimal.ZERO;
                if (uav6_occupiedamt.compareTo(BigDecimal.ZERO) >= 0) {
                    uav6_rate = rate_val_map.containsKey("uav6_rateup") ? BigDecimalUtils.toBigDecimal(rate_val_map.get("uav6_rateup")) : BigDecimal.ZERO;
                } else if (uav6_occupiedamt.compareTo(BigDecimal.ZERO) < 0) {
                    uav6_rate = rate_val_map.containsKey("uav6_ratedown") ? BigDecimalUtils.toBigDecimal(rate_val_map.get("uav6_ratedown")) : BigDecimal.ZERO;
                }
                model.setValue("uav6_rate", (Object)uav6_rate, index);
                BigDecimal uav6_todayinterest = BigDecimalUtils.multiply((BigDecimal)uav6_occupiedamt, (BigDecimal)uav6_rate, (int)10);
                uav6_todayinterest = BigDecimalUtils.div((BigDecimal)uav6_todayinterest, (BigDecimal)new BigDecimal("360"), (int)10);
                uav6_todayinterest = BigDecimalUtils.div((BigDecimal)uav6_todayinterest, (BigDecimal)BigDecimalUtils.one_handred, (int)2);
                model.setValue("uav6_todayinterest", (Object)uav6_todayinterest, index);
                uav6_dailyocc_s = BigDecimalUtils.add((BigDecimal)uav6_dailyocc_s, (BigDecimal)uav6_occupiedamt, (int)10);
            }
            BigDecimal uav6_dailyocc = BigDecimalUtils.div((Object)uav6_dailyocc_s, (Object)days, (int)2);
            model.setValue("uav6_dailyocc", (Object)uav6_dailyocc);
        }
    }

    public BigDecimal get_previous_occupiedamt(Date calendar_bg, DynamicObject yem_department) {
        DynamicObject uav6_partmentfundinterst;
        DynamicObjectCollection uav6_mjscm_bmzjlxd_mxxx_s;
        BigDecimal amt = BigDecimal.ZERO;
        QFilter qFilter = new QFilter("yem_bizdate", "<", (Object)calendar_bg);
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qFilter.and(new QFilter("yem_department.id", "=", yem_department.getPkValue()));
        DynamicObject[] uav6_partmentfundinterst_s = BusinessDataServiceHelper.load((String)"uav6_partmentfundinterst", (String)"yem_bizdate,uav6_mjscm_bmzjlxd_mxxx.uav6_occupiedamt", (QFilter[])new QFilter[]{qFilter}, (String)"yem_bizdate desc");
        if (null != uav6_partmentfundinterst_s && uav6_partmentfundinterst_s.length > 0 && null != (uav6_mjscm_bmzjlxd_mxxx_s = (uav6_partmentfundinterst = uav6_partmentfundinterst_s[0]).getDynamicObjectCollection("uav6_mjscm_bmzjlxd_mxxx")) && uav6_mjscm_bmzjlxd_mxxx_s.size() > 0) {
            amt = ((DynamicObject)uav6_mjscm_bmzjlxd_mxxx_s.get(uav6_mjscm_bmzjlxd_mxxx_s.size() - 1)).getBigDecimal("uav6_occupiedamt");
        }
        return amt;
    }

    public Map get_cas_recbill(DynamicObject yem_department, Date calendar_bg, Date calendar_ed) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        ArrayList<String> billstatus = new ArrayList<String>();
        billstatus.add("C");
        billstatus.add("D");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        QFilter qFilter = new QFilter("bizdate", ">=", (Object)calendar_bg);
        qFilter.and(new QFilter("bizdate", "<=", (Object)calendar_ed));
        qFilter.and(new QFilter("entry.uav6_department", "=", yem_department.getPkValue()));
        qFilter.and(new QFilter("billstatus", "in", billstatus));
        qFilter.and(new QFilter("uav6_companyamt", "=", (Object)false));
        DynamicObject[] cas_recbill_s = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"bizdate,entry.uav6_department,entry.e_actamt", (QFilter[])new QFilter[]{qFilter});
        if (null != cas_recbill_s && cas_recbill_s.length > 0) {
            for (DynamicObject cas_recbill : cas_recbill_s) {
                Date bizdate = cas_recbill.getDate("bizdate");
                String bizdate_str = sdf.format(bizdate);
                DynamicObjectCollection entry_s = cas_recbill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entry_s) {
                    DynamicObject uav6_department_rec = entry.getDynamicObject("uav6_department");
                    if (null == yem_department || null == uav6_department_rec || !yem_department.getPkValue().equals(uav6_department_rec.getPkValue())) continue;
                    BigDecimal e_actamt = entry.getBigDecimal("e_actamt");
                    if (map.containsKey(bizdate_str)) {
                        BigDecimal e_actamt_old = BigDecimalUtils.toBigDecimal(map.get(bizdate_str));
                        map.put(bizdate_str, BigDecimalUtils.add((BigDecimal)e_actamt_old, (BigDecimal)e_actamt, (int)10));
                        continue;
                    }
                    map.put(bizdate_str, e_actamt);
                }
            }
        }
        return map;
    }

    public Map get_cas_paybill(DynamicObject yem_department, Date calendar_bg, Date calendar_ed) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        ArrayList<String> billstatus = new ArrayList<String>();
        billstatus.add("C");
        billstatus.add("D");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        QFilter qFilter = new QFilter("bizdate", ">=", (Object)calendar_bg);
        qFilter.and(new QFilter("bizdate", "<=", (Object)calendar_ed));
        qFilter.and(new QFilter("entry.uav6_department", "=", yem_department.getPkValue()));
        qFilter.and(new QFilter("billstatus", "in", billstatus));
        qFilter.and(new QFilter("uav6_companyamt", "=", (Object)false));
        DynamicObject[] cas_paybill_s = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"bizdate,entry.uav6_department,entry.e_actamt", (QFilter[])new QFilter[]{qFilter});
        if (null != cas_paybill_s && cas_paybill_s.length > 0) {
            for (DynamicObject cas_paybill : cas_paybill_s) {
                Date bizdate = cas_paybill.getDate("bizdate");
                String bizdate_str = sdf.format(bizdate);
                DynamicObjectCollection entry_s = cas_paybill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entry_s) {
                    DynamicObject uav6_department_rec = entry.getDynamicObject("uav6_department");
                    if (null == yem_department || null == uav6_department_rec || !yem_department.getPkValue().equals(uav6_department_rec.getPkValue())) continue;
                    BigDecimal e_actamt = entry.getBigDecimal("e_actamt");
                    if (map.containsKey(bizdate_str)) {
                        BigDecimal e_actamt_old = BigDecimalUtils.toBigDecimal(map.get(bizdate_str));
                        map.put(bizdate_str, BigDecimalUtils.add((BigDecimal)e_actamt_old, (BigDecimal)e_actamt, (int)10));
                        continue;
                    }
                    map.put(bizdate_str, e_actamt);
                }
            }
        }
        return map;
    }

    public Map get_uav6_departmentfundrate(Calendar calendar_bg, Calendar calendar_ed) {
        HashMap map = new HashMap();
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] uav6_departmentfundrate_s = BusinessDataServiceHelper.load((String)"uav6_departmentfundrate", (String)"number,name,uav6_rateup,uav6_ratedown,uav6_effectivitystart,uav6_effectiveend", (QFilter[])new QFilter[]{qFilter}, (String)"uav6_effectivitystart desc");
        if (null != uav6_departmentfundrate_s && uav6_departmentfundrate_s.length > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            int days = calendar_ed.get(5);
            for (int i = 0; i < days; ++i) {
                Calendar calendar_now = Calendar.getInstance();
                calendar_now.setTime(calendar_bg.getTime());
                calendar_now.set(5, i + 1);
                Date date_now = calendar_now.getTime();
                String bizdate_str = sdf.format(calendar_now.getTime());
                for (DynamicObject uav6_departmentfundrate : uav6_departmentfundrate_s) {
                    BigDecimal uav6_rateup = uav6_departmentfundrate.getBigDecimal("uav6_rateup");
                    BigDecimal uav6_ratedown = uav6_departmentfundrate.getBigDecimal("uav6_ratedown");
                    Date uav6_effectivitystart = uav6_departmentfundrate.getDate("uav6_effectivitystart");
                    Date uav6_effectiveend = uav6_departmentfundrate.getDate("uav6_effectiveend");
                    Calendar uav6_effectivitystart_cal = Calendar.getInstance();
                    uav6_effectivitystart_cal.setTime(uav6_effectivitystart);
                    uav6_effectivitystart_cal.set(11, 0);
                    uav6_effectivitystart_cal.set(12, 0);
                    uav6_effectivitystart_cal.set(13, 0);
                    uav6_effectivitystart_cal.set(14, 0);
                    Calendar uav6_effectiveend_cal = Calendar.getInstance();
                    uav6_effectiveend_cal.setTime(uav6_effectiveend);
                    uav6_effectiveend_cal.set(11, 23);
                    uav6_effectiveend_cal.set(12, 59);
                    uav6_effectiveend_cal.set(13, 59);
                    if (uav6_effectivitystart_cal.getTime().after(date_now) || uav6_effectiveend_cal.getTime().before(date_now)) continue;
                    HashMap<String, BigDecimal> val = new HashMap<String, BigDecimal>();
                    val.put("uav6_rateup", uav6_rateup);
                    val.put("uav6_ratedown", uav6_ratedown);
                    map.put(bizdate_str, val);
                }
            }
        }
        return map;
    }
}

