/*
 * Decompiled with CFR 0.152.
 */
package yem.mjscm.bill.purinbill.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import yem.mjscm.bill.otherinbill.form.OtherinBillPlugin;

public class PurinBillPlugin
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        String billstatus = (String)model.getValue("billstatus");
        if ("A".equals(billstatus)) {
            view.setEnable(Boolean.valueOf(true), new String[]{"exchangerate"});
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"qtyunit2nd"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        DynamicObject entity = model.getDataEntity();
        switch (name = e.getProperty().getName()) {
            case "exchangerate": {
                model.beginInit();
                model.setValue("uav6_exchangerate", model.getValue("exchangerate"));
                model.endInit();
                view.updateView("uav6_exchangerate");
                break;
            }
            case "uav6_exchangerate": {
                model.beginInit();
                model.setValue("exchangerate", model.getValue("uav6_exchangerate"));
                model.endInit();
                view.updateView("exchangerate");
                break;
            }
            case "uav6_materialtype": {
                OtherinBillPlugin.setMaterialType(view, model);
                break;
            }
            case "qty": {
                this.qtyChanged(e.getChangeSet()[0], model);
                break;
            }
        }
    }

    private void qtyChanged(ChangeData changeData, IDataModel model) {
        String stocktype = (String)model.getValue("yem_stocktype");
        if (!"B".equals(stocktype)) {
            return;
        }
        int index = changeData.getRowIndex();
        BigDecimal enableqty = (BigDecimal)model.getValue("uav6_enableqty", index);
        if (enableqty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal qty = (BigDecimal)changeData.getNewValue();
        if (qty.compareTo(enableqty) > 0) {
            model.setValue("qty", changeData.getOldValue(), index);
            this.getView().showTipNotification(String.format("\u8d85\u51fa\u91c7\u8d2d\u5408\u540c\u53ef\u7528\u6570\u91cf\uff01\u53ef\u7528\u6570\u91cf\uff1a%s", enableqty.setScale(2, RoundingMode.HALF_UP)));
        }
    }
}

