/*
 * Decompiled with CFR 0.152.
 */
package yem.mjscm.bill.purinbill.op;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import yem.wm.cr.service.common.utils.CreditapplyforUtils;

public class purinbillOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("org");
        fieldKeys.add("settlecurrency");
        fieldKeys.add("biztime");
        fieldKeys.add("supplier");
        fieldKeys.add("amountandtax");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        block10: for (DynamicObject dataEntity : e.getDataEntities()) {
            Long pkValue = (Long)dataEntity.getPkValue();
            String billstatus = dataEntity.getString("billstatus");
            DynamicObject supplier = dataEntity.getDynamicObject("supplier");
            DynamicObject paycurrency = dataEntity.getDynamicObject("settlecurrency");
            boolean falg = CreditapplyforUtils.WhetherMaincrapps((DynamicObject)supplier, (String)"B");
            if (!falg) continue;
            BigDecimal mapamt = this.getAsstactAmt(dataEntity);
            switch (operationKey) {
                case "audit": {
                    CreditapplyforUtils.releases((DynamicObject)dataEntity, null, (DynamicObject)supplier, (BigDecimal)mapamt, (DynamicObject)paycurrency);
                    continue block10;
                }
                case "unaudit": {
                    CreditapplyforUtils.consumes((DynamicObject)dataEntity, (String)"B", (DynamicObject)supplier, (DynamicObject)paycurrency, (BigDecimal)mapamt);
                    continue block10;
                }
                case "occupyorrelease": {
                    boolean zy = CreditapplyforUtils.IsitGenerateds((Long)pkValue, null, (DynamicObject)supplier, (String)"A");
                    boolean sf = CreditapplyforUtils.IsitGenerateds((Long)pkValue, null, (DynamicObject)supplier, (String)"B");
                    BigDecimal amt = CreditapplyforUtils.quireRemainLiness((String)"B", (DynamicObject)supplier, (DynamicObject)paycurrency);
                    if ("C".equals(billstatus) && sf) {
                        CreditapplyforUtils.releases((DynamicObject)dataEntity, null, (DynamicObject)supplier, (BigDecimal)mapamt, (DynamicObject)paycurrency);
                    }
                    if ("C".equals(billstatus) || !zy) continue block10;
                    if (amt.compareTo(mapamt) < 0) {
                        throw new KDBizException("\u5ba2\u5546\u4e3a" + supplier.getString("name") + "\u7684\u6388\u4fe1\u989d\u5ea6\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5!");
                    }
                    CreditapplyforUtils.consumes((DynamicObject)dataEntity, (String)"B", (DynamicObject)supplier, (DynamicObject)paycurrency, (BigDecimal)mapamt);
                }
            }
        }
    }

    private BigDecimal getAsstactAmt(DynamicObject dataEntity) {
        BigDecimal amt = BigDecimal.ZERO;
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("billentry");
        for (DynamicObject dynamicObject : entry) {
            BigDecimal amountandtax = dynamicObject.getBigDecimal("amountandtax");
            amt = amt.add(amountandtax);
        }
        return amt;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        String key = (String)this.operateMeta.get("key");
        if ("unaudit".equals(key)) {
            e.addValidator(new AbstractValidator(){

                public void validate() {
                    for (ExtendedDataEntity extendedData : this.getDataEntities()) {
                        BigDecimal amt;
                        DynamicObject dataEntity = extendedData.getDataEntity();
                        DynamicObject org = dataEntity.getDynamicObject("org");
                        DynamicObject supplier = dataEntity.getDynamicObject("supplier");
                        DynamicObject paycurrency = dataEntity.getDynamicObject("settlecurrency");
                        BigDecimal mapamt = purinbillOp.this.getAsstactAmt(dataEntity);
                        boolean falg = CreditapplyforUtils.WhetherMaincrapps((DynamicObject)supplier, (String)"B");
                        if (!falg || (amt = CreditapplyforUtils.quireRemainLiness((String)"B", (DynamicObject)supplier, (DynamicObject)paycurrency)).compareTo(mapamt) >= 0) continue;
                        this.addMessage(extendedData, String.format("\u5ba2\u5546\u4e3a%s\u7684\u6388\u4fe1\u989d\u5ea6\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5\u3002", supplier.getString("name")));
                    }
                }
            });
        }
    }
}

