/*
 * Decompiled with CFR 0.152.
 */
package yem.mjscm.bill.pursettle.op;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import yem.base.common.utils.YEM;

public class PurSettlementUnAuditOpPlugin
extends AbstractOperationServicePlugIn {
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            Object currentBillId = dataEntity.getPkValue();
            dataEntity = BusinessDataServiceHelper.loadSingle((Object)currentBillId, (String)dataEntity.getDynamicObjectType().getName());
            DynamicObjectCollection htxx = dataEntity.getDynamicObjectCollection("yem_jsgl_htxx");
            for (DynamicObject dynamicObject : htxx) {
                if (!YEM.isNotEmpty((Object)dynamicObject)) continue;
                String contractBillNo = dynamicObject.getString("yem_srcbillno_ht");
                QFilter qFilter = new QFilter("yem_jsgl_htxx.yem_srcbillno_ht", "=", (Object)contractBillNo);
                qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
                qFilter.and(new QFilter("yem_isfinalsett", "=", (Object)"B"));
                qFilter.and(new QFilter("id", "!=", currentBillId));
                String selectFields = "yem_jsgl_htxx.yem_srcbillid_ht,yem_jsgl_htxx.yem_settleamount_ht,yem_jsgl_htxx.yem_difqty_ht";
                DynamicObject[] settleBills = BusinessDataServiceHelper.load((String)"yem_sm_pursettlem", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
                HashMap<Long, BigDecimal[]> contractSummaryMap = new HashMap<Long, BigDecimal[]>();
                if (settleBills != null && settleBills.length > 0) {
                    for (DynamicObject bill : settleBills) {
                        DynamicObjectCollection htxxCollection = bill.getDynamicObjectCollection("yem_jsgl_htxx");
                        if (htxxCollection == null || htxxCollection.isEmpty()) continue;
                        for (DynamicObject htxxEntry : htxxCollection) {
                            Long htId = htxxEntry.getLong("yem_srcbillid_ht");
                            BigDecimal amount = htxxEntry.getBigDecimal("yem_settleamount_ht");
                            BigDecimal quantity = htxxEntry.getBigDecimal("yem_difqty_ht");
                            if (!contractSummaryMap.containsKey(htId)) {
                                contractSummaryMap.put(htId, new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO});
                            }
                            BigDecimal[] summary = (BigDecimal[])contractSummaryMap.get(htId);
                            summary[0] = summary[0].add(amount);
                            summary[1] = summary[1].add(quantity);
                        }
                    }
                }
                for (DynamicObject object : htxx) {
                    String contractFormId;
                    DynamicObject contract;
                    Long htId = object.getLong("yem_srcbillid_ht");
                    BigDecimal[] decimals = (BigDecimal[])contractSummaryMap.get(htId);
                    BigDecimal totalAmount = BigDecimal.ZERO;
                    BigDecimal totalQuantity = BigDecimal.ZERO;
                    if (decimals != null) {
                        totalAmount = decimals[0];
                        totalQuantity = decimals[1];
                    }
                    if ((contract = BusinessDataServiceHelper.loadSingle((Object)htId, (String)(contractFormId = dataEntity.getString("yem_contracttype")))) == null) continue;
                    contract.set("uav6_settleamt", (Object)totalAmount);
                    contract.set("uav6_settleqty", (Object)totalQuantity);
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("ignorewarn", String.valueOf(true));
                    option.setVariableValue("ignoreinteraction", String.valueOf(true));
                    option.setVariableValue("strictvalidation", String.valueOf(true));
                    option.setVariableValue("ishasright", String.valueOf(true));
                    option.setVariableValue("updateModifyDate", String.valueOf(false));
                    option.setVariableValue("skipCheckDataPermission", String.valueOf(true));
                    option.setVariableValue("skipCheckSpecialDataPermission", String.valueOf(true));
                    OperationServiceHelper.executeOperate((String)"save", (String)contractFormId, (DynamicObject[])new DynamicObject[]{contract}, (OperateOption)option);
                }
            }
        }
    }
}

