/*
 * Decompiled with CFR 0.152.
 */
package yem.mjscm.bill.saloutbill.form;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import yem.base.common.utils.YEM;

public class QtycallbackFormPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.formInitialize();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        if ("uav6_actualqty".equals(name)) {
            // empty if block
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        switch (source.getKey()) {
            case "btnok": {
                this.callBackFields();
                this.getView().close();
            }
        }
    }

    private void formInitialize() {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        DynamicObject parentEntity = parentModel.getDataEntity(true);
        if (YEM.isEmpty((Object)parentEntity)) {
            return;
        }
        DynamicObjectCollection sonEntry = model.getEntryEntity("uav6_billentry");
        sonEntry.clear();
        DynamicObjectCollection billentry = parentEntity.getDynamicObjectCollection("billentry");
        for (DynamicObject parentRow : billentry) {
            DynamicObject material = parentRow.getDynamicObject("material");
            material = material.getDynamicObject("masterid");
            DynamicObject unit = parentRow.getDynamicObject("unit");
            BigDecimal qty = parentRow.getBigDecimal("qty");
            DynamicObject sonRow = sonEntry.addNew();
            sonRow.set("uav6_materiel", (Object)material);
            sonRow.set("uav6_unit", (Object)unit);
            sonRow.set("uav6_qty", (Object)qty);
        }
    }

    private static void qtyVerify(PropertyChangedArgs e, IDataModel model, IFormView view) {
        BigDecimal actualqty;
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        BigDecimal qty = (BigDecimal)model.getValue("uav6_qty", rowIndex);
        if (qty.compareTo(actualqty = (BigDecimal)model.getValue("uav6_actualqty", rowIndex)) < 0) {
            view.showTipNotification("\u5b9e\u63d0\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u7cfb\u7edf\u6570\u91cf\uff01");
            model.setValue("uav6_actualqty", (Object)BigDecimal.ZERO);
        }
    }

    private void callBackFields() {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        DynamicObjectCollection sonEntry = model.getEntryEntity("uav6_billentry");
        for (DynamicObject sonRow : sonEntry) {
            int index = sonEntry.indexOf((Object)sonRow);
            BigDecimal actualqty = sonRow.getBigDecimal("uav6_actualqty");
            parentModel.setValue("uav6_actualqty", (Object)actualqty, index);
        }
        parentView.invokeOperation("save", YEM.getOptionNoMsg());
        parentView.updateView();
    }
}

