/*
 * Decompiled with CFR 0.152.
 */
package yem.mjscm.bill.saloutbill.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import yem.base.common.utils.YEM;

public class SaloutBillPlugin
extends AbstractBillPlugIn {
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        switch (e.getProperty().getName()) {
            case "qty": 
            case "uav6_actualqty": {
                SaloutBillPlugin.calculateInvoicesdueqtyAmountandtax(e, model);
                break;
            }
            case "amountandtax": {
                this.calculatePriceandtax(e, model);
                this.calculateUninvoicedtaxamt(e, model);
                break;
            }
            case "amount": {
                this.calculatePrice(e, model);
                break;
            }
            case "taxamount": {
                this.calculateUninvoicedtaxamt(e, model);
                break;
            }
            case "currency": 
            case "settlecurrency": 
            case "exratetable": 
            case "exratedate": 
            case "quotation": {
                BigDecimal exchangeRate = YEM.getExchangeRate((Object)model.getValue("exratetable"), (Object)model.getValue("currency"), (Object)model.getValue("settlecurrency"), (Date)((Date)model.getValue("exratedate")));
                model.setValue("uav6_exchangerate", (Object)exchangeRate);
                break;
            }
            case "uav6_exchangerate": {
                model.setValue("exchangerate", (Object)((BigDecimal)model.getValue("uav6_exchangerate")));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "wlmx_htstsl": {
                this.dialogBox("uav6_im_qtycallback", "wlmx_htstsl", null);
            }
        }
    }

    private static void calculateInvoicesdueqtyAmountandtax(PropertyChangedArgs e, IDataModel model) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject billRow = model.getEntryRowEntity("billentry", rowIndex);
        BigDecimal actualqty = billRow.getBigDecimal("uav6_actualqty");
        BigDecimal qty = billRow.getBigDecimal("qty");
        BigDecimal ableprice = billRow.getBigDecimal("uav6_billableprice");
        BigDecimal ableuntaxprice = billRow.getBigDecimal("uav6_billableuntaxprice");
        if (actualqty == null || actualqty.compareTo(BigDecimal.ZERO) == 0) {
            model.setValue("uav6_invoicesdueqty", (Object)qty, rowIndex);
            model.setValue("amount", (Object)qty.multiply(ableuntaxprice), rowIndex);
            model.setValue("amountandtax", (Object)qty.multiply(ableprice), rowIndex);
            BigDecimal taxrate = (BigDecimal)model.getValue("taxrate", rowIndex);
            if (taxrate.compareTo(BigDecimal.ZERO) == 0) {
                model.setValue("uav6_uninvoicedintaxamt", (Object)qty.multiply(ableprice), rowIndex);
                model.setValue("uav6_uninvoiceduntaxamt", (Object)qty.multiply(ableuntaxprice), rowIndex);
            }
        } else {
            model.setValue("uav6_invoicesdueqty", (Object)actualqty, rowIndex);
            model.setValue("amount", (Object)actualqty.multiply(ableuntaxprice), rowIndex);
            model.setValue("amountandtax", (Object)actualqty.multiply(ableprice), rowIndex);
            BigDecimal taxrate = (BigDecimal)model.getValue("taxrate", rowIndex);
            if (taxrate.compareTo(BigDecimal.ZERO) == 0) {
                model.setValue("uav6_uninvoicedintaxamt", (Object)actualqty.multiply(ableprice), rowIndex);
            }
        }
    }

    private void calculatePriceandtax(PropertyChangedArgs e, IDataModel model) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject billRow = model.getEntryRowEntity("billentry", rowIndex);
        BigDecimal amountandtax = billRow.getBigDecimal("amountandtax");
        BigDecimal qty = billRow.getBigDecimal("qty");
        model.beginInit();
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            model.setValue("priceandtax", (Object)BigDecimal.ZERO, rowIndex);
        } else {
            model.setValue("priceandtax", (Object)amountandtax.divide(qty, 10, RoundingMode.HALF_UP), rowIndex);
        }
        model.endInit();
    }

    private void calculatePrice(PropertyChangedArgs e, IDataModel model) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject billRow = model.getEntryRowEntity("billentry", rowIndex);
        BigDecimal amount = billRow.getBigDecimal("amount");
        BigDecimal qty = billRow.getBigDecimal("qty");
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            model.setValue("price", (Object)BigDecimal.ZERO, rowIndex);
        } else {
            model.setValue("price", (Object)amount.divide(qty, 10, RoundingMode.HALF_UP), rowIndex);
        }
        BigDecimal invoiceduntaxamt = billRow.getBigDecimal("uav6_invoiceduntaxamt");
        model.setValue("uav6_uninvoiceduntaxamt", (Object)amount.subtract(invoiceduntaxamt), rowIndex);
    }

    private void calculateUninvoicedtaxamt(PropertyChangedArgs e, IDataModel model) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject billRow = model.getEntryRowEntity("billentry", rowIndex);
        BigDecimal taxamount = billRow.getBigDecimal("taxamount");
        BigDecimal invoicedtaxamt = billRow.getBigDecimal("uav6_invoicedtaxamt");
        model.setValue("uav6_uninvoicedtaxamt", (Object)taxamount.subtract(invoicedtaxamt), rowIndex);
    }

    private void dialogBox(String dynamicForm, String actionId, Map<String, Object> map) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId(dynamicForm);
        showParameter.setCustomParams(map);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(showParameter);
    }
}

