/*
 * Decompiled with CFR 0.152.
 */
package yem.mjscm.bill.saloutbill.opplugin.op;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.YEM;
import yem.mjscm.bill.saloutbill.opplugin.validate.SubmitValidatorPlugin;

public class SaloutOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(DynamicObjectUtil.addFieldKey((String)this.billEntityType.getName(), (boolean)true));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new SubmitValidatorPlugin());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        block6: for (DynamicObject dataEntity : e.getDataEntities()) {
            String operationKey;
            switch (operationKey = e.getOperationKey()) {
                case "unaudit": {
                    String procurementId = dataEntity.getString("uav6_procurementid");
                    if (YEM.isEmpty((Object)procurementId)) {
                        return;
                    }
                    DynamicObject procurement = BusinessDataServiceHelper.loadSingle((String)"im_purinbill", (QFilter[])new QFilter("id", "=", (Object)procurementId).toArray());
                    OperationResult operationResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"im_purinbill", (DynamicObject[])new DynamicObject[]{procurement}, (OperateOption)OperateOption.create());
                    if (!operationResult.isSuccess()) continue block6;
                    DeleteServiceHelper.delete((String)"im_purinbill", (QFilter[])new QFilter("id", "=", (Object)procurementId).toArray());
                }
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey;
        super.afterExecuteOperationTransaction(e);
        switch (operationKey = e.getOperationKey()) {
            case "save": 
            case "delete": {
                for (DynamicObject entity : e.getDataEntities()) {
                    this.writeBackOnSave(entity);
                }
                break;
            }
        }
    }

    private void writeBackOnSave(DynamicObject entity) {
        DynamicObjectCollection billentry = entity.getDynamicObjectCollection("billentry");
        List srcbillids = billentry.stream().map(row -> row.getLong("srcbillid")).distinct().collect(Collectors.toList());
        ArrayList<DynamicObject> salesdeliverList = new ArrayList<DynamicObject>();
        for (Long srcbillid : srcbillids) {
            DynamicObject salesdeliver = BusinessDataServiceHelper.loadSingle((String)"yem_fwb_salesdeliver", (QFilter[])new QFilter("id", "=", (Object)srcbillid).toArray());
            DynamicObjectCollection matchEntry = salesdeliver.getDynamicObjectCollection("uav6_fwb_match");
            Map<Long, Double> collect = matchEntry.stream().collect(Collectors.groupingBy(row -> row.getLong("uav6_materialentryid"), Collectors.summingDouble(row -> row.getBigDecimal("uav6_outboundqtyc").doubleValue())));
            for (DynamicObject matchRow : matchEntry) {
                BigDecimal qty = matchRow.getBigDecimal("uav6_qtyc");
                BigDecimal outboundqtyc = matchRow.getBigDecimal("uav6_outboundqtyc");
                matchRow.set("uav6_unoutboundqtyc", (Object)qty.subtract(outboundqtyc));
            }
            DynamicObjectCollection materialentry = salesdeliver.getDynamicObjectCollection("yem_materialentry");
            for (DynamicObject materialRow : materialentry) {
                long rowId = materialRow.getLong("id");
                if (!collect.containsKey(rowId)) {
                    return;
                }
                BigDecimal qty = materialRow.getBigDecimal("yem_qty");
                Double outboundqty = collect.get(rowId);
                materialRow.set("uav6_outboundqty", (Object)outboundqty);
                materialRow.set("uav6_unoutboundqty", (Object)qty.subtract(BigDecimal.valueOf(outboundqty)));
            }
            salesdeliverList.add(salesdeliver);
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"yem_fwb_salesdeliver", (DynamicObject[])salesdeliverList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            throw new KDBizException(result.getMessage());
        }
    }
}

