/*
 * Decompiled with CFR 0.152.
 */
package yem.mjscm.bill.transap.op;

import java.math.BigDecimal;
import java.util.Arrays;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.YEM;

public class TransapOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(DynamicObjectUtil.addFieldKey((String)this.billEntityType.getName(), (boolean)true));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject entity : e.getDataEntities()) {
            this.salesdeliverStatusInit(entity);
        }
    }

    private void salesdeliverStatusInit(DynamicObject entity) {
        OperationResult result;
        DynamicObject transtypebase = entity.getDynamicObject("yem_transtypebase");
        String transtypebaseNo = transtypebase.getString("number");
        if (!"005".equals(transtypebaseNo)) {
            return;
        }
        DynamicObject salesdeliverno = entity.getDynamicObject("uav6_salesdeliverno");
        if (YEM.isEmpty((Object)salesdeliverno)) {
            return;
        }
        long salesdeliverId = salesdeliverno.getLong("id");
        QFilter filter = new QFilter("billentry.srcbillid", "=", (Object)salesdeliverId);
        String saloutfields = DynamicObjectUtil.getSelectfields((String)"im_saloutbill");
        DynamicObject[] saloutbills = BusinessDataServiceHelper.load((String)"im_saloutbill", (String)(saloutfields = DynamicObjectUtil.getEntrySelectfields((String)saloutfields, (String)"im_saloutbill", (String)"billentry")), (QFilter[])filter.toArray());
        if (saloutbills.length > 0) {
            Object[] ids = Arrays.stream(saloutbills).map(single -> single.getLong("id")).toArray();
            result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"im_saloutbill", (Object[])ids, (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                throw new KDBizException(String.format("\u9500\u552e\u53d1\u8d27\u5355\u4e0b\u6e38\u5355\u636e\u53cd\u5ba1\u6838\u5931\u8d25\uff1a%s", YEM.getOpMsg((OperationResult)result)));
            }
            result = OperationServiceHelper.executeOperate((String)"delete", (String)"im_saloutbill", (Object[])ids, (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                throw new KDBizException(String.format("\u9500\u552e\u53d1\u8d27\u5355\u4e0b\u6e38\u5355\u636e\u5220\u9664\u5931\u8d25\uff1a%s", YEM.getOpMsg((OperationResult)result)));
            }
        }
        if (!(result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"yem_fwb_salesdeliver", (Object[])new Long[]{salesdeliverId}, (OperateOption)OperateOption.create())).isSuccess()) {
            throw new KDBizException(String.format("\u9500\u552e\u53d1\u8d27\u5355\u53cd\u5ba1\u6838\u5931\u8d25\uff1a%s", YEM.getOpMsg((OperationResult)result)));
        }
        salesdeliverno = BusinessDataServiceHelper.loadSingle((Object)salesdeliverno.getPkValue(), (String)salesdeliverno.getDataEntityType().getName());
        DynamicObjectCollection materialentry = salesdeliverno.getDynamicObjectCollection("yem_materialentry");
        for (DynamicObject row : materialentry) {
            row.set("uav6_oldqty", row.get("yem_qty"));
            row.set("yem_qty", (Object)BigDecimal.ZERO);
            row.set("uav6_oldsecondqty", row.get("yem_secondqty"));
            row.set("yem_secondqty", (Object)BigDecimal.ZERO);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{salesdeliverno}, (OperateOption)OperateOption.create());
    }
}

