/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.cn.bill.payapply.opplugin.op;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.shmjs.cn.bill.payapply.util.PayUtil;

public class PayApplySubmitOp
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        block9: for (DynamicObject dataEntity : e.getDataEntities()) {
            switch (e.getOperationKey()) {
                case "submit": {
                    this.contractAmount(dataEntity, true);
                    continue block9;
                }
                case "unaudit": 
                case "unsubmit": {
                    this.contractAmount(dataEntity, false);
                }
            }
        }
    }

    private void contractAmount(DynamicObject dataEntity, boolean isIncluded) {
        Map<Long, BigDecimal> paymenAmt = PayUtil.getPaymenAmt(dataEntity, isIncluded);
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>();
        for (Long billId : paymenAmt.keySet()) {
            DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)"yem_cnb_purcontract");
            if (bill == null) continue;
            BigDecimal amt = paymenAmt.get(billId);
            bill.set("uav6_payment", (Object)amt);
            bill.set("uav6_remainingamt", (Object)bill.getBigDecimal("uav6_payableamt").subtract(amt));
            saveList.add(bill);
        }
        if (saveList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("e_corebillid");
        fieldKeys.add("e_applyamount");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        String key = (String)this.operateMeta.get("key");
        if ("submit".equals(key)) {
            e.addValidator(new AbstractValidator(){

                public void validate() {
                    for (ExtendedDataEntity extendedData : this.getDataEntities()) {
                        DynamicObject dataEntity = extendedData.getDataEntity();
                        Map<Long, BigDecimal> paymenAmt = PayUtil.getPaymenAmt(dataEntity, true);
                        for (Long billId : paymenAmt.keySet()) {
                            BigDecimal payableamt;
                            BigDecimal amt;
                            DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)"yem_cnb_purcontract");
                            if (bill == null || (amt = paymenAmt.get(billId)).compareTo(payableamt = bill.getBigDecimal("uav6_payableamt")) <= 0) continue;
                            this.addMessage(extendedData, String.format("\u91c7\u8d2d\u5408\u540c\u5355\u636e\u7f16\u53f7\u4e3a%s\uff0c\u4e0d\u5141\u8bb8\u8d85\u8fc7\u3010\u5269\u4f59\u53ef\u4ed8\u6b3e\u91d1\u989d\u3011\uff0c\u8bf7\u68c0\u67e5\uff01", bill.getString("billno")));
                        }
                    }
                }
            });
        }
    }
}

