/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.cn.bill.payapply.opplugin.op;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.utils.YEM;
import yem.shmjs.cn.bill.payapply.opplugin.validator.PayCreditValidatorOp;
import yem.shmjs.cn.bill.payapply.util.PayUtil;
import yem.wm.cr.service.common.utils.CreditapplyforUtils;

public class PayCreditOp
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        for (DynamicObject dataEntity : e.getDataEntities()) {
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entry");
            Map<Long, List<DynamicObject>> e_asstact = entry.stream().filter(x -> x.getDynamicObject("uav6_settlement") != null).collect(Collectors.groupingBy(x -> x.getDynamicObject("uav6_settlement").getLong("id")));
            HashMap<Long, String> map = new HashMap<Long, String>();
            for (Long asstactId : e_asstact.keySet()) {
                List<DynamicObject> list = e_asstact.get(asstactId);
                String e_asstacttype = list.size() > 0 ? list.get(0).getString("e_asstacttype") : "";
                if (!YEM.isNotEmpty((Object)e_asstacttype) || !"bd_supplier".equals(e_asstacttype) && !"bd_customer".equals(e_asstacttype)) continue;
                map.put(asstactId, e_asstacttype);
            }
            Long pkValue = (Long)dataEntity.getPkValue();
            String billstatus = dataEntity.getString("billstatus");
            DynamicObject yem_naturetype = dataEntity.getDynamicObject("yem_naturetype");
            if (yem_naturetype == null) continue;
            String naturetype = yem_naturetype.getString("number");
            DynamicObject paycurrency = dataEntity.getDynamicObject("paycurrency");
            for (Long asstactId : map.keySet()) {
                String e_asstacttype = (String)map.get(asstactId);
                DynamicObject asstact = BusinessDataServiceHelper.loadSingleFromCache((Object)asstactId, (String)e_asstacttype);
                Map<Long, BigDecimal> mapamt = PayUtil.getAsstactAmt(dataEntity, "closepay".equals(operationKey));
                boolean falg = "bd_supplier".equals(e_asstacttype) ? CreditapplyforUtils.WhetherMaincrapps((DynamicObject)asstact, (String)"B") : CreditapplyforUtils.WhetherMaincrapps((DynamicObject)asstact, (String)"A");
                if (!falg || !"2001".equals(naturetype) && !"BD-0013".equals(naturetype) && !"BD-0008".equals(naturetype) && !"BD-0004".equals(naturetype) && !"BD-0003".equals(naturetype) && !"BD-0002".equals(naturetype)) continue;
                switch (operationKey) {
                    case "submit": {
                        if ("bd_supplier".equals(e_asstacttype)) {
                            CreditapplyforUtils.consumes((DynamicObject)dataEntity, (String)"B", (DynamicObject)asstact, (DynamicObject)paycurrency, (BigDecimal)mapamt.get(asstactId));
                            break;
                        }
                        CreditapplyforUtils.consumes((DynamicObject)dataEntity, (String)"A", (DynamicObject)asstact, (DynamicObject)paycurrency, (BigDecimal)mapamt.get(asstactId));
                        break;
                    }
                    case "unaudit": 
                    case "unsubmit": 
                    case "closepay": {
                        if ("bd_supplier".equals(e_asstacttype)) {
                            CreditapplyforUtils.releases((DynamicObject)dataEntity, null, (DynamicObject)asstact, (BigDecimal)mapamt.get(asstactId), (DynamicObject)paycurrency);
                            break;
                        }
                        CreditapplyforUtils.releases((DynamicObject)dataEntity, (DynamicObject)asstact, null, (BigDecimal)mapamt.get(asstactId), (DynamicObject)paycurrency);
                        break;
                    }
                    case "occupyorrelease": {
                        BigDecimal amt;
                        boolean sf;
                        boolean zy;
                        if ("bd_supplier".equals(e_asstacttype)) {
                            zy = CreditapplyforUtils.IsitGenerateds((Long)pkValue, null, (DynamicObject)asstact, (String)"A");
                            sf = CreditapplyforUtils.IsitGenerateds((Long)pkValue, null, (DynamicObject)asstact, (String)"B");
                            amt = CreditapplyforUtils.quireRemainLiness((String)"B", (DynamicObject)asstact, (DynamicObject)paycurrency);
                        } else {
                            zy = CreditapplyforUtils.IsitGenerateds((Long)pkValue, (DynamicObject)asstact, null, (String)"A");
                            sf = CreditapplyforUtils.IsitGenerateds((Long)pkValue, (DynamicObject)asstact, null, (String)"B");
                            amt = CreditapplyforUtils.quireRemainLiness((String)"A", (DynamicObject)asstact, (DynamicObject)paycurrency);
                        }
                        if ("B".equals(billstatus) || "C".equals(billstatus)) {
                            if (amt.compareTo(mapamt.get(asstactId)) < 0 || !zy) {
                                throw new KDBizException("\u5ba2\u5546\u4e3a" + asstact.getString("name") + "\u7684\u6388\u4fe1\u989d\u5ea6\u4e0d\u8db3\u6216\u5df2\u751f\u6210\u6388\u4fe1,\u8bf7\u68c0\u67e5!");
                            }
                            if (amt.compareTo(mapamt.get(asstactId)) >= 0 && zy && "bd_supplier".equals(e_asstacttype)) {
                                CreditapplyforUtils.consumes((DynamicObject)dataEntity, (String)"B", (DynamicObject)asstact, (DynamicObject)paycurrency, (BigDecimal)mapamt.get(asstactId));
                            } else if (amt.compareTo(mapamt.get(asstactId)) >= 0 && zy && "bd_customer".equals(e_asstacttype)) {
                                CreditapplyforUtils.consumes((DynamicObject)dataEntity, (String)"A", (DynamicObject)asstact, (DynamicObject)paycurrency, (BigDecimal)mapamt.get(asstactId));
                            }
                        }
                        if (!"D".equals(billstatus) && !"E".equals(billstatus)) break;
                        if (amt.compareTo(mapamt.get(asstactId)) < 0 || !zy) {
                            throw new KDBizException("\u5ba2\u5546\u4e3a" + asstact.getString("name") + "\u7684\u6388\u4fe1\u989d\u5ea6\u4e0d\u8db3\u6216\u5df2\u751f\u6210\u6388\u4fe1,\u8bf7\u68c0\u67e5!");
                        }
                        if (amt.compareTo(mapamt.get(asstactId)) >= 0 && zy && "bd_supplier".equals(e_asstacttype)) {
                            CreditapplyforUtils.consumes((DynamicObject)dataEntity, (String)"B", (DynamicObject)asstact, (DynamicObject)paycurrency, (BigDecimal)mapamt.get(asstactId));
                        } else if (amt.compareTo(mapamt.get(asstactId)) >= 0 && zy && "bd_customer".equals(e_asstacttype)) {
                            CreditapplyforUtils.consumes((DynamicObject)dataEntity, (String)"A", (DynamicObject)asstact, (DynamicObject)paycurrency, (BigDecimal)mapamt.get(asstactId));
                        }
                        mapamt = this.getAsstactAmt(dataEntity, true);
                        if (sf && "bd_supplier".equals(e_asstacttype)) {
                            CreditapplyforUtils.releases((DynamicObject)dataEntity, null, (DynamicObject)asstact, (BigDecimal)mapamt.get(asstactId), (DynamicObject)paycurrency);
                        }
                        if (!sf || !"bd_customer".equals(e_asstacttype)) break;
                        CreditapplyforUtils.releases((DynamicObject)dataEntity, (DynamicObject)asstact, null, (BigDecimal)mapamt.get(asstactId), (DynamicObject)paycurrency);
                    }
                }
            }
        }
    }

    private Map<Long, BigDecimal> getAsstactAmt(DynamicObject dataEntity, boolean ispay) {
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entry");
        Map<Long, List<DynamicObject>> e_asstact = entry.stream().filter(x -> x.getDynamicObject("uav6_settlement") != null).collect(Collectors.groupingBy(x -> x.getDynamicObject("uav6_settlement").getLong("id")));
        Map<Long, List<DynamicObject>> e_paidamt = entry.stream().filter(x -> x.getDynamicObject("uav6_settlement") != null).collect(Collectors.groupingBy(x -> x.getDynamicObject("uav6_settlement").getLong("id")));
        HashMap<Long, BigDecimal> mapamt = new HashMap<Long, BigDecimal>();
        for (Long asstactId : e_asstact.keySet()) {
            BigDecimal amt = e_asstact.get(asstactId).stream().map(x -> x.getBigDecimal("e_payamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (ispay) {
                BigDecimal payamt = e_paidamt.get(asstactId).stream().map(x -> x.getBigDecimal("e_paidamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
                amt = (amt = amt.subtract(payamt)).compareTo(BigDecimal.ZERO) > 0 ? amt : BigDecimal.ZERO;
            }
            mapamt.put(asstactId, amt);
        }
        return mapamt;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("uav6_settlement");
        fieldKeys.add("e_payamount");
        fieldKeys.add("e_approvedamt");
        fieldKeys.add("e_asstact");
        fieldKeys.add("settleorg");
        fieldKeys.add("paycurrency");
        fieldKeys.add("e_paidamt");
        fieldKeys.add("applydate");
        fieldKeys.add("settlecurrency");
        fieldKeys.add("billstatus");
        fieldKeys.add("e_asstacttype");
        fieldKeys.add("yem_naturetype");
        fieldKeys.add("yem_purbillno");
        fieldKeys.add("uav6_isoverpay");
        fieldKeys.add("uav6_overpayamt");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        String key = (String)this.operateMeta.get("key");
        if ("submit".equals(key)) {
            e.addValidator((AbstractValidator)new PayCreditValidatorOp());
        }
    }
}

