/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.cn.bill.payapply.opplugin.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import yem.shmjs.cn.bill.payapply.util.PayUtil;
import yem.shmjs.cn.util.ContractPayReceUtil;
import yem.wm.cr.service.common.utils.CreditapplyforUtils;

public class PayCreditValidatorOp
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extendedData : this.getDataEntities()) {
            DynamicObject dataEntity = extendedData.getDataEntity();
            DynamicObject yem_naturetype = dataEntity.getDynamicObject("yem_naturetype");
            Map<Long, BigDecimal> mapamt = PayUtil.getAsstactAmt(dataEntity, false);
            DynamicObject paycurrency = dataEntity.getDynamicObject("paycurrency");
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entry");
            HashMap<Long, BigDecimal> purinamts = new HashMap<Long, BigDecimal>();
            for (DynamicObject row : entry) {
                DynamicObject yem_purbillno = row.getDynamicObject("yem_purbillno");
                DynamicObject settlement = row.getDynamicObject("uav6_settlement");
                BigDecimal purinamt = BigDecimal.ZERO;
                if (yem_purbillno != null) {
                    DynamicObject[] im_purinbill;
                    for (DynamicObject dynamicObject1 : im_purinbill = BusinessDataServiceHelper.load((String)"im_purinbill", (String)"billentry.amountandtax", (QFilter[])new QFilter[]{new QFilter("billentry.mainbillnumber", "=", (Object)yem_purbillno.getString("number")).and("billstatus", "=", (Object)"C")})) {
                        DynamicObjectCollection billentry = dynamicObject1.getDynamicObjectCollection("billentry");
                        for (DynamicObject dynamicObject : billentry) {
                            purinamt = purinamt.add(dynamicObject.getBigDecimal("amountandtax"));
                        }
                    }
                }
                if (purinamts.containsKey(settlement.getLong("id"))) {
                    BigDecimal bigDecimal = (BigDecimal)purinamts.get(settlement.getLong("id"));
                    purinamts.put(settlement.getLong("id"), bigDecimal.add(purinamt));
                    continue;
                }
                purinamts.put(settlement.getLong("id"), purinamt);
            }
            Map<Long, List<DynamicObject>> e_corebillid = entry.stream().collect(Collectors.groupingBy(x -> x.getLong("e_corebillid")));
            ArrayList<String> message = new ArrayList<String>();
            for (Long billid : e_corebillid.keySet()) {
                DynamicObject asstact = e_corebillid.get(billid).get(0).getDynamicObject("uav6_settlement");
                DynamicObject e_asstact = e_corebillid.get(billid).get(0).getDynamicObject("e_asstact");
                DynamicObject yem_purbillno = e_corebillid.get(billid).get(0).getDynamicObject("yem_purbillno");
                boolean falg = false;
                Map<Long, BigDecimal> paymenAmt = PayUtil.getPaymenAmt(dataEntity, true);
                String e_asstacttype = e_corebillid.get(billid).get(0).getString("e_asstacttype");
                BigDecimal creditamt = BigDecimal.ZERO;
                if ("bd_customer".equals(e_asstacttype)) {
                    falg = CreditapplyforUtils.WhetherMaincrapps((DynamicObject)asstact, (String)"A");
                    creditamt = CreditapplyforUtils.quireRemainLiness((String)"A", (DynamicObject)asstact, (DynamicObject)paycurrency);
                }
                if ("bd_supplier".equals(e_asstacttype)) {
                    falg = CreditapplyforUtils.WhetherMaincrapps((DynamicObject)asstact, (String)"B");
                    creditamt = CreditapplyforUtils.quireRemainLiness((String)"B", (DynamicObject)asstact, (DynamicObject)paycurrency);
                }
                DynamicObject[] dsfsfkksba = BusinessDataServiceHelper.load((String)"uav6_bd_dsfsfkksba", (String)"id", (QFilter[])new QFilter[]{new QFilter("uav6_cusorsupn", "=", (Object)e_asstacttype).and("uav6_tradername.id", "=", e_asstact.getPkValue()).and("status", "=", (Object)"C")});
                BigDecimal payamt = mapamt.get(asstact.getLong("id"));
                if (QueryServiceHelper.exists((String)"yem_cnb_purcontract", (Object)billid)) {
                    DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((Object)billid, (String)"yem_cnb_purcontract");
                    String relationship = bill.getString("uav6_relationship");
                    Boolean dsf = true;
                    switch (relationship) {
                        case "A": {
                            if (asstact != e_asstact && dsfsfkksba.length > 0) {
                                dsf = false;
                            }
                            if (yem_purbillno != null && !falg && dsf.booleanValue()) {
                                this.addMessage(extendedData, String.format("\u8be5\u5ba2\u5546\u672a\u7ef4\u62a4\u5ba2\u5546\u6388\u4fe1,\u8bf7\u5148\u7ef4\u62a4\u5ba2\u5546\u6388\u4fe1\u7533\u8bf7\uff01", new Object[0]));
                                break;
                            }
                            if (yem_naturetype == null || !dsf.booleanValue()) break;
                            String naturetype = yem_naturetype.getString("number");
                            if (!falg || !"2001".equals(naturetype) && !"BD-0013".equals(naturetype) && !"BD-0008".equals(naturetype) && !"BD-0004".equals(naturetype) && !"BD-0003".equals(naturetype) && !"BD-0002".equals(naturetype) || creditamt.compareTo(payamt) >= 0 || !"bd_customer".equals(e_asstacttype) && !"bd_supplier".equals(e_asstacttype)) break;
                            this.addMessage(extendedData, String.format("\u5ba2\u5546\u4e3a%s\u7684\u6388\u4fe1\u989d\u5ea6\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5\u3002", asstact.getString("name")));
                            break;
                        }
                        case "B": {
                            BigDecimal inHouseAmt = ContractPayReceUtil.getInHouseAmt("yem_cnb_purcontract", billid);
                            BigDecimal payAmt = paymenAmt.get(billid);
                            if (inHouseAmt.compareTo(payAmt) < 0) {
                                message.add(bill.getString("billno"));
                            }
                            if (asstact != e_asstact && dsfsfkksba.length > 0) {
                                dsf = false;
                            }
                            if (yem_purbillno != null && ((BigDecimal)purinamts.get(asstact.getLong("id"))).compareTo(payamt) < 0 && !falg && dsf.booleanValue()) {
                                this.addMessage(extendedData, String.format("\u8be5\u5ba2\u5546\u6388\u4fe1\u989d\u5ea6\u4e0d\u8db3\uff01", new Object[0]));
                                break;
                            }
                            if (yem_naturetype == null || !dsf.booleanValue()) break;
                            String naturetype = yem_naturetype.getString("number");
                            if ((!falg || !"2001".equals(naturetype)) && !"BD-0013".equals(naturetype) && !"BD-0008".equals(naturetype) && !"BD-0004".equals(naturetype) && !"BD-0003".equals(naturetype) && !"BD-0002".equals(naturetype) || creditamt.compareTo(payamt) >= 0 || !"bd_customer".equals(e_asstacttype) && !"bd_supplier".equals(e_asstacttype)) break;
                            this.addMessage(extendedData, String.format("\u5ba2\u5546\u4e3a%s\u7684\u6388\u4fe1\u989d\u5ea6\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5\u3002", asstact.getString("name")));
                        }
                    }
                }
                if (message.size() > 0) {
                    String format = String.format("\u91c7\u8d2d\u5408\u540c\u53f7\uff1a%s\uff0c\u8d85\u51fa\u6536\u8d27\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", String.join((CharSequence)",", message));
                    this.addWarningMessage(extendedData, format);
                    dataEntity.set("uav6_isoverpay", (Object)true);
                    dataEntity.set("uav6_overpayamt", (Object)format);
                    continue;
                }
                dataEntity.set("uav6_isoverpay", (Object)false);
                dataEntity.set("uav6_overpayamt", (Object)"");
            }
        }
    }
}

