/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.cn.bill.payapply.opplugin.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import yem.base.common.utils.YEM;

public class PayReturnSubmitValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extendedData : this.getDataEntities()) {
            this.refundVerification(extendedData);
        }
    }

    public void refundVerification(ExtendedDataEntity extendedData) {
        String natureTypeNumber;
        DynamicObject dataEntity = extendedData.getDataEntity();
        DynamicObject naturetype = dataEntity.getDynamicObject("yem_naturetype");
        String string = natureTypeNumber = naturetype != null ? naturetype.getString("number") : "";
        if (Arrays.asList("BD-0013", "BD-0008", "BD-0004").contains(natureTypeNumber)) {
            String recNatureNumber = "BD-0013".equals(natureTypeNumber) ? "1001" : ("BD-0008".equals(natureTypeNumber) ? "BD-0005" : ("BD-0004".equals(natureTypeNumber) ? "BD-0006" : ""));
            DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entry");
            Map<Long, List<DynamicObject>> recEntryIdMap = rows.stream().filter(x -> YEM.isNotEmpty((Object)x.getLong("uav6_recentryid"))).collect(Collectors.groupingBy(x -> x.getLong("uav6_recentryid")));
            for (Long l : recEntryIdMap.keySet()) {
                DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"cas_recbill", (String)"entry.yem_canrecamt yem_canrecamt", (QFilter[])new QFilter[]{new QFilter("entry", "=", (Object)l), new QFilter("id", "=", (Object)recEntryIdMap.get(l).get(0).getLong("uav6_recid"))});
                BigDecimal bigDecimal = dynamicObjectCollection.stream().map(x -> x.getBigDecimal("yem_canrecamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal amt = recEntryIdMap.get(l).stream().map(x -> x.getBigDecimal("e_applyamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (amt.compareTo(bigDecimal) <= 0) continue;
                this.addErrorMessage(extendedData, String.format("\u6536\u6b3e\u5904\u7406\u5355\u53f7\uff1a%s \u5269\u4f59\u53ef\u9000\u6b3e\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5\u3002", recEntryIdMap.get(l).get(0).getString("uav6_recbillno")));
            }
            Map<Long, List<DynamicObject>> purBillnoMap = rows.stream().filter(x -> x.getDynamicObject("yem_purbillno") != null).collect(Collectors.groupingBy(x -> x.getDynamicObject("yem_purbillno").getLong("id")));
            for (Long l : purBillnoMap.keySet()) {
                this.purContractAmt(l, extendedData, purBillnoMap.get(l), "entry.yem_purbillno", natureTypeNumber, recNatureNumber);
            }
            Map<Long, List<DynamicObject>> map = rows.stream().filter(x -> x.getDynamicObject("yem_puragree") != null && x.getDynamicObject("yem_purbillno") == null).collect(Collectors.groupingBy(x -> x.getDynamicObject("yem_puragree").getLong("id")));
            for (Long l : map.keySet()) {
                this.purContractAmt(l, extendedData, map.get(l), "entry.yem_puragree", natureTypeNumber, recNatureNumber);
            }
            Map<Long, List<DynamicObject>> map2 = rows.stream().filter(x -> x.getDynamicObject("yem_salebillno") != null).collect(Collectors.groupingBy(x -> x.getDynamicObject("yem_salebillno").getLong("id")));
            for (Long id : map2.keySet()) {
                this.saleContractAmt(id, extendedData, map2.get(id), "yem_salebillno", natureTypeNumber, recNatureNumber);
            }
            Map<Long, List<DynamicObject>> map3 = rows.stream().filter(x -> x.getDynamicObject("yem_saleagree") != null && x.getDynamicObject("yem_salebillno") == null).collect(Collectors.groupingBy(x -> x.getDynamicObject("yem_saleagree").getLong("id")));
            for (Long id : map3.keySet()) {
                this.saleContractAmt(id, extendedData, map3.get(id), "yem_saleagree", natureTypeNumber, recNatureNumber);
            }
        }
    }

    private void saleContractAmt(Long id, ExtendedDataEntity extendedData, List<DynamicObject> bills, String fieldKey, String natureTypeNumber, String recNatureNumber) {
        String paramKey = "entry." + fieldKey;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "!=", (Object)extendedData.getDataEntity().getLong("id")));
        qFilters.add(new QFilter("billstatus", "in", Arrays.asList("B", "C")));
        qFilters.add(new QFilter(paramKey, "=", (Object)id));
        qFilters.add(new QFilter("yem_naturetype.number", "=", (Object)natureTypeNumber));
        DynamicObjectCollection ap_payapply = QueryServiceHelper.query((String)"ap_payapply", (String)"entry.e_applyamount e_applyamount", (QFilter[])qFilters.toArray(new QFilter[0]));
        BigDecimal amt = ap_payapply.stream().map(x -> x.getBigDecimal("e_applyamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal applyAmount = bills.stream().map(x -> x.getBigDecimal("e_applyamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        amt = applyAmount.add(amt);
        if ("BD-0013".equals(natureTypeNumber)) {
            qFilters.clear();
            qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
            if ("yem_saleagree".equals(fieldKey)) {
                DynamicObjectCollection cnb_salorder = QueryServiceHelper.query((String)"yem_cnb_salorder", (String)"id", (QFilter[])new QFilter[]{new QFilter("yem_sourcebillid", "=", (Object)id), new QFilter("billstatus", "=", (Object)"C")});
                List salOrderIds = cnb_salorder.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
                qFilters.add(new QFilter("billentry.yem_salescontnum.yem_billid", "in", salOrderIds));
            } else {
                qFilters.add(new QFilter("billentry.yem_salescontnum", "=", (Object)id));
            }
            DynamicObjectCollection im_saloutbill = QueryServiceHelper.query((String)"im_saloutbill", (String)"billentry.amountandtax amountandtax", (QFilter[])qFilters.toArray(new QFilter[0]));
            amt = im_saloutbill.stream().map(x -> x.getBigDecimal("amountandtax")).reduce(BigDecimal.ZERO, BigDecimal::add).add(amt);
        }
        qFilters.clear();
        qFilters.add(new QFilter(paramKey, "=", (Object)id));
        qFilters.add(new QFilter("entry.yem_naturetype_e.number", "=", (Object)recNatureNumber));
        qFilters.add(new QFilter("billstatus", "in", Arrays.asList("C", "D")));
        DynamicObjectCollection cas_recbill = QueryServiceHelper.query((String)"cas_recbill", (String)"entry.e_receivableamt e_receivableamt", (QFilter[])qFilters.toArray(new QFilter[0]));
        BigDecimal recAmt = cas_recbill.stream().map(x -> x.getBigDecimal("e_receivableamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        qFilters.clear();
        qFilters.add(new QFilter("billstatus", "in", Arrays.asList("B", "C")));
        qFilters.add(new QFilter("yem_natureofpt.number", "=", (Object)recNatureNumber));
        qFilters.add(new QFilter(paramKey, "=", (Object)id));
        DynamicObjectCollection ar_receivedbill = QueryServiceHelper.query((String)"ar_receivedbill", (String)"entry.e_amount e_amount", (QFilter[])qFilters.toArray(new QFilter[0]));
        recAmt = ar_receivedbill.stream().map(x -> x.getBigDecimal("e_amount")).reduce(BigDecimal.ZERO, BigDecimal::add).add(recAmt);
        if (amt.compareTo(recAmt) > 0) {
            if ("BD-0004".equals(natureTypeNumber)) {
                this.addErrorMessage(extendedData, "\u5f53\u524d\u5408\u540c\u53ef\u9000\u4fdd\u8bc1\u91d1\u4e0d\u8db3\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002");
            } else {
                this.addErrorMessage(extendedData, "\u5f53\u524d\u5408\u540c\u53ef\u9000\u8d27\u6b3e\u4e0d\u8db3\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002");
            }
        }
    }

    private void purContractAmt(Long id, ExtendedDataEntity extendedData, List<DynamicObject> bills, String paramKey, String natureTypeNumber, String recNatureNumber) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("billstatus", "in", Arrays.asList("B", "C")));
        qFilters.add(new QFilter("yem_naturetype.number", "=", (Object)natureTypeNumber));
        qFilters.add(new QFilter("id", "!=", (Object)extendedData.getDataEntity().getLong("id")));
        qFilters.add(new QFilter(paramKey, "=", (Object)id));
        DynamicObjectCollection payapply = QueryServiceHelper.query((String)"ap_payapply", (String)"entry.e_applyamount e_applyamount", (QFilter[])qFilters.toArray(new QFilter[0]));
        BigDecimal amt = payapply.stream().map(x -> x.getBigDecimal("e_applyamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        amt = bills.stream().map(x -> x.getBigDecimal("e_applyamount")).reduce(BigDecimal.ZERO, BigDecimal::add).add(amt);
        qFilters.clear();
        qFilters.add(new QFilter("billstatus", "in", Arrays.asList("C", "D")));
        qFilters.add(new QFilter(paramKey, "=", (Object)id));
        qFilters.add(new QFilter("entry.yem_naturetype_e.number", "=", (Object)recNatureNumber));
        DynamicObjectCollection cas_recbill = QueryServiceHelper.query((String)"cas_recbill", (String)"entry.e_receivableamt e_receivableamt", (QFilter[])qFilters.toArray(new QFilter[0]));
        BigDecimal recAmt = cas_recbill.stream().map(x -> x.getBigDecimal("e_receivableamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (amt.compareTo(recAmt) > 0) {
            this.addErrorMessage(extendedData, "\u5f53\u524d\u5408\u540c\u53ef\u9000\u4fdd\u8bc1\u91d1\u4e0d\u8db3\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002");
        }
    }
}

