/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.cn.bill.payapply.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PayUtil {
    public static Map<Long, BigDecimal> getAsstactAmt(DynamicObject dataEntity, boolean ispay) {
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entry");
        Map<Long, List<DynamicObject>> e_asstact = entry.stream().filter(x -> x.getDynamicObject("uav6_settlement") != null).collect(Collectors.groupingBy(x -> x.getDynamicObject("uav6_settlement").getLong("id")));
        Map<Long, List<DynamicObject>> e_paidamt = entry.stream().filter(x -> x.getDynamicObject("uav6_settlement") != null).collect(Collectors.groupingBy(x -> x.getDynamicObject("uav6_settlement").getLong("id")));
        HashMap<Long, BigDecimal> mapamt = new HashMap<Long, BigDecimal>();
        for (Long asstactId : e_asstact.keySet()) {
            BigDecimal amt = e_asstact.get(asstactId).stream().map(x -> x.getBigDecimal("e_approvedamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (ispay) {
                BigDecimal payamt = e_paidamt.get(asstactId).stream().map(x -> x.getBigDecimal("e_paidamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
                amt = (amt = amt.subtract(payamt)).compareTo(BigDecimal.ZERO) > 0 ? amt : BigDecimal.ZERO;
            }
            mapamt.put(asstactId, amt);
        }
        return mapamt;
    }

    public static Map<Long, BigDecimal> getPaymenAmt(DynamicObject dataEntity, boolean isIncluded) {
        BigDecimal payamt;
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entry");
        Map<Long, List<DynamicObject>> billIds = entry.stream().collect(Collectors.groupingBy(x -> x.getLong("e_corebillid")));
        HashMap<Long, BigDecimal> mapamt = new HashMap<Long, BigDecimal>();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("yem_naturetype.number", "in", Arrays.asList("2001", "BD-0008")));
        qFilters.add(new QFilter("billstatus", "in", Arrays.asList("C", "B")));
        qFilters.add(new QFilter("entry.e_corebillid", "in", billIds.keySet()));
        qFilters.add(new QFilter("id", "!=", (Object)dataEntity.getLong("id")));
        DynamicObjectCollection ap_payapply = QueryServiceHelper.query((String)"ap_payapply", (String)"id,entry.e_applyamount e_applyamount,entry.e_corebillid e_corebillid,entry.lockedamt lockedamt", (QFilter[])qFilters.toArray(new QFilter[0]));
        Map<Long, List<DynamicObject>> oldPayAmt = ap_payapply.stream().collect(Collectors.groupingBy(x -> x.getLong("e_corebillid")));
        for (Long billId : oldPayAmt.keySet()) {
            BigDecimal payamt2 = oldPayAmt.get(billId).stream().map(x -> x.getBigDecimal("e_applyamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal lockedamt = oldPayAmt.get(billId).stream().map(x -> x.getBigDecimal("lockedamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            mapamt.put(billId, payamt2.subtract(lockedamt));
        }
        qFilters.clear();
        qFilters.add(new QFilter("yem_naturetype.number", "in", Arrays.asList("2001", "BD-0008")));
        qFilters.add(new QFilter("entry.e_corebillid", "in", billIds.keySet()));
        DynamicObjectCollection cas_paybill = QueryServiceHelper.query((String)"cas_paybill", (String)"id,entry.e_payableamt e_payableamt,entry.e_corebillid e_corebillid", (QFilter[])qFilters.toArray(new QFilter[0]));
        Map<Long, List<DynamicObject>> paybillAmt = cas_paybill.stream().collect(Collectors.groupingBy(x -> x.getLong("e_corebillid")));
        for (Long billId : paybillAmt.keySet()) {
            payamt = paybillAmt.get(billId).stream().map(x -> x.getBigDecimal("e_payableamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            payamt = mapamt.containsKey(billId) ? ((BigDecimal)mapamt.get(billId)).add(payamt) : payamt;
            mapamt.put(billId, payamt);
        }
        for (Long billId : billIds.keySet()) {
            payamt = billIds.get(billId).stream().map(x -> x.getBigDecimal("e_applyamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            payamt = isIncluded ? payamt : BigDecimal.ZERO;
            payamt = mapamt.containsKey(billId) ? ((BigDecimal)mapamt.get(billId)).add(payamt) : payamt;
            mapamt.put(billId, payamt);
        }
        return mapamt;
    }
}

