/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.cn.bill.purcontract.opplugin.op;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ContractSubmitOp
extends AbstractOperationServicePlugIn {
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        block10: for (DynamicObject dataEntity : e.getDataEntities()) {
            switch (e.getOperationKey()) {
                case "submit": 
                case "save": {
                    this.paymenAmount(dataEntity, true);
                    continue block10;
                }
                case "unaudit": 
                case "unsubmit": {
                    this.paymenAmount(dataEntity, false);
                }
            }
        }
    }

    private void paymenAmount(DynamicObject dataEntity, boolean isIncluded) {
        BigDecimal amount = dataEntity.getBigDecimal("yem_amounttax");
        BigDecimal moreorless = dataEntity.getBigDecimal("yem_moreorless");
        moreorless = moreorless.divide(new BigDecimal(100));
        moreorless = moreorless.add(BigDecimal.ONE);
        amount = amount.multiply(moreorless);
        amount = isIncluded ? amount : BigDecimal.ZERO;
        BigDecimal settamt = dataEntity.getBigDecimal("uav6_settleamt");
        BigDecimal amt = amount.compareTo(settamt) > 0 ? amount : settamt;
        dataEntity.set("uav6_payableamt", (Object)amt);
        BigDecimal payment = dataEntity.getBigDecimal("uav6_payment");
        dataEntity.set("uav6_remainingamt", (Object)amt.subtract(payment));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("yem_amounttax");
        fieldKeys.add("yem_moreorless");
        fieldKeys.add("uav6_payableamt");
        fieldKeys.add("uav6_payment");
        fieldKeys.add("uav6_remainingamt");
        fieldKeys.add("uav6_settleamt");
    }
}

