/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.cn.bill.recbill.op;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.wm.cr.service.common.utils.CreditapplyforUtils;

public class RecbillOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("payertype");
        fieldKeys.add("e_receivableamt");
        fieldKeys.add("yem_settler");
        fieldKeys.add("currency");
        fieldKeys.add("bizdate");
        fieldKeys.add("entry");
        fieldKeys.add("yem_naturetype_e");
        fieldKeys.add("yem_purbillno");
        fieldKeys.add("yem_salebillno");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        block28: for (DynamicObject dataEntity : e.getDataEntities()) {
            BigDecimal amt;
            boolean sf;
            boolean zy;
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entry");
            HashMap<String, BigDecimal> receivableamt_p = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> receivableamt_s = new HashMap<String, BigDecimal>();
            for (DynamicObject dynamicObject1 : entry) {
                String billno;
                DynamicObject yem_naturetype_e = dynamicObject1.getDynamicObject("yem_naturetype_e");
                DynamicObject yem_purbillno = dynamicObject1.getDynamicObject("yem_purbillno");
                DynamicObject yem_salebillno = dynamicObject1.getDynamicObject("yem_salebillno");
                if (yem_naturetype_e == null) continue;
                String naturetype_e = yem_naturetype_e.getString("number");
                if (yem_purbillno != null && "BD-0005".equals(naturetype_e)) {
                    billno = yem_purbillno.getString("number");
                    if (receivableamt_p.containsKey(billno)) {
                        receivableamt_p.put(billno, ((BigDecimal)receivableamt_p.get(billno)).add(dynamicObject1.getBigDecimal("e_receivableamt")));
                    } else {
                        receivableamt_p.put(billno, dynamicObject1.getBigDecimal("e_receivableamt"));
                    }
                }
                if (yem_salebillno == null || !"BD-0006".equals(naturetype_e)) continue;
                billno = yem_salebillno.getString("number");
                if (receivableamt_s.containsKey(billno)) {
                    receivableamt_s.put(billno, ((BigDecimal)receivableamt_s.get(billno)).add(dynamicObject1.getBigDecimal("e_receivableamt")));
                    continue;
                }
                receivableamt_s.put(billno, dynamicObject1.getBigDecimal("e_receivableamt"));
            }
            switch (operationKey) {
                case "audit": {
                    DynamicObject[] yem_cnb_salorder;
                    DynamicObject[] yem_cnb_purcontract;
                    BigDecimal value;
                    if (receivableamt_p.size() > 0) {
                        for (String key : receivableamt_p.keySet()) {
                            value = (BigDecimal)receivableamt_p.get(key);
                            yem_cnb_purcontract = BusinessDataServiceHelper.load((String)"yem_cnb_purcontract", (String)"uav6_recpaidtotalmargin", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)key).and("billstatus", "=", (Object)"C")});
                            if (yem_cnb_purcontract.length <= 0) continue;
                            yem_cnb_purcontract[0].set("uav6_recpaidtotalmargin", (Object)yem_cnb_purcontract[0].getBigDecimal("uav6_recpaidtotalmargin").add(value));
                            SaveServiceHelper.update((DynamicObject)yem_cnb_purcontract[0]);
                        }
                    }
                    if (receivableamt_s.size() <= 0) break;
                    for (String key : receivableamt_s.keySet()) {
                        value = (BigDecimal)receivableamt_s.get(key);
                        yem_cnb_salorder = BusinessDataServiceHelper.load((String)"yem_cnb_salorder", (String)"uav6_recpaidtotalmargin", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)key).and("billstatus", "=", (Object)"C")});
                        if (yem_cnb_salorder.length <= 0) continue;
                        yem_cnb_salorder[0].set("uav6_recpaidtotalmargin", (Object)yem_cnb_salorder[0].getBigDecimal("uav6_recpaidtotalmargin").add(value));
                        SaveServiceHelper.update((DynamicObject)yem_cnb_salorder[0]);
                    }
                    break;
                }
                case "unaudit": {
                    DynamicObject[] yem_cnb_salorder;
                    DynamicObject[] yem_cnb_purcontract;
                    BigDecimal value;
                    if (receivableamt_p.size() > 0) {
                        for (String key : receivableamt_p.keySet()) {
                            value = (BigDecimal)receivableamt_p.get(key);
                            yem_cnb_purcontract = BusinessDataServiceHelper.load((String)"yem_cnb_purcontract", (String)"uav6_recpaidtotalmargin", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)key).and("billstatus", "=", (Object)"C")});
                            if (yem_cnb_purcontract.length <= 0) continue;
                            yem_cnb_purcontract[0].set("uav6_recpaidtotalmargin", (Object)yem_cnb_purcontract[0].getBigDecimal("uav6_recpaidtotalmargin").subtract(value));
                            SaveServiceHelper.update((DynamicObject)yem_cnb_purcontract[0]);
                        }
                    }
                    if (receivableamt_s.size() <= 0) break;
                    for (String key : receivableamt_s.keySet()) {
                        value = (BigDecimal)receivableamt_s.get(key);
                        yem_cnb_salorder = BusinessDataServiceHelper.load((String)"yem_cnb_salorder", (String)"uav6_recpaidtotalmargin", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)key).and("billstatus", "=", (Object)"C")});
                        if (yem_cnb_salorder.length <= 0) continue;
                        yem_cnb_salorder[0].set("uav6_recpaidtotalmargin", (Object)yem_cnb_salorder[0].getBigDecimal("uav6_recpaidtotalmargin").subtract(value));
                        SaveServiceHelper.update((DynamicObject)yem_cnb_salorder[0]);
                    }
                    break;
                }
            }
            Long pkValue = (Long)dataEntity.getPkValue();
            String billstatus = dataEntity.getString("billstatus");
            String payertype = dataEntity.getString("payertype");
            DynamicObject yem_settler = dataEntity.getDynamicObject("yem_settler");
            DynamicObject paycurrency = dataEntity.getDynamicObject("currency");
            boolean falg = "bd_customer".equals(payertype) ? CreditapplyforUtils.WhetherMaincrapps((DynamicObject)yem_settler, (String)"A") : CreditapplyforUtils.WhetherMaincrapps((DynamicObject)yem_settler, (String)"B");
            BigDecimal mapamt = this.getAsstactAmt(dataEntity);
            if (!falg || mapamt.compareTo(BigDecimal.ZERO) <= 0) continue;
            if ("bd_customer".equals(payertype)) {
                switch (operationKey) {
                    case "audit": {
                        CreditapplyforUtils.releases((DynamicObject)dataEntity, (DynamicObject)yem_settler, null, (BigDecimal)mapamt, (DynamicObject)paycurrency);
                        break;
                    }
                    case "unaudit": {
                        CreditapplyforUtils.consumes((DynamicObject)dataEntity, (String)"A", (DynamicObject)yem_settler, (DynamicObject)paycurrency, (BigDecimal)mapamt);
                        break;
                    }
                    case "occupyorrelease": {
                        zy = CreditapplyforUtils.IsitGenerateds((Long)pkValue, (DynamicObject)yem_settler, null, (String)"A");
                        sf = CreditapplyforUtils.IsitGenerateds((Long)pkValue, (DynamicObject)yem_settler, null, (String)"B");
                        amt = CreditapplyforUtils.quireRemainLiness((String)"A", (DynamicObject)yem_settler, (DynamicObject)paycurrency);
                        if (("C".equals(billstatus) || "D".equals(billstatus)) && sf) {
                            CreditapplyforUtils.releases((DynamicObject)dataEntity, (DynamicObject)yem_settler, null, (BigDecimal)mapamt, (DynamicObject)paycurrency);
                        }
                        if ("C".equals(billstatus) || !zy) break;
                        if (amt.compareTo(mapamt) < 0) {
                            throw new KDBizException("\u5ba2\u5546\u4e3a" + yem_settler.getString("name") + "\u7684\u6388\u4fe1\u989d\u5ea6\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5!");
                        }
                        CreditapplyforUtils.consumes((DynamicObject)dataEntity, (String)"A", (DynamicObject)yem_settler, (DynamicObject)paycurrency, (BigDecimal)mapamt);
                    }
                }
            }
            if (!"bd_supplier".equals(payertype)) continue;
            switch (operationKey) {
                case "audit": {
                    CreditapplyforUtils.releases((DynamicObject)dataEntity, null, (DynamicObject)yem_settler, (BigDecimal)mapamt, (DynamicObject)paycurrency);
                    continue block28;
                }
                case "unaudit": {
                    CreditapplyforUtils.consumes((DynamicObject)dataEntity, (String)"B", (DynamicObject)yem_settler, (DynamicObject)paycurrency, (BigDecimal)mapamt);
                    continue block28;
                }
                case "occupyorrelease": {
                    zy = CreditapplyforUtils.IsitGenerateds((Long)pkValue, null, (DynamicObject)yem_settler, (String)"A");
                    sf = CreditapplyforUtils.IsitGenerateds((Long)pkValue, null, (DynamicObject)yem_settler, (String)"B");
                    amt = CreditapplyforUtils.quireRemainLiness((String)"B", (DynamicObject)yem_settler, (DynamicObject)paycurrency);
                    if (("C".equals(billstatus) || "D".equals(billstatus)) && sf) {
                        CreditapplyforUtils.releases((DynamicObject)dataEntity, null, (DynamicObject)yem_settler, (BigDecimal)mapamt, (DynamicObject)paycurrency);
                    }
                    if ("C".equals(billstatus) || !zy) continue block28;
                    if (amt.compareTo(mapamt) < 0) {
                        throw new KDBizException("\u5ba2\u5546\u4e3a" + yem_settler.getString("name") + "\u7684\u6388\u4fe1\u989d\u5ea6\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5!");
                    }
                    CreditapplyforUtils.consumes((DynamicObject)dataEntity, (String)"B", (DynamicObject)yem_settler, (DynamicObject)paycurrency, (BigDecimal)mapamt);
                }
            }
        }
    }

    private BigDecimal getAsstactAmt(DynamicObject dataEntity) {
        BigDecimal amt = BigDecimal.ZERO;
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entry");
        for (DynamicObject dynamicObject : entry) {
            String naturetype_e;
            DynamicObject yem_naturetype_e = dynamicObject.getDynamicObject("yem_naturetype_e");
            if (yem_naturetype_e == null || !"1001".equals(naturetype_e = yem_naturetype_e.getString("number")) && !"BD-0010".equals(naturetype_e) && !"BD-0005".equals(naturetype_e) && !"BD-0006".equals(naturetype_e) && !"BD-0002".equals(naturetype_e) && !"BD-0004".equals(naturetype_e)) continue;
            BigDecimal amountandtax = dynamicObject.getBigDecimal("e_receivableamt");
            amt = amt.add(amountandtax);
        }
        return amt;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        String key = (String)this.operateMeta.get("key");
        if ("unaudit".equals(key)) {
            e.addValidator(new AbstractValidator(){

                public void validate() {
                    for (ExtendedDataEntity extendedData : this.getDataEntities()) {
                        DynamicObject dataEntity = extendedData.getDataEntity();
                        String payertype = dataEntity.getString("payertype");
                        DynamicObject yem_settler = dataEntity.getDynamicObject("yem_settler");
                        DynamicObject paycurrency = dataEntity.getDynamicObject("currency");
                        BigDecimal mapamt = RecbillOp.this.getAsstactAmt(dataEntity);
                        boolean falg = false;
                        if ("bd_customer".equals(payertype)) {
                            falg = CreditapplyforUtils.WhetherMaincrapps((DynamicObject)yem_settler, (String)"A");
                        }
                        if ("bd_supplier".equals(payertype)) {
                            falg = CreditapplyforUtils.WhetherMaincrapps((DynamicObject)yem_settler, (String)"B");
                        }
                        if (!falg) continue;
                        BigDecimal amt = BigDecimal.ZERO;
                        if ("bd_customer".equals(payertype)) {
                            amt = CreditapplyforUtils.quireRemainLiness((String)"A", (DynamicObject)yem_settler, (DynamicObject)paycurrency);
                        }
                        if ("bd_supplier".equals(payertype)) {
                            amt = CreditapplyforUtils.quireRemainLiness((String)"B", (DynamicObject)yem_settler, (DynamicObject)paycurrency);
                        }
                        if (amt.compareTo(mapamt) >= 0) continue;
                        this.addMessage(extendedData, String.format("\u5ba2\u5546\u4e3a%s\u7684\u6388\u4fe1\u989d\u5ea6\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5\u3002", yem_settler.getString("name")));
                    }
                }
            });
        }
    }
}

