/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.cn.bill.record.form;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BegineRecordBillPlugin
extends AbstractBillPlugIn {
    public void afterCreateNewData(EventObject e) {
        this.initData(this.getView());
    }

    private void initData(IFormView view) {
        IDataModel model = this.getModel();
        Map params = view.getFormShowParameter().getCustomParams();
        if (params != null && ((Boolean)params.get("isbegine")).booleanValue()) {
            String billKey = (String)params.get("billKey");
            this.getModel().setValue("org", params.get("orgId"));
            this.getModel().setValue("yem_datatype", (Object)("ar_receivedbill".equals(billKey) ? "1" : "2"));
            this.getModel().setValue("yem_isbeginning", params.get("isbegine"));
            DynamicObject accountingsys = BusinessDataServiceHelper.loadSingle((String)"bd_accountingsys_base", (String)"id,basecurrrency,exratetable,baseacctorg", (QFilter[])new QFilter[]{new QFilter("baseacctorg", "=", params.get("orgId"))});
            if (accountingsys != null) {
                model.setValue("yem_exratetable", accountingsys.get("exratetable"));
                model.setValue("yem_tocurr", accountingsys.get("basecurrrency"));
            }
            EntryGrid entryGrid = (EntryGrid)view.getControl("yem_cnb_crdjl_ysfkxx");
            List properties_this = entryGrid.getItems().stream().map(Control::getKey).collect(Collectors.toList());
            List billIds = (List)params.get("billIds");
            List entryIds = (List)params.get("entryIds");
            String selectFields = "ar_receivedbill".equals(billKey) ? "id,currency,asstacttype,asstact" : "id,currency,payeetype,payee";
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)billKey, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billIds)});
            if (bills.length > 0) {
                model.setValue("yem_fromcurr", bills[0].get("currency"));
                model.setValue("yem_accounttype", bills[0].get("ar_receivedbill".equals(billKey) ? "asstacttype" : "payeetype"));
                model.setValue("yem_cusorsupp", bills[0].get("ar_receivedbill".equals(billKey) ? "asstact" : "payee"));
            }
            for (DynamicObject bill : bills) {
                bill = BusinessDataServiceHelper.loadSingleFromCache((Object)bill.getLong("id"), (String)billKey);
                DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
                DataEntityPropertyCollection properties = entry.getDynamicObjectType().getProperties();
                for (DynamicObject row : entry) {
                    if (!entryIds.contains(row.getLong("id"))) continue;
                    int index = model.createNewEntryRow("yem_cnb_crdjl_ysfkxx");
                    model.setValue("yem_recpaytype", (Object)billKey, index);
                    model.setValue("yem_recpaybillno", bill.get("billno"), index);
                    model.setValue("yem_recpayid", bill.get("id"), index);
                    model.setValue("yem_recpayentryid", row.get("id"), index);
                    model.setValue("yem_payment", row.get("e_expenseitem"), index);
                    model.setValue("yem_recpaydate", bill.get("bizdate"), index);
                    model.setValue("yem_exratedate", bill.get("exratedate"), index);
                    model.setValue("yem_exrate", bill.get("exchangerate"), index);
                    if ("ar_receivedbill".equals(billKey)) {
                        model.setValue("yem_rectype", bill.get("yem_natureofpt"), index);
                    } else {
                        model.setValue("yem_paytype", bill.get("yem_natureofpt"), index);
                    }
                    for (IDataEntityProperty property : properties) {
                        String name = property.getName();
                        if (!properties_this.contains(name)) continue;
                        model.setValue(name, row.get(name), index);
                    }
                }
            }
        }
    }
}

