/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.cn.bill.record.list;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BegineRecPayListPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("yem_identification".equals(itemKey)) {
            this.showForm(this.getView());
        }
    }

    private void showForm(IFormView view) {
        BillList list = (BillList)view.getControl("billlistap");
        String name = list.getEntityType().getName();
        String payKey = "ar_receivedbill".equals(name) ? "asstact" : "payee";
        String amtKey = "ar_receivedbill".equals(name) ? "e_amount" : "e_actamt";
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if (selectedRows.size() < 1) {
            view.showTipNotification("\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002");
            return;
        }
        List orgIds = selectedRows.stream().map(ListSelectedRow::getMainOrgId).distinct().collect(Collectors.toList());
        if (orgIds.size() > 1) {
            view.showTipNotification("\u8bf7\u9009\u62e9\u7ec4\u7ec7\u76f8\u540c\u7684\u6570\u636e\u8fdb\u884c\u91cd\u8ba4\u5b9a\u3002");
            return;
        }
        ArrayList<Long> billIds = new ArrayList<Long>();
        ArrayList<Long> entryIds = new ArrayList<Long>();
        for (ListSelectedRow selectedRow : selectedRows) {
            Long billId = (Long)selectedRow.getPrimaryKeyValue();
            if (!billIds.contains(billId)) {
                billIds.add(billId);
            }
            if ("entry".equals(selectedRow.getEntryEntityKey())) {
                entryIds.add((Long)selectedRow.getEntryPrimaryKeyValue());
                continue;
            }
            DynamicObject[] bill = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)name);
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            List entryId = entry.stream().filter(x -> !entryIds.contains(x.getLong("id"))).map(x -> x.getLong("id")).collect(Collectors.toList());
            entryIds.addAll(entryId);
        }
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)name, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        ArrayList<String> message = new ArrayList<String>();
        ArrayList<Long> suppCusIds = new ArrayList<Long>();
        for (DynamicObject bill : bills) {
            bill = BusinessDataServiceHelper.loadSingleFromCache((Object)bill.getLong("id"), (String)name);
            String billno = bill.getString("billno");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                BigDecimal yem_recamt;
                BigDecimal e_actamt;
                if (!entryIds.contains(row.getLong("id")) || (e_actamt = row.getBigDecimal(amtKey)).subtract(yem_recamt = row.getBigDecimal("yem_recamt")).compareTo(BigDecimal.ZERO) > 0 || message.contains(billno)) continue;
                message.add(billno);
            }
            Long payId = bill.getDynamicObject(payKey) != null ? bill.getDynamicObject(payKey).getLong("id") : 0L;
            if (suppCusIds.contains(payId)) continue;
            suppCusIds.add(payId);
        }
        if (message.size() > 0) {
            view.showTipNotification(String.format("\u5355\u636e\u7f16\u53f7\u4e3a: %s\u4e2d\uff0c \u5b58\u5728\u5269\u4f59\u91cd\u8ba4\u5b9a\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", String.join((CharSequence)"\u3001", message)));
            return;
        }
        if (suppCusIds.size() > 1) {
            view.showTipNotification("\u8bf7\u9009\u62e9\u5ba2\u5546\u76f8\u540c\u7684\u6570\u636e\u8fdb\u884c\u91cd\u8ba4\u5b9a\u3002");
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("billIds", billIds);
        map.put("entryIds", entryIds);
        map.put("orgId", selectedRows.get(0).getMainOrgId());
        map.put("billKey", name);
        map.put("isbegine", true);
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("yem_cn_record");
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams(map);
        view.showForm((FormShowParameter)showParameter);
    }
}

