/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.cn.bill.record.opplugin.op;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.base.common.utils.YEM;

public class BegingRecordAuditOp
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        for (DynamicObject dataEntity : e.getDataEntities()) {
            if (!(dataEntity = BusinessDataServiceHelper.loadSingleFromCache((Object)dataEntity.getLong("id"), (String)dataEntity.getDataEntityType().getName())).getBoolean("yem_isbeginning")) continue;
            this.mainLogic(dataEntity);
        }
    }

    private void mainLogic(DynamicObject dataEntity) {
        String datatype = dataEntity.getString("yem_datatype");
        if (datatype.equals("1") || datatype.equals("2")) {
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("yem_cnb_crdjl_ysfkxx");
            Map<Long, List<DynamicObject>> groupByBillId = collection.stream().collect(Collectors.groupingBy(x -> x.getLong("yem_recpayid")));
            for (Long billId : groupByBillId.keySet()) {
                this.createRedBill(billId, groupByBillId, datatype, dataEntity);
                this.createBlueBill(billId, groupByBillId, datatype, dataEntity);
                this.backIdentAmt(billId, dataEntity, datatype);
            }
        }
    }

    private void backIdentAmt(Long billId, DynamicObject dataEntity, String datatype) {
        String billKey = "1".equals(datatype) ? "ar_receivedbill" : "ap_paidbill";
        String amtKey = "1".equals(datatype) ? "e_amount" : "e_actamt";
        DynamicObjectCollection entryRows = dataEntity.getDynamicObjectCollection("yem_cnb_crdjl_xsfkxx");
        Map<Long, List<DynamicObject>> groupByEntryId = entryRows.stream().collect(Collectors.groupingBy(x -> x.getLong("yem_recpayentryidx")));
        DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)billKey);
        DynamicObjectCollection rows = bill.getDynamicObjectCollection("entry");
        for (DynamicObject row : rows) {
            Long entryId = row.getLong("id");
            if (!groupByEntryId.containsKey(entryId)) continue;
            BigDecimal amt = groupByEntryId.get(entryId).stream().map(x -> x.getBigDecimal("yem_recpayamtx")).reduce(BigDecimal.ZERO, BigDecimal::add);
            amt = row.getBigDecimal("yem_recamt").add(amt);
            row.set("yem_recamt", (Object)amt);
            BigDecimal e_actamt = row.getBigDecimal(amtKey);
            row.set("yem_canrecamt", (Object)e_actamt.subtract(amt));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
    }

    private void createBlueBill(Long billId, Map<Long, List<DynamicObject>> groupByBillId, String datatype, DynamicObject dataEntity) {
        String ruleId;
        DynamicObjectCollection entryRows = dataEntity.getDynamicObjectCollection("yem_cnb_crdjl_xsfkxx");
        Map<Long, List<DynamicObject>> groupByEntryId = entryRows.stream().collect(Collectors.groupingBy(x -> x.getLong("yem_recpayentryidx")));
        String billKey = "1".equals(datatype) ? "ar_receivedbill" : "ap_paidbill";
        DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)billKey);
        String targetName = "1".equals(datatype) ? "cas_recbill" : "cas_paybill";
        List<DynamicObject> targetBillObjs = this.push(billKey, targetName, ruleId = "1".equals(datatype) ? "2357432931821038592" : "2357432649619876864", billId);
        if (targetBillObjs != null && targetBillObjs.size() > 0) {
            for (DynamicObject createblue : targetBillObjs) {
                DynamicObjectCollection entryBlueRow = createblue.getDynamicObjectCollection("entry");
                DynamicObjectCollection entryRow = bill.getDynamicObjectCollection("entry");
                BigDecimal amtSumTotal = BigDecimal.ZERO;
                BigDecimal amtSumBaseTotal = BigDecimal.ZERO;
                DynamicObject natureType = null;
                String natureKey = "cas_recbill".equals(targetName) ? "yem_rectypenew" : "yem_paytypenew";
                ArrayList<DynamicObject> newRows = new ArrayList<DynamicObject>();
                for (DynamicObject entry : entryRow) {
                    Long entryId = entry.getLong("id");
                    if (!groupByEntryId.containsKey(entryId)) continue;
                    List<DynamicObject> newCreateBills = groupByEntryId.get(entryId);
                    natureType = newCreateBills.get(0).getDynamicObject(natureKey);
                    for (DynamicObject createBill : newCreateBills) {
                        DynamicObject saleagree;
                        DynamicObject addNew = (DynamicObject)OrmUtils.clone((Object)entryBlueRow.get(0), (IDataEntityType)((DynamicObject)entryBlueRow.get(0)).getDataEntityType(), (boolean)true, (boolean)true);
                        BigDecimal recpayamtx = createBill.getBigDecimal("yem_recpayamtx");
                        amtSumTotal = amtSumTotal.add(recpayamtx);
                        addNew.set("1".equals(datatype) ? "e_receivableamt" : "e_payableamt", (Object)recpayamtx);
                        addNew.set("e_actamt", (Object)recpayamtx);
                        addNew.set("e_unlockamt", (Object)recpayamtx);
                        addNew.set("e_unsettledamt", (Object)recpayamtx);
                        addNew.set("yem_canrecamt", (Object)recpayamtx);
                        addNew.set("yem_recamt", (Object)BigDecimal.ZERO);
                        addNew.set("yem_returnamt", (Object)BigDecimal.ZERO);
                        BigDecimal curramt = createBill.getBigDecimal("yem_curramt");
                        amtSumBaseTotal = amtSumBaseTotal.add(curramt);
                        addNew.set("1".equals(datatype) ? "e_receivablelocamt" : "e_payablelocamt", (Object)curramt);
                        addNew.set("e_localamt", (Object)curramt);
                        addNew.set("e_unsettledlocalamt", (Object)curramt);
                        if ("cas_recbill".equals(targetName)) {
                            addNew.set("yem_naturetype_e", createBill.get("yem_rectypenew"));
                        }
                        addNew.set("e_expenseitem", createBill.get("yem_paymentx"));
                        DynamicObject salebillno = createBill.getDynamicObject("yem_salebillnox");
                        if (salebillno != null) {
                            salebillno = BusinessDataServiceHelper.loadSingleFromCache((Object)salebillno.getLong("id"), (String)salebillno.getDynamicObjectType().getName());
                            addNew.set("yem_salebillno", (Object)salebillno);
                            addNew.set("e_corebilltype", (Object)salebillno.getString("yem_billkey"));
                            addNew.set("e_corebillid", (Object)salebillno.getLong("yem_billid"));
                            addNew.set("e_corebillno", (Object)salebillno.getString("yem_billno"));
                        }
                        if ((saleagree = createBill.getDynamicObject("yem_saleagreex")) != null) {
                            saleagree = BusinessDataServiceHelper.loadSingleFromCache((Object)saleagree.getLong("id"), (String)saleagree.getDynamicObjectType().getName());
                            addNew.set("yem_saleagree", (Object)saleagree);
                            addNew.set("e_corebilltype", (Object)saleagree.getString("yem_billkey"));
                            addNew.set("e_corebillid", (Object)saleagree.getLong("yem_billid"));
                            addNew.set("e_corebillno", (Object)saleagree.getString("yem_billno"));
                        }
                        addNew.set("e_sourcebillid", (Object)0L);
                        addNew.set("e_sourcebillentryid", (Object)0L);
                        newRows.add(addNew);
                    }
                }
                entryBlueRow.clear();
                entryBlueRow.addAll(newRows);
                this.setCreateValue(createblue, amtSumTotal, amtSumBaseTotal, targetName, bill, dataEntity.getString("billno"));
                if ("cas_paybill".equals(targetName)) {
                    createblue.set("yem_naturetype", natureType);
                }
                OperateOption option = YEM.getOption();
                option.setVariableValue("coderule_billno_from_init", "");
                option.setVariableValue("coderule_recycle", "");
                option.setVariableValue("WF", "TRUE");
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)targetName, (DynamicObject[])new DynamicObject[]{createblue}, (OperateOption)option);
                if (submitResult.isSuccess()) {
                    OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)targetName, (DynamicObject[])new DynamicObject[]{createblue}, (OperateOption)YEM.getOption());
                    if (!auditResult.isSuccess()) {
                        throw new KDBizException(String.format("\u5355\u636e\u7f16\u53f7\u4e3a%s\uff1a\u5ba1\u6838\u84dd\u5b57\u5355\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a%s", groupByBillId.get(billId).get(0).getString("yem_recpaybillno"), YEM.getOpErrorMsgNoTitle((OperationResult)auditResult)));
                    }
                    createblue.set("billstatus", (Object)"D");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{createblue});
                    continue;
                }
                throw new KDBizException(String.format("\u5355\u636e\u7f16\u53f7\u4e3a%s\uff1a\u63d0\u4ea4\u84dd\u5b57\u5355\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a%s", groupByBillId.get(billId).get(0).getString("yem_recpaybillno"), YEM.getOpErrorMsgNoTitle((OperationResult)submitResult)));
            }
        }
    }

    private List<DynamicObject> push(String billKey, String targetName, String ruleId, Long billId) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(billKey);
        pushArgs.setTargetEntityNumber(targetName);
        pushArgs.setHasRight(true);
        pushArgs.setRuleId(ruleId);
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        ListSelectedRow row = new ListSelectedRow();
        row.setPrimaryKeyValue((Object)billId);
        selectedRows.add(row);
        pushArgs.setSelectedRows(selectedRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (pushResult.isSuccess()) {
            MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)pushArgs.getTargetEntityNumber());
            return pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        }
        return null;
    }

    private void createRedBill(Long billId, Map<Long, List<DynamicObject>> groupByBillId, String datatype, DynamicObject dataEntity) {
        DynamicObjectCollection entryRows = dataEntity.getDynamicObjectCollection("yem_cnb_crdjl_xsfkxx");
        Map<Long, List<DynamicObject>> groupByEntryId = entryRows.stream().collect(Collectors.groupingBy(x -> x.getLong("yem_recpayentryidx")));
        String billKey = "1".equals(datatype) ? "ar_receivedbill" : "ap_paidbill";
        String targetName = "1".equals(datatype) ? "cas_recbill" : "cas_paybill";
        String ruleId = "1".equals(datatype) ? "2357405348140169216" : "2357417315571613696";
        DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)billKey);
        List<DynamicObject> targetBillObjs = this.push(billKey, targetName, ruleId, billId);
        if (targetBillObjs != null) {
            for (DynamicObject createRed : targetBillObjs) {
                DynamicObjectCollection entryRedRow = createRed.getDynamicObjectCollection("entry");
                DynamicObjectCollection entryRow = bill.getDynamicObjectCollection("entry");
                BigDecimal amtSumTotal = BigDecimal.ZERO;
                BigDecimal amtSumBaseTotal = BigDecimal.ZERO;
                ArrayList<DynamicObject> addList = new ArrayList<DynamicObject>();
                for (DynamicObject entry : entryRow) {
                    if (!groupByEntryId.containsKey(entry.getLong("id"))) continue;
                    DynamicObject addNew = (DynamicObject)OrmUtils.clone((Object)entryRedRow.get(0), (IDataEntityType)((DynamicObject)entryRedRow.get(0)).getDataEntityType(), (boolean)true, (boolean)true);
                    BigDecimal amtSum = BigDecimal.ZERO.subtract(groupByEntryId.get(entry.getLong("id")).stream().map(x -> x.getBigDecimal("yem_recpayamtx")).reduce(BigDecimal.ZERO, BigDecimal::add));
                    addNew.set("e_actamt", (Object)amtSum);
                    addNew.set("1".equals(datatype) ? "e_receivableamt" : "e_payableamt", (Object)amtSum);
                    addNew.set("yem_canrecamt", (Object)amtSum);
                    addNew.set("e_unlockamt", (Object)amtSum);
                    addNew.set("e_unsettledamt", (Object)amtSum);
                    amtSumTotal = amtSumTotal.add(amtSum);
                    addNew.set("yem_recamt", (Object)BigDecimal.ZERO);
                    addNew.set("yem_returnamt", (Object)BigDecimal.ZERO);
                    BigDecimal amtSumBase = BigDecimal.ZERO.subtract(groupByEntryId.get(entry.getLong("id")).stream().map(x -> x.getBigDecimal("yem_curramt")).reduce(BigDecimal.ZERO, BigDecimal::add));
                    addNew.set("1".equals(datatype) ? "e_receivablelocamt" : "e_payablelocamt", (Object)amtSumBase);
                    addNew.set("e_localamt", (Object)amtSumBase);
                    addNew.set("e_unsettledlocalamt", (Object)amtSumBase);
                    amtSumBaseTotal = amtSumBaseTotal.add(amtSumBase);
                    addNew.set("e_sourcebillid", (Object)0L);
                    addNew.set("e_sourcebillentryid", (Object)0L);
                    if ("cas_recbill".equals(targetName)) {
                        addNew.set("yem_naturetype_e", bill.get("yem_natureofpt"));
                    }
                    addNew.set("yem_purbillno", entry.get("yem_purbillno"));
                    addNew.set("yem_puragree", entry.get("yem_puragree"));
                    addNew.set("yem_salebillno", entry.get("yem_salebillno"));
                    addNew.set("yem_saleagree", entry.get("yem_saleagree"));
                    addList.add(addNew);
                }
                entryRedRow.clear();
                if (addList.size() > 0) {
                    entryRedRow.addAll(addList);
                }
                this.setCreateValue(createRed, amtSumTotal, amtSumBaseTotal, targetName, bill, dataEntity.getString("billno"));
                OperateOption option = YEM.getOption();
                option.setVariableValue("coderule_billno_from_init", "");
                option.setVariableValue("coderule_recycle", "");
                option.setVariableValue("WF", "TRUE");
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)targetName, (DynamicObject[])new DynamicObject[]{createRed}, (OperateOption)option);
                if (submitResult.isSuccess()) {
                    OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)targetName, (DynamicObject[])new DynamicObject[]{createRed}, (OperateOption)option);
                    if (!auditResult.isSuccess()) {
                        throw new KDBizException(String.format("\u5355\u636e\u7f16\u53f7\u4e3a%s\uff1a\u5ba1\u6838\u7ea2\u5b57\u5355\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a%s", groupByBillId.get(billId).get(0).getString("yem_recpaybillno"), YEM.getOpErrorMsgNoTitle((OperationResult)auditResult)));
                    }
                    createRed.set("billstatus", (Object)"D");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{createRed});
                    continue;
                }
                throw new KDBizException(String.format("\u5355\u636e\u7f16\u53f7\u4e3a%s\uff1a\u63d0\u4ea4\u7ea2\u5b57\u5355\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a%s", groupByBillId.get(billId).get(0).getString("yem_recpaybillno"), YEM.getOpErrorMsgNoTitle((OperationResult)submitResult)));
            }
        }
    }

    private void setCreateValue(DynamicObject createblue, BigDecimal amtSumTotal, BigDecimal amtSumBaseTotal, String billKey, DynamicObject bill, String billno) {
        DynamicObject itempayer;
        createblue.set("bizdate", (Object)new Date());
        createblue.set("yem_actdate", (Object)bill.getDate("bizdate"));
        createblue.set("cas_recbill".equals(billKey) ? "actrecamt" : "actpayamt", (Object)amtSumTotal);
        createblue.set("unsettleamount", (Object)amtSumTotal);
        createblue.set("localamt", (Object)amtSumBaseTotal);
        createblue.set("unsettleamountbase", (Object)amtSumBaseTotal);
        createblue.set("localamt", (Object)amtSumBaseTotal);
        createblue.set("unsettleamountbase", (Object)amtSumBaseTotal);
        createblue.set("sourcebilltype", (Object)"");
        createblue.set("sourcebillnumber", (Object)"");
        createblue.set("sourcebillid", (Object)0L);
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)billKey, (DynamicObject)createblue, null);
        String generateNumber = null;
        if (codeRule != null) {
            CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)createblue);
            generateNumber = codeRule.getNumber();
        }
        if (StringUtils.isEmpty(generateNumber)) {
            generateNumber = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        }
        createblue.set("yem_isrecord", (Object)true);
        createblue.set("billno", (Object)generateNumber);
        createblue.set("billstatus", (Object)"A");
        createblue.set("yem_recordbillno", (Object)billno);
        DynamicObject org = createblue.getDynamicObject("org");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("company", "=", (Object)org.getLong("id")));
        qFilters.add(new QFilter("bank", "=", (Object)createblue.getDynamicObject("cas_recbill".equals(billKey) ? "payeebank" : "payerbank").getLong("id")));
        DynamicObject am_accountbank = BusinessDataServiceHelper.loadSingle((String)"am_accountbank", (String)"bankaccountnumber", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (am_accountbank != null) {
            createblue.set("cas_recbill".equals(billKey) ? "accountbank" : "payeracctbank", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)am_accountbank.getLong("id"), (String)"am_accountbank"));
        }
        if ((itempayer = createblue.getDynamicObject("cas_recbill".equals(billKey) ? "itempayer" : "itempayee")) != null) {
            DynamicObject bankEntry;
            List isdefault_bank = (itempayer = BusinessDataServiceHelper.loadSingleFromCache((Object)itempayer.getLong("id"), (String)itempayer.getDynamicObjectType().getName())).getDynamicObjectCollection("entry_bank").stream().filter(x -> x.getBoolean("isdefault_bank")).collect(Collectors.toList());
            DynamicObject dynamicObject = bankEntry = isdefault_bank.size() > 0 ? (DynamicObject)isdefault_bank.get(0) : null;
            if (bankEntry != null) {
                createblue.set("cas_recbill".equals(billKey) ? "payeracctbanknum" : "payeebanknum", (Object)bankEntry.getString("bankaccount"));
                DynamicObject bank = bankEntry.getDynamicObject("bank");
                createblue.set("cas_recbill".equals(billKey) ? "f7_payerbank" : "payeebank", (Object)bank);
                createblue.set("cas_recbill".equals(billKey) ? "payerbankname" : "payeebankname", (Object)(bank != null ? bank.getString("name") : ""));
            }
        }
    }
}

