/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.cn.bill.wmtpl.opplugin.op;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;

public class ContractAgreeSaveOp
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        for (DynamicObject dataEntity : e.getDataEntities()) {
            switch (e.getOperationKey()) {
                case "save": 
                case "submit": {
                    this.setQtyotal(dataEntity);
                }
            }
        }
    }

    private void setQtyotal(DynamicObject dataEntity) {
        DynamicObjectCollection yem_materialentry = dataEntity.getDynamicObjectCollection("yem_materialentry");
        BigDecimal qty = yem_materialentry.stream().map(x -> x.getBigDecimal("yem_qty")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amounttax = dataEntity.getBigDecimal("yem_amounttax");
        if (qty.compareTo(BigDecimal.ZERO) > 0) {
            dataEntity.set("uav6_pricetotal", (Object)amounttax.divide(qty, 2, RoundingMode.HALF_UP));
            dataEntity.set("uav6_qtytital", (Object)qty);
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("yem_qty");
        fieldKeys.add("yem_amounttax");
        fieldKeys.add("uav6_pricetotal");
        fieldKeys.add("uav6_qtytital");
        fieldKeys.add("yem_materialentry");
    }
}

