/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.cn.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ContractPayReceUtil {
    public static BigDecimal getSaleReceipt(String billKey, Long billId, Boolean payType) {
        return ContractPayReceUtil.getSaleReceipt(billKey, billId, payType, false);
    }

    public static BigDecimal getSaleReceipt(String billKey, Long billId, Boolean payType, Boolean ispay) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("billstatus", "in", Arrays.asList("C", "D")));
        qFilters.add(new QFilter("entry.e_corebilltype", "=", (Object)billKey));
        qFilters.add(new QFilter("entry.e_corebillid", "=", (Object)String.valueOf(billId)));
        qFilters.add(new QFilter("entry.yem_naturetype_e.number", "=", (Object)(payType != false ? "1001" : "BD-0010")));
        DynamicObjectCollection cas_recbil = QueryServiceHelper.query((String)"cas_recbill", (String)"id,entry.e_localamt e_localamt", (QFilter[])qFilters.toArray(new QFilter[0]));
        BigDecimal amt = cas_recbil.stream().map(x -> x.getBigDecimal("e_localamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        qFilters.clear();
        qFilters.add(new QFilter("billstatus", "in", ispay != false ? Collections.singletonList("D") : Arrays.asList("C", "D")));
        qFilters.add(new QFilter("entry.e_corebilltype", "=", (Object)billKey));
        qFilters.add(new QFilter("entry.e_corebillid", "=", (Object)billId));
        qFilters.add(new QFilter("yem_naturetype.number", "=", (Object)(payType != false ? "BD-0013" : "BD-0004")));
        DynamicObjectCollection cas_paybill = QueryServiceHelper.query((String)"cas_paybill", (String)"id,entry.e_localamt e_localamt", (QFilter[])qFilters.toArray(new QFilter[0]));
        amt = amt.subtract(cas_paybill.stream().map(x -> x.getBigDecimal("e_localamt")).reduce(BigDecimal.ZERO, BigDecimal::add));
        return amt.compareTo(BigDecimal.ZERO) > 0 ? amt : BigDecimal.ZERO;
    }

    public static BigDecimal getPurPayment(String billKey, Long billId) {
        return ContractPayReceUtil.getPurPayment(billKey, billId, false);
    }

    public static BigDecimal getPurPayment(String billKey, Long billId, Boolean ispay) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("billstatus", "in", ispay != false ? Collections.singletonList("D") : Arrays.asList("C", "D")));
        qFilters.add(new QFilter("entry.e_corebilltype", "=", (Object)billKey));
        qFilters.add(new QFilter("entry.e_corebillid", "=", (Object)billId));
        DynamicObjectCollection cas_recbil = QueryServiceHelper.query((String)"cas_paybill", (String)"id,entry.e_actamt e_actamt", (QFilter[])qFilters.toArray(new QFilter[0]));
        BigDecimal amt = cas_recbil.stream().map(x -> x.getBigDecimal("e_actamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        qFilters.clear();
        qFilters.add(new QFilter("billstatus", "in", Arrays.asList("C", "D")));
        qFilters.add(new QFilter("entry.e_corebilltype", "=", (Object)billKey));
        qFilters.add(new QFilter("entry.e_corebillid", "=", (Object)String.valueOf(billId)));
        DynamicObjectCollection cas_paybill = QueryServiceHelper.query((String)"cas_recbill", (String)"id,entry.e_actamt e_actamt", (QFilter[])qFilters.toArray(new QFilter[0]));
        amt = amt.subtract(cas_paybill.stream().map(x -> x.getBigDecimal("e_actamt")).reduce(BigDecimal.ZERO, BigDecimal::add));
        return amt.compareTo(BigDecimal.ZERO) > 0 ? amt : BigDecimal.ZERO;
    }

    public static BigDecimal getInHouseAmt(String billKey, Long billId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("entry.e_corebilltype", "=", (Object)billKey));
        qFilters.add(new QFilter("entry.corebillid", "=", (Object)billId));
        DynamicObjectCollection ap_busbill = QueryServiceHelper.query((String)"ap_busbill", (String)"entry.e_uninvoicedamt e_uninvoicedamt", (QFilter[])qFilters.toArray(new QFilter[0]));
        BigDecimal busamt = ap_busbill.stream().map(x -> x.getBigDecimal("e_uninvoicedamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        qFilters.clear();
        qFilters.add(new QFilter("detailentry.corebilltype", "=", (Object)billKey));
        qFilters.add(new QFilter("detailentry.corebillid", "=", (Object)billId));
        DynamicObjectCollection ap_finapbill = QueryServiceHelper.query((String)"ap_finapbill", (String)"detailentry.e_pricetaxtotal e_pricetaxtotal", (QFilter[])qFilters.toArray(new QFilter[0]));
        BigDecimal finapamt = ap_finapbill.stream().map(x -> x.getBigDecimal("e_pricetaxtotal")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return busamt.add(finapamt);
    }
}

