/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.cn.warn.salcollection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnDataSource;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import yem.base.common.utils.YEM;
import yem.shmjs.cn.util.ContractPayReceUtil;
import yem.shmjs.cn.warn.util.WarnUtils;

public class SalCollectionDataSource
implements IEarlyWarnDataSource {
    public List<QFilter> buildFilter(String s, FilterCondition filterCondition, EarlyWarnContext earlyWarnContext) {
        return WarnUtils.buildFilter(s, filterCondition);
    }

    public DynamicObjectCollection getData(String s, List<QFilter> list, EarlyWarnContext context) {
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)s, (String)"id", (QFilter[])list.toArray(new QFilter[0]));
        List<Long> billId = WarnUtils.advanceFilter(bills, s, context);
        ArrayList<Long> billIds = new ArrayList<Long>();
        for (DynamicObject bill : bills) {
            boolean isadd = false;
            if (!billId.contains((bill = BusinessDataServiceHelper.loadSingleFromCache((Object)bill.getLong("id"), (String)s)).getLong("id"))) continue;
            BigDecimal amt = ContractPayReceUtil.getSaleReceipt(s, bill.getLong("id"), true);
            amt = amt.add(ContractPayReceUtil.getSaleReceipt(s, bill.getLong("id"), false));
            DynamicObjectCollection cnb_recpayentry = bill.getDynamicObjectCollection("yem_cnb_recpayentry");
            cnb_recpayentry.removeIf(x -> YEM.isEmpty((Object)x.getDate("yem_recadvancedate")));
            cnb_recpayentry.sort(Comparator.comparing(o -> o.getDate("yem_recadvancedate")));
            BigDecimal addAmount = BigDecimal.ZERO;
            for (DynamicObject recpayentry : cnb_recpayentry) {
                if ((addAmount = addAmount.add(recpayentry.getBigDecimal("yem_rapamt"))).compareTo(amt) <= 0) continue;
                isadd = true;
            }
            if (!isadd) continue;
            billIds.add(bill.getLong("id"));
        }
        return QueryServiceHelper.query((String)s, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
    }

    public List<Map<String, Object>> getCommonFilterColumns(String s) {
        return null;
    }

    public TreeNode getSingleMessageFieldTree(String s) {
        return WarnUtils.createTreeNode(s);
    }

    public TreeNode getMergeMessageFieldTree(String s) {
        return null;
    }
}

