/*
 * Decompiled with CFR 0.152.
 */
package yem.shmjs.cn.warn.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.service.earlywarn.formula.EWFormulaHandler;
import kd.bos.service.earlywarn.var.IVariableMode;
import kd.bos.service.earlywarn.var.SourceFieldVariable;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.utils.YEM;

public class WarnUtils {
    public static List<String> addFormulaSourceFields(List<IVariableMode> vars) {
        ArrayList<String> formulaFields = new ArrayList<String>();
        for (IVariableMode var : vars) {
            if (!(var instanceof SourceFieldVariable)) continue;
            SourceFieldVariable srcField = (SourceFieldVariable)var;
            String fldString = srcField.getFullPropName();
            formulaFields.add(fldString);
        }
        return formulaFields;
    }

    public static DynamicProperty getFieldProp(String field, IDataEntityType dataEntityType) {
        String[] keys = StringUtil.split((String)field, (String)".");
        if (keys.length == 1) {
            IDataEntityProperty prop = (IDataEntityProperty)dataEntityType.getProperties().get((Object)field);
            return prop == null ? null : (DynamicProperty)prop;
        }
        IDataEntityType propertyType = dataEntityType;
        IDataEntityProperty property = null;
        for (int i = 0; i < keys.length; ++i) {
            property = (IDataEntityProperty)propertyType.getProperties().get((Object)keys[i]);
            if (i == keys.length - 1) break;
            if (!(property instanceof BasedataProp)) {
                property = null;
                break;
            }
            propertyType = ((BasedataProp)property).getComplexType();
        }
        return property == null ? null : (DynamicProperty)property;
    }

    public static List<QFilter> buildFilter(String dataSourceType, FilterCondition filterCondition) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter qFilter = PermCommonUtil.getQFilterFromEntNumFilterCondition((String)dataSourceType, (FilterCondition)filterCondition);
        qFilters.add(qFilter);
        return qFilters;
    }

    public static List<Long> advanceFilter(DynamicObject[] bills, String s, EarlyWarnContext context) {
        EWFormulaHandler formulaHandler = new EWFormulaHandler(context, (BillEntityType)EntityMetadataCache.getDataEntityType((String)s));
        HashMap<String, DynamicProperty> fieldProps = new HashMap<String, DynamicProperty>();
        List<String> formulaFields = WarnUtils.addFormulaSourceFields(formulaHandler.getVars());
        if (YEM.isNotEmpty((Object)formulaHandler.getFormula()) && bills.length > 0) {
            DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((Object)bills[0].getLong("id"), (String)s);
            IDataEntityType dataEntityType = bill.getDataEntityType();
            for (String field : formulaFields) {
                DynamicProperty fieldProp = WarnUtils.getFieldProp(field, dataEntityType);
                fieldProps.put(field, fieldProp);
            }
        }
        ArrayList<Long> billId = new ArrayList<Long>();
        for (DynamicObject bill : bills) {
            bill = BusinessDataServiceHelper.loadSingleFromCache((Object)bill.getLong("id"), (String)s);
            if (fieldProps.size() == 0) {
                billId.add(bill.getLong("id"));
                continue;
            }
            if (!((Boolean)formulaHandler.getValue(fieldProps, bill)).booleanValue()) continue;
            billId.add(bill.getLong("id"));
        }
        return billId;
    }

    public static TreeNode createTreeNode(String s) {
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setIncludeEntryEntityAsKeyPrefix(true);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)s);
        TreeNode root = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainEntityType, (PropTreeBuildOption)option);
        root.setIsOpened(true);
        return root;
    }
}

