/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.sm.bill.invoiceverification.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.plugin.Plugin;
import yem.base.common.utils.BigDecimalUtils;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.StringUtils;

public class InvoiceVerificationFormPlugin
extends AbstractBillPlugIn
implements Plugin,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((BasedataEdit)this.getView().getControl("yem_contractno_dd")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"push(red)", "push(reverse)"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("push(reverse)".equals(itemKey) || "push(red)".equals(itemKey)) {
            this.getModel().setValue("yem_isreverse", (Object)"push(reverse)".equals(itemKey));
        }
        DynamicObject entity = this.getModel().getDataEntity(true);
        SaveServiceHelper.update((DynamicObject)entity);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        switch (key = beforeF7SelectEvent.getProperty().getName()) {
            case "yem_contractno_dd": {
                this.beforeOrderBillSelect(beforeF7SelectEvent, key);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "submit": {
                this.submit_check(e);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "backfillfinalinvoice": {
                this.backFillFinalInvoice();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String key;
        super.closedCallBack(e);
        switch (key = e.getActionId()) {
            case "yem_contractno_dd": {
                this.orderBillCallBack(e);
                break;
            }
            case "backfillfinalinvoic": {
                this.backfillfinalinvoicCallBack(e);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getCallBackId().equals("submit_check") && evt.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("submit_check", "true");
            this.getView().invokeOperation("submit", operateOption);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        String key = e.getProperty().getName();
        DynamicObject bill = model.getDataEntity(true);
        switch (key) {
            case "yem_quantityofinvoice": {
                this.cal_yem_amountofnvoice();
                this.cal_yem_quantityofinvoice_last(rowIndex);
                this.cal_yem_amttax_p();
                break;
            }
            case "yem_isfinalinvoice": {
                this.cal_yem_quantityofinvoice();
                this.cal_yem_amountofnvoice();
                this.cal_yem_amttax_p();
                break;
            }
            case "yem_amountofnvoice": {
                this.cal_yem_amountofnvoice_last(rowIndex);
                this.cal_yem_amttax_p();
                break;
            }
        }
    }

    private void beforeOrderBillSelect(BeforeF7SelectEvent e, String key) {
        DynamicObject contracttype;
        List ids;
        DynamicObject yem_supplier;
        IDataModel model = this.getModel();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("yem_billstatus", "=", (Object)"C"));
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            qFilters.add(new QFilter("yem_org", "=", org.getPkValue()));
        }
        if ((yem_supplier = (DynamicObject)model.getValue("yem_supplier")) != null) {
            qFilters.add(new QFilter("yem_cusorsupp", "=", yem_supplier.getPkValue()));
        }
        if (!(ids = model.getEntryEntity("yem_dt_purchase_dd").stream().filter(x -> x.getDynamicObject("yem_contractno_dd") != null).map(x -> x.getDynamicObject("yem_contractno_dd").getLong("id")).collect(Collectors.toList())).isEmpty()) {
            qFilters.add(new QFilter("id", "not in", ids));
        }
        if ((contracttype = (DynamicObject)model.getValue("yem_contracttype")) != null) {
            qFilters.add(new QFilter("yem_billkey", "=", (Object)contracttype.getString("number")));
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.setMultiSelect(false);
        showParameter.getListFilterParameter().setQFilters(qFilters);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
    }

    public List<Long> get_final_order_ids() {
        IDataModel model = this.getModel();
        DynamicObject bill = model.getDataEntity(true);
        String bill_key = bill.getDynamicObjectType().getName();
        ArrayList<Long> ids = new ArrayList<Long>();
        QFilter qFilter = new QFilter("yem_dt_purchase_dd.yem_isfinalinvoice", "=", (Object)"A");
        qFilter.and(new QFilter("id", "!=", bill.getPkValue()));
        String selectfields = DynamicObjectUtil.getSelectfieldsFast((String)bill_key, (String[])new String[]{"yem_dt_purchase_dd"});
        DynamicObject[] yem_dt_purchase_s = BusinessDataServiceHelper.load((String)bill_key, (String)selectfields, (QFilter[])new QFilter[]{qFilter});
        if (null != yem_dt_purchase_s && yem_dt_purchase_s.length > 0) {
            for (DynamicObject yem_dt_purchase : yem_dt_purchase_s) {
                DynamicObjectCollection yem_dt_purchase_dd_s = yem_dt_purchase.getDynamicObjectCollection("yem_dt_purchase_dd");
                for (DynamicObject yem_dt_purchase_dd : yem_dt_purchase_dd_s) {
                    String yem_isfinalinvoice = yem_dt_purchase_dd.getString("yem_isfinalinvoice");
                    DynamicObject yem_contractno_dd = yem_dt_purchase_dd.getDynamicObject("yem_contractno_dd");
                    if (null == yem_contractno_dd || !"A".equals(yem_isfinalinvoice)) continue;
                    ids.add(yem_contractno_dd.getLong("id"));
                }
            }
        }
        return ids;
    }

    private void orderBillCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)e.getReturnData();
        if (null != returnData && returnData.size() > 0) {
            Object[] ids = new Object[returnData.size()];
            for (int i = 0; i < returnData.size(); ++i) {
                ids[i] = returnData.get(i).getPrimaryKeyValue();
            }
            String selectfields = DynamicObjectUtil.getSelectfieldsFast((String)"yem_bd_contractinfor", (String[])new String[0]);
            DynamicObject[] order_s = BusinessDataServiceHelper.load((String)"yem_bd_contractinfor", (String)selectfields, (QFilter[])new QFilter("id", "in", (Object)ids).toArray());
            for (int i = 0; i < order_s.length; ++i) {
                DynamicObject order = order_s[i];
                DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)order.getLong("yem_billid"), (String)order.getString("yem_billkey"));
                DynamicObjectCollection billEntry = contract.getDynamicObjectCollection("yem_materialentry");
                int rowIndex = i == 0 ? model.getEntryCurrentRowIndex("yem_dt_purchase_dd") : model.createNewEntryRow("yem_dt_purchase_dd");
                model.setValue("yem_supplier", order.get("yem_cusorsupp"));
                model.setValue("yem_contractno_dd", (Object)order, rowIndex);
                BigDecimal yem_pur_qty = this.cal_yem_pur_qty(order.getLong("yem_billid"));
                model.setValue("yem_pur_qty", (Object)yem_pur_qty, rowIndex);
                BigDecimal yem_pay_qty = this.cal_yem_pay_qty(order.getString("name"));
                model.setValue("yem_pay_qty", (Object)yem_pay_qty, rowIndex);
                BigDecimal yem_unrecognized_qty = BigDecimalUtils.sub((BigDecimal)yem_pur_qty, (BigDecimal)yem_pay_qty, (int)10);
                model.setValue("yem_unrecognized_qty", (Object)yem_unrecognized_qty, rowIndex);
                if (billEntry.isEmpty()) continue;
                DynamicObject row = (DynamicObject)billEntry.get(0);
                model.setValue("yem_material_dd", row.get("yem_material"), rowIndex);
                model.setValue("yem_unitmeasure", row.get("yem_baseunit"), rowIndex);
            }
            this.getView().updateView("yem_dt_purchase_dd");
        }
    }

    public BigDecimal cal_yem_pur_qty(Long billid) {
        IDataModel model = this.getModel();
        BigDecimal qty_s = BigDecimal.ZERO;
        if (null != billid) {
            QFilter qFilter = new QFilter("billentry.mainbillid", "=", (Object)billid);
            String selectfields = DynamicObjectUtil.getSelectfieldsFast((String)"im_purinbill", (String[])new String[]{"billentry"});
            DynamicObject[] im_purinbill_s = BusinessDataServiceHelper.load((String)"im_purinbill", (String)selectfields, (QFilter[])new QFilter[]{qFilter});
            if (null != im_purinbill_s && im_purinbill_s.length > 0) {
                for (DynamicObject im_purinbill : im_purinbill_s) {
                    DynamicObjectCollection billentry_s = im_purinbill.getDynamicObjectCollection("billentry");
                    for (DynamicObject billentry : billentry_s) {
                        BigDecimal qty = billentry.getBigDecimal("qty");
                        qty_s = BigDecimalUtils.add((BigDecimal)qty_s, (BigDecimal)qty, (int)10);
                    }
                }
            }
        }
        return qty_s;
    }

    public BigDecimal cal_yem_pay_qty(String order_billno) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ApFin_purfee_BT_S");
        list.add("ApFin_salefee_BT_S");
        list.add("ApFin_borr_BT_S");
        BigDecimal qty_s = BigDecimal.ZERO;
        QFilter qFilter = new QFilter("detailentry.corebillno", "=", (Object)order_billno);
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qFilter.and(new QFilter("billtypeid.number", "not in", list));
        String selectfields = DynamicObjectUtil.getSelectfieldsFast((String)"ap_finapbill", (String[])new String[]{"detailentry"});
        DynamicObject[] ap_finapbill_s = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)selectfields, (QFilter[])new QFilter[]{qFilter});
        if (null != ap_finapbill_s && ap_finapbill_s.length > 0) {
            for (DynamicObject ap_finapbill : ap_finapbill_s) {
                DynamicObjectCollection detailentry_s = ap_finapbill.getDynamicObjectCollection("detailentry");
                for (DynamicObject detailentry : detailentry_s) {
                    String corebillno = detailentry.getString("corebillno");
                    if (null == order_billno || null == corebillno || !order_billno.equals(corebillno)) continue;
                    BigDecimal quantity = detailentry.getBigDecimal("quantity");
                    qty_s = BigDecimalUtils.add((BigDecimal)qty_s, (BigDecimal)quantity, (int)10);
                }
            }
        }
        return qty_s;
    }

    public void submit_check(BeforeDoOperationEventArgs e) {
        IDataModel model = this.getModel();
        DynamicObject bill = model.getDataEntity(true);
        DynamicObjectCollection yem_dt_purchase_dd_s = model.getEntryEntity("yem_dt_purchase_dd");
        HashMap<Long, BigDecimal> qty_map = new HashMap<Long, BigDecimal>();
        ArrayList<Object> yem_contractno_dd_ids = new ArrayList<Object>();
        for (DynamicObject yem_dt_purchase_dd : yem_dt_purchase_dd_s) {
            DynamicObject yem_contractno_dd = yem_dt_purchase_dd.getDynamicObject("yem_contractno_dd");
            if (null == yem_contractno_dd) continue;
            yem_contractno_dd_ids.add(yem_contractno_dd.getPkValue());
        }
        QFilter qFilter = new QFilter("yem_dt_purchase_dd.yem_contractno_dd", "in", yem_contractno_dd_ids);
        qFilter.and(new QFilter("id", "!=", (Object)bill.getLong("id")));
        String selectfields = DynamicObjectUtil.getSelectfieldsFast((String)"yem_invoice_verification", (String[])new String[]{"yem_dt_purchase_dd"});
        DynamicObject[] bill_old_s = BusinessDataServiceHelper.load((String)"yem_invoice_verification", (String)selectfields, (QFilter[])new QFilter[]{qFilter});
        if (null != bill_old_s) {
            for (DynamicObject bill_old : bill_old_s) {
                DynamicObjectCollection yem_dt_purchase_dd_old_s = bill_old.getDynamicObjectCollection("yem_dt_purchase_dd");
                for (DynamicObject yem_dt_purchase_dd_old : yem_dt_purchase_dd_old_s) {
                    DynamicObject yem_contractno_dd = yem_dt_purchase_dd_old.getDynamicObject("yem_contractno_dd");
                    long yem_contractno_dd_id = yem_contractno_dd == null ? 0L : yem_contractno_dd.getLong("id");
                    BigDecimal yem_quantityofinvoice = yem_dt_purchase_dd_old.getBigDecimal("yem_quantityofinvoice");
                    if (qty_map.containsKey(yem_contractno_dd_id)) {
                        BigDecimal yem_quantityofinvoice_old = BigDecimalUtils.toBigDecimal(qty_map.get(yem_contractno_dd_id));
                        qty_map.put(yem_contractno_dd_id, BigDecimalUtils.add((BigDecimal)yem_quantityofinvoice_old, (BigDecimal)yem_quantityofinvoice, (int)10));
                        continue;
                    }
                    qty_map.put(yem_contractno_dd_id, yem_quantityofinvoice);
                }
            }
        }
        String msg = "";
        for (int i = 0; i < yem_dt_purchase_dd_s.size(); ++i) {
            BigDecimal yem_pur_qty;
            DynamicObject yem_dt_purchase_dd = (DynamicObject)yem_dt_purchase_dd_s.get(i);
            DynamicObject yem_contractno_dd = yem_dt_purchase_dd.getDynamicObject("yem_contractno_dd");
            long yem_contractno_dd_id = yem_contractno_dd == null ? 0L : yem_contractno_dd.getLong("id");
            BigDecimal yem_quantityofinvoice = yem_dt_purchase_dd.getBigDecimal("yem_quantityofinvoice");
            BigDecimal yem_quantityofinvoice_old = qty_map.containsKey(yem_contractno_dd_id) ? BigDecimalUtils.toBigDecimal(qty_map.get(yem_contractno_dd_id)) : BigDecimal.ZERO;
            if ((yem_quantityofinvoice = BigDecimalUtils.add((BigDecimal)yem_quantityofinvoice, (BigDecimal)yem_quantityofinvoice_old, (int)10)).compareTo(yem_pur_qty = yem_dt_purchase_dd.getBigDecimal("yem_pur_qty")) <= 0) continue;
            msg = msg + "\u5408\u540c\u4fe1\u606f\u7b2c" + (i + 1) + "\u884c\u7d2f\u8ba1\u6536\u7968\u5bf9\u5e94\u5b9e\u7269\u6570\u91cf\u5927\u4e8e\u7d2f\u8ba1\u5165\u5e93\u6570\u91cf\uff0c\u662f\u5426\u7ee7\u7eed\uff1f\n";
        }
        if (StringUtils.isNotEmpty((String)msg)) {
            FormOperate operate = (FormOperate)e.getSource();
            RefObject submit_check = new RefObject();
            if (!operate.getOption().tryGetVariableValue("submit_check", submit_check)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submit_check", (IFormPlugin)this);
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                e.setCancel(true);
            }
        }
    }

    public void cal_yem_amountofnvoice_last(int rowIndex) {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("yem_dt_purchase_dd");
        if (-1 == rowIndex || rowIndex == rowCount - 1) {
            return;
        }
        BigDecimal yem_intotalamount_s = BigDecimal.ZERO;
        DynamicObjectCollection yem_dt_purchase_fp_s = model.getEntryEntity("yem_dt_purchase_fp");
        for (DynamicObject yem_dt_purchase_fp : yem_dt_purchase_fp_s) {
            BigDecimal yem_intotalamount = yem_dt_purchase_fp.getBigDecimal("yem_intotalamount");
            yem_intotalamount_s = BigDecimalUtils.add((BigDecimal)yem_intotalamount_s, (BigDecimal)yem_intotalamount, (int)10);
        }
        BigDecimal yem_amountofnvoice_s = BigDecimal.ZERO;
        DynamicObjectCollection yem_dt_purchase_dd_s = model.getEntryEntity("yem_dt_purchase_dd");
        for (int i = 0; i < yem_dt_purchase_dd_s.size(); ++i) {
            BigDecimal yem_amountofnvoice;
            DynamicObject yem_dt_purchase_dd = (DynamicObject)yem_dt_purchase_dd_s.get(i);
            if (i == yem_dt_purchase_dd_s.size() - 1) {
                yem_amountofnvoice = BigDecimalUtils.sub((BigDecimal)yem_intotalamount_s, (BigDecimal)yem_amountofnvoice_s, (int)10);
                if (yem_amountofnvoice.compareTo(BigDecimal.ZERO) < 0) {
                    yem_amountofnvoice = BigDecimal.ZERO;
                }
                model.setValue("yem_amountofnvoice", (Object)yem_amountofnvoice, i);
                continue;
            }
            yem_amountofnvoice = yem_dt_purchase_dd.getBigDecimal("yem_amountofnvoice");
            yem_amountofnvoice_s = BigDecimalUtils.add((BigDecimal)yem_amountofnvoice_s, (BigDecimal)yem_amountofnvoice, (int)10);
        }
    }

    public void cal_yem_quantityofinvoice() {
        BigDecimal yem_unrecognized_qty;
        String yem_isfinalinvoice;
        DynamicObject yem_dt_purchase_dd;
        int i;
        IDataModel model = this.getModel();
        BigDecimal yem_num_s = BigDecimal.ZERO;
        DynamicObjectCollection yem_dt_purchase_fp_s = model.getEntryEntity("yem_dt_purchase_fp");
        for (DynamicObject yem_dt_purchase_fp : yem_dt_purchase_fp_s) {
            BigDecimal yem_num = yem_dt_purchase_fp.getBigDecimal("yem_num");
            yem_num_s = BigDecimalUtils.add((BigDecimal)yem_num_s, (BigDecimal)yem_num, (int)10);
        }
        DynamicObjectCollection yem_dt_purchase_dd_s = model.getEntryEntity("yem_dt_purchase_dd");
        for (i = 0; i < yem_dt_purchase_dd_s.size(); ++i) {
            yem_dt_purchase_dd = (DynamicObject)yem_dt_purchase_dd_s.get(i);
            yem_isfinalinvoice = yem_dt_purchase_dd.getString("yem_isfinalinvoice");
            if (!"A".equals(yem_isfinalinvoice)) continue;
            yem_unrecognized_qty = yem_dt_purchase_dd.getBigDecimal("yem_unrecognized_qty");
            model.setValue("yem_quantityofinvoice", (Object)yem_unrecognized_qty, i);
            yem_num_s = BigDecimalUtils.sub((BigDecimal)yem_num_s, (BigDecimal)yem_unrecognized_qty, (int)10);
        }
        for (i = 0; i < yem_dt_purchase_dd_s.size(); ++i) {
            yem_dt_purchase_dd = (DynamicObject)yem_dt_purchase_dd_s.get(i);
            yem_isfinalinvoice = yem_dt_purchase_dd.getString("yem_isfinalinvoice");
            if ("A".equals(yem_isfinalinvoice) || yem_num_s.compareTo(BigDecimal.ZERO) <= 0) continue;
            yem_unrecognized_qty = yem_dt_purchase_dd.getBigDecimal("yem_unrecognized_qty");
            if (yem_num_s.compareTo(yem_unrecognized_qty) > 0) {
                model.setValue("yem_quantityofinvoice", (Object)yem_unrecognized_qty, i);
                yem_num_s = BigDecimalUtils.sub((BigDecimal)yem_num_s, (BigDecimal)yem_unrecognized_qty, (int)10);
                continue;
            }
            model.setValue("yem_quantityofinvoice", (Object)yem_num_s, i);
            yem_num_s = BigDecimal.ZERO;
        }
    }

    public void cal_yem_amttax_p() {
        IDataModel model = this.getModel();
        BigDecimal yem_totaltaxamount_s = BigDecimal.ZERO;
        DynamicObjectCollection yem_dt_purchase_fp_s = model.getEntryEntity("yem_dt_purchase_fp");
        for (DynamicObject yem_dt_purchase_fp : yem_dt_purchase_fp_s) {
            BigDecimal yem_totaltaxamount = yem_dt_purchase_fp.getBigDecimal("yem_totaltaxamount");
            yem_totaltaxamount_s = BigDecimalUtils.add((BigDecimal)yem_totaltaxamount_s, (BigDecimal)yem_totaltaxamount, (int)10);
        }
        BigDecimal yem_amountofnvoice_s = BigDecimal.ZERO;
        DynamicObjectCollection yem_dt_purchase_dd_s = model.getEntryEntity("yem_dt_purchase_dd");
        for (DynamicObject yem_dt_purchase_dd : yem_dt_purchase_dd_s) {
            BigDecimal yem_amountofnvoice = yem_dt_purchase_dd.getBigDecimal("yem_amountofnvoice");
            yem_amountofnvoice_s = BigDecimalUtils.add((BigDecimal)yem_amountofnvoice_s, (BigDecimal)yem_amountofnvoice, (int)10);
        }
        int yem_paymentcurrency_amtprecision = 2;
        BigDecimal yem_amttax_p_s = BigDecimal.ZERO;
        for (int i = 0; i < yem_dt_purchase_dd_s.size(); ++i) {
            BigDecimal yem_amountofnvoice = ((DynamicObject)yem_dt_purchase_dd_s.get(i)).getBigDecimal("yem_amountofnvoice");
            BigDecimal yem_amttax_p = BigDecimal.ZERO;
            if (i == yem_dt_purchase_dd_s.size() - 1) {
                yem_amttax_p = BigDecimalUtils.sub((BigDecimal)yem_totaltaxamount_s, (BigDecimal)yem_amttax_p_s, (int)10);
            } else {
                yem_amttax_p = BigDecimalUtils.div((BigDecimal)yem_amountofnvoice, (BigDecimal)yem_amountofnvoice_s, (int)10);
                yem_amttax_p = BigDecimalUtils.multiply((BigDecimal)yem_totaltaxamount_s, (BigDecimal)yem_amttax_p, (int)yem_paymentcurrency_amtprecision);
            }
            model.setValue("yem_amttax_p", (Object)yem_amttax_p, i);
            yem_amttax_p_s = BigDecimalUtils.add((BigDecimal)yem_amttax_p_s, (BigDecimal)yem_amttax_p, (int)10);
        }
    }

    public void cal_yem_quantityofinvoice_last(int rowIndex) {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("yem_dt_purchase_dd");
        if (-1 == rowIndex || rowIndex == rowCount - 1) {
            return;
        }
        BigDecimal yem_num_s = BigDecimal.ZERO;
        DynamicObjectCollection yem_dt_purchase_fp_s = model.getEntryEntity("yem_dt_purchase_fp");
        for (DynamicObject yem_dt_purchase_fp : yem_dt_purchase_fp_s) {
            BigDecimal yem_num = yem_dt_purchase_fp.getBigDecimal("yem_num");
            yem_num_s = BigDecimalUtils.add((BigDecimal)yem_num_s, (BigDecimal)yem_num, (int)10);
        }
        BigDecimal yem_quantityofinvoice_s = BigDecimal.ZERO;
        DynamicObjectCollection yem_dt_purchase_dd_s = model.getEntryEntity("yem_dt_purchase_dd");
        for (int i = 0; i < yem_dt_purchase_dd_s.size(); ++i) {
            BigDecimal yem_quantityofinvoice;
            DynamicObject yem_dt_purchase_dd = (DynamicObject)yem_dt_purchase_dd_s.get(i);
            if (i == yem_dt_purchase_dd_s.size() - 1) {
                yem_quantityofinvoice = BigDecimalUtils.sub((BigDecimal)yem_num_s, (BigDecimal)yem_quantityofinvoice_s, (int)10);
                if (yem_quantityofinvoice.compareTo(BigDecimal.ZERO) < 0) {
                    yem_quantityofinvoice = BigDecimal.ZERO;
                }
                model.setValue("yem_quantityofinvoice", (Object)yem_quantityofinvoice, i);
                continue;
            }
            yem_quantityofinvoice = yem_dt_purchase_dd.getBigDecimal("yem_quantityofinvoice");
            yem_quantityofinvoice_s = BigDecimalUtils.add((BigDecimal)yem_quantityofinvoice_s, (BigDecimal)yem_quantityofinvoice, (int)10);
        }
    }

    public void cal_yem_amountofnvoice() {
        IDataModel model = this.getModel();
        BigDecimal yem_intotalamount_s = BigDecimal.ZERO;
        DynamicObjectCollection yem_dt_purchase_fp_s = model.getEntryEntity("yem_dt_purchase_fp");
        for (DynamicObject yem_dt_purchase_fp : yem_dt_purchase_fp_s) {
            BigDecimal yem_intotalamount = yem_dt_purchase_fp.getBigDecimal("yem_intotalamount");
            yem_intotalamount_s = BigDecimalUtils.add((BigDecimal)yem_intotalamount_s, (BigDecimal)yem_intotalamount, (int)10);
        }
        BigDecimal yem_quantityofinvoice_s = BigDecimal.ZERO;
        DynamicObjectCollection yem_dt_purchase_dd_s = model.getEntryEntity("yem_dt_purchase_dd");
        for (DynamicObject yem_dt_purchase_dd : yem_dt_purchase_dd_s) {
            BigDecimal yem_quantityofinvoice = yem_dt_purchase_dd.getBigDecimal("yem_quantityofinvoice");
            yem_quantityofinvoice_s = BigDecimalUtils.add((BigDecimal)yem_quantityofinvoice_s, (BigDecimal)yem_quantityofinvoice, (int)10);
        }
        int yem_paymentcurrency_amtprecision = 2;
        BigDecimal yem_amountofnvoice_s = BigDecimal.ZERO;
        for (int i = 0; i < yem_dt_purchase_dd_s.size(); ++i) {
            BigDecimal yem_quantityofinvoice = ((DynamicObject)yem_dt_purchase_dd_s.get(i)).getBigDecimal("yem_quantityofinvoice");
            BigDecimal yem_amountofnvoice = BigDecimal.ZERO;
            if (i == yem_dt_purchase_dd_s.size() - 1) {
                yem_amountofnvoice = BigDecimalUtils.sub((BigDecimal)yem_intotalamount_s, (BigDecimal)yem_amountofnvoice_s, (int)10);
            } else {
                yem_amountofnvoice = BigDecimalUtils.div((BigDecimal)yem_quantityofinvoice, (BigDecimal)yem_quantityofinvoice_s, (int)10);
                yem_amountofnvoice = BigDecimalUtils.multiply((BigDecimal)yem_intotalamount_s, (BigDecimal)yem_amountofnvoice, (int)yem_paymentcurrency_amtprecision);
            }
            model.setValue("yem_amountofnvoice", (Object)yem_amountofnvoice, i);
            yem_amountofnvoice_s = BigDecimalUtils.add((BigDecimal)yem_amountofnvoice_s, (BigDecimal)yem_amountofnvoice, (int)10);
        }
    }

    public void backFillFinalInvoice() {
        DynamicObject bill = this.getModel().getDataEntity(true);
        IFormView view = this.getView();
        FormShowParameter fsp = new FormShowParameter();
        fsp.setStatus(OperationStatus.ADDNEW);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> entryInfo = new HashMap<String, Object>();
        entryInfo.put("billId", bill.getPkValue());
        fsp.setCustomParams(entryInfo);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "backfillfinalinvoic");
        fsp.setCloseCallBack(callBack);
        fsp.setFormId("yem_sm_backfillfinalinvoi");
        view.showForm(fsp);
    }

    public void backfillfinalinvoicCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        DynamicObject bill = this.getModel().getDataEntity(true);
        if (returnData != null && "backfillfinalinvoic".equals(actionId)) {
            List values = (List)returnData;
            DynamicObjectCollection yem_dt_purchase_dd_s = bill.getDynamicObjectCollection("yem_dt_purchase_dd");
            for (int i = 0; i < values.size(); ++i) {
                DynamicObject yem_dt_purchase_dd = (DynamicObject)yem_dt_purchase_dd_s.get(i);
                yem_dt_purchase_dd.set("yem_isfinalinvoice", values.get(i));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            this.getView().invokeOperation("refresh");
        }
    }
}

