/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.sm.bill.pursettlem.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.base.common.utils.BigDecimalUtils;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.YEM;

public class PurSettlementBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"yem_advcontoolbarap1"});
        this.addClickListeners(new String[]{"yem_contractno_ht", "yem_purchaorde_qt", "yem_purchaconnum_dj"});
        BasedataEdit org = (BasedataEdit)this.getView().getControl("yem_contractno_ht");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateFiledEnable();
        this.setContractEnable();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        int index = changeSet[0].getRowIndex();
        switch (key) {
            case "yem_settleamount_ht": {
                BigDecimal taxrate = BigDecimalUtils.div((BigDecimal)BigDecimalUtils.toBigDecimal((Object)model.getValue("yem_taxrate_ht", index)), (BigDecimal)BigDecimalUtils.one_handred, (int)10);
                BigDecimal difqty = BigDecimalUtils.toBigDecimal((Object)model.getValue("yem_difqty_ht", index));
                BigDecimal tax = BigDecimalUtils.div((BigDecimal)BigDecimalUtils.multiply((Object)newValue, (Object)taxrate, (int)10), (BigDecimal)BigDecimalUtils.add((BigDecimal)BigDecimalUtils.one, (BigDecimal)taxrate, (int)10), (int)2);
                model.setValue("yem_taxamount_ht", (Object)tax, index);
                model.setValue("yem_amountinclud_ht", (Object)BigDecimalUtils.sub((Object)newValue, (Object)tax, (int)2), index);
                model.setValue("yem_pricesettle_ht", (Object)BigDecimalUtils.div((Object)newValue, (Object)difqty, (int)2), index);
            }
            case "yem_settlementfee_ht": 
            case "yem_settlementrate_ht": {
                BigDecimal settlementfee = BigDecimalUtils.toBigDecimal((Object)model.getValue("yem_settlementfee_ht", index));
                BigDecimal settlementrate = BigDecimalUtils.toBigDecimal((Object)model.getValue("yem_settlementrate_ht", index));
                BigDecimal settleamount = BigDecimalUtils.toBigDecimal((Object)model.getValue("yem_settleamount_ht", index));
                model.setValue("yem_includedsumamt_ht", (Object)BigDecimalUtils.sub((BigDecimal)settleamount, (BigDecimal)BigDecimalUtils.add((BigDecimal)settlementrate, (BigDecimal)settlementfee, (int)10), (int)10), index);
                break;
            }
            case "yem_difqty_ht": {
                BigDecimal settleQty = BigDecimalUtils.toBigDecimal((Object)newValue);
                BigDecimal amount = BigDecimalUtils.toBigDecimal((Object)model.getValue("yem_settleamount_ht"));
                model.setValue("yem_pricesettle_ht", (Object)BigDecimalUtils.div((BigDecimal)amount, (BigDecimal)settleQty, (int)10), index);
                break;
            }
            case "yem_expenseamount_qt": 
            case "yem_exrate_qt": {
                index = this.getModel().getEntryCurrentRowIndex("yem_jsgl_qtfy");
                BigDecimal expenseamount = BigDecimalUtils.toBigDecimal((Object)model.getValue("yem_expenseamount_qt", index));
                BigDecimal exrate = BigDecimalUtils.toBigDecimal((Object)model.getValue("yem_exrate_qt", index));
                BigDecimal feeamtexclud = BigDecimalUtils.multiply((BigDecimal)expenseamount, (BigDecimal)exrate, (int)2);
                model.setValue("yem_feeamtexclud_qt", (Object)feeamtexclud, index);
                break;
            }
            case "yem_feeamtexclud_qt": {
                index = this.getModel().getEntryCurrentRowIndex("yem_jsgl_qtfy");
                Object contractid = model.getValue("yem_contractid_qt", index);
                this.updateExpenseAmountToContract(contractid);
                break;
            }
            case "yem_ispurdetsett": {
                model.deleteEntryData("yem_jsgl_rkxx");
                break;
            }
            case "yem_contractno_ht": {
                if (YEM.isEmpty((Object)newValue)) {
                    model.deleteEntryRow("yem_jsgl_htxx", index);
                    break;
                }
                if (!(newValue instanceof DynamicObject)) break;
                DynamicObject selectedBill = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)newValue).getLong("yem_billid"), (String)((DynamicObject)newValue).getString("yem_billkey"));
                DynamicObjectCollection materialentry = selectedBill.getDynamicObjectCollection("yem_materialentry");
                if (YEM.isNotEmpty((Object)materialentry)) {
                    BigDecimal qty = materialentry.stream().map(x -> x.getBigDecimal("yem_qty")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    DynamicObject row = (DynamicObject)materialentry.get(0);
                    this.getModel().setValue("yem_conquantity_ht", (Object)qty, index);
                    this.getModel().setValue("yem_warehousequantity_ht", (Object)this.getWarehouseQty(selectedBill.getLong("id")), index);
                    this.getModel().setValue("yem_unitmeasure_ht", (Object)row.getDynamicObject("yem_unit"), index);
                    this.getModel().setValue("yem_taxrate_ht", (Object)row.getBigDecimal("yem_taxratevalue"), index);
                    this.getModel().setValue("yem_srcbillno_ht", (Object)selectedBill.getString("billno"), index);
                    this.getModel().setValue("yem_srcbillid_ht", (Object)selectedBill.getLong("id"), index);
                    this.getModel().setValue("yem_srcentryid_ht", (Object)row.getLong("id"), index);
                }
                if (index != 0) break;
                this.getModel().setValue("yem_supplier", (Object)selectedBill.getDynamicObject("yem_supplier"), index);
                this.getModel().setValue("yem_fromcurr", (Object)selectedBill.getDynamicObject("yem_fromcurr"), index);
                break;
            }
            case "yem_purchaorde_qt": {
                if (!YEM.isEmpty((Object)newValue)) break;
                index = this.getModel().getEntryCurrentRowIndex("yem_jsgl_qtfy");
                model.setValue("yem_contractid_qt", (Object)0L, index);
                model.setValue("yem_expenseamount_qt", (Object)BigDecimal.ZERO, index);
                model.setValue("yem_exrate_qt", (Object)BigDecimal.ZERO, index);
                this.updateExpenseAmountToContract(null);
                break;
            }
        }
    }

    private void getAppraise(DynamicObject contract) {
        Long primaryKeyValue = contract.getLong("yem_billid");
        DynamicObjectCollection rkxx = this.getModel().getEntryEntity("yem_jsgl_djxx");
        Iterator iterator = rkxx.iterator();
        while (iterator.hasNext()) {
            DynamicObject row = (DynamicObject)iterator.next();
            if (!YEM.isEmpty((Object)row.getLong("yem_contractid_dj")) && row.getLong("yem_contractid_dj") != primaryKeyValue.longValue()) continue;
            iterator.remove();
        }
        String selectfieldsFast = DynamicObjectUtil.getSelectfieldsFast((String)"yem_fw_appraise", (String[])new String[]{"yem_fw_djd_zjfl"});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"yem_fw_appraise", (String)selectfieldsFast, (QFilter[])new QFilter[]{new QFilter("yem_contractbillnum.id", "=", (Object)contract.getString("id"))});
        for (DynamicObject dynamicObject : collection) {
            DynamicObject addNew = rkxx.addNew();
            addNew.set("yem_purchaconnum_dj", (Object)contract.getString("yem_ordernum"));
            addNew.set("yem_pricecontract_dj", (Object)dynamicObject.getDynamicObject("uav6_pointpriccon"));
            addNew.set("yem_pricedpeople", (Object)dynamicObject.getString("uav6_checkprice"));
            addNew.set("yem_inboundquantity_dj", (Object)dynamicObject.getBigDecimal("uav6_orderpriqty"));
            addNew.set("yem_units_dj", (Object)dynamicObject.getDynamicObject("uav6_orderpriunit"));
            addNew.set("yem_prices_dj", (Object)dynamicObject.getBigDecimal("uav6_orderprice"));
            addNew.set("yem_amounts_dj", (Object)dynamicObject.getBigDecimal("uav6_orderpriamt"));
            addNew.set("yem_pricedate_dj", (Object)dynamicObject.getDate("uav6_pricedate"));
            addNew.set("yem_contractid_dj", (Object)primaryKeyValue);
        }
        this.getView().updateView("yem_jsgl_djxx");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObject tradenature = dataEntity.getDynamicObject("yem_natureoftrade");
        if ("yem_contractno_ht".equals(name)) {
            if (YEM.isEmpty((Object)tradenature)) {
                this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u8d38\u6613\u6027\u8d28!");
                beforeF7SelectEvent.setCancel(true);
            } else {
                DynamicObjectCollection collection;
                List contractno_ht;
                DynamicObject org;
                DynamicObject fromcurr;
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter("yem_tradetype.id", "=", tradenature.getPkValue()));
                DynamicObject supplier = dataEntity.getDynamicObject("yem_supplier");
                if (YEM.isNotEmpty((Object)supplier)) {
                    qFilters.add(new QFilter("yem_cusorsupp.id", "=", supplier.getPkValue()));
                }
                if (YEM.isNotEmpty((Object)(fromcurr = dataEntity.getDynamicObject("yem_fromcurr")))) {
                    qFilters.add(new QFilter("yem_setcurrency.id", "=", fromcurr.getPkValue()));
                }
                if (YEM.isNotEmpty((Object)(org = dataEntity.getDynamicObject("org")))) {
                    qFilters.add(new QFilter("yem_org.id", "=", org.getPkValue()));
                }
                if (!(contractno_ht = (collection = dataEntity.getDynamicObjectCollection("yem_jsgl_htxx")).stream().map(x -> x.getLong("yem_contractno_ht.id")).collect(Collectors.toList())).isEmpty()) {
                    qFilters.add(new QFilter("id", "not in", contractno_ht));
                }
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getTreeFilterParameter().getQFilters().add(new QFilter("number", "=", (Object)dataEntity.getString("yem_contracttype")));
                showParameter.getListFilterParameter().getQFilters().addAll(qFilters);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        DynamicObject tradenature = dataEntity.getDynamicObject("yem_natureoftrade");
        String contractFormID = dataEntity.getString("yem_contracttype");
        if (YEM.isEmpty((Object)contractFormID)) {
            contractFormID = "yem_cnb_impcontract";
        }
        if ("yem_purchaorde_qt".equals(key) || "yem_purchaconnum_dj".equals(key)) {
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("yem_jsgl_htxx");
            List contractno_ht = collection.stream().filter(x -> YEM.isNotEmpty((Object)x.getString("yem_contractno_ht"))).map(x -> x.getString("yem_contractno_ht.yem_billno")).collect(Collectors.toList());
            if (!contractno_ht.isEmpty()) {
                QFilter qFilter = new QFilter("billno", "in", contractno_ht);
                this.showBillList(contractFormID, key, qFilter);
            } else {
                this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u5408\u540c\u4fe1\u606f!");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject tradenature = dataEntity.getDynamicObject("yem_natureoftrade");
        String number = tradenature.getString("number");
        String contractFormID = dataEntity.getString("yem_contracttype");
        if (YEM.isEmpty((Object)contractFormID)) {
            contractFormID = "yem_cnb_impcontract";
        }
        if (actionId.equals("yem_contractno_ht") && closedCallBackEvent.getReturnData() != null) {
            returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            int index = this.getModel().getEntryCurrentRowIndex("yem_jsgl_htxx");
            String formID = returnData.get(0).getFormID();
            for (ListSelectedRow returnDatum : returnData) {
                Object primaryKeyValue = returnDatum.getPrimaryKeyValue();
                DynamicObject baseData = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)formID);
                DynamicObject selectedBill = BusinessDataServiceHelper.loadSingle((Object)baseData.getLong("yem_billid"), (String)baseData.getString("yem_billkey"));
                DynamicObjectCollection materialentry = selectedBill.getDynamicObjectCollection("yem_materialentry");
                if (YEM.isNotEmpty((Object)materialentry)) {
                    BigDecimal qty = materialentry.stream().map(x -> x.getBigDecimal("yem_qty")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    DynamicObject row = (DynamicObject)materialentry.get(0);
                    this.getModel().setValue("yem_contractno_ht", (Object)returnData.get(0).getBillNo(), index);
                    this.getModel().setValue("yem_conquantity_ht", (Object)qty, index);
                    this.getModel().setValue("yem_warehousequantity_ht", (Object)this.getWarehouseQty(primaryKeyValue), index);
                    this.getModel().setValue("yem_unitmeasure_ht", (Object)row.getDynamicObject("yem_unit"), index);
                    this.getModel().setValue("yem_taxrate_ht", (Object)row.getBigDecimal("yem_taxratevalue"), index);
                    this.getModel().setValue("yem_srcbillno_ht", (Object)returnData.get(0).getBillNo(), index);
                    this.getModel().setValue("yem_srcbillid_ht", primaryKeyValue, index);
                    this.getModel().setValue("yem_srcentryid_ht", (Object)row.getLong("id"), index);
                }
                if (index != 0) continue;
                this.getModel().setValue("yem_supplier", (Object)selectedBill.getDynamicObject("yem_supplier"), index);
                this.getModel().setValue("yem_fromcurr", (Object)selectedBill.getDynamicObject("yem_fromcurr"), index);
            }
            this.updateFiledEnable();
        }
        if (actionId.equals("yem_purchaorde_qt") && closedCallBackEvent.getReturnData() != null) {
            returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            Object primaryKeyValue = returnData.get(0).getPrimaryKeyValue();
            int index = this.getModel().getEntryCurrentRowIndex("yem_jsgl_qtfy");
            DynamicObjectCollection qtfy = this.getModel().getEntryEntity("yem_jsgl_qtfy");
            this.getModel().setValue("yem_purchaorde_qt", (Object)returnData.get(0).getBillNo(), index);
            this.getModel().setValue("yem_contractid_qt", primaryKeyValue, index);
            this.updateExpenseAmountToContract(primaryKeyValue);
            this.getView().updateView("yem_jsgl_htxx");
            this.getView().updateView("yem_jsgl_qtfy");
        }
        if (actionId.equals("yem_sm_selectwarehouse") && closedCallBackEvent.getReturnData() != null) {
            List selectedRows = (List)closedCallBackEvent.getReturnData();
            this.updateRKEntryInfo(selectedRows);
            this.updateInPurBillSettleQty(dataEntity);
            this.updateHTMessage();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
            this.setContractEnable();
        }
    }

    private void updateExpenseAmountToContract(Object contractid) {
        IDataModel model = this.getModel();
        DynamicObjectCollection qtfy = model.getEntryEntity("yem_jsgl_qtfy");
        DynamicObjectCollection htxx = model.getEntryEntity("yem_jsgl_htxx");
        Map<Long, BigDecimal> map = qtfy.stream().filter(x -> contractid == null || x.getLong("yem_contractid_qt") == ((Long)contractid).longValue()).collect(Collectors.toMap(x -> x.getLong("yem_contractid_qt"), y -> y.getBigDecimal("yem_feeamtexclud_qt"), BigDecimal::add));
        for (int i = 0; i < htxx.size(); ++i) {
            long srcbillid = ((DynamicObject)htxx.get(i)).getLong("yem_srcbillid_ht");
            if (map.containsKey(srcbillid)) {
                model.setValue("yem_settlementfee_ht", (Object)map.get(srcbillid), i);
                continue;
            }
            model.setValue("yem_settlementfee_ht", (Object)BigDecimal.ZERO, i);
        }
        this.getView().updateView("yem_jsgl_htxx");
    }

    private void updateRKEntryInfo(List<DynamicObject> selectedRows) {
        this.getModel().deleteEntryData("yem_jsgl_rkxx");
        ArrayList<DynamicObject> purinBills = new ArrayList<DynamicObject>(selectedRows.size());
        for (DynamicObject row : selectedRows) {
            int rowIndex = this.getModel().createNewEntryRow("yem_jsgl_rkxx");
            this.getModel().setValue("yem_purchasecon_rk", (Object)row.getString("yem_purchasecon_rk"), rowIndex);
            this.getModel().setValue("yem_warhousepurin_rk", (Object)row.getLong("yem_impurid_rk"), rowIndex);
            this.getModel().setValue("yem_material_rk", (Object)row.getDynamicObject("yem_material_rk"), rowIndex);
            this.getModel().setValue("yem_units_rk", (Object)row.getDynamicObject("yem_units_rk"), rowIndex);
            this.getModel().setValue("yem_inboundquantity_rk", (Object)row.getBigDecimal("yem_inboundquantity_rk"), rowIndex);
            this.getModel().setValue("yem_inqtyunsettled_rk", (Object)row.getBigDecimal("yem_inqtyunsettled_rk"), rowIndex);
            this.getModel().setValue("yem_prices_rk", (Object)row.getBigDecimal("yem_prices_rk"), rowIndex);
            this.getModel().setValue("yem_amounts_rk", (Object)row.getBigDecimal("yem_amounts_rk"), rowIndex);
            this.getModel().setValue("yem_contractid_rk", (Object)row.getLong("yem_contactid_rk"), rowIndex);
            this.getModel().setValue("yem_entryid_rk", (Object)row.getLong("yem_entryid_rk"), rowIndex);
            if (!this.getModel().getValue("yem_isfinalsett").equals("B")) continue;
            long entryid = row.getLong("yem_entryid_rk");
            DynamicObject purinbill = BusinessDataServiceHelper.loadSingle((String)"im_purinbill", (String)"billentry,billentry.qty", (QFilter[])new QFilter[]{new QFilter("billentry.id", "=", (Object)entryid)});
            DynamicObjectCollection collection = purinbill.getDynamicObjectCollection("billentry");
            for (DynamicObject object : collection) {
                if (object.getLong("id") != entryid) continue;
                object.set("qty", (Object)row.getBigDecimal("yem_inboundquantity_rk"));
            }
            purinBills.add(purinbill);
        }
        if (!purinBills.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])purinBills.toArray(new DynamicObject[0]));
        }
    }

    private void updateHTMessage() {
        DynamicObjectCollection htxx = this.getModel().getEntryEntity("yem_jsgl_htxx");
        DynamicObjectCollection rkxx = this.getModel().getEntryEntity("yem_jsgl_rkxx");
        Map<Long, List<DynamicObject>> collected = rkxx.stream().collect(Collectors.groupingBy(x -> x.getLong("yem_contractid_rk")));
        for (int i = 0; i < htxx.size(); ++i) {
            long srcbillid = ((DynamicObject)htxx.get(i)).getLong("yem_srcbillid_ht");
            List<DynamicObject> rkData = collected.get(srcbillid);
            if (rkData == null) continue;
            BigDecimal qty = BigDecimal.ZERO;
            BigDecimal amount = BigDecimal.ZERO;
            for (DynamicObject rkDatum : rkData) {
                amount = amount.add(rkDatum.getBigDecimal("yem_amounts_rk"));
                qty = qty.add(rkDatum.getBigDecimal("yem_inqtyunsettled_rk"));
            }
            this.getModel().setValue("yem_settleamount_ht", (Object)amount, i);
            this.getModel().setValue("yem_difqty_ht", (Object)qty, i);
        }
    }

    private void updateFiledEnable() {
        DynamicObjectCollection htxx = this.getModel().getEntryEntity("yem_jsgl_htxx");
        this.getView().setEnable(Boolean.valueOf(htxx.isEmpty()), new String[]{"yem_natureoftrade", "yem_fromcurr", "yem_supplier"});
    }

    private void updateInPurBillSettleQty(DynamicObject dataEntity) {
        if ("A".equals(dataEntity.getString("yem_isfinalsett"))) {
            return;
        }
        DynamicObjectCollection htxx = dataEntity.getDynamicObjectCollection("yem_jsgl_htxx");
        List htIDs = htxx.stream().map(x -> x.getLong("yem_srcbillid_ht")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("billentry.mainbillid", "in", htIDs);
        qFilter.and("billstatus", "=", (Object)"C");
        DynamicObject[] purinbill = BusinessDataServiceHelper.load((String)"im_purinbill", (String)"billentry.yem_settledquantity,billentry.id", (QFilter[])new QFilter[]{qFilter});
        QFilter qFilter_settle = new QFilter("yem_jsgl_rkxx.yem_contractid_rk", "in", htIDs);
        qFilter_settle.and("id", "!=", dataEntity.getPkValue());
        DataSet pursettlem = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "yem_sm_pursettlem", "yem_jsgl_rkxx.yem_entryid_rk,yem_jsgl_rkxx.yem_inqtyunsettled_rk", new QFilter[]{qFilter_settle});
        HashMap<Long, BigDecimal> map_other = new HashMap<Long, BigDecimal>();
        for (Row row : pursettlem) {
            Long rk_id = row.getLong("yem_jsgl_rkxx.yem_entryid_rk");
            BigDecimal decimal = row.getBigDecimal("yem_jsgl_rkxx.yem_inqtyunsettled_rk");
            map_other.merge(rk_id, decimal, BigDecimal::add);
        }
        DynamicObjectCollection rkxx = dataEntity.getDynamicObjectCollection("yem_jsgl_rkxx");
        Map<Long, BigDecimal> map_current = rkxx.stream().collect(Collectors.toMap(x -> x.getLong("yem_entryid_rk"), x -> x.getBigDecimal("yem_inqtyunsettled_rk"), BigDecimal::add));
        for (DynamicObject object : purinbill) {
            DynamicObjectCollection collection = object.getDynamicObjectCollection("billentry");
            for (DynamicObject row : collection) {
                long id = row.getLong("id");
                if (!map_other.containsKey(id) && !map_current.containsKey(id)) continue;
                row.set("yem_settledquantity", (Object)BigDecimalUtils.add((BigDecimal)((BigDecimal)map_other.get(id)), (BigDecimal)map_current.get(id), (int)2));
            }
        }
        SaveServiceHelper.save((DynamicObject[])purinbill);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        String name = entryProp.getName();
        int[] rowIndexs = e.getRowIndexs();
        if ("yem_jsgl_htxx".equals(name)) {
            for (int rowIndex : rowIndexs) {
                Long contractID = (Long)this.getModel().getValue("yem_srcbillid_ht", rowIndex);
                DynamicObjectCollection rkxx = this.getModel().getEntryEntity("yem_jsgl_rkxx");
                List collected = rkxx.stream().filter(x -> x.getLong("yem_contractid_rk") == contractID.longValue()).collect(Collectors.toList());
                if (collected.isEmpty()) continue;
                this.getView().showTipNotification("\u8bf7\u5148\u5220\u9664\u8be5\u5408\u540c\u5173\u8054\u7684\u5165\u5e93\u4fe1\u606f\uff01");
                e.setCancel(true);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryPropName = entryProp.getName();
        IDataModel model = this.getModel();
        if ("yem_jsgl_rkxx".equals(entryPropName)) {
            this.updateInPurBillSettleQty(this.getModel().getDataEntity(true));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
            this.setContractEnable();
        }
        if ("yem_jsgl_htxx".equals(entryPropName)) {
            model.setValue("yem_supplier", null);
            model.setValue("yem_fromcurr", null);
            this.updateFiledEnable();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("yem_jsgl_htxx");
            List<Long> htIDs = collection.stream().map(x -> x.getLong("yem_srcbillid_ht")).collect(Collectors.toList());
            this.deleteEntryRow(htIDs, "yem_jsgl_rkxx", "yem_contractid_rk");
            this.deleteEntryRow(htIDs, "yem_jsgl_qtfy", "yem_contractid_qt");
            this.deleteEntryRow(htIDs, "yem_jsgl_djxx", "yem_contractid_dj");
            this.updateInPurBillSettleQty(this.getModel().getDataEntity(true));
        }
        if ("yem_jsgl_qtfy".equals(entryPropName)) {
            this.updateExpenseAmountToContract(null);
        }
    }

    private void setContractEnable() {
        IDataModel model = this.getModel();
        DynamicObjectCollection rkxx = model.getEntryEntity("yem_jsgl_rkxx");
        Set collected = rkxx.stream().map(x -> x.getLong("yem_contractid_rk")).collect(Collectors.toSet());
        DynamicObjectCollection htxx = model.getEntryEntity("yem_jsgl_htxx");
        for (int i = 0; i < htxx.size(); ++i) {
            if (!collected.contains(((DynamicObject)htxx.get(i)).getLong("yem_srcbillid_ht"))) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"yem_contractno_ht"});
        }
    }

    private void deleteEntryRow(List<Long> htIDs, String entryName, String filedName) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObjectCollection jsgl_rkxx = model.getEntryEntity(entryName);
        Iterator iterator = jsgl_rkxx.iterator();
        while (iterator.hasNext()) {
            DynamicObject row = (DynamicObject)iterator.next();
            if (htIDs.contains(row.getLong(filedName))) continue;
            iterator.remove();
        }
        view.updateView(entryName);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection htxx;
        List collect;
        FormOperate control = (FormOperate)args.getSource();
        String key = control.getOperateKey();
        if ("chooserkmx".equals(key) && (collect = (htxx = this.getModel().getEntryEntity("yem_jsgl_htxx")).stream().filter(x -> YEM.isNotEmpty((Object)x.getLong("yem_srcbillid_ht"))).collect(Collectors.toList())).isEmpty()) {
            this.getView().showTipNotification("\u8bf7\u5148\u586b\u5199\u5408\u540c\u4fe1\u606f\uff01");
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        IDataModel model = this.getModel();
        if ("chooserkmx".equals(operateKey)) {
            int index = model.getEntryCurrentRowIndex("yem_jsgl_htxx");
            Object srcbillid = model.getValue("yem_srcbillid_ht", index);
            Object isfinalsett = model.getValue("yem_isfinalsett");
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("yem_sm_selectwarehouse");
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("contractID", srcbillid);
            parameter.setCustomParam("isfinalsett", isfinalsett);
            CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "yem_sm_selectwarehouse");
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        }
    }

    private BigDecimal getWarehouseQty(Object primaryKeyValue) {
        QFilter qFilter = new QFilter("billentry.mainbillid", "=", primaryKeyValue);
        qFilter.and("billstatus", "=", (Object)"C");
        BigDecimal allQty = BigDecimal.ZERO;
        DynamicObjectCollection purinbill = QueryServiceHelper.query((String)"im_purinbill", (String)"billentry,billentry.qty", (QFilter[])new QFilter[]{qFilter});
        BigDecimal qty = purinbill.stream().map(x -> x.getBigDecimal("billentry.qty")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        allQty = allQty.add(qty);
        return allQty;
    }

    private void showBillList(String keyFiled, String closedCallBack, QFilter qFilter) {
        ListShowParameter listParam = new ListShowParameter();
        listParam.setBillFormId(keyFiled);
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)keyFiled);
        listParam.setFormId(formConfig.getF7ListFormId());
        ListFilterParameter parameter = new ListFilterParameter();
        parameter.getQFilters().add(qFilter);
        listParam.setListFilterParameter(parameter);
        listParam.setParentPageId(this.getView().getPageId());
        listParam.setMultiSelect(true);
        listParam.setStatus(OperationStatus.VIEW);
        listParam.getOpenStyle().setShowType(ShowType.Modal);
        listParam.getOpenStyle().setCacheId(listParam.getPageId());
        listParam.setLookUp(true);
        listParam.setCaption(EntityMetadataCache.getDataEntityType((String)keyFiled).getDisplayName().getLocaleValue());
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setWidth("1200px");
        inlineStyleCss.setHeight("600px");
        listParam.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), closedCallBack);
        listParam.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)listParam);
    }
}

