/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.sm.bill.salesstate.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.base.common.utils.BigDecimalUtils;
import yem.base.common.utils.StringUtils;

public class SalesStateBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        ((BasedataEdit)this.getView().getControl("yem_contractno_dd")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getView().getControl("yem_contractno_fy")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.EnableContractSelect();
        this.Enableispurdetsett();
        this.EnableYem_contractno_dd();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        switch (key = beforeF7SelectEvent.getProperty().getName()) {
            case "yem_contractno_dd": {
                this.beforeContractno_ddSelect(beforeF7SelectEvent, key);
                break;
            }
            case "yem_contractno_fy": {
                this.beforecontractno_fySelect(beforeF7SelectEvent, key);
                break;
            }
        }
    }

    private void beforeContractno_ddSelect(BeforeF7SelectEvent e, String key) {
        DynamicObject contracttype;
        List ids;
        DynamicObject yem_fromcurr;
        DynamicObject yem_natureoftrade;
        DynamicObject yem_customer;
        IDataModel model = this.getModel();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("yem_billstatus", "=", (Object)"C"));
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            qFilters.add(new QFilter("yem_org", "=", org.getPkValue()));
        }
        if ((yem_customer = (DynamicObject)model.getValue("yem_customer")) != null) {
            qFilters.add(new QFilter("yem_cusorsupp", "=", yem_customer.getPkValue()));
        }
        if ((yem_natureoftrade = (DynamicObject)model.getValue("yem_natureoftrade")) != null) {
            qFilters.add(new QFilter("yem_tradetype", "=", yem_natureoftrade.getPkValue()));
        }
        if ((yem_fromcurr = (DynamicObject)model.getValue("yem_fromcurr")) != null) {
            qFilters.add(new QFilter("yem_setcurrency", "=", yem_fromcurr.getPkValue()));
        }
        if (!(ids = model.getEntryEntity("yem_sm_xsjs_htxx").stream().filter(x -> x.getDynamicObject("yem_contractno_dd") != null).map(x -> x.getDynamicObject("yem_contractno_dd").getLong("id")).collect(Collectors.toList())).isEmpty()) {
            qFilters.add(new QFilter("id", "not in", ids));
        }
        if ((contracttype = (DynamicObject)model.getValue("yem_contracttype")) != null) {
            qFilters.add(new QFilter("yem_billkey", "=", (Object)contracttype.getString("number")));
        } else {
            qFilters.add(new QFilter("yem_billkey", "=", (Object)"null"));
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.setMultiSelect(false);
        showParameter.getListFilterParameter().setQFilters(qFilters);
    }

    private void beforecontractno_fySelect(BeforeF7SelectEvent e, String key) {
        List ids;
        IDataModel model = this.getModel();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("yem_billstatus", "=", (Object)"C"));
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            qFilters.add(new QFilter("yem_org", "=", org.getPkValue()));
        }
        if (!(ids = model.getEntryEntity("yem_sm_xsjs_htxx").stream().filter(x -> x.getDynamicObject("yem_contractno_dd") != null).map(x -> x.getDynamicObject("yem_contractno_dd").getLong("id")).collect(Collectors.toList())).isEmpty()) {
            qFilters.add(new QFilter("id", "in", ids));
        } else {
            qFilters.add(new QFilter("id", "=", (Object)0L));
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.setMultiSelect(false);
        showParameter.getListFilterParameter().setQFilters(qFilters);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        DynamicObject billdata = model.getDataEntity(true);
        IFormView view = this.getView();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (StringUtils.isNotEmpty((String)name)) {
            switch (name) {
                case "yem_contractno_dd": {
                    if (newValue != null) {
                        DynamicObject contractnbill;
                        DynamicObject yem_bd_contractinfor = (DynamicObject)newValue;
                        DynamicObject yem_contracttype = billdata.getDynamicObject("yem_contracttype");
                        if (yem_contracttype == null || (contractnbill = BusinessDataServiceHelper.loadSingle((Object)yem_bd_contractinfor.getLong("yem_billid"), (String)yem_contracttype.getString("number"))) == null) break;
                        String yem_sourcebillno = contractnbill.getString("yem_sourcebillno");
                        if (rowIndex == 0) {
                            DynamicObject yem_tradeproperty = contractnbill.getDynamicObject("yem_tradeproperty");
                            DynamicObject yem_customer = contractnbill.getDynamicObject("yem_customer");
                            DynamicObject yem_fromcurr = contractnbill.getDynamicObject("yem_fromcurr");
                            this.getModel().setValue("yem_natureoftrade", (Object)yem_tradeproperty);
                            this.getModel().setValue("yem_customer", (Object)yem_customer);
                            this.getModel().setValue("yem_fromcurr", (Object)yem_fromcurr);
                            if (billdata.getDynamicObject("yem_customer_re") == null) {
                                this.getModel().setValue("yem_customer_re", (Object)yem_customer);
                            }
                        }
                        this.getModel().setValue("yem_agreementno_dd", (Object)yem_sourcebillno, rowIndex);
                        DynamicObjectCollection yem_materialentryCol = contractnbill.getDynamicObjectCollection("yem_materialentry");
                        if (yem_materialentryCol.size() <= 0) break;
                        this.getModel().setValue("yem_unit_dd", ((DynamicObject)yem_materialentryCol.get(0)).get("yem_unit"), rowIndex);
                        this.getModel().setValue("yem_secondunit_dd", ((DynamicObject)yem_materialentryCol.get(0)).get("yem_secondunit"), rowIndex);
                        break;
                    }
                    this.getModel().setValue("yem_agreementno_dd", null, rowIndex);
                    this.getModel().setValue("yem_unit_dd", null, rowIndex);
                    this.getModel().setValue("yem_secondunit_dd", null, rowIndex);
                    break;
                }
                case "yem_contractid": 
                case "yem_contractid_fy": 
                case "yem_contractid_dk": {
                    this.EnableYem_contractno_dd();
                    break;
                }
                case "yem_qty": {
                    this.Calculate_yem_qty_dd();
                    break;
                }
                case "yem_secondqty": {
                    this.Calculate_yem_secondqty_dd();
                    break;
                }
                case "yem_amt": {
                    this.Calculate_yem_amount_dd();
                    break;
                }
                case "yem_amttax": {
                    this.Calculate_yem_taxinamount_dd();
                    break;
                }
                case "yem_taxrateamt": {
                    this.Calculate_yem_taxamount_dd();
                    break;
                }
                case "yem_taxamountfee": {
                    this.Calculate_yem_taxamount_dd();
                    break;
                }
                case "yem_feeamt": {
                    this.Calculate_yem_amount_dd();
                    break;
                }
                case "yem_feeamttax": {
                    this.Calculate_yem_taxinamount_dd();
                    break;
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "choicedetails": {
                OperationStatus Status = this.getView().getFormShowParameter().getStatus();
                if (!Status.equals((Object)OperationStatus.ADDNEW)) break;
                this.getView().showErrorNotification("\u9009\u62e9\u51fa\u5e93\u660e\u7ec6\u524d\uff0c\u8bf7\u5148\u4fdd\u5b58\u5f53\u524d\u5355\u636e\uff01");
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey = e.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        if (operateKey.equals("choicedetails") && operationResult.isSuccess()) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("yem_settlementdetails");
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("yem_businesstype", (Object)"s");
            CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "yem_settlementdetails");
            parameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String key = e.getActionId();
        Object returnData = e.getReturnData();
        DynamicObject bill = this.getModel().getDataEntity(true);
        switch (key) {
            case "yem_settlementdetails": {
                this.setInwardInfo(returnData);
                break;
            }
        }
    }

    private void setInwardInfo(Object returnData) {
        Map values = (Map)returnData;
        if (values != null) {
            DynamicObjectCollection entryentityCol = (DynamicObjectCollection)values.get("entryentityCol");
            this.getModel().deleteEntryData("yem_sm_xsjs_spxx");
            for (DynamicObject entryentity : entryentityCol) {
                int rowindex = this.getModel().createNewEntryRow("yem_sm_xsjs_spxx");
                long yem_contractid = entryentity.getLong("yem_contractid");
                QFilter qFilter = new QFilter("yem_billid", "=", (Object)yem_contractid);
                DynamicObject contractDetailsEntity = BusinessDataServiceHelper.loadSingle((String)"yem_bd_contractinfor", (QFilter[])new QFilter[]{qFilter});
                this.getModel().setValue("yem_contractno", (Object)contractDetailsEntity, rowindex);
                this.getModel().setValue("yem_saleout_sp", entryentity.get("yem_inventoryid"), rowindex);
                this.getModel().setValue("yem_material", entryentity.get("yem_material"), rowindex);
                this.getModel().setValue("yem_unit", entryentity.get("yem_unit"), rowindex);
                this.getModel().setValue("yem_qty", entryentity.get("yem_qty"), rowindex);
                this.getModel().setValue("yem_secondunit", entryentity.get("yem_secondunit"), rowindex);
                this.getModel().setValue("yem_secondqty", entryentity.get("yem_secondqty"), rowindex);
                this.getModel().setValue("yem_price", entryentity.get("yem_price"), rowindex);
                this.getModel().setValue("yem_amt", entryentity.get("yem_amt"), rowindex);
                this.getModel().setValue("yem_taxrate", entryentity.get("yem_taxrate"), rowindex);
                this.getModel().setValue("yem_taxratevalue", entryentity.get("yem_taxratevalue"), rowindex);
                this.getModel().setValue("yem_pricetax", entryentity.get("yem_pricetax"), rowindex);
                this.getModel().setValue("yem_amttax", entryentity.get("yem_amttax"), rowindex);
                this.getModel().setValue("yem_taxrateamt", entryentity.get("yem_taxrateamt"), rowindex);
                this.getModel().setValue("yem_goodscontent", entryentity.get("yem_goodscontent"), rowindex);
                this.getModel().setValue("yem_contractid", entryentity.get("yem_contractid"), rowindex);
                this.getModel().setValue("yem_contractentryid", entryentity.get("yem_contractentryid"), rowindex);
                this.getModel().setValue("yem_saleoutid", entryentity.get("yem_inventoryid"), rowindex);
                this.getModel().setValue("yem_saloutentrieid", entryentity.get("yem_inventoryentrieid"), rowindex);
            }
            this.Enableispurdetsett();
            this.EnableYem_contractno_dd();
            this.Calculate_yem_qty_dd();
            this.Calculate_yem_secondqty_dd();
            this.Calculate_yem_amount_dd();
            this.Calculate_yem_taxinamount_dd();
            this.Calculate_yem_taxamount_dd();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()});
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        int[] RowIndexs = e.getRowIndexs();
        String entryPropName = entryProp.getName();
        boolean isOk = true;
        StringBuilder msgStr = new StringBuilder();
        if ("yem_sm_xsjs_htxx".equals(entryPropName)) {
            DynamicObject billdata = this.getModel().getDataEntity(true);
            ArrayList<Long> spxxcontractidList = new ArrayList<Long>();
            DynamicObjectCollection yem_sm_xsjs_spxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_spxx");
            for (DynamicObject yem_sm_xsjs_spxx : yem_sm_xsjs_spxxCol) {
                spxxcontractidList.add(yem_sm_xsjs_spxx.getLong("yem_contractid"));
            }
            ArrayList<Long> fyxxcontractidList = new ArrayList<Long>();
            DynamicObjectCollection yem_sm_xsjs_fyxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_fyxx");
            for (DynamicObject yem_sm_xsjs_fyxx : yem_sm_xsjs_fyxxCol) {
                fyxxcontractidList.add(yem_sm_xsjs_fyxx.getLong("yem_contractid_fy"));
            }
            ArrayList<Long> dkxxcontractidList = new ArrayList<Long>();
            DynamicObjectCollection yem_sm_xsjs_dkxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_dkxx");
            for (DynamicObject yem_sm_xsjs_dkxx : yem_sm_xsjs_dkxxCol) {
                dkxxcontractidList.add(yem_sm_xsjs_dkxx.getLong("yem_contractid_dk"));
            }
            for (Object RowIndex : (Object)RowIndexs) {
                Long yem_contractid_dd = (Long)this.getModel().getValue("yem_contractid_dd", (int)RowIndex);
                if (spxxcontractidList.contains(yem_contractid_dd)) {
                    msgStr.append("\u5f53\u524d\u5408\u540c\u4fe1\u606f\u5df2\u88ab\u5546\u54c1\u4fe1\u606f\u5f15\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5bf9\u5e94\u5546\u54c1\u4fe1\u606f!").append("\r\n");
                    isOk = false;
                }
                if (fyxxcontractidList.contains(yem_contractid_dd)) {
                    msgStr.append("\u5f53\u524d\u5408\u540c\u4fe1\u606f\u5df2\u88ab\u8d39\u7528\u4fe1\u606f\u5f15\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5bf9\u5e94\u8d39\u7528\u4fe1\u606f!").append("\r\n");
                    isOk = false;
                }
                if (!dkxxcontractidList.contains(yem_contractid_dd)) continue;
                msgStr.append("\u5f53\u524d\u5408\u540c\u4fe1\u606f\u5df2\u88ab\u62b5\u6263\u4fe1\u606f\u5f15\u7528\uff0c\u8bf7\u5148\u53d6\u6d88\u5bf9\u5e94\u62b5\u6263\u4fe1\u606f!").append("\r\n");
                isOk = false;
            }
        }
        if (!isOk) {
            this.getView().showTipNotification(msgStr.toString());
            e.setCancel(true);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryPropName = entryProp.getName();
        if ("yem_sm_xsjs_htxx".equals(entryPropName)) {
            this.EnableContractSelect();
        }
        if ("yem_sm_xsjs_spxx".equals(entryPropName)) {
            this.Enableispurdetsett();
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryPropName = entryProp.getName();
        if ("yem_sm_xsjs_htxx".equals(entryPropName)) {
            this.EnableContractSelect();
        }
        if ("yem_sm_xsjs_spxx".equals(entryPropName)) {
            this.Enableispurdetsett();
            this.EnableYem_contractno_dd();
            this.Calculate_yem_qty_dd();
            this.Calculate_yem_secondqty_dd();
            this.Calculate_yem_amount_dd();
            this.Calculate_yem_taxinamount_dd();
            this.Calculate_yem_taxamount_dd();
        }
        if ("yem_sm_xsjs_fyxx".equals(entryPropName)) {
            this.EnableYem_contractno_dd();
            this.Calculate_yem_amount_dd();
            this.Calculate_yem_taxinamount_dd();
            this.Calculate_yem_taxamount_dd();
        }
        if ("yem_sm_xsjs_dkxx".equals(entryPropName)) {
            this.EnableYem_contractno_dd();
        }
        this.Calculate_yem_qty_dd();
        this.Calculate_yem_secondqty_dd();
        this.Calculate_yem_amount_dd();
        this.Calculate_yem_taxinamount_dd();
        this.Calculate_yem_taxamount_dd();
    }

    public void EnableContractSelect() {
        IDataModel model = this.getModel();
        DynamicObject billdata = model.getDataEntity(true);
        DynamicObjectCollection yem_sm_xsjs_htxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_htxx");
        this.getView().setEnable(Boolean.valueOf(yem_sm_xsjs_htxxCol.isEmpty()), new String[]{"yem_customer", "yem_natureoftrade", "yem_contracttype", "yem_fromcurr"});
    }

    public void Enableispurdetsett() {
        IDataModel model = this.getModel();
        DynamicObject billdata = model.getDataEntity(true);
        DynamicObjectCollection yem_sm_xsjs_spxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_spxx");
        this.getView().setEnable(Boolean.valueOf(yem_sm_xsjs_spxxCol.isEmpty()), new String[]{"yem_ispurdetsett"});
    }

    public void EnableYem_contractno_dd() {
        IDataModel model = this.getModel();
        DynamicObject billdata = model.getDataEntity(true);
        ArrayList<Long> spxxcontractidList = new ArrayList<Long>();
        DynamicObjectCollection yem_sm_xsjs_spxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_spxx");
        for (DynamicObject yem_sm_xsjs_spxx : yem_sm_xsjs_spxxCol) {
            spxxcontractidList.add(yem_sm_xsjs_spxx.getLong("yem_contractid"));
        }
        ArrayList<Long> fyxxcontractidList = new ArrayList<Long>();
        DynamicObjectCollection yem_sm_xsjs_fyxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_fyxx");
        for (DynamicObject yem_sm_xsjs_fyxx : yem_sm_xsjs_fyxxCol) {
            fyxxcontractidList.add(yem_sm_xsjs_fyxx.getLong("yem_contractid_fy"));
        }
        ArrayList<Long> dkxxcontractidList = new ArrayList<Long>();
        DynamicObjectCollection yem_sm_xsjs_dkxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_dkxx");
        for (DynamicObject yem_sm_xsjs_dkxx : yem_sm_xsjs_dkxxCol) {
            dkxxcontractidList.add(yem_sm_xsjs_dkxx.getLong("yem_contractid_dk"));
        }
        DynamicObjectCollection yem_sm_xsjs_htxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_htxx");
        for (int RowIndex = 0; RowIndex < yem_sm_xsjs_htxxCol.size(); ++RowIndex) {
            boolean isOk = true;
            DynamicObject yem_sm_xsjs_htxx = (DynamicObject)yem_sm_xsjs_htxxCol.get(RowIndex);
            Long yem_contractid_dd = yem_sm_xsjs_htxx.getLong("yem_contractid_dd");
            if (spxxcontractidList.contains(yem_contractid_dd)) {
                isOk = false;
            }
            if (fyxxcontractidList.contains(yem_contractid_dd)) {
                isOk = false;
            }
            if (dkxxcontractidList.contains(yem_contractid_dd)) {
                isOk = false;
            }
            this.getView().setEnable(Boolean.valueOf(isOk), RowIndex, new String[]{"yem_contractno_dd"});
        }
    }

    public void Calculate_yem_qty_dd() {
        IDataModel model = this.getModel();
        DynamicObject billdata = model.getDataEntity(true);
        HashMap<Long, BigDecimal> contractyem_qty_ddMap = new HashMap<Long, BigDecimal>();
        DynamicObjectCollection yem_sm_xsjs_spxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_spxx");
        for (DynamicObject yem_sm_xsjs_spxx : yem_sm_xsjs_spxxCol) {
            Long yem_contractid = yem_sm_xsjs_spxx.getLong("yem_contractid");
            BigDecimal yem_qty = BigDecimalUtils.toBigDecimal((Object)yem_sm_xsjs_spxx.getBigDecimal("yem_qty"));
            if (contractyem_qty_ddMap.containsKey(yem_contractid)) {
                BigDecimal yem_qtyMap = (BigDecimal)contractyem_qty_ddMap.get(yem_contractid);
                contractyem_qty_ddMap.put(yem_contractid, BigDecimalUtils.add((BigDecimal)yem_qty, (BigDecimal)yem_qtyMap, (int)6));
                continue;
            }
            contractyem_qty_ddMap.put(yem_contractid, yem_qty);
        }
        DynamicObjectCollection yem_sm_xsjs_htxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_htxx");
        for (int RowIndex = 0; RowIndex < yem_sm_xsjs_htxxCol.size(); ++RowIndex) {
            DynamicObject yem_sm_xsjs_htxx = (DynamicObject)yem_sm_xsjs_htxxCol.get(RowIndex);
            Long yem_contractid_dd = yem_sm_xsjs_htxx.getLong("yem_contractid_dd");
            if (contractyem_qty_ddMap.containsKey(yem_contractid_dd)) {
                this.getModel().setValue("yem_qty_dd", contractyem_qty_ddMap.get(yem_contractid_dd), RowIndex);
                continue;
            }
            this.getModel().setValue("yem_qty_dd", (Object)BigDecimal.ZERO, RowIndex);
        }
    }

    public void Calculate_yem_secondqty_dd() {
        IDataModel model = this.getModel();
        DynamicObject billdata = model.getDataEntity(true);
        HashMap<Long, BigDecimal> contractyem_secondqty_ddMap = new HashMap<Long, BigDecimal>();
        DynamicObjectCollection yem_sm_xsjs_spxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_spxx");
        for (DynamicObject yem_sm_xsjs_spxx : yem_sm_xsjs_spxxCol) {
            Long yem_contractid = yem_sm_xsjs_spxx.getLong("yem_contractid");
            BigDecimal yem_secondqty = BigDecimalUtils.toBigDecimal((Object)yem_sm_xsjs_spxx.getBigDecimal("yem_secondqty"));
            if (contractyem_secondqty_ddMap.containsKey(yem_contractid)) {
                BigDecimal yem_secondqtyMap = (BigDecimal)contractyem_secondqty_ddMap.get(yem_contractid);
                contractyem_secondqty_ddMap.put(yem_contractid, BigDecimalUtils.add((BigDecimal)yem_secondqty, (BigDecimal)yem_secondqtyMap, (int)6));
                continue;
            }
            contractyem_secondqty_ddMap.put(yem_contractid, yem_secondqty);
        }
        DynamicObjectCollection yem_sm_xsjs_htxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_htxx");
        for (int RowIndex = 0; RowIndex < yem_sm_xsjs_htxxCol.size(); ++RowIndex) {
            DynamicObject yem_sm_xsjs_htxx = (DynamicObject)yem_sm_xsjs_htxxCol.get(RowIndex);
            Long yem_contractid_dd = yem_sm_xsjs_htxx.getLong("yem_contractid_dd");
            if (contractyem_secondqty_ddMap.containsKey(yem_contractid_dd)) {
                this.getModel().setValue("yem_secondqty_dd", contractyem_secondqty_ddMap.get(yem_contractid_dd), RowIndex);
                continue;
            }
            this.getModel().setValue("yem_secondqty_dd", (Object)BigDecimal.ZERO, RowIndex);
        }
    }

    public void Calculate_yem_amount_dd() {
        IDataModel model = this.getModel();
        DynamicObject billdata = model.getDataEntity(true);
        HashMap<Long, BigDecimal> contractyem_amount_ddMap = new HashMap<Long, BigDecimal>();
        DynamicObjectCollection yem_sm_xsjs_spxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_spxx");
        for (Object yem_sm_xsjs_spxx : yem_sm_xsjs_spxxCol) {
            Long yem_contractid = yem_sm_xsjs_spxx.getLong("yem_contractid");
            BigDecimal yem_amt = BigDecimalUtils.toBigDecimal((Object)yem_sm_xsjs_spxx.getBigDecimal("yem_amt"));
            if (contractyem_amount_ddMap.containsKey(yem_contractid)) {
                BigDecimal yem_amtMap = (BigDecimal)contractyem_amount_ddMap.get(yem_contractid);
                contractyem_amount_ddMap.put(yem_contractid, BigDecimalUtils.add((BigDecimal)yem_amt, (BigDecimal)yem_amtMap, (int)6));
                continue;
            }
            contractyem_amount_ddMap.put(yem_contractid, yem_amt);
        }
        DynamicObjectCollection yem_sm_xsjs_fyxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_fyxx");
        for (DynamicObject yem_sm_xsjs_fyxx : yem_sm_xsjs_fyxxCol) {
            Long yem_contractid_fy = yem_sm_xsjs_fyxx.getLong("yem_contractid_fy");
            BigDecimal yem_feeamt = BigDecimalUtils.toBigDecimal((Object)yem_sm_xsjs_fyxx.getBigDecimal("yem_feeamt"));
            if (contractyem_amount_ddMap.containsKey(yem_contractid_fy)) {
                BigDecimal yem_amtMap = (BigDecimal)contractyem_amount_ddMap.get(yem_contractid_fy);
                contractyem_amount_ddMap.put(yem_contractid_fy, BigDecimalUtils.add((BigDecimal)yem_feeamt, (BigDecimal)yem_amtMap, (int)6));
                continue;
            }
            contractyem_amount_ddMap.put(yem_contractid_fy, yem_feeamt);
        }
        DynamicObjectCollection yem_sm_xsjs_htxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_htxx");
        for (int RowIndex = 0; RowIndex < yem_sm_xsjs_htxxCol.size(); ++RowIndex) {
            DynamicObject yem_sm_xsjs_htxx = (DynamicObject)yem_sm_xsjs_htxxCol.get(RowIndex);
            Long yem_contractid_dd = yem_sm_xsjs_htxx.getLong("yem_contractid_dd");
            if (contractyem_amount_ddMap.containsKey(yem_contractid_dd)) {
                this.getModel().setValue("yem_amount_dd", contractyem_amount_ddMap.get(yem_contractid_dd), RowIndex);
                continue;
            }
            this.getModel().setValue("yem_amount_dd", (Object)BigDecimal.ZERO, RowIndex);
        }
    }

    public void Calculate_yem_taxamount_dd() {
        IDataModel model = this.getModel();
        DynamicObject billdata = model.getDataEntity(true);
        HashMap<Long, BigDecimal> contractyem_taxamount_ddMap = new HashMap<Long, BigDecimal>();
        DynamicObjectCollection yem_sm_xsjs_spxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_spxx");
        for (Object yem_sm_xsjs_spxx : yem_sm_xsjs_spxxCol) {
            Long yem_contractid = yem_sm_xsjs_spxx.getLong("yem_contractid");
            BigDecimal yem_taxrateamt = BigDecimalUtils.toBigDecimal((Object)yem_sm_xsjs_spxx.getBigDecimal("yem_taxrateamt"));
            if (contractyem_taxamount_ddMap.containsKey(yem_contractid)) {
                BigDecimal yem_taxrateamtMap = (BigDecimal)contractyem_taxamount_ddMap.get(yem_contractid);
                contractyem_taxamount_ddMap.put(yem_contractid, BigDecimalUtils.add((BigDecimal)yem_taxrateamt, (BigDecimal)yem_taxrateamtMap, (int)6));
                continue;
            }
            contractyem_taxamount_ddMap.put(yem_contractid, yem_taxrateamt);
        }
        DynamicObjectCollection yem_sm_xsjs_fyxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_fyxx");
        for (DynamicObject yem_sm_xsjs_fyxx : yem_sm_xsjs_fyxxCol) {
            Long yem_contractid_fy = yem_sm_xsjs_fyxx.getLong("yem_contractid_fy");
            BigDecimal yem_taxamountfee = BigDecimalUtils.toBigDecimal((Object)yem_sm_xsjs_fyxx.getBigDecimal("yem_taxamountfee"));
            if (contractyem_taxamount_ddMap.containsKey(yem_contractid_fy)) {
                BigDecimal yem_taxrateamtMap = (BigDecimal)contractyem_taxamount_ddMap.get(yem_contractid_fy);
                contractyem_taxamount_ddMap.put(yem_contractid_fy, BigDecimalUtils.add((BigDecimal)yem_taxamountfee, (BigDecimal)yem_taxrateamtMap, (int)6));
                continue;
            }
            contractyem_taxamount_ddMap.put(yem_contractid_fy, yem_taxamountfee);
        }
        DynamicObjectCollection yem_sm_xsjs_htxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_htxx");
        for (int RowIndex = 0; RowIndex < yem_sm_xsjs_htxxCol.size(); ++RowIndex) {
            DynamicObject yem_sm_xsjs_htxx = (DynamicObject)yem_sm_xsjs_htxxCol.get(RowIndex);
            Long yem_contractid_dd = yem_sm_xsjs_htxx.getLong("yem_contractid_dd");
            if (contractyem_taxamount_ddMap.containsKey(yem_contractid_dd)) {
                this.getModel().setValue("yem_taxamount_dd", contractyem_taxamount_ddMap.get(yem_contractid_dd), RowIndex);
                continue;
            }
            this.getModel().setValue("yem_taxamount_dd", (Object)BigDecimal.ZERO, RowIndex);
        }
    }

    public void Calculate_yem_taxinamount_dd() {
        IDataModel model = this.getModel();
        DynamicObject billdata = model.getDataEntity(true);
        HashMap<Long, BigDecimal> contractyem_taxinamount_ddMap = new HashMap<Long, BigDecimal>();
        DynamicObjectCollection yem_sm_xsjs_spxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_spxx");
        for (Object yem_sm_xsjs_spxx : yem_sm_xsjs_spxxCol) {
            Long yem_contractid = yem_sm_xsjs_spxx.getLong("yem_contractid");
            BigDecimal yem_amttax = BigDecimalUtils.toBigDecimal((Object)yem_sm_xsjs_spxx.getBigDecimal("yem_amttax"));
            if (contractyem_taxinamount_ddMap.containsKey(yem_contractid)) {
                BigDecimal yem_amttaxMap = (BigDecimal)contractyem_taxinamount_ddMap.get(yem_contractid);
                contractyem_taxinamount_ddMap.put(yem_contractid, BigDecimalUtils.add((BigDecimal)yem_amttax, (BigDecimal)yem_amttaxMap, (int)6));
                continue;
            }
            contractyem_taxinamount_ddMap.put(yem_contractid, yem_amttax);
        }
        DynamicObjectCollection yem_sm_xsjs_fyxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_fyxx");
        for (DynamicObject yem_sm_xsjs_fyxx : yem_sm_xsjs_fyxxCol) {
            Long yem_contractid_fy = yem_sm_xsjs_fyxx.getLong("yem_contractid_fy");
            BigDecimal yem_feeamttax = BigDecimalUtils.toBigDecimal((Object)yem_sm_xsjs_fyxx.getBigDecimal("yem_feeamttax"));
            if (contractyem_taxinamount_ddMap.containsKey(yem_contractid_fy)) {
                BigDecimal yem_amttaxMap = (BigDecimal)contractyem_taxinamount_ddMap.get(yem_contractid_fy);
                contractyem_taxinamount_ddMap.put(yem_contractid_fy, BigDecimalUtils.add((BigDecimal)yem_feeamttax, (BigDecimal)yem_amttaxMap, (int)6));
                continue;
            }
            contractyem_taxinamount_ddMap.put(yem_contractid_fy, yem_feeamttax);
        }
        DynamicObjectCollection yem_sm_xsjs_htxxCol = billdata.getDynamicObjectCollection("yem_sm_xsjs_htxx");
        for (int RowIndex = 0; RowIndex < yem_sm_xsjs_htxxCol.size(); ++RowIndex) {
            DynamicObject yem_sm_xsjs_htxx = (DynamicObject)yem_sm_xsjs_htxxCol.get(RowIndex);
            Long yem_contractid_dd = yem_sm_xsjs_htxx.getLong("yem_contractid_dd");
            if (contractyem_taxinamount_ddMap.containsKey(yem_contractid_dd)) {
                this.getModel().setValue("yem_taxinamount_dd", contractyem_taxinamount_ddMap.get(yem_contractid_dd), RowIndex);
                continue;
            }
            this.getModel().setValue("yem_taxinamount_dd", (Object)BigDecimal.ZERO, RowIndex);
        }
    }
}

