/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.sm.bill.salesstatem.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.base.common.utils.BigDecimalUtils;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.StringUtils;

public class SalesStatemBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        this.lockFinalSett(model);
        SalesStatemBillPlugin.lockByHtxx(model, view);
        SalesStatemBillPlugin.lockByDjxx(view, model);
    }

    private static void lockByDjxx(IFormView view, IDataModel model) {
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObjectCollection yem_sm_salesse_djxxCol = model.getEntryEntity("yem_sm_salesse_djxx");
        for (DynamicObject yem_sm_salesse_djxx : yem_sm_salesse_djxxCol) {
            long yemContractidDj = yem_sm_salesse_djxx.getLong("yem_contractid_dj");
            if (yemContractidDj <= 0L) continue;
            ids.add(yemContractidDj);
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        DynamicObjectCollection yem_sm_salesse_htxxCol = model.getEntryEntity("yem_sm_salesse_htxx");
        for (DynamicObject yem_sm_salesse_htxx : yem_sm_salesse_htxxCol) {
            view.setEnable(Boolean.valueOf(true), yem_sm_salesse_htxx.getInt("seq") - 1, new String[]{"yem_contractno_xx"});
            long id = yem_sm_salesse_htxx.getLong("yem_constractidht");
            if (!ids.contains(id)) continue;
            indexList.add(yem_sm_salesse_htxx.getInt("seq") - 1);
        }
        Iterator iterator = indexList.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            view.setEnable(Boolean.valueOf(false), index, new String[]{"yem_contractno_xx"});
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit yemContractnoXx;
        TextEdit yem_salectnumber;
        TextEdit tpv_orderno_p = (TextEdit)this.getView().getControl("yem_contractno_dd");
        if (tpv_orderno_p != null) {
            tpv_orderno_p.addButtonClickListener((ClickListener)this);
        }
        if ((yem_salectnumber = (TextEdit)this.getView().getControl("yem_salectnumber")) != null) {
            yem_salectnumber.addButtonClickListener((ClickListener)this);
        }
        if ((yemContractnoXx = (BasedataEdit)this.getView().getControl("yem_contractno_xx")) != null) {
            yemContractnoXx.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "choiceoutbill": {
                long id = this.getModel().getDataEntity().getLong("id");
                if (id != 0L) break;
                OperateOption Option = OperateOption.create();
                Option.setVariableValue("updateModifyDate", String.valueOf(false));
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                String name = dataEntity.getDynamicObjectType().getName();
                SaveServiceHelper.saveOperate((String)name, (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)Option);
            }
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        IDataModel model = this.getModel();
        key.getClass();
    }

    private void choiceContractByQt(IDataModel model) {
        String number;
        String billFormId = "";
        String billname = "";
        DynamicObject yem_natureoftrade = (DynamicObject)model.getValue("yem_natureoftrade");
        if (yem_natureoftrade != null && StringUtils.isNotEmpty((String)(number = yem_natureoftrade.getString("number")))) {
            switch (number) {
                case "MYXZ001_SYS": 
                case "MYXZ002_SYS": 
                case "MYXZ003_SYS": {
                    billFormId = "yem_cnb_expcontract";
                    billname = "\u51fa\u53e3\u5408\u540c(\u5927\u5b97)";
                    break;
                }
                case "MYXZ009_SYS": {
                    billFormId = "yem_cnb_salorder";
                    billname = "\u9500\u552e\u5408\u540c(\u5927\u5b97)";
                }
            }
        }
        if (StringUtils.isNotEmpty((String)billFormId)) {
            ListShowParameter listpara = new ListShowParameter();
            listpara.setBillFormId(billFormId);
            listpara.setParentPageId(this.getView().getPageId());
            listpara.setMultiSelect(false);
            listpara.setStatus(OperationStatus.VIEW);
            listpara.getOpenStyle().setShowType(ShowType.Modal);
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            QFilter qFilter = new QFilter("billstatus", "=", (Object)"C");
            qFilterList.add(qFilter);
            ArrayList<Long> listIds = new ArrayList<Long>();
            DynamicObjectCollection entryEntityCol = model.getEntryEntity("yem_sm_salesse_htxx");
            for (DynamicObject entryEntity : entryEntityCol) {
                long yemSrcbillidDd = entryEntity.getLong("yem_constractidht");
                if (yemSrcbillidDd <= 0L) continue;
                listIds.add(yemSrcbillidDd);
            }
            if (listIds.size() > 0) {
                qFilterList.add(new QFilter("id", "in", listIds));
            }
            listFilterParameter.setQFilters(qFilterList);
            listpara.setListFilterParameter(listFilterParameter);
            listpara.getOpenStyle().setCacheId(listpara.getPageId());
            listpara.setLookUp(true);
            StyleCss inlineStyleCss = new StyleCss();
            inlineStyleCss.setHeight("800");
            inlineStyleCss.setWidth("1400");
            listpara.getOpenStyle().setInlineStyleCss(inlineStyleCss);
            CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), billFormId + "qt");
            listpara.setCloseCallBack(closeCallBack);
            listpara.setCaption(billname);
            this.getView().showForm((FormShowParameter)listpara);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String name = e.getEntryProp().getName();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        switch (name) {
            case "yem_sm_salesse_htxx": {
                SalesStatemBillPlugin.updateOutEntry(model, view);
                SalesStatemBillPlugin.updateFeeEntry(model, view);
                SalesStatemBillPlugin.lockByHtxx(model, view);
                this.lockFinalSett(model);
                break;
            }
            case "yem_sm_salesse_ckxx": {
                this.reCalculate(model);
                Object value = model.getValue("yem_isfinalsett");
                if (value != null) {
                    ArrayList<Long> reayDeleteList = new ArrayList<Long>();
                    DynamicObjectCollection entryEntityCol = model.getEntryEntity("yem_sm_salesse_htxx");
                    for (DynamicObject entryEntity : entryEntityCol) {
                        long yemConstractid = entryEntity.getLong("yem_constractidht");
                        if (yemConstractid <= 0L) continue;
                        reayDeleteList.add(yemConstractid);
                    }
                    SalesStatemBillPlugin.backOutBill(value, reayDeleteList);
                }
                this.lockFinalSett(model);
                break;
            }
            case "yem_sm_salesse_qtxx": {
                this.reCalculateByQt(model);
                this.lockFinalSett(model);
                break;
            }
            case "yem_sm_salesse_djxx": {
                SalesStatemBillPlugin.lockByDjxx(view, model);
                this.lockFinalSett(model);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (StringUtils.isNotEmpty((String)name)) {
            switch (name) {
                case "yem_ispurdetsett": {
                    model.deleteEntryData("yem_sm_salesse_ckxx");
                    this.lockFinalSett(model);
                    break;
                }
                case "yem_contractno_xx": {
                    this.htxxConstract(model, newValue, rowIndex);
                    break;
                }
                case "yem_contractno_dd": {
                    if (StringUtils.isEmpty((String)((String)newValue))) {
                        this.getModel().setValue("yem_constractidht", (Object)0, rowIndex);
                    }
                    SalesStatemBillPlugin.lockByHtxx(model, view);
                    SalesStatemBillPlugin.updateOutEntry(model, view);
                    SalesStatemBillPlugin.updateFeeEntry(model, view);
                    break;
                }
                case "yem_qtfeeamtexclud": {
                    this.reCalculateByQt(model);
                    break;
                }
                case "yem_inqtyunsettled": 
                case "yem_prices": 
                case "yem_amounts": {
                    this.reCalculate(model);
                    break;
                }
                case "yem_salectnumber": {
                    this.lockFinalSett(model);
                    break;
                }
                case "yem_salectnumberqt": {
                    DynamicObject expcontract;
                    DynamicObject yem_bd_contractinfor;
                    DynamicObject yem_contractno_xx = (DynamicObject)model.getValue("yem_salectnumberqt");
                    if (yem_contractno_xx == null || (yem_bd_contractinfor = BusinessDataServiceHelper.loadSingle((Object)yem_contractno_xx.getPkValue(), (String)"yem_bd_contractinfor")) == null) break;
                    long yemBillid = yem_bd_contractinfor.getLong("yem_billid");
                    String yemBillkey = yem_bd_contractinfor.getString("yem_billkey");
                    if (yemBillid <= 0L || !StringUtils.isNotEmpty((String)yemBillkey) || (expcontract = BusinessDataServiceHelper.loadSingle((Object)yemBillid, (String)yemBillkey)) == null) break;
                    model.setValue("yem_salectnumber", (Object)expcontract.getString("billno"), rowIndex);
                    model.setValue("yem_constractidqt", (Object)expcontract.getLong("id"), rowIndex);
                }
            }
        }
    }

    private void htxxConstract(IDataModel model, Object newValue, int rowIndex) {
        if (newValue == null) {
            this.getModel().setValue("yem_constractidht", (Object)0, rowIndex);
            this.getModel().setValue("yem_contractno_dd", (Object)"", rowIndex);
        } else {
            DynamicObject yem_bd_contractinfor;
            DynamicObject yem_contractno_xx = (DynamicObject)model.getValue("yem_contractno_xx", rowIndex);
            if (yem_contractno_xx != null && (yem_bd_contractinfor = BusinessDataServiceHelper.loadSingle((Object)yem_contractno_xx.getPkValue(), (String)"yem_bd_contractinfor")) != null) {
                DynamicObject expcontract;
                long yemBillid = yem_bd_contractinfor.getLong("yem_billid");
                String yemBillkey = yem_bd_contractinfor.getString("yem_billkey");
                if (yemBillid > 0L && StringUtils.isNotEmpty((String)yemBillkey) && (expcontract = BusinessDataServiceHelper.loadSingle((Object)yemBillid, (String)yemBillkey)) != null) {
                    DynamicObject dynamicObjectFirst;
                    DynamicObjectCollection yem_materialentryCol = expcontract.getDynamicObjectCollection("yem_materialentry");
                    BigDecimal qty = BigDecimal.ZERO;
                    for (DynamicObject yem_materialentry : yem_materialentryCol) {
                        qty = BigDecimalUtils.add((BigDecimal)yem_materialentry.getBigDecimal("yem_qty"), (BigDecimal)qty, (int)7);
                    }
                    model.setValue("yem_contractno_dd", (Object)expcontract.getString("billno"), rowIndex);
                    model.setValue("yem_ctquantity", (Object)qty, rowIndex);
                    if (yem_materialentryCol != null && yem_materialentryCol.size() > 0 && (dynamicObjectFirst = (DynamicObject)yem_materialentryCol.get(0)) != null) {
                        model.setValue("yem_unitmeasure", (Object)dynamicObjectFirst.getDynamicObject("yem_unit"), rowIndex);
                        model.setValue("yem_taxrate_dd", (Object)dynamicObjectFirst.getBigDecimal("yem_taxratevalue"), rowIndex);
                    }
                    model.setValue("yem_constractidht", expcontract.getPkValue(), rowIndex);
                    if (rowIndex == 0) {
                        Object yem_customer;
                        Object yem_fromcurr = model.getValue("yem_fromcurr");
                        if (yem_fromcurr == null) {
                            model.setValue("yem_fromcurr", (Object)expcontract.getDynamicObject("yem_fromcurr"));
                        }
                        if ((yem_customer = model.getValue("yem_customer")) == null) {
                            model.setValue("yem_customer", (Object)expcontract.getDynamicObject("yem_customer"));
                        }
                    }
                    String selectfields = DynamicObjectUtil.getSelectfieldsFast((String)"im_saloutbill", (String[])new String[]{"billentry"});
                    DynamicObject[] im_saloutbillCol = BusinessDataServiceHelper.load((String)"im_saloutbill", (String)selectfields, (QFilter[])new QFilter[]{new QFilter("billentry.mainbillid", "=", expcontract.getPkValue()), new QFilter("billstatus", "=", (Object)"C")});
                    BigDecimal outQty = BigDecimal.ZERO;
                    for (DynamicObject im_saloutbill : im_saloutbillCol) {
                        DynamicObjectCollection billentryCol = im_saloutbill.getDynamicObjectCollection("billentry");
                        for (DynamicObject billentry : billentryCol) {
                            outQty = BigDecimalUtils.add((BigDecimal)outQty, (BigDecimal)billentry.getBigDecimal("qty"), (int)7);
                        }
                    }
                    model.setValue("yem_orderquantity", (Object)outQty, rowIndex);
                    model.setValue("yem_contractno_dd", (Object)expcontract.getString("billno"), rowIndex);
                    model.setValue("yem_constractidht", (Object)expcontract.getLong("id"), rowIndex);
                }
            }
        }
    }

    private static void lockByHtxx(IDataModel model, IFormView view) {
        boolean flag = false;
        DynamicObjectCollection yem_sm_salesse_htxxCol = model.getEntryEntity("yem_sm_salesse_htxx");
        for (DynamicObject yem_sm_salesse_htxx : yem_sm_salesse_htxxCol) {
            String yem_contractno_dd = yem_sm_salesse_htxx.getString("yem_contractno_dd");
            if (!StringUtils.isNotEmpty((String)yem_contractno_dd)) continue;
            flag = true;
            break;
        }
        if (flag) {
            view.setEnable(Boolean.valueOf(false), new String[]{"yem_fromcurr", "yem_natureoftrade", "yem_customer"});
        } else {
            view.setEnable(Boolean.valueOf(true), new String[]{"yem_fromcurr", "yem_natureoftrade", "yem_customer"});
        }
    }

    private static void updateOutEntry(IDataModel model, IFormView view) {
        DynamicObjectCollection yem_sm_salesse_htxxCol = model.getEntryEntity("yem_sm_salesse_htxx");
        ArrayList<Long> constractIds = new ArrayList<Long>();
        for (DynamicObject yem_sm_salesse_htxx : yem_sm_salesse_htxxCol) {
            long yemSrcbillidDd = yem_sm_salesse_htxx.getLong("yem_constractidht");
            if (yemSrcbillidDd <= 0L) continue;
            constractIds.add(yemSrcbillidDd);
        }
        ArrayList<Integer> arrs = new ArrayList<Integer>();
        DynamicObjectCollection yem_sm_salesse_ckxxCol = model.getEntryEntity("yem_sm_salesse_ckxx");
        for (DynamicObject yem_sm_salesse_ckxx : yem_sm_salesse_ckxxCol) {
            long yemConstractid = yem_sm_salesse_ckxx.getLong("yem_constractid");
            if (constractIds.contains(yemConstractid)) continue;
            arrs.add(yem_sm_salesse_ckxx.getInt("seq") - 1);
        }
        if (arrs.size() > 0) {
            int[] removeArr = new int[arrs.size()];
            for (int i = 0; i < arrs.size(); ++i) {
                removeArr[i] = (Integer)arrs.get(i);
            }
            model.deleteEntryRows("yem_sm_salesse_ckxx", removeArr);
        }
    }

    private static void updateFeeEntry(IDataModel model, IFormView view) {
        DynamicObjectCollection yem_sm_salesse_htxxCol = model.getEntryEntity("yem_sm_salesse_htxx");
        ArrayList<Object> constracts = new ArrayList<Object>();
        for (DynamicObject yem_sm_salesse_htxx : yem_sm_salesse_htxxCol) {
            String yem_contractno_dd = yem_sm_salesse_htxx.getString("yem_contractno_dd");
            if (!StringUtils.isNotEmpty((String)yem_contractno_dd)) continue;
            constracts.add(yem_contractno_dd);
        }
        ArrayList<Integer> removeList = new ArrayList<Integer>();
        DynamicObjectCollection yem_sm_salesse_qtxxCol = model.getEntryEntity("yem_sm_salesse_qtxx");
        for (DynamicObject yem_sm_salesse_ckxx : yem_sm_salesse_qtxxCol) {
            String yem_salectnumber = yem_sm_salesse_ckxx.getString("yem_salectnumber");
            if (constracts.contains(yem_salectnumber)) continue;
            removeList.add(yem_sm_salesse_ckxx.getInt("seq") - 1);
        }
        if (removeList.size() > 0) {
            int[] removeArr = new int[removeList.size()];
            for (int i = 0; i < removeList.size(); ++i) {
                removeArr[i] = (Integer)removeList.get(i);
            }
            model.deleteEntryRows("yem_sm_salesse_qtxx", removeArr);
        }
    }

    private void choiceContract(IDataModel model) {
        DynamicObject yem_fromcurr;
        DynamicObject org;
        DynamicObject yem_customer;
        String number;
        String billFormId = "yem_cnb_expcontract";
        String billname = "";
        DynamicObject yem_natureoftrade = (DynamicObject)model.getValue("yem_natureoftrade");
        if (yem_natureoftrade != null && StringUtils.isNotEmpty((String)(number = yem_natureoftrade.getString("number")))) {
            switch (number) {
                case "MYXZ001_SYS": 
                case "MYXZ002_SYS": 
                case "MYXZ003_SYS": {
                    billFormId = "yem_cnb_expcontract";
                    billname = "\u51fa\u53e3\u5408\u540c(\u5927\u5b97)";
                    break;
                }
                case "MYXZ009_SYS": {
                    billFormId = "yem_cnb_salorder";
                    billname = "\u9500\u552e\u5408\u540c(\u5927\u5b97)";
                }
            }
        }
        ListShowParameter listpara = new ListShowParameter();
        listpara.setBillFormId(billFormId);
        listpara.setParentPageId(this.getView().getPageId());
        listpara.setMultiSelect(false);
        listpara.setStatus(OperationStatus.VIEW);
        listpara.getOpenStyle().setShowType(ShowType.Modal);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"C");
        qFilterList.add(qFilter);
        if (yem_natureoftrade != null) {
            qFilterList.add(new QFilter("yem_tradeproperty.id", "=", yem_natureoftrade.getPkValue()));
        }
        if ((yem_customer = (DynamicObject)model.getValue("yem_customer")) != null) {
            qFilterList.add(new QFilter("yem_customer.id", "=", yem_customer.getPkValue()));
        }
        if ((org = (DynamicObject)model.getValue("org")) != null) {
            qFilterList.add(new QFilter("org.id", "=", org.getPkValue()));
        }
        if ((yem_fromcurr = (DynamicObject)model.getValue("yem_fromcurr")) != null) {
            qFilterList.add(new QFilter("yem_fromcurr.id", "=", yem_fromcurr.getPkValue()));
        }
        ArrayList<String> constractList = new ArrayList<String>();
        DynamicObjectCollection yem_sm_salesse_htxxCol = model.getEntryEntity("yem_sm_salesse_htxx");
        for (DynamicObject yem_sm_salesse_htxx : yem_sm_salesse_htxxCol) {
            String yem_contractno_dd = yem_sm_salesse_htxx.getString("yem_contractno_dd");
            if (!StringUtils.isNotEmpty((String)yem_contractno_dd)) continue;
            constractList.add(yem_contractno_dd);
        }
        if (constractList.size() > 0) {
            qFilterList.add(new QFilter("billno", "not in", constractList));
        }
        listFilterParameter.setQFilters(qFilterList);
        listpara.setListFilterParameter(listFilterParameter);
        listpara.getOpenStyle().setCacheId(listpara.getPageId());
        listpara.setLookUp(true);
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("800");
        inlineStyleCss.setWidth("1400");
        listpara.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), billFormId);
        listpara.setCloseCallBack(closeCallBack);
        listpara.setCaption(billname);
        this.getView().showForm((FormShowParameter)listpara);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        IDataModel model = this.getModel();
        if (StringUtils.isNotEmpty((String)actionId)) {
            switch (actionId) {
                case "yem_outbillmx": {
                    this.backOutBill(closedCallBackEvent, model);
                    this.lockFinalSett(model);
                }
            }
        }
    }

    private void lockFinalSett(IDataModel model) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ArrayList<String> strings = new ArrayList<String>();
        DynamicObjectCollection yem_sm_salesse_ckxxCol = model.getEntryEntity("yem_sm_salesse_ckxx");
        DynamicObjectCollection yem_sm_salesse_qtxxCol = model.getEntryEntity("yem_sm_salesse_qtxx");
        for (DynamicObject yem_sm_salesse_ckxx : yem_sm_salesse_ckxxCol) {
            long yemConstractid = yem_sm_salesse_ckxx.getLong("yem_constractid");
            if (yemConstractid <= 0L) continue;
            ids.add(yemConstractid);
        }
        for (DynamicObject yem_sm_salesse_ckxx : yem_sm_salesse_qtxxCol) {
            String str = yem_sm_salesse_ckxx.getString("yem_salectnumber");
            if (!StringUtils.isNotEmpty((String)str)) continue;
            strings.add(str);
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        DynamicObjectCollection yem_sm_salesse_htxxCol = model.getEntryEntity("yem_sm_salesse_htxx");
        for (DynamicObject yem_sm_salesse_htxx : yem_sm_salesse_htxxCol) {
            int i;
            if (ids.contains(yem_sm_salesse_htxx.getLong("yem_constractidht"))) {
                indexList.add(yem_sm_salesse_htxx.getInt("seq") - 1);
            }
            if (!strings.contains(yem_sm_salesse_htxx.getString("yem_contractno_xx")) || indexList.contains(i = yem_sm_salesse_htxx.getInt("seq") - 1)) continue;
            indexList.add(i);
        }
        if (yem_sm_salesse_ckxxCol != null && yem_sm_salesse_ckxxCol.size() > 0) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"yem_isfinalsett"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"yem_isfinalsett"});
        }
        for (DynamicObject yem_sm_salesse_htxx : yem_sm_salesse_htxxCol) {
            this.getView().setEnable(Boolean.valueOf(true), yem_sm_salesse_htxx.getInt("seq") - 1, new String[]{"yem_contractno_xx"});
        }
        Iterator str = indexList.iterator();
        while (str.hasNext()) {
            int index = (Integer)str.next();
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"yem_contractno_xx"});
        }
        DynamicObjectCollection yem_sm_salesse_djxxCol = model.getEntryEntity("yem_sm_salesse_djxx");
        if (yem_sm_salesse_ckxxCol.size() > 0 || yem_sm_salesse_qtxxCol.size() > 0 || yem_sm_salesse_djxxCol.size() > 0) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"yem_advconbaritemap13"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"yem_advconbaritemap13"});
        }
    }

    private void backOutBill(ClosedCallBackEvent closedCallBackEvent, IDataModel model) {
        List returnData = (List)closedCallBackEvent.getReturnData();
        Object value = model.getValue("yem_isfinalsett");
        if (returnData != null) {
            ArrayList<Long> constractIds = new ArrayList<Long>();
            for (DynamicObject yem_entryentity : returnData) {
                long yemEntryid = yem_entryentity.getLong("yem_entryid");
                long id = yem_entryentity.getLong("yem_constractid");
                if (id > 0L) {
                    constractIds.add(id);
                }
                boolean flag = false;
                DynamicObjectCollection yem_sm_salesse_ckxxCol = model.getEntryEntity("yem_sm_salesse_ckxx");
                for (DynamicObject yem_sm_salesse_ckxx : yem_sm_salesse_ckxxCol) {
                    long yemSmCkxx = yem_sm_salesse_ckxx.getLong("yem_entryid");
                    if (yemEntryid != yemSmCkxx) continue;
                    flag = true;
                    yem_sm_salesse_ckxx.set("yem_constratnumber", (Object)yem_entryentity.getString("yem_constratnumber"));
                    yem_sm_salesse_ckxx.set("yem_outbillnumber", (Object)yem_entryentity.getString("yem_outbillnumber"));
                    yem_sm_salesse_ckxx.set("yem_material", (Object)yem_entryentity.getDynamicObject("yem_material"));
                    yem_sm_salesse_ckxx.set("yem_inboundquantity", (Object)yem_entryentity.getBigDecimal("yem_inboundquantity"));
                    yem_sm_salesse_ckxx.set("yem_inqtyunsettled", (Object)yem_entryentity.getBigDecimal("yem_inqtyunsettled"));
                    yem_sm_salesse_ckxx.set("yem_units", (Object)yem_entryentity.getDynamicObject("yem_units"));
                    yem_sm_salesse_ckxx.set("yem_prices", (Object)yem_entryentity.getBigDecimal("yem_prices"));
                    yem_sm_salesse_ckxx.set("yem_amounts", (Object)yem_entryentity.getBigDecimal("yem_amounts"));
                    yem_sm_salesse_ckxx.set("yem_constractid", (Object)yem_entryentity.getLong("yem_constractid"));
                    yem_sm_salesse_ckxx.set("yem_outbillid", (Object)yem_entryentity.getLong("yem_outbillid"));
                    break;
                }
                if (flag) continue;
                int row = model.createNewEntryRow("yem_sm_salesse_ckxx");
                model.setValue("yem_constratnumber", (Object)yem_entryentity.getString("yem_constratnumber"), row);
                model.setValue("yem_outbillnumber", (Object)yem_entryentity.getString("yem_outbillnumber"), row);
                model.setValue("yem_material", (Object)yem_entryentity.getDynamicObject("yem_material"), row);
                model.setValue("yem_inboundquantity", (Object)yem_entryentity.getBigDecimal("yem_inboundquantity"), row);
                model.setValue("yem_inqtyunsettled", (Object)yem_entryentity.getBigDecimal("yem_inqtyunsettled"), row);
                model.setValue("yem_units", (Object)yem_entryentity.getDynamicObject("yem_units"), row);
                model.setValue("yem_prices", (Object)yem_entryentity.getBigDecimal("yem_prices"), row);
                model.setValue("yem_amounts", (Object)yem_entryentity.getBigDecimal("yem_amounts"), row);
                model.setValue("yem_constractid", (Object)yem_entryentity.getLong("yem_constractid"), row);
                model.setValue("yem_outbillid", (Object)yem_entryentity.getLong("yem_outbillid"), row);
                model.setValue("yem_entryid", (Object)yemEntryid, row);
            }
            if ("B".equals(value)) {
                OperateOption Option = OperateOption.create();
                Option.setVariableValue("updateModifyDate", String.valueOf(false));
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                String name = dataEntity.getDynamicObjectType().getName();
                SaveServiceHelper.saveOperate((String)name, (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)Option);
                this.getView().updateView("yem_sm_salesse_ckxx");
            }
            SalesStatemBillPlugin.backOutBill(value, constractIds);
            this.reCalculate(model);
        }
    }

    private static void backOutBill(Object value, List<Long> ids) {
        if ("B".equals(value)) {
            DynamicObject[] im_saloutbillCol;
            String salesstatemSelectfields = DynamicObjectUtil.getSelectfieldsFast((String)"yem_sm_salesstatem", (String[])new String[]{"yem_sm_salesse_ckxx"});
            DynamicObject[] yem_sm_salesstatemCol = BusinessDataServiceHelper.load((String)"yem_sm_salesstatem", (String)salesstatemSelectfields, (QFilter[])new QFilter[]{new QFilter("billstatus", "in", (Object)new String[]{"A", "B", "C"}), new QFilter("yem_isfinalsett", "=", (Object)"B"), new QFilter("yem_sm_salesse_htxx.yem_constractidht", "in", ids)});
            HashMap<Long, BigDecimal> entryAndQty = new HashMap<Long, BigDecimal>();
            for (DynamicObject yem_sm_salesstatem : yem_sm_salesstatemCol) {
                DynamicObjectCollection yem_sm_salesse_ckxxCol = yem_sm_salesstatem.getDynamicObjectCollection("yem_sm_salesse_ckxx");
                for (DynamicObject yem_sm_salesse_ckxx : yem_sm_salesse_ckxxCol) {
                    long yemEntryid = yem_sm_salesse_ckxx.getLong("yem_entryid");
                    BigDecimal yemInqtyunsettled = yem_sm_salesse_ckxx.getBigDecimal("yem_inqtyunsettled");
                    if (yemEntryid <= 0L) continue;
                    if (!entryAndQty.containsKey(yemEntryid)) {
                        entryAndQty.put(yemEntryid, yemInqtyunsettled);
                        continue;
                    }
                    BigDecimal bigDecimal = (BigDecimal)entryAndQty.get(yemEntryid);
                    entryAndQty.put(yemEntryid, BigDecimalUtils.add((BigDecimal)yemInqtyunsettled, (BigDecimal)bigDecimal, (int)7));
                }
            }
            String im_saloutbillSelectfields = DynamicObjectUtil.getSelectfieldsFast((String)"im_saloutbill", (String[])new String[]{"billentry"});
            for (DynamicObject im_saloutbill : im_saloutbillCol = BusinessDataServiceHelper.load((String)"im_saloutbill", (String)im_saloutbillSelectfields, (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)"C"), new QFilter("billentry.mainbillid", "in", ids)})) {
                DynamicObjectCollection billentryCol = im_saloutbill.getDynamicObjectCollection("billentry");
                for (DynamicObject billentry : billentryCol) {
                    long id = billentry.getLong("id");
                    if (entryAndQty.containsKey(id)) {
                        billentry.set("yem_setqty", entryAndQty.get(id));
                        continue;
                    }
                    billentry.set("yem_setqty", (Object)BigDecimal.ZERO);
                }
            }
            SaveServiceHelper.save((DynamicObject[])im_saloutbillCol);
        }
    }

    private void reCalculate(IDataModel model) {
        HashMap<Long, BigDecimal> datasByAmount = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> datasByQty = new HashMap<Long, BigDecimal>();
        DynamicObjectCollection yem_sm_salesse_ckxxCol = model.getEntryEntity("yem_sm_salesse_ckxx");
        for (Object yem_sm_salesse_ckxx : yem_sm_salesse_ckxxCol) {
            BigDecimal bigDecimal;
            long yemConstractid = yem_sm_salesse_ckxx.getLong("yem_constractid");
            BigDecimal yemAmounts = yem_sm_salesse_ckxx.getBigDecimal("yem_amounts");
            BigDecimal yemInqtyunsettled = yem_sm_salesse_ckxx.getBigDecimal("yem_inqtyunsettled");
            if (yemConstractid <= 0L) continue;
            if (!datasByAmount.containsKey(yemConstractid)) {
                datasByAmount.put(yemConstractid, yemAmounts);
            } else {
                bigDecimal = (BigDecimal)datasByAmount.get(yemConstractid);
                datasByAmount.put(yemConstractid, BigDecimalUtils.add((BigDecimal)bigDecimal, (BigDecimal)yemAmounts, (int)7));
            }
            if (!datasByQty.containsKey(yemConstractid)) {
                datasByQty.put(yemConstractid, yemInqtyunsettled);
                continue;
            }
            bigDecimal = (BigDecimal)datasByQty.get(yemConstractid);
            datasByQty.put(yemConstractid, BigDecimalUtils.add((BigDecimal)bigDecimal, (BigDecimal)yemInqtyunsettled, (int)7));
        }
        DynamicObjectCollection yem_sm_salesse_htxxCol = model.getEntryEntity("yem_sm_salesse_htxx");
        for (DynamicObject yem_sm_salesse_htxx : yem_sm_salesse_htxxCol) {
            int seq = yem_sm_salesse_htxx.getInt("seq") - 1;
            long yemSrcbillidDd = yem_sm_salesse_htxx.getLong("yem_constractidht");
            if (yemSrcbillidDd <= 0L) continue;
            if (datasByQty.containsKey(yemSrcbillidDd)) {
                model.setValue("yem_difqty", datasByQty.get(yemSrcbillidDd), seq);
                continue;
            }
            model.setValue("yem_difqty", (Object)BigDecimal.ZERO, seq);
        }
        Object value = model.getValue("yem_isfinalsett");
        if ("B".equals(value)) {
            OperateOption Option = OperateOption.create();
            Option.setVariableValue("updateModifyDate", String.valueOf(false));
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            String name = dataEntity.getDynamicObjectType().getName();
            SaveServiceHelper.saveOperate((String)name, (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)Option);
        }
    }

    private void reCalculateByQt(IDataModel model) {
        HashMap<String, BigDecimal> datasByAmount = new HashMap<String, BigDecimal>();
        DynamicObjectCollection yem_sm_salesse_qtxxCol = model.getEntryEntity("yem_sm_salesse_qtxx");
        for (DynamicObject yem_sm_salesse_qtxx : yem_sm_salesse_qtxxCol) {
            String yem_salectnumber = yem_sm_salesse_qtxx.getString("yem_salectnumber");
            BigDecimal yem_qtfeeamtexclud = yem_sm_salesse_qtxx.getBigDecimal("yem_qtfeeamtexclud");
            if (!StringUtils.isNotEmpty((String)yem_salectnumber)) continue;
            if (!datasByAmount.containsKey(yem_salectnumber)) {
                datasByAmount.put(yem_salectnumber, yem_qtfeeamtexclud);
                continue;
            }
            BigDecimal bigDecimal = (BigDecimal)datasByAmount.get(yem_salectnumber);
            datasByAmount.put(yem_salectnumber, BigDecimalUtils.add((BigDecimal)bigDecimal, (BigDecimal)yem_qtfeeamtexclud, (int)7));
        }
        DynamicObjectCollection yem_sm_salesse_htxxCol = model.getEntryEntity("yem_sm_salesse_htxx");
        for (DynamicObject yem_sm_salesse_htxx : yem_sm_salesse_htxxCol) {
            int seq = yem_sm_salesse_htxx.getInt("seq") - 1;
            String yem_contractno_dd = yem_sm_salesse_htxx.getString("yem_contractno_dd");
            if (!StringUtils.isNotEmpty((String)yem_contractno_dd)) continue;
            if (datasByAmount.containsKey(yem_contractno_dd)) {
                model.setValue("yem_ctpayamt_dd", datasByAmount.get(yem_contractno_dd), seq);
                continue;
            }
            model.setValue("yem_ctpayamt_dd", (Object)BigDecimal.ZERO, seq);
        }
        this.getView().updateView("yem_sm_salesse_htxx");
    }

    private static void exPcontract(ClosedCallBackEvent closedCallBackEvent, IDataModel model) {
        DynamicObject expcontract;
        long yem_cnb_expcontract;
        int rowIndex = model.getEntryCurrentRowIndex("yem_sm_salesse_htxx");
        ListSelectedRowCollection listData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (listData != null && listData.size() > 0 && (yem_cnb_expcontract = ((Long)listData.get(0).getPrimaryKeyValue()).longValue()) > 0L && (expcontract = BusinessDataServiceHelper.loadSingle((Object)yem_cnb_expcontract, (String)"yem_cnb_expcontract")) != null) {
            DynamicObject dynamicObjectFirst;
            DynamicObjectCollection yem_materialentryCol = expcontract.getDynamicObjectCollection("yem_materialentry");
            BigDecimal qty = BigDecimal.ZERO;
            for (DynamicObject yem_materialentry : yem_materialentryCol) {
                qty = BigDecimalUtils.add((BigDecimal)yem_materialentry.getBigDecimal("yem_qty"), (BigDecimal)qty, (int)7);
            }
            model.setValue("yem_contractno_dd", (Object)expcontract.getString("billno"), rowIndex);
            model.setValue("yem_ctquantity", (Object)qty, rowIndex);
            if (yem_materialentryCol != null && yem_materialentryCol.size() > 0 && (dynamicObjectFirst = (DynamicObject)yem_materialentryCol.get(0)) != null) {
                model.setValue("yem_unitmeasure", (Object)dynamicObjectFirst.getDynamicObject("yem_unit"), rowIndex);
                model.setValue("yem_taxrate_dd", (Object)dynamicObjectFirst.getBigDecimal("yem_taxratevalue"), rowIndex);
            }
            model.setValue("yem_constractidht", expcontract.getPkValue(), rowIndex);
            if (rowIndex == 0) {
                Object yem_customer;
                Object yem_fromcurr = model.getValue("yem_fromcurr");
                if (yem_fromcurr == null) {
                    model.setValue("yem_fromcurr", (Object)expcontract.getDynamicObject("yem_fromcurr"));
                }
                if ((yem_customer = model.getValue("yem_customer")) == null) {
                    model.setValue("yem_customer", (Object)expcontract.getDynamicObject("yem_customer"));
                }
            }
            String selectfields = DynamicObjectUtil.getSelectfieldsFast((String)"im_saloutbill", (String[])new String[]{"billentry"});
            DynamicObject[] im_saloutbillCol = BusinessDataServiceHelper.load((String)"im_saloutbill", (String)selectfields, (QFilter[])new QFilter[]{new QFilter("billentry.mainbillid", "=", expcontract.getPkValue()), new QFilter("billstatus", "=", (Object)"C")});
            BigDecimal outQty = BigDecimal.ZERO;
            for (DynamicObject im_saloutbill : im_saloutbillCol) {
                DynamicObjectCollection billentryCol = im_saloutbill.getDynamicObjectCollection("billentry");
                for (DynamicObject billentry : billentryCol) {
                    outQty = BigDecimalUtils.add((BigDecimal)outQty, (BigDecimal)billentry.getBigDecimal("qty"), (int)7);
                }
            }
            model.setValue("yem_orderquantity", (Object)outQty, rowIndex);
        }
    }

    private static void salOrder(ClosedCallBackEvent closedCallBackEvent, IDataModel model) {
        DynamicObject expcontract;
        long yem_cnb_expcontract;
        int rowIndex = model.getEntryCurrentRowIndex("yem_sm_salesse_htxx");
        ListSelectedRowCollection listData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (listData != null && listData.size() > 0 && (yem_cnb_expcontract = ((Long)listData.get(0).getPrimaryKeyValue()).longValue()) > 0L && (expcontract = BusinessDataServiceHelper.loadSingle((Object)yem_cnb_expcontract, (String)"yem_cnb_salorder")) != null) {
            DynamicObject dynamicObjectFirst;
            DynamicObjectCollection yem_materialentryCol = expcontract.getDynamicObjectCollection("yem_materialentry");
            BigDecimal qty = BigDecimal.ZERO;
            for (DynamicObject yem_materialentry : yem_materialentryCol) {
                qty = BigDecimalUtils.add((BigDecimal)yem_materialentry.getBigDecimal("yem_qty"), (BigDecimal)qty, (int)7);
            }
            model.setValue("yem_contractno_dd", (Object)expcontract.getString("billno"), rowIndex);
            model.setValue("yem_ctquantity", (Object)qty, rowIndex);
            if (yem_materialentryCol != null && yem_materialentryCol.size() > 0 && (dynamicObjectFirst = (DynamicObject)yem_materialentryCol.get(0)) != null) {
                model.setValue("yem_unitmeasure", (Object)dynamicObjectFirst.getDynamicObject("yem_unit"), rowIndex);
                model.setValue("yem_taxrate_dd", (Object)dynamicObjectFirst.getBigDecimal("yem_taxratevalue"), rowIndex);
            }
            model.setValue("yem_constractidht", expcontract.getPkValue(), rowIndex);
            if (rowIndex == 0) {
                Object yem_customer;
                Object yem_fromcurr = model.getValue("yem_fromcurr");
                if (yem_fromcurr == null) {
                    model.setValue("yem_fromcurr", (Object)expcontract.getDynamicObject("yem_fromcurr"));
                }
                if ((yem_customer = model.getValue("yem_customer")) == null) {
                    model.setValue("yem_customer", (Object)expcontract.getDynamicObject("yem_customer"));
                }
            }
            String selectfields = DynamicObjectUtil.getSelectfieldsFast((String)"im_saloutbill", (String[])new String[]{"billentry"});
            DynamicObject[] im_saloutbillCol = BusinessDataServiceHelper.load((String)"im_saloutbill", (String)selectfields, (QFilter[])new QFilter[]{new QFilter("billentry.mainbillid", "=", expcontract.getPkValue()), new QFilter("billstatus", "=", (Object)"C")});
            BigDecimal outQty = BigDecimal.ZERO;
            for (DynamicObject im_saloutbill : im_saloutbillCol) {
                DynamicObjectCollection billentryCol = im_saloutbill.getDynamicObjectCollection("billentry");
                for (DynamicObject billentry : billentryCol) {
                    outQty = BigDecimalUtils.add((BigDecimal)outQty, (BigDecimal)billentry.getBigDecimal("qty"), (int)7);
                }
            }
            model.setValue("yem_orderquantity", (Object)outQty, rowIndex);
        }
    }

    private static void exPcontractByQt(ClosedCallBackEvent closedCallBackEvent, IDataModel model) {
        DynamicObject dynamicObjectFirst;
        DynamicObjectCollection yem_cnb_costentryCol;
        DynamicObject expcontract;
        long yem_cnb_expcontract;
        int rowIndex = model.getEntryCurrentRowIndex("yem_sm_salesse_qtxx");
        ListSelectedRowCollection listData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (listData != null && listData.size() > 0 && (yem_cnb_expcontract = ((Long)listData.get(0).getPrimaryKeyValue()).longValue()) > 0L && (expcontract = BusinessDataServiceHelper.loadSingle((Object)yem_cnb_expcontract, (String)"yem_cnb_expcontract")) != null && (yem_cnb_costentryCol = expcontract.getDynamicObjectCollection("yem_cnb_costentry")) != null && yem_cnb_costentryCol.size() > 0 && (dynamicObjectFirst = (DynamicObject)yem_cnb_costentryCol.get(0)) != null) {
            model.setValue("yem_salectnumber", (Object)expcontract.getString("billno"), rowIndex);
            model.setValue("yem_constractidqt", (Object)expcontract.getLong("id"), rowIndex);
        }
    }

    private static void salOrderByQt(ClosedCallBackEvent closedCallBackEvent, IDataModel model) {
        DynamicObject dynamicObjectFirst;
        DynamicObjectCollection yem_cnb_costentryCol;
        DynamicObject expcontract;
        long yem_cnb_expcontract;
        int rowIndex = model.getEntryCurrentRowIndex("yem_sm_salesse_qtxx");
        ListSelectedRowCollection listData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (listData != null && listData.size() > 0 && (yem_cnb_expcontract = ((Long)listData.get(0).getPrimaryKeyValue()).longValue()) > 0L && (expcontract = BusinessDataServiceHelper.loadSingle((Object)yem_cnb_expcontract, (String)"yem_cnb_salorder")) != null && (yem_cnb_costentryCol = expcontract.getDynamicObjectCollection("yem_cnb_costentry")) != null && yem_cnb_costentryCol.size() > 0 && (dynamicObjectFirst = (DynamicObject)yem_cnb_costentryCol.get(0)) != null) {
            model.setValue("yem_salectnumber", (Object)expcontract.getString("billno"), rowIndex);
            model.setValue("yem_constractidqt", (Object)expcontract.getLong("id"), rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        switch (operateKey = e.getOperateKey()) {
            case "choiceoutbill": {
                boolean success = e.getOperationResult().isSuccess();
                if (!success) break;
                FormShowParameter param = new FormShowParameter();
                DynamicObjectCollection yem_sm_salesse_htxxCol = this.getModel().getEntryEntity("yem_sm_salesse_htxx");
                ArrayList<Long> constractIds = new ArrayList<Long>();
                for (DynamicObject yem_sm_salesse_htxx : yem_sm_salesse_htxxCol) {
                    long yemSrcbillidDd = yem_sm_salesse_htxx.getLong("yem_constractidht");
                    if (yemSrcbillidDd <= 0L) continue;
                    constractIds.add(yemSrcbillidDd);
                }
                HashMap<Long, BigDecimal[]> datas = new HashMap<Long, BigDecimal[]>();
                DynamicObjectCollection yem_sm_salesse_ckxxCol = this.getModel().getEntryEntity("yem_sm_salesse_ckxx");
                for (DynamicObject yem_sm_salesse_ckxx : yem_sm_salesse_ckxxCol) {
                    long yemOutbillid = yem_sm_salesse_ckxx.getLong("yem_outbillid");
                    if (yemOutbillid <= 0L) continue;
                    BigDecimal[] arr = new BigDecimal[3];
                    arr[0] = yem_sm_salesse_ckxx.getBigDecimal("yem_inqtyunsettled");
                    arr[1] = yem_sm_salesse_ckxx.getBigDecimal("yem_prices");
                    datas.put(yemOutbillid, arr);
                }
                param.setCustomParam("ids", constractIds);
                param.setCustomParam("nowId", (Object)this.getModel().getDataEntity(true).getLong("id"));
                param.setCustomParam("datas", datas);
                param.getOpenStyle().setShowType(ShowType.Modal);
                param.setFormId("yem_outbillmx");
                param.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "yem_outbillmx"));
                this.getView().showForm(param);
                break;
            }
            case "divide": {
                IDataModel model = this.getModel();
                HashMap<Long, BigDecimal[]> datas = new HashMap<Long, BigDecimal[]>();
                DynamicObjectCollection yem_sm_salesse_htxxCol = model.getEntryEntity("yem_sm_salesse_htxx");
                for (DynamicObject dt : yem_sm_salesse_htxxCol) {
                    long yemConstractidht = dt.getLong("yem_constractidht");
                    BigDecimal yemDifqty = dt.getBigDecimal("yem_difqty");
                    BigDecimal yemAmountorder = dt.getBigDecimal("yem_amountorder");
                    if (yemConstractidht <= 0L || yemAmountorder == null || yemAmountorder.compareTo(BigDecimal.ZERO) <= 0 || yemDifqty == null || yemDifqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    datas.put(yemConstractidht, new BigDecimal[]{yemDifqty, yemAmountorder});
                }
                DynamicObjectCollection yem_sm_salesse_ckxxCol = model.getEntryEntity("yem_sm_salesse_ckxx");
                HashMap<Long, BigDecimal[]> coountQty = new HashMap<Long, BigDecimal[]>();
                for (DynamicObject yem_sm_salesse_ckxx : yem_sm_salesse_ckxxCol) {
                    int sqe = yem_sm_salesse_ckxx.getInt("seq") - 1;
                    long yemConstractid = yem_sm_salesse_ckxx.getLong("yem_constractid");
                    BigDecimal yemInqtyunsettled = yem_sm_salesse_ckxx.getBigDecimal("yem_inqtyunsettled");
                    if (yemConstractid <= 0L) continue;
                    if (!coountQty.containsKey(yemConstractid)) {
                        if (!datas.containsKey(yemConstractid)) continue;
                        BigDecimal[] bigDecimals = (BigDecimal[])datas.get(yemConstractid);
                        if (yemInqtyunsettled != null && yemInqtyunsettled.compareTo(bigDecimals[0]) == 0) {
                            model.setValue("yem_amounts", (Object)bigDecimals[1], sqe);
                            model.setValue("yem_prices", (Object)BigDecimalUtils.div((BigDecimal)bigDecimals[1], (BigDecimal)yemInqtyunsettled, (int)2), sqe);
                            continue;
                        }
                        BigDecimal multiply = BigDecimalUtils.multiply((BigDecimal)yemInqtyunsettled, (BigDecimal)bigDecimals[1], (int)6);
                        BigDecimal div = BigDecimalUtils.div((BigDecimal)multiply, (BigDecimal)bigDecimals[0], (int)2);
                        model.setValue("yem_amounts", (Object)div, sqe);
                        model.setValue("yem_prices", (Object)BigDecimalUtils.div((BigDecimal)div, (BigDecimal)yemInqtyunsettled, (int)2), sqe);
                        coountQty.put(yemConstractid, new BigDecimal[]{yemInqtyunsettled, div});
                        continue;
                    }
                    BigDecimal[] bigDecimal = (BigDecimal[])coountQty.get(yemConstractid);
                    BigDecimal addQty = BigDecimalUtils.add((BigDecimal)yemInqtyunsettled, (BigDecimal)bigDecimal[0], (int)6);
                    if (!datas.containsKey(yemConstractid)) continue;
                    BigDecimal[] bigDecimals = (BigDecimal[])datas.get(yemConstractid);
                    if (yemInqtyunsettled != null && addQty.compareTo(bigDecimals[0]) == 0) {
                        BigDecimal sub = BigDecimalUtils.sub((BigDecimal)bigDecimals[1], (BigDecimal)bigDecimal[1], (int)2);
                        model.setValue("yem_amounts", (Object)sub, sqe);
                        model.setValue("yem_prices", (Object)BigDecimalUtils.div((BigDecimal)sub, (BigDecimal)yemInqtyunsettled, (int)2), sqe);
                        continue;
                    }
                    BigDecimal multiply = BigDecimalUtils.multiply((BigDecimal)yemInqtyunsettled, (BigDecimal)bigDecimals[1], (int)6);
                    BigDecimal div = BigDecimalUtils.div((BigDecimal)multiply, (BigDecimal)bigDecimals[0], (int)2);
                    model.setValue("yem_amounts", (Object)div, sqe);
                    model.setValue("yem_prices", (Object)BigDecimalUtils.div((BigDecimal)div, (BigDecimal)yemInqtyunsettled, (int)2), sqe);
                    BigDecimal addAmount = BigDecimalUtils.add((BigDecimal)div, (BigDecimal)bigDecimal[1], (int)2);
                    coountQty.put(yemConstractid, new BigDecimal[]{addQty, addAmount});
                }
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        IDataModel model = this.getModel();
        switch (name) {
            case "yem_contractno_xx": {
                ArrayList<QFilter> list = new ArrayList<QFilter>();
                DynamicObject yem_natureoftrade = (DynamicObject)model.getValue("yem_natureoftrade");
                if (yem_natureoftrade != null) {
                    list.add(new QFilter("yem_tradetype.id", "=", yem_natureoftrade.getPkValue()));
                }
                list.add(new QFilter("yem_accounttype", "=", (Object)"bd_customer"));
                DynamicObject yem_customer = (DynamicObject)model.getValue("yem_customer");
                if (yem_customer != null) {
                    list.add(new QFilter("yem_cusorsupp.id", "=", yem_customer.getPkValue()));
                }
                beforeF7SelectEvent.setCustomQFilters(list);
                break;
            }
            case "yem_salectnumberqt": {
                ArrayList<Long> listIds = new ArrayList<Long>();
                DynamicObjectCollection entryEntityCol = model.getEntryEntity("yem_sm_salesse_htxx");
                for (DynamicObject entryEntity : entryEntityCol) {
                    DynamicObject yem_contractno_xx = entryEntity.getDynamicObject("yem_contractno_xx");
                    if (yem_contractno_xx == null) continue;
                    listIds.add(yem_contractno_xx.getLong("id"));
                }
                if (listIds.size() <= 0) break;
                ArrayList<QFilter> lists = new ArrayList<QFilter>();
                lists.add(new QFilter("id", "in", listIds));
                beforeF7SelectEvent.setCustomQFilters(lists);
            }
        }
    }
}

