/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.sm.common.util;

import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.FileNameUtils;
import yem.base.common.utils.BigDecimalUtils;
import yem.base.common.utils.StringUtils;

public class CommonUtils {
    public static final String[] SPECIAL_SYMBOLS = new String[]{"%", "=", "+"};
    public static final String[] SPECIAL_CHARACTERS = new String[]{"+", "/", "?", "%", "#", "&", "="};

    public static BigDecimal getExchangeRate(Long exchangeRateTableId, Long sourceCurrencyId, Long targetCurrencyId, Long orgId, Date date) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (date == null) {
            date = new Date();
        }
        if (sourceCurrencyId == 0L || targetCurrencyId == 0L || sourceCurrencyId.equals(targetCurrencyId)) {
            return exchangeRate;
        }
        if (sourceCurrencyId.equals(targetCurrencyId)) {
            return exchangeRate;
        }
        if (exchangeRateTableId == 0L) {
            if (CommonUtils.getExrateTable(orgId) != null) {
                exchangeRateTableId = CommonUtils.getExrateTable(orgId).getLong("id");
                exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)date);
            }
        } else {
            exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)date);
        }
        if (exchangeRate == null) {
            exchangeRate = BigDecimal.ZERO;
        }
        return exchangeRate;
    }

    public static DynamicObject getStandardCurrency(long orgId) {
        DynamicObject systemStatusCtrol = CommonUtils.getSystemStatusCtrol(orgId);
        if (systemStatusCtrol == null) {
            return null;
        }
        return systemStatusCtrol.getDynamicObject("standardcurrency");
    }

    public static DynamicObject getExrateTable(long orgId) {
        DynamicObject systemStatusCtrol = CommonUtils.getSystemStatusCtrol(orgId);
        if (systemStatusCtrol == null) {
            return null;
        }
        return systemStatusCtrol.getDynamicObject("exratetable");
    }

    private static DynamicObject getSystemStatusCtrol(long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        DynamicObjectCollection CasInitColl = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"id", (QFilter[])filters);
        if (CasInitColl.size() == 0) {
            DynamicObject bos_org = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
            if (!bos_org.getBoolean("fisaccounting")) {
                DynamicObject bos_orgparent = CommonUtils.getViewparent(bos_org);
                if (bos_orgparent != null) {
                    return CommonUtils.getSystemStatusCtrol(bos_orgparent.getLong("id"));
                }
            } else {
                return null;
            }
        }
        DynamicObject ArInit = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)CasInitColl.get(0)).getLong("id"), (String)"cas_cashmgtinit");
        return ArInit;
    }

    public static DynamicObject getInitialization(long orgId, String SystemType) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        QFilter qFilter1 = new QFilter("isfinishinit", "=", (Object)true);
        DynamicObjectCollection CasInitColl = QueryServiceHelper.query((String)SystemType, (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter1});
        if (CasInitColl.size() > 0) {
            DynamicObject ArInit = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)CasInitColl.get(0)).getLong("id"), (String)SystemType);
            return ArInit;
        }
        return null;
    }

    public static boolean getParameterBoolean(long orgId, String key) {
        Object value = SystemParamServiceHelper.getAppParameter((String)"075YJT9UL49+", (String)"075YOP7VS1VC", (Long)orgId, (String)key);
        return value != null && (Boolean)value != false;
    }

    public static int getParameterInteger(long orgId, String key) {
        Object value = SystemParamServiceHelper.getAppParameter((String)"075YJT9UL49+", (String)"075YOP7VS1VC", (Long)orgId, (String)key);
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value.toString());
    }

    public static void setValue(IDataModel model, IFormView view, String field, DynamicObject value) {
        model.beginInit();
        model.setValue(field, value == null ? null : value.getPkValue());
        model.endInit();
        view.updateView(field);
    }

    public static Long getCurrentUserId() {
        Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
        return currentUserId;
    }

    public static DynamicObject getCurrentUser() {
        Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
        return BusinessDataServiceHelper.loadSingleFromCache((Object)currentUserId, (String)"bos_user");
    }

    public static DynamicObject getCurrentUser(String Username) {
        QFilter qf1 = new QFilter("name", "=", (Object)Username);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (QFilter[])new QFilter[]{qf1});
    }

    public static AppInfo getBizAppByFormId(String formId) {
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
        if (formConfig == null || formConfig.getAppId() == null) {
            return null;
        }
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)formConfig.getAppId());
        return appInfo;
    }

    public static String getBizAppOrgFuncByAppId(String appId) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
        return appInfo.getOrgFunc();
    }

    public static String getBizAppOrgFuncByFormId(String formId) {
        AppInfo appInfo = CommonUtils.getBizAppByFormId(formId);
        if (appInfo == null) {
            return null;
        }
        return appInfo.getOrgFunc();
    }

    public static Long getLinkman(DynamicObject customer) {
        DynamicObjectCollection linkmans = customer.getDynamicObjectCollection("entry_linkman");
        Long customerLinkmanId = null;
        for (DynamicObject linkman : linkmans) {
            boolean isDefault = linkman.getBoolean("isdefault_linkman");
            if (!isDefault) continue;
            customerLinkmanId = (long)((Long)linkman.getPkValue());
            break;
        }
        return customerLinkmanId;
    }

    public static String getAddress(DynamicObject customer) {
        DynamicObjectCollection addresses = customer.getDynamicObjectCollection("entry_address");
        for (DynamicObject addressInfo : addresses) {
            boolean isDefault = addressInfo.getBoolean("isdefault_addr");
            if (!isDefault) continue;
            return addressInfo.getString("addr_address");
        }
        return "";
    }

    public static void updateView(IFormView view, String ... parm) {
        for (String s : parm) {
            CommonUtils.updateView(view, s);
        }
    }

    private static void updateView(IFormView view, String key) {
        if (!CommonUtils.isNull(view.getControl(key))) {
            view.updateView(key);
        }
    }

    public static boolean isNull(Object o) {
        return o == null || o instanceof String && ((String)o).length() == 0 || o instanceof StringBuffer && ((StringBuffer)o).length() == 0 || o instanceof List && ((List)o).size() == 0 || o instanceof Collection && ((Collection)o).size() == 0 || o instanceof Object[] && ((Object[])o).length == 0 || o instanceof Map && ((Map)o).size() == 0;
    }

    public static long GetCompanyInfoIdnew(long Orgid) {
        QFilter qFilter3;
        QFilter qFilter2;
        long Companyfid = 0L;
        QFilter qFilter1 = new QFilter("org", "=", (Object)Orgid);
        DynamicObject[] Companyobj = BusinessDataServiceHelper.load((String)"tpv_bd_companyinfo", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2 = new QFilter("tpv_isdefault", "=", (Object)true), qFilter3 = new QFilter("status", "=", (Object)"C")});
        if (Companyobj != null && Companyobj.length > 0) {
            Companyfid = Companyobj[0].getLong("id");
        }
        return Companyfid;
    }

    public static DynamicObject GetCurrencyInfoId(String CurrencyCode) {
        QFilter qFilter1 = new QFilter("number", "=", (Object)CurrencyCode);
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{qFilter1});
        DynamicObject bill = null;
        for (int j = 0; j < bills.length; ++j) {
            bill = bills[j];
        }
        return bill;
    }

    public static void SetAmountInWordsCN(IDataModel model, String amountKey, String currencyKey, String wordKey) {
        BigDecimal amount;
        DynamicObject currency = (DynamicObject)model.getValue(currencyKey);
        if (currency != null && (amount = BigDecimalUtils.toBigDecimal((Object)model.getValue(amountKey))).compareTo(BigDecimal.ZERO) > 0) {
            model.setValue(wordKey, (Object)BigDecimalUtils.digitCapital((Object)amount.doubleValue()));
        }
    }

    public static String getPurdep() {
        long userId = UserServiceHelper.getCurrentUserId();
        QFilter qFilter1 = new QFilter("operatorid", "=", (Object)userId);
        DynamicObject[] puroperators = BusinessDataServiceHelper.load((String)"bd_operator", (String)"id,operatornumber,operatorname", (QFilter[])new QFilter[]{qFilter1});
        if (puroperators != null && puroperators.length > 0) {
            DynamicObjectCollection entryentitys;
            DynamicObject puroperator = puroperators[0];
            DynamicObject operatorid = (DynamicObject)(puroperator = BusinessDataServiceHelper.loadSingleFromCache((Object)puroperator.getPkValue(), (String)"bd_operator")).get("operatorid");
            if (null != operatorid && (entryentitys = (operatorid = BusinessDataServiceHelper.loadSingleFromCache((Object)operatorid.getPkValue(), (String)"bos_user")).getDynamicObjectCollection("entryentity")) != null && entryentitys.size() == 1) {
                DynamicObject entryentity = (DynamicObject)entryentitys.get(0);
                DynamicObject purdep = entryentity.getDynamicObject("dpt");
                String purdepNme = purdep.getString("name");
                return purdepNme;
            }
        }
        return null;
    }

    public static void setApprovalinfo(Map map, DynamicObject descBill) {
        if (!map.containsKey("srcBill")) {
            throw new KDBizException("\u521d\u59cb\u5316\u5ba1\u6279\u4fe1\u606f\u5206\u5f55\u65f6\uff0c\u53c2\u6570srcBill\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (!map.containsKey("srcBillId")) {
            throw new KDBizException("\u521d\u59cb\u5316\u5ba1\u6279\u4fe1\u606f\u5206\u5f55\u65f6\uff0c\u53c2\u6570srcBillId\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (!map.containsKey("srcEntry")) {
            throw new KDBizException("\u521d\u59cb\u5316\u5ba1\u6279\u4fe1\u606f\u5206\u5f55\u65f6\uff0c\u53c2\u6570srcEntry\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (!map.containsKey("srcApprovalnode")) {
            throw new KDBizException("\u521d\u59cb\u5316\u5ba1\u6279\u4fe1\u606f\u5206\u5f55\u65f6\uff0c\u53c2\u6570srcApprovalnode\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (!map.containsKey("srcApprovedby")) {
            throw new KDBizException("\u521d\u59cb\u5316\u5ba1\u6279\u4fe1\u606f\u5206\u5f55\u65f6\uff0c\u53c2\u6570srcApprovedby\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (!map.containsKey("srcApprovetime")) {
            throw new KDBizException("\u521d\u59cb\u5316\u5ba1\u6279\u4fe1\u606f\u5206\u5f55\u65f6\uff0c\u53c2\u6570srcApprovetime\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (!map.containsKey("descEntry")) {
            throw new KDBizException("\u521d\u59cb\u5316\u5ba1\u6279\u4fe1\u606f\u5206\u5f55\u65f6\uff0c\u53c2\u6570descEntry\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (!map.containsKey("descApprovalnode")) {
            throw new KDBizException("\u521d\u59cb\u5316\u5ba1\u6279\u4fe1\u606f\u5206\u5f55\u65f6\uff0c\u53c2\u6570descApprovalnode\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (!map.containsKey("descApprovedby")) {
            throw new KDBizException("\u521d\u59cb\u5316\u5ba1\u6279\u4fe1\u606f\u5206\u5f55\u65f6\uff0c\u53c2\u6570descApprovedby\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (!map.containsKey("descApprovetime")) {
            throw new KDBizException("\u521d\u59cb\u5316\u5ba1\u6279\u4fe1\u606f\u5206\u5f55\u65f6\uff0c\u53c2\u6570descApprovetime\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        String srcBill = map.get("srcBill").toString();
        long srcBillId = (Long)map.get("srcBillId");
        String srcEntry = map.get("srcEntry").toString();
        String srcApprovalnode = map.get("srcApprovalnode").toString();
        String srcApprovedby = map.get("srcApprovedby").toString();
        String srcApprovetime = map.get("srcApprovetime").toString();
        String descEntry = map.get("descEntry").toString();
        String descApprovalnode = map.get("descApprovalnode").toString();
        String descApprovedby = map.get("descApprovedby").toString();
        String descApprovetime = map.get("descApprovetime").toString();
        DynamicObjectCollection descEntryObjs = descBill.getDynamicObjectCollection(descEntry);
        descEntryObjs.clear();
        DynamicObject srcObj = BusinessDataServiceHelper.loadSingle((Object)srcBillId, (String)srcBill);
        if (null != srcObj) {
            DynamicObjectCollection srcEntryObjs = srcObj.getDynamicObjectCollection(srcEntry);
            for (int i = 0; i < srcEntryObjs.size(); ++i) {
                DynamicObject srcEntryObj = (DynamicObject)srcEntryObjs.get(i);
                DynamicObject descEntryObj = descEntryObjs.addNew();
                descEntryObj.set(descApprovalnode, srcEntryObj.get(srcApprovalnode));
                descEntryObj.set(descApprovedby, srcEntryObj.get(srcApprovedby));
                descEntryObj.set(descApprovetime, srcEntryObj.get(srcApprovetime));
            }
        }
    }

    public static void AttachmentService(String sourceBillId, String sourceBillformId, String ExtendedbillId, String ExtendedbillformId, String attachmentpanelId) {
        List listold = AttachmentServiceHelper.getAttachmentsByExport((String)sourceBillformId, (Object)sourceBillId);
        ArrayList<Map> listnew = new ArrayList<Map>();
        for (Map obj : listold) {
            obj.put("lastModified", null);
            listnew.add(obj);
        }
        AttachmentServiceHelper.upload((String)ExtendedbillformId, (Object)ExtendedbillId, (String)attachmentpanelId, listnew);
    }

    public static void botpAttachmentpanel(DynamicObject bill, String attachKey, Long fsourcebillid, String sourcebillform, String appId) {
        Object pkId = bill.getPkValue();
        if ((Long)pkId == 0L) {
            return;
        }
        String formId = bill.getDataEntityType().getName();
        List listMapAttachments = AttachmentServiceHelper.getAttachmentsByExport((String)sourcebillform, (Object)fsourcebillid);
        for (Map attach : listMapAttachments) {
            String Dodurl = (String)attach.get("url");
            String fileName = (String)attach.get("name");
            FileService service = FileServiceFactory.getAttachmentFileService();
            InputStream in = service.getInputStream(Dodurl);
            String tenantId = RequestContext.get().getTenantId();
            String accountId = RequestContext.get().getAccountId();
            String uuid = UUID.randomUUID().toString().replace("-", "");
            String path = FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (String)appId, (String)formId, (Object)CommonUtils.replaceSpeChar(String.valueOf(pkId)), (String)(uuid + "/" + CommonUtils.replaceSpeSymbol(fileName)));
            FileItem fileItem = new FileItem(fileName, path, in);
            fileItem.setCreateNewFileWhenExists(true);
            String turl = service.upload(fileItem);
            ORM orm = ORM.create();
            DynamicObject dynamicObject = orm.newDynamicObject("bos_attachment");
            Long id = orm.genLongId("bos_attachment");
            dynamicObject.set("id", (Object)id);
            dynamicObject.set("FNUMBER", attach.get("uid"));
            dynamicObject.set("FBillType", (Object)formId);
            dynamicObject.set("FInterID", pkId);
            dynamicObject.set("FModifyTime", (Object)new Date());
            dynamicObject.set("fcreatetime", (Object)new Date());
            dynamicObject.set("FaliasFileName", (Object)fileName);
            dynamicObject.set("FAttachmentName", (Object)fileName);
            dynamicObject.set("FExtName", (Object)(fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : ""));
            dynamicObject.set("FATTACHMENTSIZE", attach.get("size"));
            dynamicObject.set("FFileId", (Object)turl);
            dynamicObject.set("FCREATEMEN", (Object)RequestContext.get().getUserId());
            dynamicObject.set("FMODIFYMEN", (Object)RequestContext.get().getUserId());
            dynamicObject.set("fattachmentpanel", (Object)attachKey);
            dynamicObject.set("fbillstatus", (Object)"1");
            orm.insert(dynamicObject);
        }
    }

    public static void botpAttachmentpanel2(DynamicObject bill, String attachKey, Long fsourcebillid, String sourcebillform, String appId) {
        Object pkId = bill.getPkValue();
        if ((Long)pkId == 0L) {
            return;
        }
        String formId = bill.getDataEntityType().getName();
        List listMapAttachments = AttachmentServiceHelper.getAttachmentsByExport((String)sourcebillform, (Object)fsourcebillid);
        for (Map attach : listMapAttachments) {
            String Dodurl = (String)attach.get("url");
            String fileName = (String)attach.get("name");
            DynamicObject giftamountss = BusinessDataServiceHelper.loadSingle((String)sourcebillform, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)fsourcebillid)});
            DynamicObjectCollection tpv_attachmentpanelentitys = giftamountss.getDynamicObjectCollection("tpv_attachmentpanelentity");
            for (DynamicObject tpv_attachmentpanelentity : tpv_attachmentpanelentitys) {
                if (tpv_attachmentpanelentity.getDynamicObject("tpv_attachmenttype") != null && StringUtils.isNotEmpty((String)tpv_attachmentpanelentity.getDynamicObject("tpv_attachmenttype").getString("number")) && StringUtils.isNotEmpty((String)tpv_attachmentpanelentity.getString("tpv_attachmentname")) && fileName.equals(tpv_attachmentpanelentity.getString("tpv_attachmentname")) && "A".equals(giftamountss.getString("tpv_straighthair"))) {
                    DynamicObject tpv_attachmenttype = tpv_attachmentpanelentity.getDynamicObject("tpv_attachmenttype");
                    tpv_attachmenttype = BusinessDataServiceHelper.loadSingle((Object)tpv_attachmenttype.getPkValue(), (String)tpv_attachmenttype.getDynamicObjectType().getName());
                    int i = 0;
                    if (tpv_attachmenttype.getBoolean("tpv_straight")) {
                        DynamicObjectCollection tpv_atts = bill.getDynamicObjectCollection("tpv_attachmentpanelentity");
                        DynamicObject entry = new DynamicObject(tpv_atts.getDynamicObjectType());
                        entry.set("seq", (Object)i);
                        ++i;
                        entry.set("tpv_attachmentuid", (Object)tpv_attachmentpanelentity.getString("tpv_attachmentuid"));
                        entry.set("tpv_attachmenturl", (Object)tpv_attachmentpanelentity.getString("tpv_attachmenturl"));
                        entry.set("tpv_attachmentname", (Object)tpv_attachmentpanelentity.getString("tpv_attachmentname"));
                        entry.set("tpv_attachmenttype", (Object)tpv_attachmentpanelentity.getDynamicObject("tpv_attachmenttype"));
                        entry.set("tpv_uploaddatetime", (Object)tpv_attachmentpanelentity.getDate("tpv_uploaddatetime"));
                        entry.set("tpv_uploadedby", (Object)tpv_attachmentpanelentity.getString("tpv_uploadedby"));
                        entry.set("tpv_attachmentdes", (Object)tpv_attachmentpanelentity.getString("tpv_attachmentdes"));
                        entry.set("tpv_attachment_fjdl", (Object)tpv_attachmentpanelentity.getString("tpv_attachment_fjdl"));
                        entry.set("tpv_attachment_fjzl", (Object)tpv_attachmentpanelentity.getString("tpv_attachment_fjzl"));
                        entry.set("tpv_ispaper", (Object)tpv_attachmentpanelentity.getString("tpv_ispaper"));
                        tpv_atts.add((Object)entry);
                        FileService service = FileServiceFactory.getAttachmentFileService();
                        InputStream in = service.getInputStream(Dodurl);
                        String tenantId = RequestContext.get().getTenantId();
                        String accountId = RequestContext.get().getAccountId();
                        String uuid = UUID.randomUUID().toString().replace("-", "");
                        String path = FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (String)appId, (String)formId, (Object)CommonUtils.replaceSpeChar(String.valueOf(pkId)), (String)(uuid + "/" + CommonUtils.replaceSpeSymbol(fileName)));
                        FileItem fileItem = new FileItem(fileName, path, in);
                        fileItem.setCreateNewFileWhenExists(true);
                        String turl = service.upload(fileItem);
                        ORM orm = ORM.create();
                        DynamicObject dynamicObject = orm.newDynamicObject("bos_attachment");
                        Long id = orm.genLongId("bos_attachment");
                        dynamicObject.set("id", (Object)id);
                        dynamicObject.set("FNUMBER", attach.get("uid"));
                        dynamicObject.set("FBillType", (Object)formId);
                        dynamicObject.set("FInterID", pkId);
                        dynamicObject.set("FModifyTime", (Object)new Date());
                        dynamicObject.set("fcreatetime", (Object)new Date());
                        dynamicObject.set("FaliasFileName", (Object)fileName);
                        dynamicObject.set("FAttachmentName", (Object)fileName);
                        dynamicObject.set("FExtName", (Object)(fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : ""));
                        dynamicObject.set("FATTACHMENTSIZE", attach.get("size"));
                        dynamicObject.set("FFileId", (Object)turl);
                        dynamicObject.set("FCREATEMEN", (Object)RequestContext.get().getUserId());
                        dynamicObject.set("FMODIFYMEN", (Object)RequestContext.get().getUserId());
                        dynamicObject.set("fattachmentpanel", (Object)attachKey);
                        dynamicObject.set("fbillstatus", (Object)"1");
                        orm.insert(dynamicObject);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            }
        }
    }

    public static String botpAttachmentpanel3(DynamicObject bill, String attachKey, Long fsourcebillid, String sourcebillform, String appId) {
        QFilter qFilter3;
        QFilter qFilter2;
        String msg = "";
        Object pkId = bill.getPkValue();
        if ((Long)pkId == 0L) {
            msg = "\u5355\u636e\u5185\u7801\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01";
            return msg;
        }
        String billtype = bill.getDataEntityType().getName();
        QFilter qFilter1 = new QFilter("tpv_relatedbill.number", "=", (Object)billtype);
        DynamicObject attachmenttype = BusinessDataServiceHelper.loadSingle((String)"tpv_bd_attachmenttype", (QFilter[])new QFilter[]{qFilter1, qFilter2 = new QFilter("tpv_default", "=", (Object)true), qFilter3 = new QFilter("enable", "=", (Object)"1")});
        if (null == attachmenttype) {
            msg = "\u5355\u636e\u9ed8\u8ba4\u9644\u4ef6\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01";
            return msg;
        }
        DynamicObjectCollection tpv_atts = bill.getDynamicObjectCollection("tpv_attachmentpanelentity");
        int i = 0;
        String formId = bill.getDataEntityType().getName();
        List listMapAttachments = AttachmentServiceHelper.getAttachmentsByExport((String)sourcebillform, (Object)fsourcebillid);
        for (Map attach : listMapAttachments) {
            String Dodurl = (String)attach.get("url");
            String fileName = (String)attach.get("name");
            DynamicObject bill_src = BusinessDataServiceHelper.loadSingle((String)sourcebillform, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)fsourcebillid)});
            DynamicObjectCollection tpv_attachmentpanelentitys = bill_src.getDynamicObjectCollection("tpv_attachmentpanelentity");
            DynamicObject tpv_attachmentpanelentity = (DynamicObject)tpv_attachmentpanelentitys.get(i);
            DynamicObject entry = new DynamicObject(tpv_atts.getDynamicObjectType());
            entry.set("seq", (Object)i);
            entry.set("tpv_attachmentuid", (Object)tpv_attachmentpanelentity.getString("tpv_attachmentuid"));
            entry.set("tpv_attachmenturl", (Object)tpv_attachmentpanelentity.getString("tpv_attachmenturl"));
            entry.set("tpv_attachmentname", (Object)tpv_attachmentpanelentity.getString("tpv_attachmentname"));
            entry.set("tpv_attachmenttype", (Object)attachmenttype);
            entry.set("tpv_uploaddatetime", (Object)tpv_attachmentpanelentity.getDate("tpv_uploaddatetime"));
            entry.set("tpv_uploadedby", (Object)tpv_attachmentpanelentity.getString("tpv_uploadedby"));
            entry.set("tpv_attachmentdes", (Object)tpv_attachmentpanelentity.getString("tpv_attachmentdes"));
            entry.set("tpv_attachment_fjdl", (Object)attachmenttype.getDynamicObject("tpv_attachment_fjdl"));
            entry.set("tpv_attachment_fjzl", (Object)attachmenttype.getDynamicObject("tpv_attachment_fjzl"));
            entry.set("tpv_ispaper", (Object)attachmenttype.getBoolean("tpv_ispaper"));
            tpv_atts.add((Object)entry);
            FileService service = FileServiceFactory.getAttachmentFileService();
            InputStream in = service.getInputStream(Dodurl);
            String tenantId = RequestContext.get().getTenantId();
            String accountId = RequestContext.get().getAccountId();
            String uuid = UUID.randomUUID().toString().replace("-", "");
            String path = FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (String)appId, (String)formId, (Object)CommonUtils.replaceSpeChar(String.valueOf(pkId)), (String)(uuid + "/" + CommonUtils.replaceSpeSymbol(fileName)));
            FileItem fileItem = new FileItem(fileName, path, in);
            fileItem.setCreateNewFileWhenExists(true);
            String turl = service.upload(fileItem);
            ORM orm = ORM.create();
            DynamicObject dynamicObject = orm.newDynamicObject("bos_attachment");
            Long id = orm.genLongId("bos_attachment");
            dynamicObject.set("id", (Object)id);
            dynamicObject.set("FNUMBER", attach.get("uid"));
            dynamicObject.set("FBillType", (Object)formId);
            dynamicObject.set("FInterID", pkId);
            dynamicObject.set("FModifyTime", (Object)new Date());
            dynamicObject.set("fcreatetime", (Object)new Date());
            dynamicObject.set("FaliasFileName", (Object)fileName);
            dynamicObject.set("FAttachmentName", (Object)fileName);
            dynamicObject.set("FExtName", (Object)(fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : ""));
            dynamicObject.set("FATTACHMENTSIZE", attach.get("size"));
            dynamicObject.set("FFileId", (Object)turl);
            dynamicObject.set("FCREATEMEN", (Object)RequestContext.get().getUserId());
            dynamicObject.set("FMODIFYMEN", (Object)RequestContext.get().getUserId());
            dynamicObject.set("fattachmentpanel", (Object)attachKey);
            dynamicObject.set("fbillstatus", (Object)"1");
            orm.insert(dynamicObject);
            ++i;
        }
        bill.set("tpv_attachmentcount", (Object)i);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
        return msg;
    }

    private static void botpAttachmentpanel1(DynamicObject bill, String attachKey, Long fsourcebillid, String sourcebillform, String appId, String Targetbillform) {
        List listold = AttachmentServiceHelper.getAttachmentsByExport((String)sourcebillform, (Object)fsourcebillid);
        ArrayList<Map> listnew = new ArrayList<Map>();
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        ArrayList<FileItem> fileItemList = new ArrayList<FileItem>(10);
        for (Map obj : listold) {
            String path = (String)obj.get("url");
            String fileName = (String)obj.get("name");
            RequestContext requestContext = RequestContext.get();
            String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)"botpUpload", (String)fileName);
            FileItem item = new FileItem(fileName, pathParam, fileService.getInputStream(path));
            fileItemList.add(item);
            obj.put("lastModified", null);
            obj.put("url", pathParam);
            listnew.add(obj);
        }
        FileItem[] fileItems = fileItemList.toArray(new FileItem[fileItemList.size()]);
        fileService.upload(fileItems);
        AttachmentServiceHelper.upload((String)Targetbillform, (Object)bill.getPkValue(), (String)"attachmentpanel", listnew);
    }

    private static String replaceSpeSymbol(String str) {
        for (int i = 0; i < SPECIAL_SYMBOLS.length; ++i) {
            if (!str.contains(SPECIAL_SYMBOLS[i])) continue;
            str = str.replace(SPECIAL_SYMBOLS[i], "_");
        }
        return str;
    }

    private static String replaceSpeChar(String str) {
        for (int i = 0; i < SPECIAL_CHARACTERS.length; ++i) {
            if (!str.contains(SPECIAL_CHARACTERS[i])) continue;
            str = str.replace(SPECIAL_CHARACTERS[i], "");
        }
        return str;
    }

    public static void GetUserDepInfo(IDataModel model) {
        long userId = UserServiceHelper.getCurrentUserId();
        QFilter qFilter1 = new QFilter("operatorid", "=", (Object)userId);
        DynamicObject[] puroperators = BusinessDataServiceHelper.load((String)"bd_operator", (String)"id,operatornumber,operatorname", (QFilter[])new QFilter[]{qFilter1});
        if (puroperators != null && puroperators.length > 0) {
            DynamicObject puroperator = puroperators[0];
            model.setValue("tpv_operator", (Object)puroperator);
            puroperator = BusinessDataServiceHelper.loadSingleFromCache((Object)puroperator.getPkValue(), (String)"bd_operator");
            model.setValue("tpv_department", puroperator.get("operatorgrpid"));
            DynamicObject operatorid = (DynamicObject)puroperator.get("operatorid");
            operatorid = BusinessDataServiceHelper.loadSingleFromCache((Object)operatorid.getPkValue(), (String)"bos_user");
            DynamicObjectCollection entryentitys = operatorid.getDynamicObjectCollection("entryentity");
            if (entryentitys != null && entryentitys.size() == 1) {
                DynamicObject entryentity = (DynamicObject)entryentitys.get(0);
                DynamicObject purdep = (DynamicObject)model.getValue("tpv_department");
                if (purdep == null) {
                    model.setValue("tpv_department", entryentity.get("dpt"));
                }
            }
        }
    }

    public static void beforeMaterialSelect(BeforeF7SelectEvent e, DynamicObject materialgroup) {
        if (null != materialgroup) {
            ArrayList<Object> ids = new ArrayList<Object>();
            QFilter qFilter1 = new QFilter("group.id", "=", materialgroup.getPkValue());
            DynamicObject[] groups = BusinessDataServiceHelper.load((String)"bd_materialgroupdetail", (String)"standard,group,material", (QFilter[])new QFilter[]{qFilter1});
            for (int i = 0; i < groups.length; ++i) {
                DynamicObject material = (DynamicObject)groups[i].get("material");
                ids.add(material.getPkValue());
            }
            QFilter qFilter = new QFilter("id", "in", ids);
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public static void beforeMetalcoefficientSelect(BeforeF7SelectEvent e, DynamicObject tpv_material, String tpv_tradetype) {
        if (null != tpv_material) {
            ArrayList<Object> ids = new ArrayList<Object>();
            QFilter qFilter1 = new QFilter("enable", "=", (Object)"1");
            QFilter qFilter2 = new QFilter("status", "=", (Object)"C");
            QFilter qFilter3 = new QFilter("tpv_material", "=", tpv_material.getPkValue());
            QFilter qFilter4 = new QFilter("tpv_tradetype", "=", (Object)tpv_tradetype);
            DynamicObject[] tpv_bd_metalcoefficient_s = BusinessDataServiceHelper.load((String)"tpv_bd_metalcoefficient", (String)"id,name,number", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3, qFilter4}, null);
            for (int i = 0; i < tpv_bd_metalcoefficient_s.length; ++i) {
                ids.add(tpv_bd_metalcoefficient_s[i].getPkValue());
            }
            QFilter qFilter = new QFilter("id", "in", ids);
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public static BigDecimal getUnitRateConv(DynamicObject material, DynamicObject srcUnit, DynamicObject desUnit) {
        BigDecimal unitRate = null;
        if (material == null || srcUnit == null || desUnit == null) {
            unitRate = BigDecimal.ZERO;
        } else {
            long desUnitId;
            long materialId = material.getLong("id");
            long srcUnitId = srcUnit.getLong("id");
            if (srcUnitId == (desUnitId = desUnit.getLong("id"))) {
                unitRate = BigDecimal.ONE;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
                if (muConv != null && muConv.getInt("numerator") != 0) {
                    unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), 10, RoundingMode.HALF_UP);
                }
            }
        }
        if (unitRate == null) {
            unitRate = BigDecimal.ZERO;
        }
        return unitRate;
    }

    public static BigDecimal getMeasureUnitConv(long srcUnitId, long desUnitId) {
        BigDecimal unitRate = null;
        if (srcUnitId == desUnitId) {
            unitRate = BigDecimal.ONE;
        } else {
            QFilter qFilter4;
            QFilter qFilter1 = new QFilter("enable", "=", (Object)"1");
            QFilter qFilter2 = new QFilter("status", "=", (Object)"C");
            QFilter qFilter3 = new QFilter("tpv_srcmuid", "=", (Object)srcUnitId).and(new QFilter("tpv_desmuid", "=", (Object)desUnitId));
            QFilter qFilter5 = qFilter3.or(qFilter4 = new QFilter("tpv_srcmuid", "=", (Object)desUnitId).and(new QFilter("tpv_desmuid", "=", (Object)srcUnitId)));
            DynamicObject[] tpv_measureunitconv_s = BusinessDataServiceHelper.load((String)"tpv_measureunitconv", (String)"id,name,number,tpv_srcmuid,tpv_desmuid,tpv_numerator", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter5}, null);
            if (null != tpv_measureunitconv_s && tpv_measureunitconv_s.length > 0) {
                DynamicObject tpv_measureunitconv = tpv_measureunitconv_s[0];
                DynamicObject tpv_srcmuid = tpv_measureunitconv.getDynamicObject("tpv_srcmuid");
                long tpv_srcmuid_id = tpv_srcmuid.getLong("id");
                DynamicObject tpv_desmuid = tpv_measureunitconv.getDynamicObject("tpv_desmuid");
                long tpv_desmuid_id = tpv_desmuid.getLong("id");
                BigDecimal tpv_numerator = tpv_measureunitconv.getBigDecimal("tpv_numerator");
                if (tpv_srcmuid_id == srcUnitId && tpv_desmuid_id == desUnitId) {
                    unitRate = tpv_numerator;
                } else if (tpv_srcmuid_id == desUnitId && tpv_desmuid_id == srcUnitId) {
                    unitRate = BigDecimalUtils.div((BigDecimal)BigDecimal.ONE, (BigDecimal)tpv_numerator, (int)4);
                }
            }
        }
        return unitRate;
    }

    public static void GetFormShowParameter(IFormView view, IDataModel model, String billtype, String tpv_purorderno, String tpv_arrivalbill, String hispricinginfo) {
        FormShowParameter bsp = new FormShowParameter();
        bsp.setStatus(OperationStatus.ADDNEW);
        bsp.getOpenStyle().setShowType(ShowType.Modal);
        Map<String, Object> entryInfo = CommonUtils.Gethistorpriced(model, billtype, tpv_purorderno, tpv_arrivalbill);
        bsp.setCustomParams(entryInfo);
        bsp.setFormId("tpv_historicalpricing");
        view.showForm(bsp);
    }

    public static Map<String, Object> Gethistorpriced(IDataModel model, String billtype, String orderno, String arrandsubbill) {
        HashMap<String, Object> parm = new HashMap<String, Object>();
        ArrayList<Object> parmlist = new ArrayList<Object>();
        if (billtype.equals("tpv_pricelist_Pur")) {
            QFilter qFilterarr1 = new QFilter("tpv_purorderno", "=", (Object)orderno);
            QFilter qFilterarr4 = new QFilter("id", "!=", model.getValue("id"));
            List queryFields = CommonUtils.getQuerypricelistBill();
            String selectStr = String.join((CharSequence)",", queryFields);
            DynamicObject[] pricelistBillColl = BusinessDataServiceHelper.load((String)"tpv_pricelist", (String)selectStr, (QFilter[])new QFilter[]{qFilterarr1, qFilterarr4});
            if (null != pricelistBillColl && pricelistBillColl.length > 0) {
                for (DynamicObject pricelistBill : pricelistBillColl) {
                    parmlist.add(pricelistBill.getPkValue());
                }
                parm.put("hispricelistID", parmlist);
            }
        } else {
            QFilter qFilterarr1 = new QFilter("tpv_salorderno", "=", (Object)orderno);
            QFilter qFilterarr2 = new QFilter("tpv_submitbill", "=", (Object)arrandsubbill);
            QFilter qFilterarr4 = new QFilter("id", "!=", model.getValue("id"));
            List queryFields = CommonUtils.getQuerypricelistBill();
            String selectStr = String.join((CharSequence)",", queryFields);
            DynamicObject[] pricelistBillColl = BusinessDataServiceHelper.load((String)"tpv_pricelist", (String)selectStr, (QFilter[])new QFilter[]{qFilterarr1, qFilterarr4});
            if (null != pricelistBillColl && pricelistBillColl.length > 0) {
                for (DynamicObject pricelistBill : pricelistBillColl) {
                    parmlist.add(pricelistBill.getPkValue());
                }
                parm.put("hispricelistID", parmlist);
            }
        }
        return parm;
    }

    public static List getQuerypricelistBill() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("billno");
        fields.add("tpv_purorderno");
        fields.add("tpv_arrivalbill");
        fields.add("tpv_salorderno");
        fields.add("tpv_submitbill");
        fields.add("tpv_operatmetal");
        fields.add("tpv_operatmetalunit");
        fields.add("tpv_pointdate");
        fields.add("tpv_operatprice");
        fields.add("tpv_srcentryid");
        fields.add("tpv_srcsubbillid");
        fields.add("tpv_currpricingqty");
        return fields;
    }

    public static String getFrontPath(DynamicObject bill) {
        String path = bill.getDynamicObject("org").getString("name");
        long id = bill.getLong("id");
        QFilter qFilter = new QFilter("tpv_orderid_s", "=", (Object)id);
        DynamicObject[] tpv_purpinmatbottable_s = BusinessDataServiceHelper.load((String)"tpv_purpinmatbottable", (String)"id,billno,billstatus,tpv_orderid_s,tpv_orderid_p", (QFilter[])new QFilter[]{qFilter});
        if (null != tpv_purpinmatbottable_s && tpv_purpinmatbottable_s.length > 0) {
            for (int i = 0; i < tpv_purpinmatbottable_s.length; ++i) {
                DynamicObject tpv_purpinmatbottable = tpv_purpinmatbottable_s[i];
                long tpv_orderid_p = tpv_purpinmatbottable.getLong("tpv_orderid_p");
                DynamicObject tpv_purchaseorder = BusinessDataServiceHelper.loadSingle((Object)tpv_orderid_p, (String)"tpv_purchaseorder");
                long tpv_saleorderid = tpv_purchaseorder.getLong("tpv_saleorderid");
                if (tpv_saleorderid != 0L) {
                    DynamicObject tpv_salesorder = BusinessDataServiceHelper.loadSingle((Object)tpv_saleorderid, (String)"tpv_salesorder");
                    path = CommonUtils.getFrontPath(tpv_salesorder) + "\u2192" + path;
                    continue;
                }
                String str = "(\u4f9b\u5e94\u5546)";
                String supplier = tpv_purchaseorder.getDynamicObject("tpv_cus_supplier").getString("name");
                path = path.length() > 5 && path.substring(0, 5).equals(str) ? str + supplier + ";" + path : str + supplier + "\u2192" + path;
            }
        }
        return path;
    }

    public static DynamicObject getDepByUser() {
        long userId = UserServiceHelper.getCurrentUserId();
        DynamicObject bos_user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
        DynamicObjectCollection entryentitys = bos_user.getDynamicObjectCollection("entryentity");
        if (entryentitys != null && entryentitys.size() == 1) {
            DynamicObject entryentity = (DynamicObject)entryentitys.get(0);
            DynamicObject purdep = entryentity.getDynamicObject("dpt");
            return purdep;
        }
        return null;
    }

    public static DynamicObject getExpenseItem(String number) {
        DynamicObject[] dynamicObjectArray;
        int n;
        int n2;
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        DynamicObject[] er_expenseitemeditCol = BusinessDataServiceHelper.load((String)"er_expenseitemedit", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter});
        if (null != er_expenseitemeditCol && er_expenseitemeditCol.length > 0 && (n2 = 0) < (n = (dynamicObjectArray = er_expenseitemeditCol).length)) {
            DynamicObject er_expenseitemedit = dynamicObjectArray[n2];
            return er_expenseitemedit;
        }
        return null;
    }

    public static DynamicObject getTaxRate(String taxcategoryname, BigDecimal Rate) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter1 = new QFilter("taxrate", "=", (Object)Rate);
        QFilter qFilter2 = new QFilter("taxcategoryid.name", "=", (Object)taxcategoryname);
        DynamicObject[] bd_taxrateCol = BusinessDataServiceHelper.load((String)"bd_taxrate", (String)"id,number,name,issystem,taxrate,taxcategoryid.name", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2});
        DynamicObject bd_taxrateN = null;
        DynamicObject[] dynamicObjectArray = bd_taxrateCol;
        int n = dynamicObjectArray.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject bd_taxrate;
            bd_taxrateN = bd_taxrate = dynamicObjectArray[i];
            if (!bd_taxrate.getBoolean("issystem")) continue;
            return bd_taxrateN;
        }
        return bd_taxrateN;
    }

    public static DynamicObject getViewparent(DynamicObject bos_org) {
        if (bos_org != null) {
            bos_org = BusinessDataServiceHelper.loadSingle((Object)bos_org.getLong("id"), (String)"bos_org");
            DynamicObjectCollection structureCol = bos_org.getDynamicObjectCollection("structure");
            for (DynamicObject structure : structureCol) {
                DynamicObject view = structure.getDynamicObject("view");
                DynamicObject viewparent = structure.getDynamicObject("viewparent");
                if (!"15".equals(view.getString("number"))) continue;
                return viewparent;
            }
        }
        return null;
    }

    public static DynamicObject getOperatorGroup(DynamicObject org, DynamicObject tpv_material, DynamicObject tpv_natureoftrade, String tpv_bizstyles, DynamicObject creator) {
        if (org != null && tpv_material != null && tpv_natureoftrade != null) {
            DynamicObject[] bd_operatorgroupCol;
            QFilter qFilter = new QFilter("createorg.id", "in", (Object)org.getLong("id"));
            QFilter qFilter1 = new QFilter("tpv_natureoftrade.fbasedataid", "in", (Object)tpv_natureoftrade.getLong("id"));
            QFilter qFilter2 = new QFilter("tpv_material.fbasedataid", "in", (Object)tpv_material.getLong("id"));
            if (StringUtils.isNotEmpty((String)tpv_bizstyles)) {
                if (tpv_bizstyles.equals("C")) {
                    tpv_bizstyles = "A";
                }
                QFilter qFilter3 = new QFilter("tpv_bizstyles", "like", (Object)("%" + tpv_bizstyles + "%"));
                qFilter = qFilter.and(qFilter3);
            }
            if ((bd_operatorgroupCol = BusinessDataServiceHelper.load((String)"bd_operatorgroup", (String)"id,number,name ", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2})).length == 1) {
                DynamicObject bd_operatorgroup = bd_operatorgroupCol[0];
                bd_operatorgroup = BusinessDataServiceHelper.loadSingle((Object)bd_operatorgroup.getPkValue(), (String)"bd_operatorgroup");
                return bd_operatorgroup;
            }
            if (bd_operatorgroupCol.length > 1 && creator != null) {
                for (DynamicObject bd_operatorgroup : bd_operatorgroupCol) {
                    bd_operatorgroup = BusinessDataServiceHelper.loadSingle((Object)bd_operatorgroup.getPkValue(), (String)"bd_operatorgroup");
                    DynamicObjectCollection operatorgroupentryCol = bd_operatorgroup.getDynamicObjectCollection("entryentity");
                    for (DynamicObject operatorgroupentry : operatorgroupentryCol) {
                        DynamicObject operator = operatorgroupentry.getDynamicObject("operator");
                        if (operator == null || creator.getLong("id") != operator.getLong("id")) continue;
                        return bd_operatorgroup;
                    }
                }
            }
        }
        return null;
    }
}

