/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.customs.api.utils;

import com.alibaba.fastjson.JSONObject;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static final CloseableHttpClient httpClient = HttpClients.createDefault();
    private String url;
    private String method = "GET";
    private Map<String, String> headers = new HashMap<String, String>();
    private String body;
    private Map<String, String> queris = new HashMap<String, String>();
    private String contentType = "application/json;charset=utf-8";

    public static HttpUtil create() {
        return new HttpUtil();
    }

    public HttpUtil url(String url) {
        this.url = url;
        return this;
    }

    public HttpUtil post() {
        this.method = "POST";
        return this;
    }

    public HttpUtil headers(Map<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public HttpUtil header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public HttpUtil token(String token) {
        this.headers.put("Authorization", "Bearer " + token);
        return this;
    }

    public HttpUtil body(String body) {
        this.body = body;
        return this;
    }

    public HttpUtil body(JSONObject body) {
        this.body = body.toJSONString();
        return this;
    }

    public HttpUtil query(String k, String v) {
        this.queris.put(k, v);
        return this;
    }

    public HttpUtil contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String execute() throws Exception {
        HttpGet request;
        String requestUrl = this.url;
        if (this.queris != null && !this.queris.isEmpty()) {
            String queryString = this.toQueryString(this.queris);
            requestUrl = requestUrl.contains("?") ? requestUrl + "&" + queryString : requestUrl + "?" + queryString;
        }
        if ("POST".equalsIgnoreCase(this.method)) {
            HttpPost post = new HttpPost(requestUrl);
            if (this.body != null) {
                StringEntity stringEntity = new StringEntity(this.body, StandardCharsets.UTF_8);
                post.setEntity((HttpEntity)stringEntity);
            }
            request = post;
        } else {
            request = new HttpGet(requestUrl);
        }
        if (this.contentType == null || this.contentType.isEmpty()) {
            this.contentType = "application/json;charset=utf-8";
        }
        this.headers.putIfAbsent("Content-Type", this.contentType);
        for (Map.Entry entry : this.headers.entrySet()) {
            request.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        Throwable throwable = null;
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
    }

    private String toQueryString(Map<String, String> queryParams) {
        return queryParams.entrySet().stream().map(entry -> this.encode((String)entry.getKey()) + "=" + this.encode((String)entry.getValue())).collect(Collectors.joining("&"));
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (Exception e) {
            throw new RuntimeException("URL encoding failed", e);
        }
    }
}

