/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.customs.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import yem.base.common.utils.YEM;
import yem.wm.customs.common.utils.FileUtil;

public class AttachmentUtil
extends FileUtil {
    public AttachmentUtil(String formId) {
        super(formId);
    }

    public static DynamicObject uploadAttachment(String appId, String formId, String pkId, String attachmentKey, String fileName, String filePath) throws IOException {
        Date today = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
        String NewDateStr = df.format(today);
        String attachmentPath = "/" + RequestContext.get().getTenantId() + "/" + RequestContext.get().getAccountId() + "/" + NewDateStr + "/" + appId + "/" + formId + "/" + pkId + "/attachments/";
        DynamicObject newAtt = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
        File file = new File(filePath);
        if (file.isFile()) {
            int size = new FileInputStream(file).available();
            FileService fs = FileServiceFactory.getAttachmentFileService();
            String path = attachmentPath + fileName;
            FileItem fi = new FileItem(fileName, path, (InputStream)new FileInputStream(file.getPath()));
            fi.setCreateNewFileWhenExists(true);
            String url = fs.upload(fi);
            if (url != null && !"".equals(url)) {
                newAtt.set("fnumber", (Object)("upload_" + formId));
                newAtt.set("FBillType", (Object)formId);
                newAtt.set("FInterID", (Object)pkId);
                newAtt.set("FModifyTime", (Object)today);
                newAtt.set("fcreatetime", (Object)today);
                newAtt.set("FaliasFileName", (Object)fileName);
                newAtt.set("FAttachmentName", (Object)fileName);
                newAtt.set("FFileId", (Object)url);
                newAtt.set("FExtName", (Object)(fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : ""));
                newAtt.set("FATTACHMENTSIZE", (Object)size);
                newAtt.set("FCREATEMEN", (Object)RequestContext.get().getCurrUserId());
                newAtt.set("fattachmentpanel", (Object)attachmentKey);
                newAtt.set("fdescription", (Object)"");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newAtt});
            } else {
                new Exception("\u9644\u4ef6\u3010" + fileName + "\u3011\u4e0a\u4f20\u5931\u8d25\uff01");
            }
        }
        return newAtt;
    }

    /*
     * WARNING - void declaration
     */
    public static void uploadAttachmentPanel(DynamicObject from, DynamicObject to) {
        String selectProp = "id,fnumber,fmodifytime,fcreatetime,faliasfilename,fattachmentname,ffileid,fextname,fattachmentsize,fcreatemen,fattachmentpanel,fdescription";
        DynamicObject[] Attachments = BusinessDataServiceHelper.load((String)"bos_attachment", (String)selectProp, (QFilter[])new QFilter[]{new QFilter("FInterID", "=", (Object)String.valueOf(from.getLong("id"))), new QFilter("fbilltype", "=", (Object)from.getDataEntityType().getName())});
        DynamicObject[] toAttachments = BusinessDataServiceHelper.load((String)"bos_attachment", (String)selectProp, (QFilter[])new QFilter[]{new QFilter("FInterID", "=", (Object)String.valueOf(to.getLong("id"))), new QFilter("fbilltype", "=", (Object)to.getDataEntityType().getName())});
        AttachmentUtil.CreateLogBill(from, to, Attachments, toAttachments);
        if (toAttachments != null && !YEM.isEmpty((Object)toAttachments)) {
            void var6_7;
            ArrayList<Object> attIds = new ArrayList<Object>();
            DynamicObjectType dynamicObjectType = new DynamicObjectType();
            DynamicObject[] dynamicObjectArray = toAttachments;
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject toAttachment = dynamicObjectArray[i];
                DynamicObjectType dynamicObjectType2 = toAttachment.getDynamicObjectType();
                attIds.add(toAttachment.getPkValue());
            }
            DeleteServiceHelper.delete((IDataEntityType)var6_7, (Object[])attIds.toArray());
        }
        JSONObject json = new JSONObject();
        if (to.getDataEntityType().getProperties().containsKey((Object)"yem_attachmentcon")) {
            String string = to.getString("yem_attachmentcon_tag");
            json = YEM.isEmpty((Object)string) ? null : JSONObject.parseObject((String)string);
        }
        for (DynamicObject attach : Attachments) {
            String fileName = (String)attach.get("fattachmentname");
            String fileId = (String)attach.get("fnumber");
            DynamicObject newAtt = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
            Long id = ORM.create().genLongId("bos_attachment");
            newAtt.set("id", (Object)id);
            String newAttUid = "upload_" + id;
            if (json != null) {
                JSONObject innerJson = json.getJSONObject(fileId);
                innerJson.put("uid", (Object)newAttUid);
                Object value = json.remove((Object)fileId);
                json.put(newAttUid, value);
            }
            newAtt.set("fnumber", (Object)newAttUid);
            newAtt.set("FBillType", (Object)to.getDataEntityType().getName());
            newAtt.set("FInterID", (Object)to.getString("id"));
            newAtt.set("FModifyTime", attach.get("fmodifytime"));
            newAtt.set("fcreatetime", attach.get("fcreatetime"));
            newAtt.set("FaliasFileName", (Object)fileName);
            newAtt.set("FAttachmentName", (Object)fileName);
            newAtt.set("FFileId", attach.get("ffileid"));
            newAtt.set("FExtName", attach.get("fextname"));
            newAtt.set("FATTACHMENTSIZE", attach.get("fattachmentsize"));
            newAtt.set("FCREATEMEN", attach.get("fcreatemen"));
            newAtt.set("fattachmentpanel", attach.get("fattachmentpanel"));
            newAtt.set("fdescription", attach.get("fdescription"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newAtt});
        }
        if (json != null) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)to.getDataEntityType().getName(), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)to.getLong("id"))});
            dynamicObject.set("yem_attachmentcon_tag", (Object)json);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public static void CreateLogBill(DynamicObject from, DynamicObject to, DynamicObject[] Attachments, DynamicObject[] toAttachments) {
        DynamicObject logEntity = BusinessDataServiceHelper.newDynamicObject((String)"yem_cm_attachupdatelog");
        String orgName = from.getDataEntityType().getName();
        DynamicObject orgBillObject = BusinessDataServiceHelper.loadSingle((String)"bos_entityobject", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgName)});
        logEntity.set("yem_orghostentity", (Object)orgBillObject);
        logEntity.set("yem_orgbillno", (Object)from.getString("id"));
        String newName = to.getDataEntityType().getName();
        DynamicObject newBillObject = BusinessDataServiceHelper.loadSingle((String)"bos_entityobject", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)newName)});
        logEntity.set("yem_newhostentity", (Object)newBillObject);
        logEntity.set("yem_newbillno", (Object)to.getString("id"));
        logEntity.set("yem_updatedatetime", (Object)new Date());
        logEntity.set("yem_operator", (Object)UserServiceHelper.getCurrentUser((String)"name"));
        DynamicObjectCollection orgEntryentity = logEntity.getDynamicObjectCollection("yem_orgentryentity");
        for (DynamicObject orgAtt : toAttachments) {
            DynamicObject orgNewEntry = orgEntryentity.addNew();
            orgNewEntry.set("yem_orgattachname", orgAtt.get("fattachmentname"));
            orgNewEntry.set("yem_orgattachnumber", orgAtt.get("fnumber"));
            orgNewEntry.set("yem_orgattachurl", orgAtt.get("ffileid"));
            orgNewEntry.set("yem_orgattachid", orgAtt.get("id"));
        }
        DynamicObjectCollection newEntryentity = logEntity.getDynamicObjectCollection("yem_newentryentity");
        for (DynamicObject newAtt : Attachments) {
            DynamicObject newNewEntry = newEntryentity.addNew();
            newNewEntry.set("yem_newattachname", newAtt.get("fattachmentname"));
            newNewEntry.set("yem_newattachnumber", newAtt.get("fnumber"));
            newNewEntry.set("yem_newattachurl", newAtt.get("ffileid"));
            newNewEntry.set("yem_newattachid", newAtt.get("id"));
        }
        OperationResult result = SaveServiceHelper.saveOperate((String)"yem_cm_attachupdatelog", (DynamicObject[])new DynamicObject[]{logEntity}, (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            throw new KDBizException("\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25");
        }
    }

    public static String uploadFileItem(String appId, String formId, String pkId, String fileName, String filePath) throws IOException {
        Date today = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
        String NewDateStr = df.format(today);
        String attachmentPath = "/" + RequestContext.get().getTenantId() + "/" + RequestContext.get().getAccountId() + "/" + NewDateStr + "/" + appId + "/" + formId + "/" + pkId + "/attachments/";
        String url = "";
        File file = new File(filePath);
        if (file.isFile()) {
            FileService fs = FileServiceFactory.getAttachmentFileService();
            String path = attachmentPath + fileName;
            FileItem fi = new FileItem(fileName, path, (InputStream)new FileInputStream(file.getPath()));
            fi.setCreateNewFileWhenExists(true);
            url = fs.upload(fi);
            if (url == null || "".equals(url)) {
                new Exception("\u9644\u4ef6\u3010" + fileName + "\u3011\u4e0a\u4f20\u5931\u8d25\uff01");
            }
        }
        return url;
    }

    public DynamicObject downloadFile2Attachment(String appId, String formId, String pkId, String attachmentKey, String fileName, String downloadUrl) throws IOException {
        return AttachmentUtil.uploadAttachment(appId, formId, pkId, attachmentKey, fileName, this.downloadFile(fileName, downloadUrl));
    }

    public String downloadFile2FileItem(String appId, String formId, String pkId, String fileName, String downloadUrl) throws IOException {
        return AttachmentUtil.uploadFileItem(appId, formId, pkId, fileName, this.downloadFile(fileName, downloadUrl));
    }

    public static DynamicObject uploadAttachmentPanel(String formId, Object pkId, String attachmentKey, String fileName, String url) {
        int size = 0;
        try {
            size = FileServiceFactory.getAttachmentFileService().getInputStream(url).available();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (YEM.isNotEmpty((Object)url)) {
            if (YEM.isEmpty((Object)fileName)) {
                fileName = url.substring(url.lastIndexOf("/") + 1);
            }
            Date today = new Date();
            DynamicObject newAtt = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
            Long id = ORM.create().genLongId("bos_attachment");
            newAtt.set("id", (Object)id);
            newAtt.set("fnumber", (Object)("upload_" + id));
            newAtt.set("FBillType", (Object)formId);
            newAtt.set("FInterID", pkId);
            newAtt.set("FModifyTime", (Object)today);
            newAtt.set("fcreatetime", (Object)today);
            newAtt.set("FaliasFileName", (Object)fileName);
            newAtt.set("FAttachmentName", (Object)fileName);
            newAtt.set("FFileId", (Object)url);
            newAtt.set("FExtName", (Object)fileName.substring(fileName.lastIndexOf(46) + 1));
            newAtt.set("FCREATEMEN", (Object)RequestContext.get().getCurrUserId());
            newAtt.set("fattachmentpanel", (Object)attachmentKey);
            newAtt.set("fdescription", (Object)"");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newAtt});
            return newAtt;
        }
        return null;
    }
}

