/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.customs.common.utils;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import yem.wm.customs.common.utils.FieldSelectHandler;

public class FieldSelectHelper {
    private final FieldSelectHandler handler;

    public FieldSelectHelper(FieldSelectHandler handler) {
        this.handler = handler;
    }

    public void handleSelectBeforeField(String actionId, Object returnData, String middleField, IDataModel model) {
        if (!(returnData instanceof DynamicObjectCollection)) {
            return;
        }
        DynamicObjectCollection collection = (DynamicObjectCollection)returnData;
        if (collection.isEmpty()) {
            return;
        }
        this.handleSingleEntry(model, (DynamicObject)collection.get(0), middleField, actionId);
        for (int i = 1; i < collection.size(); ++i) {
            this.handleNewEntry(model, (DynamicObject)collection.get(i), middleField, actionId);
        }
    }

    public void handleSingleEntry(IDataModel model, DynamicObject dynamicObject, String middleField, String actionId) {
        int idx = model.getEntryCurrentRowIndex(this.handler.getEntryKey());
        this.handler.updateModelValues(model, dynamicObject, middleField, idx, actionId);
    }

    public void handleNewEntry(IDataModel model, DynamicObject dynamicObject, String middleField, String actionId) {
        int idx = model.createNewEntryRow(this.handler.getEntryKey());
        this.handler.updateModelValues(model, dynamicObject, middleField, idx, actionId);
    }

    public void handleClosedCallBack(String actionId, Object returnData, IDataModel model, String middleField) {
        this.handleSelectBeforeField(actionId, returnData, middleField, model);
    }
}

