/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.customs.common.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;

public class FileUtil {
    private static final String[] SPECIAL_SYMBOLS = new String[]{"%", "=", "+", "&"};
    private static boolean isLinux = FileUtil.isOSLinux();
    protected String realePath;
    private String monthStr = FileUtil.getMonthStr();

    public FileUtil(String formId) {
        String uuid = FileUtil.createUUID();
        this.realePath = isLinux ? String.format("/kingdee/tpwm/files/%s/%s/%s/", this.monthStr, formId, uuid) : String.format("C:/kingdee/tpwm/files/%s/%s/%s/", this.monthStr, formId, uuid);
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static boolean createNewFile(File file) throws IOException {
        File fileParent = file.getParentFile();
        if (!fileParent.exists()) {
            fileParent.mkdirs();
        }
        boolean created = file.createNewFile();
        if (isLinux) {
            file.setExecutable(true);
            file.setReadable(true);
            file.setWritable(true);
        }
        return created;
    }

    public static String downloadFile(File file, String downloadUrl) throws IOException {
        URL url = new URL(downloadUrl);
        URLConnection urlConnection = url.openConnection();
        HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
        httpURLConnection.setConnectTimeout(5000);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
        httpURLConnection.setRequestProperty("Charset", "UTF-8");
        httpURLConnection.connect();
        int fileLength = httpURLConnection.getContentLength();
        System.out.println("\u60a8\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6\u5927\u5c0f\u4e3a:" + fileLength / 1024 + "K");
        FileUtil.createNewFile(file);
        InputStream inputStream = httpURLConnection.getInputStream();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedInputStream bin = new BufferedInputStream(inputStream);
        int size = 0;
        byte[] buf = new byte[1024];
        while ((size = bin.read(buf)) != -1) {
            fileOutputStream.write(buf, 0, size);
        }
        bin.close();
        fileOutputStream.close();
        return file.getPath();
    }

    private static boolean isOSLinux() {
        Properties prop = System.getProperties();
        String os = prop.getProperty("os.name");
        return os != null && os.toLowerCase().indexOf("linux") > -1;
    }

    public static String replaceSpeSymbol(String str) {
        for (int i = 0; i < SPECIAL_SYMBOLS.length; ++i) {
            if (!str.contains(SPECIAL_SYMBOLS[i])) continue;
            str = str.replace(SPECIAL_SYMBOLS[i], "_");
        }
        return str;
    }

    public static String createUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String getMonthStr() {
        return new SimpleDateFormat("yyyyMM").format(new Date());
    }

    public File newFile(String fileName) {
        return new File(this.realePath + FileUtil.replaceSpeSymbol(fileName));
    }

    public File createNewFile(String fileName) throws IOException {
        File file = this.newFile(fileName);
        FileUtil.createNewFile(file);
        return file;
    }

    public String downloadFile(String downloadUrl) throws IOException {
        String fileName = FilenameUtils.getName((String)downloadUrl);
        return this.downloadFile(fileName, downloadUrl);
    }

    public String downloadFile(String fileName, String downloadUrl) throws IOException {
        return FileUtil.downloadFile(this.newFile(fileName), downloadUrl);
    }
}

