/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.lg.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.BeforeImportEntryEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.importentry.resolving.ImportEntryData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import yem.base.common.utils.YEM;

public class VehicleUtils {
    public static DynamicObject getVehicle(DynamicObject entity, String carNoField) {
        DynamicObject vehiclecardno = entity.getDynamicObject(carNoField);
        if (vehiclecardno == null) {
            return null;
        }
        DynamicObject carInfo = BusinessDataServiceHelper.loadSingle((Object)vehiclecardno.getPkValue(), (String)"yem_lg_carno");
        if (carInfo == null) {
            return null;
        }
        DynamicObject vehiclearchive = carInfo.getDynamicObject("yem_vehiclearchive");
        if (vehiclearchive == null) {
            return null;
        }
        long vehicleId = vehiclearchive.getLong("id");
        String entityName = vehiclearchive.getDataEntityType().getName();
        if (!Objects.equals(entityName, "yem_lg_vehiclefile")) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((String)entityName, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)vehicleId)});
    }

    public static void quashVehicle(@NotNull DynamicObject[] dataEntities, @NotNull String carNoField, @NotNull String entry, @NotNull String srcIdField) {
        for (DynamicObject entity : dataEntities) {
            DynamicObject vehicle = VehicleUtils.getVehicle(entity, carNoField);
            if (vehicle == null) continue;
            DynamicObjectCollection wxbyglEntry = vehicle.getDynamicObjectCollection(entry);
            List collectEntry = wxbyglEntry.stream().filter(wxbyglRow -> Objects.equals(wxbyglRow.getLong(srcIdField), entity.getLong("id"))).collect(Collectors.toList());
            for (DynamicObject row : collectEntry) {
                wxbyglEntry.remove((Object)row);
            }
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"yem_lg_vehiclefile", (DynamicObject[])new DynamicObject[]{vehicle}, (OperateOption)OperateOption.create());
            if (result.isSuccess()) continue;
            throw new KDBizException("\u64a4\u9500\u53cd\u5199\u8f66\u8f86\u6863\u6848\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }

    public static <ShowParamType extends FormShowParameter, FormPluginType extends AbstractFormPlugin> void dialogBox(String dynamicForm, String actionId, Map<String, Object> map, ShowParamType showParameter, FormPluginType form) {
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId(dynamicForm);
        showParameter.setCustomParams(map);
        showParameter.setCloseCallBack(new CloseCallBack(form, actionId));
        form.getView().showForm(showParameter);
    }

    public static DynamicObject getCarStatus(String status) {
        QFilter filter = new QFilter("name", "=", (Object)status);
        return BusinessDataServiceHelper.loadSingle((String)"yem_lg_carstatus", (QFilter[])new QFilter[]{filter});
    }

    public static Map<Long, JSONObject> getEntryImportData(BeforeImportEntryEventArgs e, String entryName, String sonEntryName) {
        HashMap entryDataMap = (HashMap)e.getSource();
        if (!entryDataMap.containsKey(entryName)) {
            return null;
        }
        List impData = (List)entryDataMap.get(entryName);
        HashMap<Long, JSONObject> resultMap = new HashMap<Long, JSONObject>();
        if (YEM.isEmpty((Object)sonEntryName)) {
            for (Object entryRow : impData) {
                ImportEntryData rowData = (ImportEntryData)entryRow;
                JSONObject entryRowData = rowData.getData();
                resultMap.put(entryRowData.getLong("$matchid$"), entryRowData);
            }
            return resultMap;
        }
        JSONObject entryOneRowData = ((ImportEntryData)impData.get(0)).getData();
        JSONArray sonEntryData = (JSONArray)entryOneRowData.get((Object)sonEntryName);
        for (Object sonEntryRow : sonEntryData) {
            JSONObject sonEntryRowData = (JSONObject)sonEntryRow;
            resultMap.put(sonEntryRowData.getLong("$matchid$"), sonEntryRowData);
        }
        return resultMap;
    }
}

