/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pa.trade.bill.inventorybills.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import yem.base.common.utils.YEM;
import yem.wm.pa.common.utils.MatchInventoryUtils;

public class InventoryBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit yem_inventorynode;
        super.registerListener(e);
        BasedataEdit yem_billtype = (BasedataEdit)this.getView().getControl("yem_nodedoc");
        if (yem_billtype != null) {
            yem_billtype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((yem_inventorynode = (BasedataEdit)this.getView().getControl("yem_inventorynode")) != null) {
            yem_inventorynode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"yem_quantityfield", "yem_entityfieldname", "yem_qentityfieldname", "yem_srcfield", "yem_srcidfield", "yem_srcentityidfield", "yem_mainbillfield", "yem_mainbillidfield", "yem_maientityidfield", "yem_mainbillnofield", "yem_srcbillnofield"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.bindFilterGrid();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.fillEntityCombo();
        this.bindFilterGridData();
        this.updateEntry();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                this.saveFilter(e);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        OperationResult operationResult = e.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            this.bindFilterGridData();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        DynamicObject yemNodedoc = (DynamicObject)this.getView().getModel().getValue("yem_nodedoc");
        this.fieldListAbles(key, yemNodedoc);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        switch (key = e.getProperty().getName()) {
            case "yem_nodedoc": {
                InventoryBillPlugin.nodedocFilter(e);
                break;
            }
            case "yem_inventorynode": {
                InventoryBillPlugin.inventorynodeFilter(e, model, view);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        this.documentHead(name);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        DynamicObjectCollection returnData = (DynamicObjectCollection)e.getReturnData();
        IDataModel model = this.getModel();
        this.returndata(model, actionId, returnData);
    }

    private void updateEntry() {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        DynamicObject group = (DynamicObject)model.getValue("group");
        String filedType = "";
        if (group != null && "CG".equals(group.getString("number"))) {
            filedType = "A";
        }
        if (group != null && "XS".equals(group.getString("number"))) {
            filedType = "B";
        }
        MatchInventoryUtils matchInventoryUtils = new MatchInventoryUtils();
        Map MatchingFields = MatchInventoryUtils.queryMatchingFields((String)filedType);
        Set fields = MatchingFields.keySet();
        DynamicObjectCollection ppwd = model.getEntryEntity("yem_pa_cxppdjpz_ppwd");
        List yemMatchfieldlib = ppwd.stream().filter(x -> x.getDynamicObject("yem_matchfieldlib") != null).collect(Collectors.toList());
        List<Object> collect = new ArrayList();
        if (!yemMatchfieldlib.isEmpty()) {
            collect = yemMatchfieldlib.stream().map(x -> x.getDynamicObject("yem_matchfieldlib").getString("number")).collect(Collectors.toList());
        }
        for (String field : fields) {
            if (collect.contains(field)) continue;
            int newEntryRow = model.createNewEntryRow("yem_pa_cxppdjpz_ppwd");
            DynamicObject object = (DynamicObject)MatchingFields.get(field);
            model.setValue("yem_matchfieldlib", (Object)object, newEntryRow);
        }
    }

    private void fieldListAbles(String key, DynamicObject yemNodedoc) {
        switch (key) {
            case "yem_quantityfield": 
            case "yem_entityfieldname": 
            case "yem_qentityfieldname": 
            case "yem_srcfield": 
            case "yem_srcbillnofield": 
            case "yem_srcidfield": 
            case "yem_srcentityidfield": 
            case "yem_mainbillfield": 
            case "yem_mainbillnofield": 
            case "yem_mainbillidfield": 
            case "yem_maientityidfield": {
                this.openBillFieldListAbles(key, yemNodedoc);
                break;
            }
        }
    }

    private void documentHead(String name) {
        switch (name) {
            case "yem_nodedoc": {
                this.fillEntityCombo();
                this.updateFiltergridAp();
                break;
            }
            case "group": {
                this.groupChangeOp();
                break;
            }
        }
    }

    private void groupChangeOp() {
        IDataModel model = this.getView().getModel();
        model.deleteEntryData("yem_pa_cxppdjpz_ppwd");
        this.updateEntry();
    }

    private void returndata(IDataModel model, String actionId, DynamicObjectCollection returnData) {
        int rowIndexpp = model.getEntryCurrentRowIndex("yem_pa_cxppdjpz_ppwd");
        int rowIndecx = model.getEntryCurrentRowIndex("yem_pa_cxppdjpz_cxsjy");
        switch (actionId) {
            case "yem_quantityfield": 
            case "yem_entityfieldname": 
            case "yem_qentityfieldname": 
            case "yem_srcfield": 
            case "yem_srcbillnofield": 
            case "yem_srcidfield": 
            case "yem_srcentityidfield": 
            case "yem_mainbillfield": 
            case "yem_mainbillnofield": 
            case "yem_mainbillidfield": 
            case "yem_maientityidfield": {
                if (returnData == null) break;
                for (DynamicObject returnDatum : returnData) {
                    if ("yem_quantityfield".equals(actionId)) {
                        model.setValue("yem_quantityfield", (Object)returnDatum.getString("yem_name"));
                        model.setValue("yem_qtyfiledkeys", (Object)returnDatum.getString("yem_number"));
                        continue;
                    }
                    if ("yem_entityfieldname".equals(actionId)) {
                        model.setValue("yem_entityfieldname", (Object)returnDatum.getString("yem_name"), rowIndexpp);
                        model.setValue("yem_entityfieldid", (Object)returnDatum.getString("yem_number"), rowIndexpp);
                        continue;
                    }
                    if ("yem_qentityfieldname".equals(actionId)) {
                        model.setValue("yem_qentityfieldname", (Object)returnDatum.getString("yem_name"), rowIndecx);
                        model.setValue("yem_qentityfieldid", (Object)returnDatum.getString("yem_number"), rowIndecx);
                        continue;
                    }
                    if ("yem_srcfield".equals(actionId)) {
                        model.setValue("yem_srcfield", (Object)returnDatum.getString("yem_name"));
                        model.setValue("yem_srcnum", (Object)returnDatum.getString("yem_number"));
                        continue;
                    }
                    if ("yem_srcidfield".equals(actionId)) {
                        model.setValue("yem_srcidfield", (Object)returnDatum.getString("yem_name"));
                        model.setValue("yem_srcidnum", (Object)returnDatum.getString("yem_number"));
                        continue;
                    }
                    if ("yem_srcentityidfield".equals(actionId)) {
                        model.setValue("yem_srcentityidfield", (Object)returnDatum.getString("yem_name"));
                        model.setValue("yem_srcentityidnum", (Object)returnDatum.getString("yem_number"));
                        continue;
                    }
                    if ("yem_mainbillfield".equals(actionId)) {
                        model.setValue("yem_mainbillfield", (Object)returnDatum.getString("yem_name"));
                        model.setValue("yem_mainbillnum", (Object)returnDatum.getString("yem_number"));
                        continue;
                    }
                    if ("yem_mainbillidfield".equals(actionId)) {
                        model.setValue("yem_mainbillidfield", (Object)returnDatum.getString("yem_name"));
                        model.setValue("yem_mainbillidnum", (Object)returnDatum.getString("yem_number"));
                        continue;
                    }
                    if ("yem_maientityidfield".equals(actionId)) {
                        model.setValue("yem_maientityidfield", (Object)returnDatum.getString("yem_name"));
                        model.setValue("yem_maientityidnum", (Object)returnDatum.getString("yem_number"));
                        continue;
                    }
                    if ("yem_srcbillnofield".equals(actionId)) {
                        model.setValue("yem_srcbillnofield", (Object)returnDatum.getString("yem_name"));
                        model.setValue("yem_srcbillnonum", (Object)returnDatum.getString("yem_number"));
                        continue;
                    }
                    if (!"yem_mainbillnofield".equals(actionId)) continue;
                    model.setValue("yem_mainbillnofield", (Object)returnDatum.getString("yem_name"));
                    model.setValue("yem_mainbillnonum", (Object)returnDatum.getString("yem_number"));
                }
                break;
            }
        }
    }

    private void openBillFieldListAbles(String Backkey, DynamicObject yemNodedoc) {
        if (null == yemNodedoc) {
            this.getView().showErrorNotification("\u8bf7\u5148\u9009\u62e9\u8282\u70b9\u5355\u636e");
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId("yem_pa_fieldselection");
        if ("yem_entityfieldname".equals(Backkey) || "yem_qentityfieldname".equals(Backkey) || "yem_quantityfield".equals(Backkey) || "yem_srcfield".equals(Backkey) || "yem_srcidfield".equals(Backkey) || "yem_srcentityidfield".equals(Backkey) || "yem_mainbillfield".equals(Backkey) || "yem_mainbillidfield".equals(Backkey) || "yem_maientityidfield".equals(Backkey) || "yem_srcbillnofield".equals(Backkey) || "yem_mainbillnofield".equals(Backkey)) {
            DynamicObject yem_billtype = (DynamicObject)this.getView().getModel().getValue("yem_nodedoc");
            String yemMatchentry = (String)this.getView().getModel().getValue("yem_matchentry");
            if (yem_billtype != null && !YEM.isEmpty((Object)yemMatchentry)) {
                fsp.setCustomParam("field", (Object)Backkey);
            } else {
                this.getView().showTipNotification("\u4e1a\u52a1\u5bf9\u8c61\u6216\u5546\u54c1\u5206\u5f55\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\uff01");
                return;
            }
        }
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, Backkey));
        this.getView().showForm(fsp);
    }

    private void fillEntityCombo() {
        DynamicObject entityObj = (DynamicObject)this.getModel().getValue("yem_nodedoc");
        String entityNumber = "";
        if (entityObj != null) {
            entityNumber = entityObj.getString("number");
        }
        ComboEdit entryEditor = (ComboEdit)this.getView().getControl("yem_matchentry");
        if (!entityNumber.isEmpty()) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            List<ComboItem> entryItems = this.buildEntryComboItems(mainType);
            entryEditor.setComboItems(entryItems);
            String yem_matchentry = (String)this.getModel().getValue("yem_matchentry");
            String selectentity = "";
            for (ComboItem comboItem : entryItems) {
                if (!comboItem.getValue().equals(yem_matchentry)) continue;
                selectentity = yem_matchentry;
            }
            this.getModel().setValue("yem_matchentry", (Object)selectentity);
        } else {
            entryEditor.setComboItems(null);
        }
    }

    private List<ComboItem> buildEntryComboItems(MainEntityType mainType) {
        ArrayList<ComboItem> entryItems = new ArrayList<ComboItem>();
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        entryItems.add(blankItem);
        if (mainType != null) {
            Map entitys = mainType.getAllEntities();
            for (EntityType entity : entitys.values()) {
                if (entity instanceof LinkEntryType || !(entity instanceof EntryType) || entity instanceof SubEntryType) continue;
                ComboItem entryItem = new ComboItem();
                entryItem.setValue(entity.getName());
                entryItem.setCaption(entity.getDisplayName());
                entryItems.add(entryItem);
            }
        }
        return entryItems;
    }

    private void updateFiltergridAp() {
        this.bindFilterGrid();
        this.getView().updateView("yem_filtergridap");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("yem_filtergridap");
        filterGrid.SetValue(new FilterCondition());
    }

    private void bindFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("yem_filtergridap");
        DynamicObject yem_nodedoc = (DynamicObject)this.getModel().getValue("yem_nodedoc");
        if (yem_nodedoc != null) {
            filterGrid.setEntityNumber(yem_nodedoc.getString("number"));
        } else {
            filterGrid.setEntityNumber("");
        }
    }

    private void bindFilterGridData() {
        FilterCondition filterCondition;
        String yem_filtergird = this.getModel().getDataEntity().getString("yem_filtergird");
        if (!StringUtils.isBlank((String)yem_filtergird) && (filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)yem_filtergird, FilterCondition.class)) != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("yem_filtergridap");
            filterGrid.SetValue(filterCondition);
        }
    }

    private void saveFilter(BeforeDoOperationEventArgs e) {
        IDataModel model = this.getModel();
        String filterGirdData = this.parseFilterGrid2Json("yem_filtergridap");
        model.setValue("yem_filtergird", (Object)filterGirdData);
    }

    public String parseFilterGrid2Json(String filterGridKey) {
        String filter = "";
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filterGridKey);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        if (filterCondition != null) {
            filter = SerializationUtils.toJsonString((Object)filterCondition);
        }
        return filter;
    }

    private static void nodedocFilter(BeforeF7SelectEvent e) {
        QFilter qFilter = new QFilter("modeltype", "=", (Object)"BillFormModel");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private static void inventorynodeFilter(BeforeF7SelectEvent e, IDataModel model, IFormView view) {
        Object group = model.getValue("group");
        if (group == null) {
            view.showTipNotification("\u8bf7\u586b\u5199\u3010\u5339\u914d\u7aef\u3011\uff01");
            e.setCancel(true);
            return;
        }
        QFilter filter = new QFilter("group.id", "=", (Object)((DynamicObject)group).getLong("id"));
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(filter);
    }
}

