/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pa.common.fieldselection.dynamic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;

public class FieldSelectionFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static List<String> noPropNames = new ArrayList<String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        TreeView treeView = (TreeView)this.getControl("yem_treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search searchap = (Search)this.getControl("yem_searchap");
        searchap.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        this.buildListsFields(view);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                IFormView view = this.getView();
                EntryGrid entry = (EntryGrid)view.getControl("yem_entryentity");
                int[] selectRowIndexs = entry.getSelectRows();
                if (selectRowIndexs.length > 0) {
                    DynamicObjectCollection selectRows = new DynamicObjectCollection();
                    for (int i : selectRowIndexs) {
                        selectRows.add((Object)this.getModel().getEntryRowEntity("yem_entryentity", i));
                    }
                    view.returnDataToParent((Object)selectRows);
                    view.close();
                    break;
                }
                view.showTipNotification("\u672a\u9009\u62e9\u6570\u636e\u3002");
                break;
            }
        }
    }

    public void search(SearchEnterEvent e) {
        String text = e.getText();
        IFormView view = this.getView();
        view.updateView("yem_entryentity");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("yem_entryentity");
        EntryGrid grid = (EntryGrid)view.getControl("yem_entryentity");
        if (StringUtils.isNotEmpty((String)text)) {
            ArrayList<Integer> indexs = new ArrayList<Integer>();
            for (int rowIndex = 0; rowIndex < entryEntity.size(); ++rowIndex) {
                DynamicObject o = (DynamicObject)entryEntity.get(rowIndex);
                if (!o.getString("yem_number").contains(text) && !o.getString("yem_name").contains(text)) continue;
                indexs.add(rowIndex);
            }
            if (indexs.isEmpty()) {
                view.showTipNotification("\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002");
            } else {
                int[] rowIndexes = indexs.stream().mapToInt(Integer::valueOf).toArray();
                grid.setRowBackcolor("#eff3fd", rowIndexes);
                grid.focusCell(rowIndexes[0], "yem_number");
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        IFormView view = this.getView();
        DynamicObject yem_billtype = (DynamicObject)this.getView().getParentView().getModel().getValue("yem_nodedoc");
        String entityKey = "";
        if (yem_billtype != null) {
            entityKey = yem_billtype.getString("number");
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("yem_entryentity");
        entryEntity.clear();
        ArrayList<String> showList = new ArrayList<String>();
        if (nodeId.equals(entityKey)) {
            this.fieldQFilter(null, entryEntity, (IDataEntityType)entityType, false, showList);
        } else {
            if (nodeId.equals("head")) {
                showList.add(entityKey);
            } else {
                showList.add(nodeId);
            }
            this.fieldQFilter(null, entryEntity, (IDataEntityType)entityType, true, showList);
        }
        view.updateView("yem_entryentity");
    }

    private void buildListsFields(IFormView view) {
        DynamicObject yem_billtype = (DynamicObject)this.getView().getParentView().getModel().getValue("yem_nodedoc");
        String entityKey = "";
        if (yem_billtype != null) {
            entityKey = yem_billtype.getString("number");
        }
        if (entityKey != null) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityKey);
            DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("yem_entryentity");
            entryEntity.clear();
            TreeView tree = (TreeView)view.getControl("yem_treeviewap");
            this.fieldQFilter(tree, entryEntity, (IDataEntityType)entityType, false, null);
        }
    }

    private void fieldQFilter(TreeView tree, DynamicObjectCollection entryEntity, IDataEntityType entityType, boolean alone, Collection<String> showKeys) {
        String field;
        String yemMatchentry = (String)this.getView().getParentView().getModel().getValue("yem_matchentry");
        FormShowParameter fsp = this.getView().getFormShowParameter();
        switch (field = (String)fsp.getCustomParam("field")) {
            case "yem_quantityfield": 
            case "yem_qentityfieldname": {
                this.initMetaDataQty(tree, entryEntity, entityType, alone, showKeys, yemMatchentry);
                break;
            }
            case "yem_entityfieldname": {
                this.initMetaData(tree, entryEntity, entityType, alone, showKeys, yemMatchentry);
                break;
            }
            case "yem_srcfield": 
            case "yem_srcbillnofield": 
            case "yem_srcidfield": 
            case "yem_srcentityidfield": 
            case "yem_mainbillfield": 
            case "yem_mainbillnofield": 
            case "yem_mainbillidfield": 
            case "yem_maientityidfield": {
                this.initMetaDataField(tree, entryEntity, entityType, alone, showKeys, yemMatchentry);
                break;
            }
        }
    }

    private void initMetaData(TreeView tree, DynamicObjectCollection entryEntity, IDataEntityType entityType, boolean alone, Collection<String> showKeys, String yemMatchentry) {
        boolean isInit = false;
        String entityKey = entityType.getName();
        if (!alone || alone && showKeys.contains(entityKey)) {
            isInit = true;
        }
        if (tree != null) {
            TreeNode node = new TreeNode("", entityKey, entityType.getDisplayName().getLocaleValue());
            node.setIsOpened(true);
            if (entityType instanceof BillEntityType) {
                node.addChild(new TreeNode(entityKey, "head", "\u5355\u636e\u5934"));
                tree.addNode(node);
            } else if (isInit && entityType instanceof EntryType && yemMatchentry.equals(entityKey)) {
                node.setParentid(entityType.getParent().getName());
                tree.addNode(node);
            }
        }
        ArrayList<IDataEntityType> entryTypes = new ArrayList<IDataEntityType>();
        for (IDataEntityProperty property : entityType.getProperties()) {
            boolean oneDot;
            String number = property.getName();
            String classSimpleName = property.getClass().getSimpleName();
            if (property instanceof EntryProp && !(property instanceof LinkEntryProp)) {
                entryTypes.add(((EntryProp)property).getItemType());
                continue;
            }
            if (!isInit || noPropNames.contains(classSimpleName) && !"id".equals(number)) continue;
            String displayName = property.getDisplayName() != null ? property.getDisplayName().getLocaleValue() : ("id".equals(number) ? "ID" : "");
            String fullnumber = number;
            String fullname = displayName;
            IDataEntityType parent = property.getParent();
            if (yemMatchentry.equals(entityKey)) {
                if (parent instanceof SubEntryType) {
                    IDataEntityType grandParent = parent.getParent();
                    fullnumber = grandParent.getName() + "." + parent.getName() + "." + fullnumber;
                    fullname = grandParent.getDisplayName().getLocaleValue() + "." + parent.getDisplayName().getLocaleValue() + "." + fullname;
                } else if (parent instanceof EntryType) {
                    fullnumber = parent.getName() + "." + fullnumber;
                    fullname = parent.getDisplayName().getLocaleValue() + "." + fullname;
                }
            }
            boolean containsEntry = fullnumber.contains(yemMatchentry);
            int firstDot = fullnumber.indexOf(46);
            boolean zeroDot = firstDot == -1;
            boolean bl = oneDot = firstDot != -1 && firstDot == fullnumber.lastIndexOf(46);
            if ((!containsEntry || !oneDot) && !zeroDot) continue;
            DynamicObject row = entryEntity.addNew();
            row.set("yem_number", (Object)fullnumber);
            row.set("yem_name", (Object)fullname);
            row.set("yem_datatype", (Object)classSimpleName);
        }
        for (IDataEntityType entryType : entryTypes) {
            this.fieldQFilter(tree, entryEntity, entryType, alone, showKeys);
        }
    }

    private void initMetaDataQty(TreeView tree, DynamicObjectCollection entryEntity, IDataEntityType entityType, boolean alone, Collection<String> showKeys, String yemMatchentry) {
        boolean isInit = false;
        String entityKey = entityType.getName();
        if (!alone || alone && showKeys.contains(entityKey)) {
            isInit = true;
        }
        if (tree != null) {
            TreeNode node = new TreeNode("", entityKey, entityType.getDisplayName().getLocaleValue());
            node.setIsOpened(true);
            if (entityType instanceof BillEntityType) {
                tree.addNode(node);
            } else if (isInit && entityType instanceof EntryType && yemMatchentry.equals(entityKey)) {
                node.setParentid(entityType.getParent().getName());
                tree.addNode(node);
            }
        }
        ArrayList<IDataEntityType> entryTypes = new ArrayList<IDataEntityType>();
        for (IDataEntityProperty property : entityType.getProperties()) {
            boolean flag;
            String number = property.getName();
            String classSimpleName = property.getClass().getSimpleName();
            if (property instanceof EntryProp && !(property instanceof LinkEntryProp)) {
                entryTypes.add(((EntryProp)property).getItemType());
                continue;
            }
            if (!isInit || noPropNames.contains(classSimpleName) && !"id".equals(number)) continue;
            String displayName = property.getDisplayName() != null ? property.getDisplayName().getLocaleValue() : ("id".equals(number) ? "ID" : "");
            String fullnumber = number;
            String fullname = displayName;
            IDataEntityType parent = property.getParent();
            if (yemMatchentry.equals(entityKey)) {
                if (parent instanceof SubEntryType) {
                    IDataEntityType grandParent = parent.getParent();
                    fullnumber = grandParent.getName() + "." + parent.getName() + "." + fullnumber;
                    fullname = grandParent.getDisplayName().getLocaleValue() + "." + parent.getDisplayName().getLocaleValue() + "." + fullname;
                } else if (parent instanceof EntryType) {
                    fullnumber = parent.getName() + "." + fullnumber;
                    fullname = parent.getDisplayName().getLocaleValue() + "." + fullname;
                }
            }
            boolean containsEntry = fullnumber.contains(yemMatchentry);
            boolean singleDot = fullnumber.split("\\.").length - 1 == 1;
            boolean bl = flag = "BaseUnitqtyProp".equals(classSimpleName) || "QtyProp".equals(classSimpleName);
            if (!containsEntry || !singleDot || !flag) continue;
            DynamicObject row = entryEntity.addNew();
            row.set("yem_number", (Object)fullnumber);
            row.set("yem_name", (Object)fullname);
            row.set("yem_datatype", (Object)classSimpleName);
        }
        for (IDataEntityType entryType : entryTypes) {
            this.fieldQFilter(tree, entryEntity, entryType, alone, showKeys);
        }
    }

    private void initMetaDataField(TreeView tree, DynamicObjectCollection entryEntity, IDataEntityType entityType, boolean alone, Collection<String> showKeys, String yemMatchentry) {
        boolean isInit = false;
        String entityKey = entityType.getName();
        if (!alone || alone && showKeys.contains(entityKey)) {
            isInit = true;
        }
        if (tree != null) {
            TreeNode node = new TreeNode("", entityKey, entityType.getDisplayName().getLocaleValue());
            node.setIsOpened(true);
            if (entityType instanceof BillEntityType) {
                tree.addNode(node);
            } else if (isInit && entityType instanceof EntryType && yemMatchentry.equals(entityKey)) {
                node.setParentid(entityType.getParent().getName());
                tree.addNode(node);
            }
        }
        ArrayList<IDataEntityType> entryTypes = new ArrayList<IDataEntityType>();
        for (IDataEntityProperty property : entityType.getProperties()) {
            boolean singleDot;
            String number = property.getName();
            String classSimpleName = property.getClass().getSimpleName();
            if (property instanceof EntryProp && !(property instanceof LinkEntryProp)) {
                entryTypes.add(((EntryProp)property).getItemType());
                continue;
            }
            if (!isInit || noPropNames.contains(classSimpleName) && !"id".equals(number)) continue;
            String displayName = property.getDisplayName() != null ? property.getDisplayName().getLocaleValue() : ("id".equals(number) ? "ID" : "");
            String fullnumber = number;
            String fullname = displayName;
            IDataEntityType parent = property.getParent();
            if (yemMatchentry.equals(entityKey)) {
                if (parent instanceof SubEntryType) {
                    IDataEntityType grandParent = parent.getParent();
                    fullnumber = grandParent.getName() + "." + parent.getName() + "." + fullnumber;
                    fullname = grandParent.getDisplayName().getLocaleValue() + "." + parent.getDisplayName().getLocaleValue() + "." + fullname;
                } else if (parent instanceof EntryType) {
                    fullnumber = parent.getName() + "." + fullnumber;
                    fullname = parent.getDisplayName().getLocaleValue() + "." + fullname;
                }
            }
            boolean containsEntry = fullnumber.contains(yemMatchentry);
            boolean bl = singleDot = fullnumber.split("\\.").length - 1 == 1;
            if (!containsEntry || !singleDot) continue;
            DynamicObject row = entryEntity.addNew();
            row.set("yem_number", (Object)fullnumber);
            row.set("yem_name", (Object)fullname);
            row.set("yem_datatype", (Object)classSimpleName);
        }
        for (IDataEntityType entryType : entryTypes) {
            this.fieldQFilter(tree, entryEntity, entryType, alone, showKeys);
        }
    }

    static {
        noPropNames.add("LongProp");
        noPropNames.add("LinkEntryProp");
        noPropNames.add("DynamicLocaleProperty");
    }
}

