/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pa.common.purSalmatch.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.SystemParamUtil;
import yem.base.common.utils.YEM;
import yem.wm.pa.common.utils.GetFieldMappingUtils;
import yem.wm.pa.common.utils.MatchInventoryUtils;

public class PurchaseSalesMatchBillPlugin
extends AbstractBillPlugIn {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"yem_tbmainentry"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.matchFunctionInit();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        switch (operateKey) {
            case "cxpp_cxpp": {
                this.cancelMatchVerify(args, view, model);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() != null && !e.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = ((AbstractOperate)e.getSource()).getOperateKey();
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        String name = model.getDataEntityType().getName();
        switch (operateKey) {
            case "cxpp_cxpp": {
                this.cancelMatch(view, model, name, dataEntity);
                break;
            }
            case "spmx_xskykc": {
                this.showInventorySelectForm(view, dataEntity);
                break;
            }
            case "submit": {
                this.getView().updateView();
                break;
            }
            case "cxpp_sgpp": {
                this.matchOp(e);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        switch (actionId) {
            case "cxpp_sgpp": {
                this.backMatchQty(closedCallBackEvent, model, view);
            }
        }
    }

    private void backMatchQty(ClosedCallBackEvent closedCallBackEvent, IDataModel model, IFormView view) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData == null || returnData.isEmpty()) {
            return;
        }
        DynamicObject matchConfig = MatchInventoryUtils.getMatchBillConfig(view.getEntityId());
        String entryName = matchConfig.getString("yem_matchentry");
        DynamicObjectCollection entryEntity = model.getEntryEntity(entryName);
        for (DynamicObject entryRow : entryEntity) {
            long rowId = entryRow.getLong("id");
            if (!returnData.containsKey(rowId)) continue;
            BigDecimal matchQty = (BigDecimal)returnData.get(rowId);
            entryRow.set("yem_matchqty", (Object)matchQty);
        }
        view.invokeOperation("save", YEM.getOptionNoMsg());
        view.updateView();
    }

    private void matchFunctionInit() {
        this.controlDisplayHide(false);
        boolean isEnable = false;
        Object param = SystemParamUtil.getAppParam((String)"yem_pa", (Long)100000L, (String)"yem_enabled");
        if (param instanceof Boolean) {
            isEnable = (Boolean)param;
        }
        if (isEnable) {
            IDataModel model = this.getView().getModel();
            DynamicObject matchConfig = MatchInventoryUtils.getMatchBillConfig(model.getDataEntityType().getName());
            if (YEM.isEmpty((Object)matchConfig)) {
                return;
            }
            boolean isOpenFunction = matchConfig.getBoolean("yem_openfunction");
            if (!isOpenFunction) {
                return;
            }
            this.controlDisplayHide(true);
            DynamicObject group = matchConfig.getDynamicObject("group");
            if ("XS".equals(group.getString("number"))) {
                this.getView().setVisible(Boolean.valueOf("A".equals(matchConfig.getString("yem_smartmatch"))), new String[]{"yem_cxpp_znpp"});
            }
        }
    }

    private void controlDisplayHide(boolean isVisible) {
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"yem_fw_cxpp"});
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"yem_matchqty"});
    }

    private DynamicObject judgeConfigIsCompleted() {
        IDataModel model = this.getView().getModel();
        String name = model.getDataEntityType().getName();
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("number", "=", (Object)name);
        return BusinessDataServiceHelper.loadSingle((String)"yem_pa_inventorybills", (QFilter[])qFilter.toArray());
    }

    private List<String> queryDispositionReceipt(QFilter qFilter) {
        DynamicObject[] yemPaInventorybills;
        ArrayList<String> logotypelist = new ArrayList<String>();
        for (DynamicObject yemPaInventorybill : yemPaInventorybills = BusinessDataServiceHelper.load((String)"yem_pa_inventorybills", (String)DynamicObjectUtil.getSelectfields((String)"yem_pa_inventorybills", (boolean)false), (QFilter[])qFilter.toArray())) {
            DynamicObject yemNodedoc = (DynamicObject)yemPaInventorybill.get("yem_nodedoc");
            String number = yemNodedoc.getString("number");
            logotypelist.add(number);
        }
        return logotypelist;
    }

    private void cancelMatchVerify(BeforeDoOperationEventArgs args, IFormView view, IDataModel model) {
        EntryGrid entryPpxx = (EntryGrid)this.getControl("yem_materialentry");
        int[] selectRows = entryPpxx.getSelectRows();
        if (selectRows.length == 0) {
            view.showTipNotification("\u8bf7\u9009\u62e9\u5546\u54c1\u4fe1\u606f\uff01");
            args.setCancel(true);
            return;
        }
        for (int rowSeq : selectRows) {
            DynamicObject materialRow = model.getEntryRowEntity("yem_materialentry", rowSeq);
            BigDecimal matchqty = materialRow.getBigDecimal("yem_matchqty");
            MatchInventoryUtils matchInventoryUtils = new MatchInventoryUtils();
            List<DynamicObject> cxppEntity = MatchInventoryUtils.queryMatchRelation(false, view.getEntityId(), model.getDataEntity().getLong("id"), materialRow.getLong("id"));
            if (matchqty.compareTo(BigDecimal.ZERO) != 0 && !cxppEntity.isEmpty()) continue;
            view.showTipNotification(String.format("\u64a4\u9500\u5931\u8d25\uff01\u7b2c%S\u884c\u6682\u65e0\u91c7\u9500\u5339\u914d\u5173\u7cfb", rowSeq + 1));
            args.setCancel(true);
        }
    }

    private void cancelMatch(IFormView view, IDataModel model, String name, DynamicObject dataEntity) {
        EntryGrid entryPpxx = (EntryGrid)this.getControl("yem_materialentry");
        int[] selectRows = entryPpxx.getSelectRows();
        DynamicObject matchConfig = MatchInventoryUtils.getMatchBillConfig(view.getEntityId());
        DynamicObject group = matchConfig.getDynamicObject("group");
        boolean isPur = !"XS".equals(group.getString("number"));
        for (int rowSeq : selectRows) {
            DynamicObject materialRow = model.getEntryRowEntity("yem_materialentry", rowSeq);
            MatchInventoryUtils matchInventoryUtils = new MatchInventoryUtils();
            List<DynamicObject> cxppEntity = MatchInventoryUtils.queryMatchRelation(false, name, dataEntity.getLong("id"), materialRow.getLong("id"));
            if (cxppEntity.isEmpty()) continue;
            Boolean result = MatchInventoryUtils.unMatchRelation(isPur, view.getEntityId(), dataEntity.getLong("id"), materialRow.getLong("id"));
            if (!result.booleanValue()) {
                view.showTipNotification("\u64a4\u9500\u5931\u8d25!");
                continue;
            }
            view.showSuccessNotification("\u64a4\u9500\u6210\u529f\uff01");
            model.setValue("yem_matchqty", (Object)BigDecimal.ZERO, rowSeq);
            view.invokeOperation("save", YEM.getOptionNoMsg());
            view.updateView();
        }
    }

    private void showInventorySelectForm(IFormView view, DynamicObject dataEntity) {
        String[] fields = GetFieldMappingUtils.INSTANCE.getFieldMapping(view.getEntityId());
        if (Arrays.stream(fields).anyMatch(field -> field == null || field.isEmpty())) {
            return;
        }
        DynamicObject org = dataEntity.getDynamicObject(fields[0]);
        if (YEM.isEmpty((Object)org)) {
            view.showTipNotification("\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u7ec4\u7ec7\uff01");
            return;
        }
        DynamicObject bizdept = dataEntity.getDynamicObject(fields[1]);
        if (YEM.isEmpty((Object)bizdept)) {
            view.showTipNotification("\u90e8\u95e8\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u7ec4\u7ec7\u90e8\u95e8\uff01");
            return;
        }
        this.showForm("yem_pa_inventoryselect", "spmx_xskykc");
    }

    private void matchOp(AfterDoOperationEventArgs e) {
        OperationResult operationResult = e.getOperationResult();
        boolean success = operationResult.isSuccess();
        if (success) {
            IFormView view = this.getView();
            IDataModel model = this.getView().getModel();
            DynamicObject entity = model.getDataEntity(true);
            String name = model.getDataEntityType().getName();
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            qFilter.and("status", "=", (Object)"C");
            qFilter.and("yem_openfunction", "=", (Object)true);
            List<String> logotypelist = this.queryDispositionReceipt(qFilter);
            if (!logotypelist.contains(name)) {
                view.showTipNotification("\u5f53\u524d\u5355\u636e\u4e0d\u662f\u5339\u914d\u5355\u636e\uff0c\u8bf7\u5148\u8fdb\u884c\u914d\u7f6e\uff01");
            } else {
                OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)view.getEntityId(), (Object[])new Object[]{entity.getPkValue()}, (OperateOption)OperateOption.create());
                this.showForm("yem_pa_distribution", "cxpp_sgpp");
            }
        }
    }

    public void showForm(String formKey, String button) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId(formKey);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, button));
        this.getView().showForm(showParameter);
    }
}

