/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pa.common.purSalmatch.op;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.plugin.Plugin;
import yem.base.common.utils.YEM;
import yem.wm.pa.common.purSalmatch.op.validators.SubmitValidatorPlugin;
import yem.wm.pa.common.utils.MatchInventoryUtils;

public class MatchInventoryOpPlugin
extends AbstractOperationServicePlugIn
implements Plugin {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new SubmitValidatorPlugin());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] entities = e.getDataEntities();
        DynamicObject matchConfig = MatchInventoryUtils.getMatchBillConfig(this.billEntityType.getName());
        if (YEM.isEmpty((Object)matchConfig)) {
            return;
        }
        switch (key) {
            case "submit": {
                boolean isDefaultInherit = this.isDefaultInheritVerify(matchConfig);
                if (!isDefaultInherit) {
                    return;
                }
                for (DynamicObject entity : entities) {
                    this.purchaseSalesMatch(entity, matchConfig);
                }
            }
            case "delete": {
                for (DynamicObject entity : entities) {
                    this.deleteOperation(entity, matchConfig);
                }
                break;
            }
        }
    }

    private void deleteOperation(DynamicObject entity, DynamicObject matchConfig) {
        long entityId = entity.getLong("id");
        String entryName = matchConfig.getString("yem_matchentry");
        DynamicObjectCollection billEntry = entity.getDynamicObjectCollection(entryName);
        String name = entity.getDataEntityType().getName();
        for (DynamicObject row : billEntry) {
            Boolean result;
            long rowId = row.getLong("id");
            List<DynamicObject> matchRelationList = MatchInventoryUtils.queryMatchRelation(false, name, entityId, rowId);
            if (matchRelationList.isEmpty() || (result = MatchInventoryUtils.unMatchRelation(false, name, entityId, rowId)).booleanValue()) continue;
            throw new KDBizException("\u5220\u9664\u5931\u8d25: \u64a4\u9500\u5339\u914d\u5173\u7cfb\u5931\u8d25\uff01");
        }
    }

    private boolean isDefaultInheritVerify(DynamicObject matchConfig) {
        String isInheritup = matchConfig.getString("yem_inheritupstream");
        return "A".equals(isInheritup);
    }

    private void purchaseSalesMatch(DynamicObject entity, DynamicObject matchConfig) {
        String entryName = matchConfig.getString("yem_matchentry");
        long entityId = entity.getLong("id");
        String name = this.billEntityType.getName();
        DynamicObjectCollection billentry = entity.getDynamicObjectCollection(entryName);
        ArrayList<DynamicObject> saveMatchRelation = new ArrayList<DynamicObject>();
        HashMap<Long, BigDecimal> qtyMap = new HashMap<Long, BigDecimal>();
        for (DynamicObject billRow2 : billentry) {
            long rowId = billRow2.getLong("id");
            Map<String, Object> data = MatchInventoryUtils.createNodeInfo(matchConfig, entity, rowId);
            if (data == null) continue;
            DynamicObject group = matchConfig.getDynamicObject("group");
            String groupid = group.getString("number");
            boolean isPur = "CG".equals(groupid);
            BigDecimal qty = (BigDecimal)data.get("yem_pqty");
            List<DynamicObject> matchRelations = MatchInventoryUtils.queryMatchRelation(isPur, name, entityId, rowId);
            BigDecimal matchqty = BigDecimal.ZERO;
            if (!matchRelations.isEmpty()) {
                matchqty = matchRelations.stream().map(row -> row.getBigDecimal("yem_newmatchqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            qtyMap.put(rowId, matchqty);
            if (qty.compareTo(matchqty) <= 0) continue;
            String srcbillkey = (String)data.get("yem_srcbillkey_" + (isPur ? "p" : "s"));
            Long srcbillid = (Long)data.get("yem_srcbillid_" + (isPur ? "p" : "s"));
            Long srcbillentryid = (Long)data.get("yem_srcbillentryid_" + (isPur ? "p" : "s"));
            List<DynamicObject> srcMatchRelations = MatchInventoryUtils.queryMatchRelation(isPur, srcbillkey, srcbillid, srcbillentryid);
            if (srcMatchRelations.isEmpty()) continue;
            BigDecimal remainingQty = qty.subtract(matchqty);
            if (!MatchInventoryUtils.isAvailableInventory(srcbillkey, srcbillid, srcbillentryid, remainingQty).booleanValue()) {
                return;
            }
            boolean isExist = remainingQty.compareTo(qty) == 0;
            ArrayList<DynamicObject> saveComputMatchRelation = new ArrayList<DynamicObject>();
            for (DynamicObject srcRelation : srcMatchRelations) {
                if (remainingQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal newmatchqty = srcRelation.getBigDecimal("yem_newmatchqty");
                if (isPur) {
                    HashMap<String, Object> salesRelation = new HashMap<String, Object>();
                    salesRelation.put("yem_businessnode_s", srcRelation.get("yem_businessnode_p"));
                    salesRelation.put("yem_computbillkeysale", srcRelation.get("yem_computbillkeysale"));
                    salesRelation.put("yem_computbillidsale", srcRelation.get("yem_computbillidsale"));
                    salesRelation.put("yem_computingidsale", srcRelation.get("yem_computingidsale"));
                    salesRelation.put("yem_salebill", srcRelation.get("yem_salebill"));
                    salesRelation.put("yem_salebillno", srcRelation.get("yem_salebillno"));
                    salesRelation.put("yem_salebillid", srcRelation.get("yem_salebillid"));
                    salesRelation.put("yem_salebillrowid", srcRelation.get("yem_salebillrowid"));
                    salesRelation.put("yem_mainbillkey_s", srcRelation.get("yem_mainbillkey_s"));
                    salesRelation.put("yem_mainbillno_s", srcRelation.get("yem_mainbillno_s"));
                    salesRelation.put("yem_mainbillid_s", srcRelation.get("yem_mainbillid_s"));
                    salesRelation.put("yem_mainbillentryid_s", srcRelation.get("yem_mainbillentryid_s"));
                    salesRelation.put("yem_srcbillkey_s", srcRelation.get("yem_srcbillkey_s"));
                    salesRelation.put("yem_srcbillno_s", srcRelation.get("yem_srcbillno_s"));
                    salesRelation.put("yem_srcbillid_s", srcRelation.get("yem_srcbillid_s"));
                    salesRelation.put("yem_srcbillentryid_s", srcRelation.get("yem_srcbillentryid_s"));
                    salesRelation.putAll(data);
                    salesRelation.put("yem_pqty", remainingQty.compareTo(newmatchqty) > 0 ? newmatchqty : remainingQty);
                    DynamicObject cg = yem.wm.pa.shmjs.utils.MatchInventoryUtils.createMatchRelation(salesRelation, "CG", "\u63d0\u4ea4\u81ea\u52a8\u5339\u914d\u3002");
                    saveMatchRelation.add(cg);
                } else {
                    HashMap<String, Object> purchaseRelation = new HashMap<String, Object>();
                    purchaseRelation.put("yem_businessnode_p", srcRelation.get("yem_businessnode_p"));
                    purchaseRelation.put("yem_computingidpur", srcRelation.get("yem_computingidpur"));
                    purchaseRelation.put("yem_procurebill", srcRelation.get("yem_procurebill"));
                    purchaseRelation.put("yem_procurebillno", srcRelation.get("yem_procurebillno"));
                    purchaseRelation.put("yem_procurebillid", srcRelation.get("yem_procurebillid"));
                    purchaseRelation.put("yem_procurebillrowid", srcRelation.get("yem_procurebillrowid"));
                    purchaseRelation.put("yem_mainbillkey_p", srcRelation.get("yem_mainbillkey_p"));
                    purchaseRelation.put("yem_mainbillno_p", srcRelation.get("yem_mainbillno_p"));
                    purchaseRelation.put("yem_mainbillid_p", srcRelation.get("yem_mainbillid_p"));
                    purchaseRelation.put("yem_mainbillentryid_p", srcRelation.get("yem_mainbillentryid_p"));
                    purchaseRelation.put("yem_srcbillkey_p", srcRelation.get("yem_srcbillkey_p"));
                    purchaseRelation.put("yem_srcbillno_p", srcRelation.get("yem_srcbillno_p"));
                    purchaseRelation.put("yem_srcbillid_p", srcRelation.get("yem_srcbillid_p"));
                    purchaseRelation.put("yem_srcbillentryid_p", srcRelation.get("yem_srcbillentryid_p"));
                    purchaseRelation.putAll(data);
                    purchaseRelation.put("yem_pqty", remainingQty.compareTo(newmatchqty) > 0 ? newmatchqty : remainingQty);
                    DynamicObject xs = yem.wm.pa.shmjs.utils.MatchInventoryUtils.createMatchRelation(purchaseRelation, "XS", "\u63d0\u4ea4\u81ea\u52a8\u5339\u914d\u3002");
                    saveMatchRelation.add(xs);
                }
                DynamicObject minusMatchRelation = yem.wm.pa.shmjs.utils.MatchInventoryUtils.createMinusMatchRelation(isPur, srcRelation.getLong("id"), remainingQty.compareTo(newmatchqty) > 0 ? newmatchqty : remainingQty, name, entityId, rowId, "\u63d0\u4ea4\u81ea\u52a8\u5339\u914d\u3002");
                saveComputMatchRelation.add(minusMatchRelation);
                billRow2.set("yem_matchqty", (Object)qty);
                remainingQty = remainingQty.subtract(newmatchqty);
            }
            if (saveComputMatchRelation.isEmpty()) continue;
            OperationResult operationResult = SaveServiceHelper.saveOperate((String)"save", (String)"yem_pa_matchrelation", (DynamicObject[])saveComputMatchRelation.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
        if (saveMatchRelation.isEmpty()) {
            return;
        }
        OperationResult saveResult = SaveServiceHelper.saveOperate((String)"save", (String)"yem_pa_matchrelation", (DynamicObject[])saveMatchRelation.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!saveResult.isSuccess()) {
            billentry.forEach(billRow -> billRow.set("yem_matchqty", qtyMap.get(billRow.getLong("id"))));
            throw new KDBizException("\u751f\u6210\u5339\u914d\u5173\u7cfb\u5931\u8d25!");
        }
    }
}

