/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pa.common.purSalmatch.op.validators;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import yem.wm.pa.common.utils.MatchInventoryUtils;

public class InventorySubmitValidatorPlugin
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            String operateKey = this.getOperateKey();
            if (!"submit".equals(operateKey)) continue;
            this.availableInventoryValidator(dataEntity);
        }
    }

    private void availableInventoryValidator(ExtendedDataEntity dataEntity) {
        DynamicObject entity = dataEntity.getDataEntity();
        DynamicObjectCollection billentry = entity.getDynamicObjectCollection("billentry");
        ArrayList<Integer> errIndex = new ArrayList<Integer>();
        HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>();
        for (DynamicObject row : billentry) {
            String procurebill = row.getString("yem_procurebill");
            long procurebillid = row.getLong("yem_procurebillid");
            long procurebillrowid = row.getLong("yem_procurebillrowid");
            BigDecimal oldQty = qtyMap.getOrDefault(procurebill + procurebillid + procurebillrowid, BigDecimal.ZERO);
            BigDecimal qty = row.getBigDecimal("qty").add(oldQty);
            qtyMap.put(procurebill + procurebillid + procurebillrowid, qty);
            Boolean result = MatchInventoryUtils.isAvailableInventory(procurebill, procurebillid, procurebillrowid, qty);
            if (result.booleanValue()) continue;
            errIndex.add(billentry.indexOf((Object)row));
        }
        if (!errIndex.isEmpty()) {
            String errSeqInfo = errIndex.stream().map(num -> String.valueOf(num + 1)).collect(Collectors.joining("\u3001"));
            this.addFatalErrorMessage(dataEntity, String.format("\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\u5e93\u5b58\u4e3a\u4e0d\u53ef\u7528\u5e93\u5b58\uff0c\u63d0\u4ea4\u5931\u8d25\uff01", errSeqInfo));
        }
    }
}

