/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pa.common.purSalmatch.op.validators;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import yem.base.common.utils.YEM;
import yem.wm.pa.common.utils.MatchInventoryUtils;

public class SubmitValidatorPlugin
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject matchConfig = MatchInventoryUtils.getMatchBillConfig(this.entityKey);
        if (YEM.isEmpty((Object)matchConfig)) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String operateKey = this.getOperateKey();
            if (!"submit".equals(operateKey)) continue;
            this.qtyValidator(dataEntity, matchConfig);
            this.SubmitControlValidator(dataEntity, matchConfig);
            this.isEnablInventoryValidator(dataEntity, matchConfig);
            this.isDefaultInheritVerify(dataEntity, matchConfig);
        }
    }

    private void qtyValidator(ExtendedDataEntity dataEntity, DynamicObject matchConfig) {
        String entryName = matchConfig.getString("yem_matchentry");
        String qtyName = matchConfig.getString("yem_qtyfiledkeys");
        qtyName = qtyName.substring(qtyName.indexOf(".") + 1);
        DynamicObject entity = dataEntity.getDataEntity();
        DynamicObjectCollection materialentry = entity.getDynamicObjectCollection(entryName);
        if (materialentry.isEmpty()) {
            return;
        }
        ArrayList<String> errSeq = new ArrayList<String>();
        for (DynamicObject materialRow : materialentry) {
            BigDecimal matchqty;
            int seq = materialentry.indexOf((Object)materialRow) + 1;
            BigDecimal qty = materialRow.getBigDecimal(qtyName);
            if (qty.compareTo(matchqty = materialRow.getBigDecimal("yem_matchqty")) >= 0) continue;
            errSeq.add(String.valueOf(seq));
        }
        if (!errSeq.isEmpty()) {
            this.addFatalErrorMessage(dataEntity, String.format("\u5f53\u524d\u5546\u54c1\u7b2c%s\u884c\uff0c\u5df2\u91c7\u9500\u5339\u914d\u6570\u91cf\u5927\u4e8e\u6570\u91cf\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u91c7\u9500\u5339\u914d\u64cd\u4f5c\uff01", String.join((CharSequence)"\u3001", errSeq)));
        }
    }

    private void SubmitControlValidator(ExtendedDataEntity dataEntity, DynamicObject matchConfig) {
        String entryName = matchConfig.getString("yem_matchentry");
        String qtyName = matchConfig.getString("yem_qtyfiledkeys");
        qtyName = qtyName.substring(qtyName.indexOf(".") + 1);
        DynamicObject group = matchConfig.getDynamicObject("group");
        if (!"XS".equals(group.getString("number"))) {
            return;
        }
        DynamicObject entity = dataEntity.getDataEntity();
        String submitcon = matchConfig.getString("yem_submitcon");
        DynamicObjectCollection materialentry = entity.getDynamicObjectCollection(entryName);
        for (DynamicObject materialRow : materialentry) {
            BigDecimal matchqty;
            int seq = materialentry.indexOf((Object)materialRow) + 1;
            BigDecimal qty = materialRow.getBigDecimal(qtyName);
            if (qty.compareTo(matchqty = materialRow.getBigDecimal("yem_matchqty")) <= 0) continue;
            BigDecimal subtracted = qty.subtract(matchqty);
            if ("A".equals(submitcon)) {
                this.addFatalErrorMessage(dataEntity, String.format("\u63d0\u4ea4\u5931\u8d25\uff0c\u5546\u54c1\u5206\u5f55\u7b2c%s\u884c\uff0c\u5269\u4f59%d\u6570\u91cf\u672a\u8fdb\u884c\u91c7\u9500\u5339\u914d\uff0c\u8bf7\u5148\u5b8c\u6210\u91c7\u9500\u5339\u914d\u64cd\u4f5c\uff01", seq, subtracted.longValue()));
            }
            if (!"B".equals(submitcon)) continue;
            this.addWarningMessage(dataEntity, String.format("\u5546\u54c1\u5206\u5f55\u7b2c%s\u884c\uff0c\u5269\u4f59%d\u6570\u91cf\u672a\u8fdb\u884c\u91c7\u9500\u5339\u914d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", seq, subtracted.longValue()));
        }
    }

    private void isEnablInventoryValidator(ExtendedDataEntity dataEntity, DynamicObject matchConfig) {
        String entryName = matchConfig.getString("yem_matchentry");
        DynamicObject group = matchConfig.getDynamicObject("group");
        if (!"XS".equals(group.getString("number"))) {
            return;
        }
        DynamicObject entity = dataEntity.getDataEntity();
        long entityId = entity.getLong("id");
        String name = entity.getDataEntityType().getName();
        boolean issysbill = matchConfig.getBoolean("yem_issysbill");
        if (!issysbill) {
            return;
        }
        DynamicObjectCollection materialentry = entity.getDynamicObjectCollection(entryName);
        ArrayList<String> errSeq = new ArrayList<String>();
        block0: for (DynamicObject materialRow : materialentry) {
            int seq = materialentry.indexOf((Object)materialRow) + 1;
            MatchInventoryUtils matchInventoryUtils = new MatchInventoryUtils();
            List<DynamicObject> cxppEntityList = MatchInventoryUtils.queryMatchRelation(false, name, entityId, materialRow.getLong("id"));
            if (cxppEntityList.isEmpty()) continue;
            for (DynamicObject cxppEntity : cxppEntityList) {
                DynamicObject businessnodeP = cxppEntity.getDynamicObject("yem_businessnode_p");
                if (YEM.isEmpty((Object)businessnodeP) || "CG-KC".equals(businessnodeP.getString("number"))) continue;
                errSeq.add(String.valueOf(seq));
                continue block0;
            }
        }
        if (!errSeq.isEmpty()) {
            this.addFatalErrorMessage(dataEntity, String.format("\u5546\u54c1\u5206\u5f55\u7b2c%s\u884c\uff0c\u5bf9\u5e94\u7684\u91c7\u8d2d\u8fd8\u672a\u5165\u5e93\uff0c\u8bf7\u5148\u68c0\u67e5\u6570\u636e\u6216\u8fdb\u884c\u6362\u8d27\u5904\u7406\uff01", String.join((CharSequence)"\u3001", errSeq)));
        }
    }

    private void isDefaultInheritVerify(ExtendedDataEntity dataEntity, DynamicObject matchConfig) {
        String isInheritup = matchConfig.getString("yem_inheritupstream");
        if (!"A".equals(isInheritup)) {
            return;
        }
    }
}

