/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pa.common.purchase.op;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.YEM;
import yem.wm.pa.common.purchase.op.validators.UnauditValidatorPlugin;
import yem.wm.pa.shmjs.utils.MatchInventoryUtils;

public class PurchaseOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(DynamicObjectUtil.addFieldKey((String)this.billEntityType.getName(), (boolean)true));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new UnauditValidatorPlugin());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject matchConfig = MatchInventoryUtils.getMatchBillConfig(this.billEntityType.getName());
        if ("audit".equals(operationKey) || "unaudit".equals(operationKey)) {
            for (DynamicObject entity : e.getDataEntities()) {
                this.purchaseSaleOperation(entity, matchConfig, operationKey);
            }
        }
    }

    private void purchaseSaleOperation(DynamicObject entity, DynamicObject matchConfig, String operationKey) {
        String entryName = matchConfig.getString("yem_matchentry");
        String name = this.billEntityType.getName();
        long id = entity.getLong("id");
        String number = entity.getString("billno");
        String srcnum = matchConfig.getString("yem_srcnum");
        srcnum = srcnum.substring(srcnum.indexOf(".") + 1);
        String srcbillnonum = matchConfig.getString("yem_srcbillnonum");
        srcbillnonum = srcbillnonum.substring(srcbillnonum.indexOf(".") + 1);
        String srcidnum = matchConfig.getString("yem_srcidnum");
        srcidnum = srcidnum.substring(srcidnum.indexOf(".") + 1);
        String srcentityidnum = matchConfig.getString("yem_srcentityidnum");
        srcentityidnum = srcentityidnum.substring(srcentityidnum.indexOf(".") + 1);
        DynamicObjectCollection entry = entity.getDynamicObjectCollection(entryName);
        for (DynamicObject row : entry) {
            long entryId = row.getLong("id");
            String srcbillkey = row.getString(srcnum);
            long srcbillid = row.getLong(srcidnum);
            long srcentryid = row.getLong(srcentityidnum);
            List<DynamicObject> srcMatchRelationList = MatchInventoryUtils.queryMatchRelation(true, srcbillkey, srcbillid, srcentryid);
            switch (operationKey) {
                case "audit": {
                    if (srcMatchRelationList.isEmpty()) break;
                    DynamicObject srcmatchRelation = srcMatchRelationList.get(0);
                    this.auditOperation(row, srcmatchRelation, matchConfig, number, id, entryId);
                    break;
                }
                case "unaudit": {
                    List<DynamicObject> matchRelationList = MatchInventoryUtils.queryMatchRelation(true, name, id, entryId);
                    if (matchRelationList.isEmpty()) break;
                    DynamicObject matchRelation = matchRelationList.get(0);
                    this.unauditOperation(row, matchRelation, srcMatchRelationList, matchConfig);
                    break;
                }
            }
        }
    }

    private void auditOperation(DynamicObject row, DynamicObject matchRelation, DynamicObject matchConfig, String number, long id, long entryId) {
        String qtyName = matchConfig.getString("yem_qtyfiledkeys");
        qtyName = qtyName.substring(qtyName.indexOf(".") + 1);
        BigDecimal newmatchqty = matchRelation.getBigDecimal("yem_newmatchqty");
        BigDecimal qty = row.getBigDecimal(qtyName);
        if (qty.compareTo(newmatchqty) >= 0) {
            DynamicObject newMatchRelation = this.relationshipPositiveModification(matchRelation, matchConfig, null, number, id, entryId);
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"yem_pa_matchrelation", (DynamicObject[])new DynamicObject[]{newMatchRelation}, (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                throw new KDBizException(String.format("\u91c7\u9500\u5339\u914d\u5173\u7cfb: %s\uff0c\u4fee\u6539\u5f02\u5e38", newMatchRelation.getString("billno")));
            }
        } else {
            DynamicObject copyMatchRelation = BusinessDataServiceHelper.newDynamicObject((String)"yem_pa_matchrelation");
            DynamicObjectUtils.copy((DynamicObject)matchRelation, (DynamicObject)copyMatchRelation);
            CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)"yem_pa_matchrelation", (DynamicObject)copyMatchRelation, (String)String.valueOf(YEM.getCurrentOrgId()));
            copyMatchRelation.set("billno", (Object)CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)copyMatchRelation));
            matchRelation.set("yem_newmatchqty", (Object)newmatchqty.subtract(qty));
            matchRelation.set("yem_matchqty", (Object)newmatchqty.subtract(qty));
            DynamicObject newCopyMatchRelation = this.relationshipPositiveModification(copyMatchRelation, matchConfig, qty, number, id, entryId);
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"yem_pa_matchrelation", (DynamicObject[])new DynamicObject[]{newCopyMatchRelation}, (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                throw new KDBizException(String.format("\u91c7\u9500\u5339\u914d\u5173\u7cfb: %s\uff0c\u4fee\u6539\u5f02\u5e38", matchRelation.getString("billno")));
            }
            result = OperationServiceHelper.executeOperate((String)"save", (String)"yem_pa_matchrelation", (DynamicObject[])new DynamicObject[]{matchRelation}, (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                throw new KDBizException(String.format("\u91c7\u9500\u5339\u914d\u5173\u7cfb: %s\uff0c\u4fee\u6539\u5f02\u5e38", matchRelation.getString("billno")));
            }
        }
    }

    private DynamicObject relationshipPositiveModification(DynamicObject matchRelation, DynamicObject matchConfig, BigDecimal qty, String number, long id, long entryId) {
        if (qty != null) {
            matchRelation.set("yem_newmatchqty", (Object)qty);
            matchRelation.set("yem_matchqty", (Object)qty);
        }
        matchRelation.set("yem_matchtime", (Object)new Date());
        matchRelation.set("yem_businessnode_p", (Object)matchConfig.getDynamicObject("yem_inventorynode"));
        DynamicObject procureConfig = matchRelation.getDynamicObject("yem_procurebill");
        String procurebillno = matchRelation.getString("yem_procurebillno");
        long procurebillid = matchRelation.getLong("yem_procurebillid");
        long procurebillrowid = matchRelation.getLong("yem_procurebillrowid");
        matchRelation.set("yem_procurebill", (Object)matchConfig);
        matchRelation.set("yem_procurebillno", (Object)number);
        matchRelation.set("yem_procurebillid", (Object)id);
        matchRelation.set("yem_procurebillrowid", (Object)entryId);
        DynamicObjectCollection cxjcEntry = matchRelation.getDynamicObjectCollection("yem_pa_cxppgx_cxjc");
        DynamicObject newRow = cxjcEntry.addNew();
        newRow.set("yem_srcbillkey_p_j", (Object)procureConfig.getString("number"));
        newRow.set("yem_srcbillno_p_j", (Object)procurebillno);
        newRow.set("yem_srcbillid_p_j", (Object)procurebillid);
        newRow.set("yem_srcbillentryid_p_j", (Object)procurebillrowid);
        newRow.set("yem_procurebill_j", (Object)procureConfig);
        matchRelation.set("yem_srcbillkey_p", (Object)procureConfig.getString("number"));
        matchRelation.set("yem_srcbillno_p", (Object)procurebillno);
        matchRelation.set("yem_srcbillid_p", (Object)procurebillid);
        matchRelation.set("yem_srcbillentryid_p", (Object)procurebillrowid);
        return matchRelation;
    }

    private void unauditOperation(DynamicObject row, DynamicObject matchRelation, List<DynamicObject> matchRelationList, DynamicObject matchConfig) {
        String qtyName = matchConfig.getString("yem_qtyfiledkeys");
        qtyName = qtyName.substring(qtyName.indexOf(".") + 1);
        BigDecimal newmatchqty = matchRelation.getBigDecimal("yem_newmatchqty");
        BigDecimal qty = row.getBigDecimal(qtyName);
        DynamicObjectCollection cxjcEntry = matchRelation.getDynamicObjectCollection("yem_pa_cxppgx_cxjc");
        if (cxjcEntry.isEmpty()) {
            return;
        }
        if (!matchRelationList.isEmpty()) {
            DynamicObject srcMatchRelation = matchRelationList.get(0);
            BigDecimal srcNewmatchqty = srcMatchRelation.getBigDecimal("yem_newmatchqty");
            srcMatchRelation.set("yem_newmatchqty", (Object)srcNewmatchqty.add(newmatchqty));
            srcMatchRelation.set("yem_matchqty", (Object)srcNewmatchqty.add(newmatchqty));
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"yem_pa_matchrelation", (DynamicObject[])new DynamicObject[]{srcMatchRelation}, (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                throw new KDBizException(String.format("\u91c7\u9500\u5339\u914d\u5173\u7cfb: %s\uff0c\u4fee\u6539\u5f02\u5e38", srcMatchRelation.getString("number")));
            }
            result = OperationServiceHelper.executeOperate((String)"delete", (String)"yem_pa_matchrelation", (DynamicObject[])new DynamicObject[]{matchRelation}, (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                throw new KDBizException(String.format("\u91c7\u9500\u5339\u914d\u5173\u7cfb: %s\uff0c\u5220\u9664\u5f02\u5e38", matchRelation.getString("billno")));
            }
        } else {
            DynamicObject newMatchRelation = this.relationshipReverseModification(matchRelation);
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"yem_pa_matchrelation", (DynamicObject[])new DynamicObject[]{newMatchRelation}, (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                throw new KDBizException(String.format("\u91c7\u9500\u5339\u914d\u5173\u7cfb: %s\uff0c\u4fee\u6539\u5f02\u5e38", newMatchRelation.getString("billno")));
            }
        }
    }

    private DynamicObject relationshipReverseModification(DynamicObject matchRelation) {
        matchRelation.set("yem_matchtime", (Object)new Date());
        DynamicObjectCollection cxjcEntry = matchRelation.getDynamicObjectCollection("yem_pa_cxppgx_cxjc");
        DynamicObject lastRow = (DynamicObject)cxjcEntry.get(cxjcEntry.size() - 1);
        cxjcEntry.remove((Object)lastRow);
        DynamicObject procurebill = lastRow.getDynamicObject("yem_procurebill_j");
        String srcbillno = lastRow.getString("yem_srcbillno_p_j");
        long srcbillid = lastRow.getLong("yem_srcbillid_p_j");
        long srcbillentryid = lastRow.getLong("yem_srcbillentryid_p_j");
        matchRelation.set("yem_procurebill", (Object)procurebill);
        matchRelation.set("yem_procurebillno", (Object)srcbillno);
        matchRelation.set("yem_procurebillid", (Object)srcbillid);
        matchRelation.set("yem_procurebillrowid", (Object)srcbillentryid);
        procurebill = BusinessDataServiceHelper.loadSingle((Object)procurebill.getPkValue(), (String)procurebill.getDynamicObjectType().getName());
        matchRelation.set("yem_businessnode_p", (Object)procurebill.getDynamicObject("yem_inventorynode"));
        if (cxjcEntry.size() - 2 >= 0) {
            DynamicObject lastBeforeRow = (DynamicObject)cxjcEntry.get(cxjcEntry.size() - 2);
            matchRelation.set("yem_srcbillkey_p", (Object)lastBeforeRow.getString("yem_srcbillkey_p_j"));
            matchRelation.set("yem_srcbillno_p", (Object)lastBeforeRow.getString("yem_srcbillno_p_j"));
            matchRelation.set("yem_srcbillid_p", (Object)lastBeforeRow.getLong("yem_srcbillid_p_j"));
            matchRelation.set("yem_srcbillentryid_p", (Object)lastBeforeRow.getLong("yem_srcbillentryid_p_j"));
        } else {
            matchRelation.set("yem_srcbillkey_p", null);
            matchRelation.set("yem_srcbillno_p", null);
            matchRelation.set("yem_srcbillid_p", null);
            matchRelation.set("yem_srcbillentryid_p", null);
        }
        return matchRelation;
    }
}

