/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pa.common.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.lang3.StringUtils;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.RptUtil;
import yem.base.common.utils.YEM;

public class MatchInventoryUtils {
    private static final String algoKey = MatchInventoryUtils.class.getName();
    private static final String fieldsEntityKey = "yem_pa_matchingfields";
    private static final String matchRelation = "yem_pa_matchrelation";
    private static final String matchBillConfig = "yem_pa_inventorybills";
    private static final String aigoKey = MatchInventoryUtils.class.getName();
    public static final String KEY_APP_NAME = "wm-pa";

    public static DynamicObject getMatchBillConfig(String billKey) {
        QFilter qfilter = new QFilter("enable", "=", (Object)"1");
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        qfilter.and(new QFilter("number", "=", (Object)billKey));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)matchBillConfig, (String)"id", (QFilter[])new QFilter[]{qfilter});
        if (load.length > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)load[0].getLong("id"), (String)matchBillConfig);
        }
        return null;
    }

    public static Map<String, DynamicObject> queryMatchingFields(String fieldtype) {
        DynamicObject[] load;
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>();
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter = filter.and(new QFilter("status", "=", (Object)"C"));
        filter = "A".equals(fieldtype) ? filter.and(new QFilter("yem_fieldtype", "in", (Object)new String[]{"A", "C"})) : ("B".equals(fieldtype) ? filter.and(new QFilter("yem_fieldtype", "in", (Object)new String[]{"B", "C"})) : filter.and(new QFilter("yem_fieldtype", "=", (Object)"C")));
        String selectfields = DynamicObjectUtil.getSelectfields((String)fieldsEntityKey, (boolean)false);
        for (DynamicObject data : load = BusinessDataServiceHelper.load((String)fieldsEntityKey, (String)selectfields, (QFilter[])new QFilter[]{filter})) {
            result.put(data.getString("number"), data);
        }
        return result;
    }

    public Map<String, DynamicObject> queryDimensionFields() {
        DynamicObject[] load;
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>();
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter = filter.and(new QFilter("status", "=", (Object)"C"));
        filter = filter.and(new QFilter("yem_fieldtype", "=", (Object)"C"));
        filter = filter.and(new QFilter("yem_isdimension", "=", (Object)true));
        String selectfields = DynamicObjectUtil.getSelectfields((String)fieldsEntityKey, (boolean)false);
        for (DynamicObject data : load = BusinessDataServiceHelper.load((String)fieldsEntityKey, (String)selectfields, (QFilter[])new QFilter[]{filter})) {
            result.put(data.getString("number"), data);
        }
        return result;
    }

    public static List<DynamicObject> queryMatchRelation(Boolean isPur, String billkey, Long billId, Long billEntryId) {
        QFilter filter = new QFilter("yem_iscomputing", "=", (Object)false);
        filter = filter.and(new QFilter("yem_newmatchqty", ">", (Object)BigDecimal.ZERO));
        if (isPur.booleanValue()) {
            if (YEM.isNotEmpty((Object)billkey)) {
                filter = filter.and(new QFilter("yem_procurebill.number", "=", (Object)billkey));
            }
            if (YEM.isNotEmpty((Object)billId)) {
                filter = filter.and(new QFilter("yem_procurebillid", "=", (Object)billId));
            }
            if (YEM.isNotEmpty((Object)billEntryId)) {
                filter = filter.and(new QFilter("yem_procurebillrowid", "=", (Object)billEntryId));
            }
        } else {
            if (YEM.isNotEmpty((Object)billkey)) {
                filter = filter.and(new QFilter("yem_salebill.number", "=", (Object)billkey));
            }
            if (YEM.isNotEmpty((Object)billId)) {
                filter = filter.and(new QFilter("yem_salebillid", "=", (Object)billId));
            }
            if (YEM.isNotEmpty((Object)billEntryId)) {
                filter = filter.and(new QFilter("yem_salebillrowid", "=", (Object)billEntryId));
            }
        }
        String selectfields = DynamicObjectUtil.getSelectfields((String)matchRelation, (boolean)false);
        selectfields = DynamicObjectUtil.getEntrySelectfields((String)selectfields, (String)matchRelation, (String)"yem_pa_cxppgx_cxjc");
        DynamicObject[] result = BusinessDataServiceHelper.load((String)matchRelation, (String)selectfields, (QFilter[])new QFilter[]{filter});
        return Arrays.asList(result);
    }

    public BigDecimal querySupMatchQty(Boolean isPur, String billkey, Long billId, Long billEntryId) {
        QFilter filter = new QFilter("yem_iscomputing", "=", (Object)false);
        filter = filter.and(new QFilter("yem_newmatchqty", ">=", (Object)BigDecimal.ZERO));
        QFilter filter1 = new QFilter("yem_iscomputing", "=", (Object)false);
        filter1 = filter1.and(new QFilter("yem_newmatchqty", ">=", (Object)BigDecimal.ZERO));
        if (isPur.booleanValue()) {
            if (YEM.isNotEmpty((Object)billkey)) {
                filter = filter.and(new QFilter("yem_procurebill.number", "=", (Object)billkey));
                filter1 = filter1.and(new QFilter("yem_srcbillkey_p", "=", (Object)billkey));
            }
            if (YEM.isNotEmpty((Object)billId)) {
                filter = filter.and(new QFilter("yem_procurebillid", "=", (Object)billId));
                filter1 = filter1.and(new QFilter("yem_srcbillid_p", "=", (Object)billId));
            }
            if (YEM.isNotEmpty((Object)billEntryId)) {
                filter = filter.and(new QFilter("yem_procurebillrowid", "=", (Object)billEntryId));
                filter1 = filter1.and(new QFilter("yem_srcbillentryid_p", "=", (Object)billEntryId));
            }
        } else {
            if (YEM.isNotEmpty((Object)billkey)) {
                filter = filter.and(new QFilter("yem_salebill.number", "=", (Object)billkey));
                filter1 = filter1.and(new QFilter("yem_srcbillkey_s", "=", (Object)billkey));
            }
            if (YEM.isNotEmpty((Object)billId)) {
                filter = filter.and(new QFilter("yem_salebillid", "=", (Object)billId));
                filter1 = filter1.and(new QFilter("yem_srcbillid_s", "=", (Object)billId));
            }
            if (YEM.isNotEmpty((Object)billEntryId)) {
                filter = filter.and(new QFilter("yem_salebillrowid", "=", (Object)billEntryId));
                filter1 = filter1.and(new QFilter("yem_srcbillentryid_s", "=", (Object)billEntryId));
            }
        }
        QFilter qFilter = filter.or(filter1);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)matchRelation, (String)"yem_newmatchqty", (QFilter[])new QFilter[]{qFilter});
        BigDecimal result = BigDecimal.ZERO;
        for (DynamicObject object : load) {
            result = result.add(object.getBigDecimal("yem_newmatchqty"));
        }
        return result;
    }

    public static Boolean isAvailableInventory(String billkey, Long billId, Long billEntryId, BigDecimal thisMatchQty) {
        DynamicObject billConfig = MatchInventoryUtils.getMatchBillConfig(billkey);
        if (YEM.isEmpty((Object)billConfig) || YEM.isEmpty((Object)billId) || YEM.isEmpty((Object)billEntryId) || YEM.isEmpty((Object)thisMatchQty)) {
            return false;
        }
        String entryKey = billConfig.getString("yem_matchentry");
        String qtyKey = billConfig.getString("yem_qtyfiledkeys");
        List<QFilter> qFilters = MatchInventoryUtils.getBillConfigFilter(billConfig);
        qFilters.add(new QFilter("id", "=", (Object)billId));
        qFilters.add(new QFilter(entryKey + ".id", "=", (Object)billEntryId));
        StringBuilder filedKey = new StringBuilder(qtyKey);
        DynamicObjectCollection deductQty = billConfig.getDynamicObjectCollection("yem_pa_cxppdjpz_cxsjy");
        for (DynamicObject object : deductQty) {
            String qtyFields = object.getString("yem_qentityfieldid");
            if (!YEM.isNotEmpty((Object)qtyFields)) continue;
            filedKey.append("-").append(qtyFields);
        }
        filedKey.append(" qty");
        DataSet dataSet = ORM.create().queryDataSet(algoKey, billkey, filedKey.toString(), qFilters.toArray(new QFilter[0]));
        DynamicObjectCollection collection = ORM.create().toPlainDynamicObjectCollection(dataSet);
        BigDecimal queryQty = BigDecimal.ZERO;
        for (DynamicObject object : collection) {
            queryQty = queryQty.add(object.getBigDecimal("qty"));
        }
        List<DynamicObject> matchData = MatchInventoryUtils.queryMatchRelation(true, billkey, billId, billEntryId);
        BigDecimal matchQty = BigDecimal.ZERO;
        for (DynamicObject matchDatum : matchData) {
            matchQty = matchQty.add(matchDatum.getBigDecimal("yem_newmatchqty"));
        }
        BigDecimal availableQty = queryQty.subtract(matchQty);
        return availableQty.compareTo(thisMatchQty) != -1;
    }

    public static Map<String, List<Map<String, Object>>> queryUsableInventory(Map<String, Object> params) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
        Map<String, List<DynamicObject>> inventoryScope = MatchInventoryUtils.queryInventoryScope();
        Set<String> scopes = inventoryScope.keySet();
        for (String scope : scopes) {
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
            List<DynamicObject> billConfigs = inventoryScope.get(scope);
            for (DynamicObject billConfig : billConfigs) {
                List<Map<String, Object>> billData = MatchInventoryUtils.queryInventoryBillData(params, billConfig);
                data.addAll(billData);
            }
            result.put(scope, data);
        }
        return result;
    }

    public static List<Map<String, Object>> queryInventoryBillData(Map<String, Object> params, DynamicObject billConfig) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(MatchInventoryUtils.getBillConfigFilter(billConfig));
        DynamicObjectCollection ppwd = billConfig.getDynamicObjectCollection("yem_pa_cxppdjpz_ppwd");
        HashMap<String, Object> collect = new HashMap<String, Object>();
        for (Object object : ppwd) {
            boolean yemIsdimension = object.getBoolean("yem_isdimension");
            String yemEntityFieldId = object.getString("yem_entityfieldid");
            if (!yemIsdimension || !YEM.isNotEmpty((Object)yemEntityFieldId)) continue;
            String yemMatchFieldlib = object.getDynamicObject("yem_matchfieldlib").getString("number");
            collect.put(yemMatchFieldlib, object);
        }
        Set<String> paramsKeys = params.keySet();
        for (String paramsKey : paramsKeys) {
            if (!collect.containsKey(paramsKey)) continue;
            DynamicObject entity = (DynamicObject)collect.get(paramsKey);
            String yemEntityFieldid = entity.getString("yem_entityfieldid");
            Object value = params.get(paramsKey);
            if (value instanceof DynamicObject) {
                qFilters.add(new QFilter(yemEntityFieldid, "=", ((DynamicObject)value).getPkValue()));
                continue;
            }
            qFilters.add(new QFilter(yemEntityFieldid, "=", value));
        }
        ArrayList<String> fileds = new ArrayList<String>();
        ArrayList<String> queryFileds = new ArrayList<String>();
        String matchEntryKey = billConfig.getString("yem_matchentry");
        fileds.add("id");
        queryFileds.add("id");
        fileds.add(matchEntryKey + ".id entryid");
        queryFileds.add("entryid");
        String yemSrcNum = billConfig.getString("yem_srcnum");
        fileds.add(yemSrcNum + " yem_srcbillkey");
        queryFileds.add("yem_srcbillkey");
        String yemSrcIdNum = billConfig.getString("yem_srcidnum");
        fileds.add(yemSrcIdNum + " yem_srcbillid");
        queryFileds.add("yem_srcbillid");
        String yemSrcBillnoNum = billConfig.getString("yem_srcbillnonum");
        fileds.add(yemSrcBillnoNum + " yem_srcbillno");
        queryFileds.add("yem_srcbillno");
        String yemSrcEntityIdNum = billConfig.getString("yem_srcentityidnum");
        fileds.add(yemSrcEntityIdNum + " yem_srcbillentryid");
        queryFileds.add("yem_srcbillentryid");
        String yemMainBillNum = billConfig.getString("yem_mainbillnum");
        fileds.add(yemMainBillNum + " yem_mainbillKey");
        queryFileds.add("yem_mainbillKey");
        String yemMainBillno = billConfig.getString("yem_mainbillnonum");
        fileds.add(yemMainBillno + " yem_mainbillno");
        queryFileds.add("yem_mainbillno");
        String yemMainBillId = billConfig.getString("yem_mainbillidnum");
        fileds.add(yemMainBillId + " yem_mainbillid");
        queryFileds.add("yem_mainbillid");
        String yemMainBillEntryId = billConfig.getString("yem_maientityidnum");
        fileds.add(yemMainBillEntryId + " yem_mainbillentryid");
        queryFileds.add("yem_mainbillentryid");
        for (DynamicObject object : ppwd) {
            String yemEntityFieldid = object.getString("yem_entityfieldid");
            DynamicObject yemMatchfield = object.getDynamicObject("yem_matchfieldlib");
            if (YEM.isEmpty((Object)yemEntityFieldid) || YEM.isEmpty((Object)yemMatchfield)) continue;
            fileds.add(yemEntityFieldid + " " + yemMatchfield.getString("number"));
            queryFileds.add(yemMatchfield.getString("number"));
        }
        String yemQtyfiledkeys = billConfig.getString("yem_qtyfiledkeys");
        StringBuilder qtyfiledkey = new StringBuilder(yemQtyfiledkeys);
        DynamicObjectCollection cxsjy = billConfig.getDynamicObjectCollection("yem_pa_cxppdjpz_cxsjy");
        for (DynamicObject entry : cxsjy) {
            String yemQentityfieldid = entry.getString("yem_qentityfieldid");
            if (YEM.isEmpty((Object)yemQentityfieldid)) continue;
            qtyfiledkey.append(" - ").append(yemQentityfieldid);
        }
        qtyfiledkey.append(" qty");
        fileds.add(qtyfiledkey.toString());
        queryFileds.add("qty");
        String billKey = billConfig.getString("number");
        DataSet dataSet = ORM.create().queryDataSet(aigoKey, billKey, String.join((CharSequence)",", fileds), qFilters.toArray(new QFilter[0]));
        dataSet = dataSet.where("qty > 0");
        DynamicObjectCollection matchrelationCol = ORM.create().toPlainDynamicObjectCollection(dataSet.copy());
        List idList = matchrelationCol.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        List entryIdList = matchrelationCol.stream().map(x -> x.getLong("entryid")).collect(Collectors.toList());
        qFilters.clear();
        qFilters.add(new QFilter("yem_procurebill.number", "=", (Object)billKey));
        qFilters.add(new QFilter("yem_procurebillid", "in", idList));
        qFilters.add(new QFilter("yem_procurebillrowid", "in", entryIdList));
        qFilters.add(new QFilter("yem_iscomputing", "=", (Object)false));
        qFilters.add(new QFilter("yem_newmatchqty", ">=", (Object)BigDecimal.ZERO));
        DataSet matchRelationData = ORM.create().queryDataSet(aigoKey, matchRelation, "yem_procurebillid,yem_procurebillrowid,yem_newmatchqty yem_matchqty", qFilters.toArray(new QFilter[0]));
        matchRelationData = matchRelationData.groupBy(new String[]{"yem_procurebillid", "yem_procurebillrowid"}).sum("yem_matchqty").finish();
        DataSet resultDataSet = dataSet.leftJoin(matchRelationData).on("id", "yem_procurebillid").on("entryid", "yem_procurebillrowid").select(RptUtil.getDataSetFiledAlias((DataSet)dataSet), new String[]{"yem_matchqty"}).finish();
        DynamicObjectCollection resultCol = ORM.create().toPlainDynamicObjectCollection(resultDataSet);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (DynamicObject object : resultCol) {
            BigDecimal matchQty;
            BigDecimal qty = object.getBigDecimal("qty");
            BigDecimal inventoryQty = qty.subtract(matchQty = object.getBigDecimal("yem_matchqty"));
            if (BigDecimal.ZERO.compareTo(inventoryQty) >= 0) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("yem_qty", inventoryQty);
            for (String filed : queryFileds) {
                data.put(filed, object.get(filed));
            }
            data.put("billconfig", billConfig);
            result.add(data);
        }
        return result;
    }

    public static Map<String, List<DynamicObject>> queryInventoryScope() {
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>();
        Map<String, List<String>> businessNode = MatchInventoryUtils.queryBusinessNode(true);
        QFilter qfilter = new QFilter("enable", "=", (Object)"1");
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        qfilter.and(new QFilter("group.number", "=", (Object)"CG"));
        qfilter.and(new QFilter("yem_isbusbill", "=", (Object)true));
        String selectfields = DynamicObjectUtil.getSelectfields((String)matchBillConfig, (boolean)true);
        selectfields = DynamicObjectUtil.getEntrySelectfields((String)selectfields, (String)matchBillConfig, (String)"yem_pa_cxppdjpz_ppwd", (boolean)false);
        selectfields = DynamicObjectUtil.getEntrySelectfields((String)selectfields, (String)matchBillConfig, (String)"yem_pa_cxppdjpz_cxsjy", (boolean)false);
        Set<String> nodegrades = businessNode.keySet();
        for (String nodegrade : nodegrades) {
            List<String> nodeNumber = businessNode.get(nodegrade);
            QFilter filter = new QFilter("yem_inventorynode.number", "in", nodeNumber);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)matchBillConfig, (String)selectfields, (QFilter[])new QFilter[]{filter, qfilter});
            result.put(nodegrade, Arrays.asList(load));
        }
        return result;
    }

    public static Map<String, List<String>> queryBusinessNode(Boolean isPur) {
        ArrayList<QFilter> qfilter = new ArrayList<QFilter>();
        qfilter.add(new QFilter("enable", "=", (Object)"1"));
        qfilter.add(new QFilter("status", "=", (Object)"C"));
        String groupNUmber = isPur != false ? "CG" : "XS";
        qfilter.add(new QFilter("group.number", "=", (Object)groupNUmber));
        DataSet data = ORM.create().queryDataSet(algoKey, "yem_pa_businessnode", "number,yem_nodegrade", qfilter.toArray(new QFilter[0]));
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        DynamicObjectCollection col = ORM.create().toPlainDynamicObjectCollection(data.copy());
        for (DynamicObject obj : col) {
            String yemNodegrade = obj.getString("yem_nodegrade");
            List<String> numbers = new ArrayList<String>();
            if (result.containsKey(yemNodegrade)) {
                numbers = (List)result.get(yemNodegrade);
            }
            numbers.add(obj.getString("number"));
            result.put(yemNodegrade, numbers);
        }
        return result;
    }

    public static List<QFilter> getBillConfigFilter(DynamicObject billConfig) {
        FilterCondition filterCondition;
        ArrayList<QFilter> result = new ArrayList<QFilter>();
        String yemFiltergird = billConfig.getString("yem_filtergird");
        String configNumber = billConfig.getString("number");
        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)configNumber);
        if (!StringUtils.isBlank((CharSequence)yemFiltergird) && (filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)yemFiltergird, FilterCondition.class)) != null) {
            FilterBuilder fBuilder = new FilterBuilder(billType, filterCondition);
            fBuilder.buildFilter();
            result.addAll(fBuilder.getQFilters());
        }
        return result;
    }

    public static DynamicObject createMatchRelation(Map<String, Object> data, String matchendNumber, String scenario) {
        DynamicObject matchRelationBill = BusinessDataServiceHelper.newDynamicObject((String)matchRelation);
        matchRelationBill.set("billstatus", (Object)"A");
        matchRelationBill.set("org", data.get("yem_org"));
        matchRelationBill.set("yem_matchtime", (Object)new Date());
        matchRelationBill.set("yem_materiel", data.get("yem_materiel"));
        matchRelationBill.set("yem_unit", data.get("yem_unit"));
        matchRelationBill.set("yem_matchqty", data.get("yem_pqty"));
        matchRelationBill.set("yem_newmatchqty", data.get("yem_pqty"));
        matchRelationBill.set("yem_scenario", (Object)scenario);
        DynamicObject[] matchends = BusinessDataServiceHelper.load((String)"yem_pa_matchend", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)matchendNumber)});
        if (matchends.length > 0) {
            matchRelationBill.set("yem_pa_matchend", (Object)matchends[0]);
        }
        matchRelationBill.set("yem_ischang", data.get("yem_ischang"));
        matchRelationBill.set("yem_iscomputing", (Object)false);
        DynamicObject pBusinessnode = (DynamicObject)data.get("yem_businessnode_p");
        pBusinessnode = BusinessDataServiceHelper.loadSingle((Object)pBusinessnode.getPkValue(), (String)pBusinessnode.getDynamicObjectType().getName());
        matchRelationBill.set("yem_businessnode_p", (Object)pBusinessnode);
        matchRelationBill.set("yem_batchno", data.get("yem_batchno"));
        matchRelationBill.set("yem_warehouse", data.get("yem_warehouse"));
        matchRelationBill.set("yem_procurebill", data.get("yem_procurebill"));
        matchRelationBill.set("yem_procurebillno", data.get("yem_procurebillno"));
        matchRelationBill.set("yem_procurebillid", data.getOrDefault("yem_procurebillid", 0L));
        matchRelationBill.set("yem_procurebillrowid", data.getOrDefault("yem_procurebillrowid", 0L));
        if ("1".equals(pBusinessnode.getString("yem_nodegrade"))) {
            matchRelationBill.set("yem_mainbillkey_p", ((DynamicObject)data.get("yem_procurebill")).get("number"));
            matchRelationBill.set("yem_mainbillno_p", data.get("yem_procurebillno"));
            matchRelationBill.set("yem_mainbillid_p", data.getOrDefault("yem_procurebillid", 0L));
            matchRelationBill.set("yem_mainbillentryid_p", data.getOrDefault("yem_procurebillrowid", 0L));
        } else {
            matchRelationBill.set("yem_mainbillkey_p", data.get("yem_mainbillkey_p"));
            matchRelationBill.set("yem_mainbillno_p", data.get("yem_mainbillno_p"));
            matchRelationBill.set("yem_mainbillid_p", data.getOrDefault("yem_mainbillid_p", 0L));
            matchRelationBill.set("yem_mainbillentryid_p", data.getOrDefault("yem_mainbillentryid_p", 0L));
        }
        matchRelationBill.set("yem_srcbillkey_p", data.get("yem_srcbillkey_p"));
        matchRelationBill.set("yem_srcbillno_p", data.get("yem_srcbillno_p"));
        matchRelationBill.set("yem_srcbillid_p", data.getOrDefault("yem_srcbillid_p", 0L));
        matchRelationBill.set("yem_srcbillentryid_p", data.getOrDefault("yem_srcbillentryid_p", 0L));
        DynamicObject sBusinessnode = (DynamicObject)data.get("yem_businessnode_s");
        sBusinessnode = BusinessDataServiceHelper.loadSingle((Object)sBusinessnode.getPkValue(), (String)sBusinessnode.getDynamicObjectType().getName());
        matchRelationBill.set("yem_businessnode_s", (Object)sBusinessnode);
        matchRelationBill.set("yem_salebill", data.get("yem_salebill"));
        matchRelationBill.set("yem_salebillno", data.get("yem_salebillno"));
        matchRelationBill.set("yem_salebillid", data.getOrDefault("yem_salebillid", 0L));
        matchRelationBill.set("yem_salebillrowid", data.getOrDefault("yem_salebillrowid", 0L));
        if ("1".equals(sBusinessnode.getString("yem_nodegrade"))) {
            matchRelationBill.set("yem_mainbillkey_s", ((DynamicObject)data.get("yem_salebill")).get("number"));
            matchRelationBill.set("yem_mainbillno_s", data.get("yem_salebillno"));
            matchRelationBill.set("yem_mainbillid_s", data.getOrDefault("yem_salebillid", 0L));
            matchRelationBill.set("yem_mainbillentryid_s", data.getOrDefault("yem_salebillrowid", 0L));
        } else {
            matchRelationBill.set("yem_mainbillkey_s", data.get("yem_mainbillkey_s"));
            matchRelationBill.set("yem_mainbillno_s", data.get("yem_mainbillno_s"));
            matchRelationBill.set("yem_mainbillid_s", data.getOrDefault("yem_mainbillid_s", 0L));
            matchRelationBill.set("yem_mainbillentryid_s", data.getOrDefault("yem_mainbillentryid_s", 0L));
        }
        matchRelationBill.set("yem_srcbillkey_s", data.get("yem_srcbillkey_s"));
        matchRelationBill.set("yem_srcbillno_s", data.get("yem_srcbillno_s"));
        matchRelationBill.set("yem_srcbillid_s", data.getOrDefault("yem_srcbillid_s", 0L));
        matchRelationBill.set("yem_srcbillentryid_s", data.getOrDefault("yem_srcbillentryid_s", 0L));
        return matchRelationBill;
    }

    private DynamicObject mapGetOrDefaultDyn(Map<String, Object> data, String key) {
        DynamicObject result = null;
        if (data.containsKey(key)) {
            result = (DynamicObject)data.get(key);
        }
        return result;
    }

    public static DynamicObject createMinusMatchRelation(Boolean ispur, Long matchRelationId, BigDecimal computingQty, String thisBillKey, Long thisBillId, Long thisBillEntryId, String scenario) {
        boolean exists = QueryServiceHelper.exists((String)matchRelation, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)matchRelationId)});
        if (!exists) {
            return null;
        }
        DynamicObject matchRelationBill = BusinessDataServiceHelper.loadSingle((Object)matchRelationId, (String)matchRelation);
        OperationResult chargeoff = OperationServiceHelper.executeOperate((String)"chargeoff", (String)matchRelation, (DynamicObject[])new DynamicObject[]{matchRelationBill}, (OperateOption)OperateOption.create());
        if (chargeoff.isSuccess()) {
            List successPkIds = chargeoff.getSuccessPkIds();
            Object successPkId = successPkIds.get(0);
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("yem_srcbillid", "=", successPkId));
            filters.add(new QFilter("yem_iscomputing", "=", (Object)true));
            filters.add(new QFilter("yem_newmatchqty", "=", (Object)BigDecimal.ZERO));
            boolean exist = QueryServiceHelper.exists((String)matchRelation, (QFilter[])filters.toArray(new QFilter[0]));
            if (!exist) {
                return null;
            }
            DynamicObject chargeoffBill = BusinessDataServiceHelper.loadSingle((String)matchRelation, (QFilter[])filters.toArray(new QFilter[0]));
            chargeoffBill.set("billstatus", (Object)"A");
            chargeoffBill.set("yem_matchtime", (Object)new Date());
            chargeoffBill.set("yem_matchqty", (Object)computingQty);
            chargeoffBill.set("yem_newmatchqty", (Object)computingQty);
            chargeoffBill.set("yem_computbillkeysale", (Object)thisBillKey);
            chargeoffBill.set("yem_computbillidsale", (Object)thisBillId);
            chargeoffBill.set("yem_computingidsale", (Object)thisBillEntryId);
            chargeoffBill.set("yem_scenario", (Object)scenario);
            return chargeoffBill;
        }
        return null;
    }

    public static Boolean unMatchRelation(Boolean isPur, String billKey, Long billId, Long billEntryID) {
        QFilter filter = null;
        if (isPur.booleanValue()) {
            filter = new QFilter("yem_procurebill.number", "=", (Object)billKey);
            filter = filter.and(new QFilter("yem_procurebillid", "=", (Object)billId));
            filter = filter.and(new QFilter("yem_procurebillrowid", "=", (Object)billEntryID));
        } else {
            filter = new QFilter("yem_salebill.number", "=", (Object)billKey);
            filter = filter.and(new QFilter("yem_salebillid", "=", (Object)billId));
            filter = filter.and(new QFilter("yem_salebillrowid", "=", (Object)billEntryID));
        }
        DynamicObject[] billRelation = BusinessDataServiceHelper.load((String)matchRelation, (String)"id", (QFilter[])new QFilter[]{filter});
        filter = new QFilter("yem_iscomputing", "=", (Object)true);
        filter = isPur != false ? filter.and(new QFilter("yem_computingidpur", "=", (Object)billEntryID)) : filter.and(new QFilter("yem_computingidsale", "=", (Object)billEntryID));
        DynamicObject[] srcRelation = BusinessDataServiceHelper.load((String)matchRelation, (String)"id", (QFilter[])new QFilter[]{filter});
        ArrayList<Long> datas = new ArrayList<Long>();
        for (DynamicObject bill : billRelation) {
            datas.add(bill.getLong("id"));
        }
        for (DynamicObject bill : srcRelation) {
            datas.add(bill.getLong("id"));
        }
        OperateOption operateOption = OperateOption.create();
        OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)matchRelation, (Object[])datas.toArray(), (OperateOption)OperateOption.create());
        return deleteResult.isSuccess();
    }

    public Map<String, Object> getNodeInformation(DynamicObject NodeConfiguration, DynamicObject dataEntity, Long entryRowId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, String> fieldnum = new HashMap<String, String>();
        fieldnum.put(NodeConfiguration.getString("yem_qtyfiledkeys"), "yem_qty");
        fieldnum.put(NodeConfiguration.getString("yem_srcnum"), "yem_srcbillkey_s");
        fieldnum.put(NodeConfiguration.getString("yem_srcbillnonum"), "yem_srcbillno_s");
        fieldnum.put(NodeConfiguration.getString("yem_srcidnum"), "yem_srcbillid_s");
        fieldnum.put(NodeConfiguration.getString("yem_srcentityidnum"), "yem_srcbillentryid_s");
        fieldnum.put(NodeConfiguration.getString("yem_mainbillnum"), "yem_mainbillkey_s");
        fieldnum.put(NodeConfiguration.getString("yem_mainbillnonum"), "yem_mainbillno_s");
        fieldnum.put(NodeConfiguration.getString("yem_mainbillidnum"), "yem_mainbillid_s");
        fieldnum.put(NodeConfiguration.getString("yem_maientityidnum"), "yem_mainbillentryid_s");
        for (DynamicObject dynamicObject : NodeConfiguration.getDynamicObjectCollection("yem_pa_cxppdjpz_ppwd")) {
            String yemQentityfieldid = dynamicObject.getString("yem_entityfieldid");
            String fieldkey = dynamicObject.getDynamicObject("yem_matchfieldlib").getString("number");
            fieldnum.put(yemQentityfieldid, fieldkey);
        }
        for (String entityfield : fieldnum.keySet()) {
            String[] split = entityfield.split("\\.");
            String firstPart = split.length > 0 ? split[0] : null;
            String lastPart = split.length > 0 ? split[split.length - 1] : null;
            String fieldkey = (String)fieldnum.get(entityfield);
            if (!firstPart.equals(lastPart)) {
                DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection(firstPart);
                for (DynamicObject row : entry) {
                    resultMap.put(fieldkey, row.get(lastPart));
                }
            }
            if (!firstPart.equals(lastPart)) continue;
            resultMap.put(fieldkey, dataEntity.get(lastPart));
        }
        return resultMap;
    }

    public static Map<String, Object> createNodeInfo(DynamicObject matchConfig, DynamicObject entity, Long entryRowId) {
        DynamicObject group = matchConfig.getDynamicObject("group");
        if (YEM.isEmpty((Object)group)) {
            return null;
        }
        String groupid = group.getString("number");
        String ps = "XS".equals(groupid) ? "s" : "p";
        String saleOrProcure = "XS".equals(groupid) ? "sale" : "procure";
        HashMap<String, Object> relationship = new HashMap<String, Object>();
        relationship.put("yem_srcbillkey_" + ps, matchConfig.getString("yem_srcnum"));
        relationship.put("yem_srcbillno_" + ps, matchConfig.getString("yem_srcbillnonum"));
        relationship.put("yem_srcbillid_" + ps, matchConfig.getString("yem_srcidnum"));
        relationship.put("yem_srcbillentryid_" + ps, matchConfig.getString("yem_srcentityidnum"));
        relationship.put("yem_mainbillkey_" + ps, matchConfig.getString("yem_mainbillnum"));
        relationship.put("yem_mainbillno_" + ps, matchConfig.getString("yem_mainbillnonum"));
        relationship.put("yem_mainbillid_" + ps, matchConfig.getString("yem_mainbillidnum"));
        relationship.put("yem_mainbillentryid_" + ps, matchConfig.getString("yem_maientityidnum"));
        if ("XS".equals(groupid)) {
            relationship.put("yem_pqty", matchConfig.getString("yem_qtyfiledkeys"));
        }
        for (DynamicObject dynamicObject : matchConfig.getDynamicObjectCollection("yem_pa_cxppdjpz_ppwd")) {
            String fieldkey = dynamicObject.getDynamicObject("yem_matchfieldlib").getString("number");
            String fieldId = dynamicObject.getString("yem_entityfieldid");
            relationship.put(fieldkey, fieldId);
        }
        String materielField = (String)relationship.get("yem_materiel");
        String entryField = materielField.substring(0, materielField.indexOf("."));
        DynamicObjectCollection entry = entity.getDynamicObjectCollection(entryField);
        Optional<DynamicObject> infoOptional = entry.stream().filter(entryRow -> entryRow.getLong("id") == entryRowId.longValue()).findFirst();
        DynamicObject row = infoOptional.orElse(null);
        if (YEM.isEmpty((Object)row)) {
            return null;
        }
        relationship.forEach((key, value) -> {
            String field = (String)value;
            if (field.isEmpty()) {
                relationship.put((String)key, null);
                return;
            }
            if (field.contains(".")) {
                DynamicObject object;
                field = field.substring(field.indexOf(".") + 1);
                relationship.put((String)key, row.get(field));
                if ("yem_materiel".equals(key) && !"bd_materiel".equals((object = row.getDynamicObject(field)).getDynamicObjectType().getName())) {
                    relationship.put((String)key, object.get("masterid"));
                }
            } else {
                relationship.put((String)key, entity.get(field));
            }
        });
        relationship.put("yem_" + saleOrProcure + "billno", entity.get("billno"));
        relationship.put("yem_" + saleOrProcure + "billid", entity.get("id"));
        relationship.put("yem_" + saleOrProcure + "billrowid", row.get("id"));
        relationship.put("yem_businessnode_" + ps, matchConfig.getDynamicObject("yem_inventorynode"));
        relationship.put("yem_" + saleOrProcure + "bill", matchConfig);
        return relationship;
    }
}

