/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pa.shmjs.distribution.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.StringUtils;
import yem.base.common.utils.YEM;
import yem.wm.pa.shmjs.utils.MatchInventoryUtils;

public class DistributionBillPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"yem_advcontoolbarap"});
        AbstractGrid ppxxGrid = (AbstractGrid)this.getControl("yem_pa_cxppph_ppxx");
        ppxxGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.init();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.matchFunctionInit();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "yem_thismatchqtyk": 
            case "yem_thisreleaseqtyk": {
                this.verifyYpqtyk(e.getChangeSet());
                break;
            }
            case "uav6_check": {
                this.checkChanged(e.getChangeSet()[0]);
            }
        }
    }

    private void checkChanged(ChangeData change) {
        Boolean ischeck = (Boolean)change.getNewValue();
        int rowIndex = change.getRowIndex();
        if (ischeck.booleanValue()) {
            BigDecimal qtyk = (BigDecimal)this.getModel().getValue("yem_qtyk", rowIndex);
            this.getModel().setValue("yem_thismatchqtyk", (Object)qtyk, rowIndex);
        } else {
            this.getModel().setValue("yem_thismatchqtyk", (Object)BigDecimal.ZERO, rowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        IFormView view = this.getView();
        switch (operateKey) {
            case "cxppph_sgpp": {
                this.verifyInfoQty(args, view);
                break;
            }
            case "confirm": {
                this.checkInventory(args);
                this.availableStockMatchCheck(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        switch (operateKey) {
            case "confirm": {
                this.confirmOp(e);
                this.getView().close();
                break;
            }
        }
        this.itemClick(operateKey);
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        IDataModel model = this.getModel();
        int row = evt.getRow();
        if (row == -1) {
            return;
        }
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entryPpxx = dataEntity.getDynamicObjectCollection("yem_pa_cxppph_ppxx");
        DynamicObjectCollection entryKppxx = dataEntity.getDynamicObjectCollection("yem_pa_cxppph_kppkc");
        DynamicObjectCollection entrySdsf = dataEntity.getDynamicObjectCollection("yem_pa_cxppph_sdsf");
        switch (key) {
            case "yem_pa_cxppph_ppxx": {
                this.loadMatchable(row, entryPpxx, entryKppxx, entrySdsf);
            }
        }
    }

    public void itemClick(String itemKey) {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        EntryGrid entryPpxxGrid = (EntryGrid)this.getControl("yem_pa_cxppph_ppxx");
        int[] selectRows = entryPpxxGrid.getSelectRows();
        DynamicObjectCollection entryKppkcentry = dataEntity.getDynamicObjectCollection("yem_pa_cxppph_kppkc");
        DynamicObjectCollection ppxxEntry = dataEntity.getDynamicObjectCollection("yem_pa_cxppph_ppxx");
        DynamicObjectCollection sdsfEntry = dataEntity.getDynamicObjectCollection("yem_pa_cxppph_sdsf");
        if (selectRows.length == 0) {
            return;
        }
        switch (itemKey) {
            case "cxppph_sgpp": {
                DynamicObject ppxx = (DynamicObject)ppxxEntry.get(selectRows[0]);
                ArrayList<Integer> deleteEntry = new ArrayList<Integer>();
                BigDecimal yemQty = ppxx.getBigDecimal("yem_qty");
                BigDecimal pqty = ppxx.getBigDecimal("yem_pqty");
                long matchids = ppxx.getLong("yem_matchid");
                BigDecimal newqty = BigDecimal.ZERO;
                Map<Long, BigDecimal> map = this.releaseqty(entryKppkcentry);
                if (pqty.compareTo(BigDecimal.ZERO) > 0) {
                    this.replacement(pqty, matchids);
                }
                for (DynamicObject entryKppkc : entryKppkcentry) {
                    BigDecimal rowqty;
                    int i = entryKppkcentry.indexOf((Object)entryKppkc);
                    BigDecimal yemQtyk = entryKppkc.getBigDecimal("yem_qtyk");
                    BigDecimal yemThismatchqtyk = entryKppkc.getBigDecimal("yem_thismatchqtyk");
                    newqty = newqty.add(yemThismatchqtyk);
                    BigDecimal yemThisreleaseqtyk = entryKppkc.getBigDecimal("yem_thisreleaseqtyk");
                    Long yemMatchidk = entryKppkc.getLong("yem_matchidk");
                    Long yemProcurebillrowidk = entryKppkc.getLong("yem_procurebillrowidk");
                    BigDecimal qty = yemThismatchqtyk.add(yemThisreleaseqtyk);
                    if (qty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    if (qty.compareTo(yemQtyk) == 0) {
                        this.addSdsfRow(yemMatchidk, ppxx, yemThismatchqtyk, yemProcurebillrowidk, map);
                        if (yemThismatchqtyk.compareTo(BigDecimal.ZERO) <= 0 || null == yemThismatchqtyk) continue;
                        this.updateyppxxinfo(ppxx, yemThismatchqtyk, entryKppkc);
                        rowqty = yemQty.subtract(newqty);
                        ppxx.set("yem_qty", (Object)yemThismatchqtyk);
                        ppxx = this.copyppxxrow(ppxxEntry, ppxx, rowqty);
                        deleteEntry.add(i);
                        continue;
                    }
                    if (qty.compareTo(yemQtyk) >= 0) continue;
                    this.addSdsfRow(yemMatchidk, ppxx, yemThismatchqtyk, yemProcurebillrowidk, map);
                    if (yemThismatchqtyk.compareTo(BigDecimal.ZERO) > 0 && null != yemThismatchqtyk) {
                        this.updateyppxxinfo(ppxx, yemThismatchqtyk, entryKppkc);
                        rowqty = yemQty.subtract(newqty);
                        ppxx.set("yem_qty", (Object)yemThismatchqtyk);
                        ppxx = this.copyppxxrow(ppxxEntry, ppxx, rowqty);
                    }
                    model.setValue("yem_thismatchqtyk", (Object)BigDecimal.ZERO, i);
                    model.setValue("yem_thisreleaseqtyk", (Object)BigDecimal.ZERO, i);
                    model.setValue("yem_qtyk", (Object)yemQtyk.subtract(qty), i);
                }
                this.deletekppxx(deleteEntry, view);
                this.mergePpxx(dataEntity);
                this.mergesdsf(dataEntity);
                view.updateView();
                break;
            }
            case "cxppph_qxpp": {
                DynamicObjectCollection entryPpxx = dataEntity.getDynamicObjectCollection("yem_pa_cxppph_ppxx");
                DynamicObjectCollection entryKppxx = dataEntity.getDynamicObjectCollection("yem_pa_cxppph_kppkc");
                DynamicObjectCollection entrySdsf = dataEntity.getDynamicObjectCollection("yem_pa_cxppph_sdsf");
                for (int selectRow : selectRows) {
                    DynamicObject ppxxRow = (DynamicObject)ppxxEntry.get(selectRow);
                    BigDecimal yemPqty = ppxxRow.getBigDecimal("yem_pqty");
                    long matchid = ppxxRow.getLong("yem_matchid");
                    long procurebillid = ppxxRow.getLong("yem_procurebillid");
                    long procurebillrowid = ppxxRow.getLong("yem_procurebillrowid");
                    ArrayList indexList = new ArrayList();
                    Boolean remain = false;
                    long matchidk = 0L;
                    Boolean matchidflag = false;
                    ArrayList<Integer> index = new ArrayList<Integer>();
                    for (DynamicObject Kppkcentry : entryKppkcentry) {
                        long procurebillrowidk = Kppkcentry.getLong("yem_procurebillrowidk");
                        if (procurebillrowid != procurebillrowidk) continue;
                        Boolean flag = false;
                        for (DynamicObject sdsfRow : sdsfEntry) {
                            matchidk = Kppkcentry.getLong("yem_matchidk");
                            int yemPpxxindex = sdsfRow.getInt("yem_ppxxindex");
                            if (yemPpxxindex - 1 != selectRow || matchidk != matchid) continue;
                            flag = true;
                            remain = true;
                            matchidflag = true;
                            BigDecimal reversaQty = sdsfRow.getBigDecimal("yem_reversaqty");
                            Kppkcentry.set("yem_qtyk", (Object)Kppkcentry.getBigDecimal("yem_qtyk").add(reversaQty));
                            int i = sdsfEntry.indexOf((Object)sdsfRow);
                            index.add(i);
                        }
                        if (flag.booleanValue() || matchid != 0L) continue;
                        Kppkcentry.set("yem_qtyk", (Object)Kppkcentry.getBigDecimal("yem_qtyk").add(yemPqty));
                    }
                    if (remain.booleanValue()) {
                        for (Integer i : index) {
                            this.getModel().deleteEntryRow("yem_pa_cxppph_sdsf", i.intValue());
                        }
                    }
                    model.setValue("yem_pqty", null, selectRow);
                    model.setValue("yem_batchno", null, selectRow);
                    model.setValue("yem_pwarehouse", null, selectRow);
                    model.setValue("yem_businessnode_p", null, selectRow);
                    model.setValue("yem_procurebill", null, selectRow);
                    model.setValue("yem_procurebillno", null, selectRow);
                    model.setValue("yem_mainbillno_p", null, selectRow);
                    model.setValue("yem_procurebillid", null, selectRow);
                    model.setValue("yem_mainbillid_p", null, selectRow);
                    model.setValue("yem_mainbillkey_p", null, selectRow);
                    model.setValue("yem_mainbillentryid_p", null, selectRow);
                    model.setValue("yem_matchid", null, selectRow);
                    model.setValue("yem_procurebillrowid", null, selectRow);
                    if (matchid == 0L || matchidflag.booleanValue()) continue;
                    this.replacement(yemPqty, matchid);
                }
                this.mergePpxx(dataEntity);
                this.mergesdsf(dataEntity);
                view.updateView();
                break;
            }
            case "cxppph_sx": {
                this.getModel().deleteEntryData("yem_pa_cxppph_ppxx");
                this.getModel().deleteEntryData("yem_pa_cxppph_kppkc");
                this.init();
            }
        }
        DistributionBillPlugin.entrySort(entryKppkcentry, model, view, "yem_pa_cxppph_kppkc");
    }

    private void mergePpxx(DynamicObject dataEntity) {
        DynamicObjectCollection ppxxEntry = dataEntity.getDynamicObjectCollection("yem_pa_cxppph_ppxx");
        HashMap<String, EntryData> resultMap = new HashMap<String, EntryData>();
        HashSet<DynamicObject> deleteInfo = new HashSet<DynamicObject>();
        for (int i = 0; i < ppxxEntry.size(); ++i) {
            DynamicObject ppxxRow = (DynamicObject)ppxxEntry.get(i);
            long billentryid = ppxxRow.getLong("yem_billentryid");
            long procurebillrowid = ppxxRow.getLong("yem_procurebillrowid");
            BigDecimal yemPqty = ppxxRow.getBigDecimal("yem_pqty");
            BigDecimal yemQty = ppxxRow.getBigDecimal("yem_qty");
            String key = billentryid + "_" + procurebillrowid;
            if (!resultMap.containsKey(key)) {
                resultMap.put(key, new EntryData(i, yemPqty, yemQty));
                continue;
            }
            deleteInfo.add(ppxxRow);
            EntryData entry2 = (EntryData)resultMap.get(key);
            entry2.quantity = entry2.quantity.add(yemPqty);
            entry2.qty = entry2.qty.add(yemQty);
            ((DynamicObject)ppxxEntry.get(((EntryData)resultMap.get((Object)key)).index)).set("yem_matchid", null);
        }
        ArrayList resultList = new ArrayList(resultMap.values());
        Collections.sort(resultList, Comparator.comparingInt(entry -> entry.index));
        for (EntryData entryData : resultList) {
            ((DynamicObject)ppxxEntry.get(entryData.index)).set("yem_pqty", (Object)entryData.quantity);
            ((DynamicObject)ppxxEntry.get(entryData.index)).set("yem_qty", (Object)entryData.qty);
        }
        deleteInfo.forEach(arg_0 -> ((DynamicObjectCollection)ppxxEntry).remove(arg_0));
    }

    private void mergesdsf(DynamicObject dataEntity) {
        DynamicObjectCollection ppxxEntry = dataEntity.getDynamicObjectCollection("yem_pa_cxppph_ppxx");
        DynamicObjectCollection sdsfEntry = dataEntity.getDynamicObjectCollection("yem_pa_cxppph_sdsf");
        HashMap<String, EntryData> resultMap = new HashMap<String, EntryData>();
        HashSet<DynamicObject> deleteInfo = new HashSet<DynamicObject>();
        for (int i = 0; i < sdsfEntry.size(); ++i) {
            DynamicObject sdsfRow = (DynamicObject)sdsfEntry.get(i);
            long billentryid = sdsfRow.getLong("yem_nodebillentryid");
            long procurebillrowid = sdsfRow.getLong("yem_procurerowidk");
            BigDecimal yemPqty = sdsfRow.getBigDecimal("yem_reversaqty");
            long matchingid = sdsfRow.getLong("yem_matchingid");
            int ppxxindex = sdsfRow.getInt("yem_ppxxindex");
            String key = billentryid + "_" + procurebillrowid + "_" + matchingid;
            if (!resultMap.containsKey(key)) {
                resultMap.put(key, new EntryData(ppxxindex, yemPqty, BigDecimal.ZERO));
                continue;
            }
            deleteInfo.add(sdsfRow);
            EntryData entry2 = (EntryData)resultMap.get(key);
            entry2.quantity = entry2.quantity.add(yemPqty);
        }
        ArrayList resultList = new ArrayList(resultMap.values());
        Collections.sort(resultList, Comparator.comparingInt(entry -> entry.index));
        for (EntryData entryData : resultList) {
            for (DynamicObject sdsfRow : sdsfEntry) {
                long rocurerowidk = sdsfRow.getLong("yem_procurerowidk");
                int yemPpxxindex = sdsfRow.getInt("yem_ppxxindex");
                if (yemPpxxindex == entryData.index) {
                    sdsfRow.set("yem_reversaqty", (Object)entryData.quantity);
                }
                for (DynamicObject ppxxRow : ppxxEntry) {
                    long procurebillrowid = ppxxRow.getLong("yem_procurebillrowid");
                    if (rocurerowidk != procurebillrowid) continue;
                    long matchid = ppxxRow.getLong("yem_matchid");
                    if (YEM.isEmpty((Object)matchid)) {
                        deleteInfo.add(sdsfRow);
                        continue;
                    }
                    sdsfRow.set("yem_ppxxindex", (Object)ppxxEntry.indexOf((Object)ppxxRow));
                }
            }
        }
        deleteInfo.forEach(arg_0 -> ((DynamicObjectCollection)sdsfEntry).remove(arg_0));
    }

    public static void entrySort(DynamicObjectCollection zxxx, IDataModel model, IFormView view, String billname) {
        boolean swapped;
        do {
            swapped = false;
            for (int j = 0; j < zxxx.size() - 1; ++j) {
                String current = ((DynamicObject)zxxx.get(j)).getString("yem_inventorydatatype");
                String next = ((DynamicObject)zxxx.get(j + 1)).getString("yem_inventorydatatype");
                if (current.equals("B") && next.equals("A")) {
                    model.moveEntryRowDown(billname, j);
                    swapped = true;
                    continue;
                }
                if (!current.equals("A") || next.equals("A") || next.equals("B")) continue;
                model.moveEntryRowUp(billname, j + 1);
                swapped = true;
            }
        } while (swapped);
        view.updateView(billname);
    }

    private void replacement(BigDecimal yemPqty, Long matchid) {
        IDataModel model = this.getModel();
        DynamicObject match = BusinessDataServiceHelper.loadSingle((String)"yem_pa_matchrelation", (QFilter[])new QFilter("id", "=", (Object)matchid).toArray());
        if (!YEM.isEmpty((Object)match)) {
            int seq = model.createNewEntryRow("yem_pa_cxppph_kppkc");
            long yemProcurebillrowid = match.getLong("yem_procurebillrowid");
            long yemProcurebillid = match.getLong("yem_procurebillid");
            DynamicObject yemProcurebill = match.getDynamicObject("yem_procurebill");
            DynamicObject yemPaInventorybills = BusinessDataServiceHelper.loadSingle((String)"yem_pa_inventorybills", (QFilter[])new QFilter("id", "=", yemProcurebill.getPkValue()).toArray());
            String number = yemPaInventorybills.getString("number");
            DynamicObject purdataEntity = BusinessDataServiceHelper.loadSingle((String)number, (QFilter[])new QFilter("id", "=", (Object)yemProcurebillid).toArray());
            this.setYemPaCxppdjpzPpwd(yemPaInventorybills, model, 0, seq, purdataEntity, yemProcurebillrowid, "k");
            this.matchedInfo(match, model, seq, "k", "yem_newmatchqty");
            model.setValue("yem_inventorydatatype", (Object)"A", seq);
            model.setValue("yem_qtyk", (Object)yemPqty, seq);
        }
    }

    private void init() {
        IFormView view = this.getView();
        IFormView parentView = this.getView().getParentView();
        IDataModel model = view.getModel();
        IDataModel parentmodel = view.getParentView().getModel();
        String name = parentmodel.getDataEntityType().getName();
        if (YEM.isEmpty((Object)name)) {
            return;
        }
        DynamicObject yemPaInventorybills = BusinessDataServiceHelper.loadSingle((String)"yem_pa_inventorybills", (QFilter[])new QFilter("yem_nodedoc.number", "=", (Object)name).toArray());
        DynamicObjectCollection yemPaCxppdjpzPpwd = yemPaInventorybills.getDynamicObjectCollection("yem_pa_cxppdjpz_ppwd");
        this.sodeDocumentAss(model, yemPaInventorybills, parentmodel, yemPaCxppdjpzPpwd);
        Map<Integer, Long> entryMap = this.getindex(parentView, yemPaInventorybills);
        DynamicObject dataEntity = parentmodel.getDataEntity(true);
        this.creatPpxxInfo(dataEntity, model, entryMap, name, yemPaInventorybills);
        Map<Long, BigDecimal> addrow = this.addrow(model);
        Map<Long, Integer> matchedResults = this.creatMatchedResults(addrow, entryMap);
        for (Map.Entry<Long, Integer> entry : matchedResults.entrySet()) {
            Long addKey = entry.getKey();
            Integer entryKey = entry.getValue();
            int seq = model.createNewEntryRow("yem_pa_cxppph_ppxx");
            this.setYemPaCxppdjpzPpwd(yemPaInventorybills, model, entryKey, seq, dataEntity, 0L, "");
            model.setValue("yem_qty", (Object)addrow.get(addKey), seq);
        }
    }

    private void loadMatchable(int row, DynamicObjectCollection entryPpxx, DynamicObjectCollection entryKppxx, DynamicObjectCollection entrySdsf) {
        IDataModel model = this.getModel();
        this.getModel().deleteEntryData("yem_pa_cxppph_kppkc");
        this.queryUpstreamMatchQty(row, BigDecimal.ZERO);
        this.queryOtherInventory(row);
        this.Excludematchedinventory(entryPpxx, entryKppxx, entrySdsf);
    }

    private void queryOtherInventory(int row) {
        IDataModel parentmodel = this.getView().getParentView().getModel();
        IDataModel model = this.getModel();
        HashMap<String, Object> map = new HashMap<String, Object>();
        DynamicObjectCollection ppxxEntry = model.getEntryEntity("yem_pa_cxppph_ppxx");
        DynamicObject yemPaCxppphPpxx = (DynamicObject)ppxxEntry.get(row);
        map.put("specification", yemPaCxppphPpxx.getString("uav6_specification"));
        map.put("materialtype", yemPaCxppphPpxx.getString("uav6_materialtype"));
        map.put("brand", yemPaCxppphPpxx.getString("uav6_brand"));
        map.put("lotnumber", yemPaCxppphPpxx.getString("uav6_lotnumber"));
        map.put("bundlenum", yemPaCxppphPpxx.getString("uav6_bundlenum"));
        map.put("warehouse", yemPaCxppphPpxx.getDynamicObject("yem_warehouse"));
        DynamicObject entryRowInfo = (DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("yem_pa_cxppph_ppxx").get(row);
        List<String> entityFieldKeyList = DistributionBillPlugin.getEntityFieldKeyList("yem_pa_distribution", "yem_pa_cxppph_ppxx", null);
        HashMap<String, Object> fbasedataid = new HashMap<String, Object>();
        for (String entityFieldKey : entityFieldKeyList) {
            fbasedataid.put(entityFieldKey, entryRowInfo.get(entityFieldKey));
        }
        String yemStocktype = (String)parentmodel.getValue("yem_stocktype");
        if ("A".equals(yemStocktype)) {
            map.put("billstatus", "C");
            map.put("yem_contractter", false);
        }
        Map<String, List<Map<String, Object>>> stringListMap = MatchInventoryUtils.queryUsableInventory(fbasedataid, yemStocktype, map);
        TreeMap sortedMap = new TreeMap(Collections.reverseOrder());
        sortedMap.putAll(stringListMap);
        for (String level : sortedMap.keySet()) {
            List<Map<String, Object>> infoList = stringListMap.get(level);
            if (YEM.isEmpty(infoList)) continue;
            for (Map<String, Object> info : infoList) {
                int index = model.createNewEntryRow("yem_pa_cxppph_kppkc");
                block19: for (String field : info.keySet()) {
                    model.setValue("yem_inventorydatatype", (Object)"B", index);
                    String kppfield = field + "k";
                    switch (field) {
                        case "billconfig": {
                            DynamicObject bill = (DynamicObject)info.get(field);
                            model.setValue("yem_procurebillk", bill.get("id"), index);
                            model.setValue("yem_businessnode_pk", bill.get("yem_inventorynode"), index);
                            continue block19;
                        }
                        case "yem_billno": {
                            model.setValue("yem_procurebillnok", info.get(field), index);
                            continue block19;
                        }
                        case "id": {
                            model.setValue("yem_procurebillidk", info.get(field), index);
                            continue block19;
                        }
                        case "entryid": {
                            model.setValue("yem_procurebillrowidk", info.get(field), index);
                            continue block19;
                        }
                        case "yem_mainbillno": {
                            model.setValue("yem_mainbillno_pk", info.get(field), index);
                            continue block19;
                        }
                        case "yem_mainbillKey": {
                            model.setValue("yem_mainbillkey_pk", info.get(field), index);
                            continue block19;
                        }
                    }
                    entityFieldKeyList = DistributionBillPlugin.getEntityFieldKeyList("yem_pa_distribution", "yem_pa_cxppph_kppkc", new ArrayList<String>(Arrays.asList("id", "seq")));
                    if (!entityFieldKeyList.contains(kppfield)) continue;
                    model.setValue(kppfield, info.get(field), index);
                }
            }
        }
    }

    private Map<Long, BigDecimal> releaseqty(DynamicObjectCollection entryKppkcentry) {
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        for (DynamicObject entryKppkc : entryKppkcentry) {
            Long yemMatchidk = entryKppkc.getLong("yem_matchidk");
            if (YEM.isEmpty((Object)yemMatchidk)) continue;
            BigDecimal yemThisreleaseqtyk = entryKppkc.getBigDecimal("yem_thisreleaseqtyk");
            map.put(yemMatchidk, yemThisreleaseqtyk);
        }
        return map;
    }

    private void deletekppxx(List<Integer> deleteEntry, IFormView view) {
        IDataModel model = view.getModel();
        for (int i = deleteEntry.size(); i > 0; --i) {
            model.deleteEntryRow("yem_pa_cxppph_kppkc", deleteEntry.get(i - 1).intValue());
        }
    }

    private DynamicObject copyppxxrow(DynamicObjectCollection ppxxEntry, DynamicObject ppxx, BigDecimal rowqty) {
        if (rowqty.compareTo(BigDecimal.ZERO) > 0) {
            DynamicObject newPpxx = ppxxEntry.addNew();
            DynamicObjectUtil.copyDynamicObject((DynamicObject)ppxx, (DynamicObject)newPpxx, (int)2, (boolean)false, (boolean)true, (boolean)true);
            newPpxx.set("yem_qty", (Object)rowqty);
            newPpxx.set("yem_pqty", null);
            newPpxx.set("yem_businessnode_p", null);
            newPpxx.set("yem_procurebill", null);
            newPpxx.set("yem_procurebillno", null);
            newPpxx.set("yem_mainbillno_p", null);
            newPpxx.set("yem_procurebillid", null);
            newPpxx.set("yem_procurebillrowid", null);
            newPpxx.set("yem_mainbillkey_p", null);
            newPpxx.set("yem_mainbillid_p", null);
            newPpxx.set("yem_mainbillentryid_p", null);
            newPpxx.set("yem_matchid", null);
            newPpxx.set("yem_pwarehouse", null);
            newPpxx.set("yem_batchno", null);
            return newPpxx;
        }
        return null;
    }

    private void updateyppxxinfo(DynamicObject ppxx, BigDecimal yemThismatchqtyk, DynamicObject entryKppkc) {
        ppxx.set("yem_pqty", (Object)yemThismatchqtyk);
        ppxx.set("yem_businessnode_p", (Object)entryKppkc.getDynamicObject("yem_businessnode_pk"));
        ppxx.set("yem_procurebill", (Object)entryKppkc.getDynamicObject("yem_procurebillk"));
        ppxx.set("yem_procurebillno", (Object)entryKppkc.getString("yem_procurebillnok"));
        ppxx.set("yem_mainbillno_p", (Object)entryKppkc.getString("yem_mainbillno_pk"));
        ppxx.set("yem_procurebillid", (Object)entryKppkc.getLong("yem_procurebillidk"));
        ppxx.set("yem_procurebillrowid", (Object)entryKppkc.getLong("yem_procurebillrowidk"));
        ppxx.set("yem_mainbillkey_p", (Object)entryKppkc.getString("yem_mainbillkey_pk"));
        ppxx.set("yem_mainbillid_p", (Object)entryKppkc.getLong("yem_mainbillidk"));
        ppxx.set("yem_mainbillentryid_p", (Object)entryKppkc.getLong("yem_mainbillentryidk"));
        ppxx.set("yem_matchid", (Object)entryKppkc.getLong("yem_matchidk"));
        ppxx.set("yem_batchno", (Object)entryKppkc.getString("yem_batchnok"));
        DynamicObject yemWarehousek = entryKppkc.getDynamicObject("yem_warehousek");
        if (null != yemWarehousek) {
            ppxx.set("yem_pwarehouse", (Object)yemWarehousek);
        }
    }

    private void addSdsfRow(Long yemMatchidk, DynamicObject ppxx, BigDecimal qty, Long yemProcurebillrowidk, Map<Long, BigDecimal> map) {
        IDataModel model = this.getModel();
        Long billEntryId = ppxx.getLong("yem_billentryid");
        DynamicObjectCollection ppxxEntry = model.getDataEntity(true).getDynamicObjectCollection("yem_pa_cxppph_ppxx");
        int ppxxIndex = ppxxEntry.indexOf((Object)ppxx) + 1;
        BigDecimal remainQty = qty;
        if (!YEM.isEmpty((Object)yemMatchidk) && map.containsKey(yemMatchidk)) {
            int rowIndex = model.createNewEntryRow("yem_pa_cxppph_sdsf");
            model.setValue("yem_nodebillentryid", (Object)billEntryId, rowIndex);
            model.setValue("yem_matchingid", (Object)yemMatchidk, rowIndex);
            model.setValue("yem_reversaqty", (Object)remainQty, rowIndex);
            model.setValue("yem_ppxxindex", (Object)ppxxIndex, rowIndex);
            model.setValue("yem_procurerowidk", (Object)yemProcurebillrowidk, rowIndex);
        } else {
            Iterator<Map.Entry<Long, BigDecimal>> it = map.entrySet().iterator();
            while (remainQty.compareTo(BigDecimal.ZERO) > 0 && it.hasNext()) {
                Map.Entry<Long, BigDecimal> entry = it.next();
                Long currentKey = entry.getKey();
                BigDecimal available = entry.getValue();
                if (available.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal deduct = available.min(remainQty);
                int rowIndex = model.createNewEntryRow("yem_pa_cxppph_sdsf");
                model.setValue("yem_nodebillentryid", (Object)billEntryId, rowIndex);
                model.setValue("yem_matchingid", (Object)currentKey, rowIndex);
                model.setValue("yem_reversaqty", (Object)deduct, rowIndex);
                model.setValue("yem_ppxxindex", (Object)ppxxIndex, rowIndex);
                model.setValue("yem_procurerowidk", (Object)yemProcurebillrowidk, rowIndex);
                entry.setValue(available.subtract(deduct));
                remainQty = remainQty.subtract(deduct);
            }
        }
    }

    private void matchFunctionInit() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"yem_cxpp_znpp"});
        IDataModel parentModel = this.getView().getParentView().getModel();
        if (YEM.isEmpty((Object)parentModel.getDataEntity())) {
            return;
        }
        DynamicObject matchConfig = MatchInventoryUtils.getMatchBillConfig(parentModel.getDataEntityType().getName());
        if (YEM.isEmpty((Object)matchConfig)) {
            return;
        }
        boolean isOpenFunction = matchConfig.getBoolean("yem_openfunction");
        if (!isOpenFunction) {
            return;
        }
        DynamicObject group = matchConfig.getDynamicObject("group");
        if ("XS".equals(group.getString("number"))) {
            if (!"A".equals(matchConfig.getString("yem_smartmatch"))) {
                return;
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"yem_cxpp_znpp"});
        }
    }

    private void queryOtherInventory() {
    }

    private void verifyYpqtyk(ChangeData[] changeSet) {
        for (ChangeData changeData : changeSet) {
            BigDecimal thisreleaseqtyk;
            BigDecimal thismatchqtyk;
            DynamicObject kppkcRow = this.getModel().getEntryRowEntity("yem_pa_cxppph_kppkc", changeData.getRowIndex());
            BigDecimal ypqtyk = kppkcRow.getBigDecimal("yem_qtyk");
            if (ypqtyk.compareTo((thismatchqtyk = kppkcRow.getBigDecimal("yem_thismatchqtyk")).add(thisreleaseqtyk = kppkcRow.getBigDecimal("yem_thisreleaseqtyk"))) >= 0) continue;
            this.getModel().setValue("yem_thismatchqtyk", (Object)BigDecimal.ZERO);
            this.getModel().setValue("yem_thisreleaseqtyk", (Object)BigDecimal.ZERO);
            this.getView().showTipNotification("\u586b\u5199\u6570\u91cf\u8d85\u51fa\u3010\u53ef\u7528\u5e93\u5b58\u6570\u91cf\u3011\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\uff01");
        }
    }

    private void verifyInfoQty(BeforeDoOperationEventArgs args, IFormView view) {
        IDataModel model = view.getModel();
        EntryGrid entryPpxx = (EntryGrid)this.getControl("yem_pa_cxppph_ppxx");
        int[] selectRows = entryPpxx.getSelectRows();
        if (selectRows.length == 0) {
            view.showTipNotification("\u8bf7\u9009\u62e9\u5339\u914d\u4fe1\u606f\uff01");
            args.setCancel(true);
            return;
        }
        DynamicObject ppxxRow = model.getEntryRowEntity("yem_pa_cxppph_ppxx", selectRows[0]);
        BigDecimal psaleqty = ppxxRow.getBigDecimal("yem_qty");
        DynamicObjectCollection kppkcEntry = model.getEntryEntity("yem_pa_cxppph_kppkc");
        BigDecimal sumThismatchqtyk = BigDecimal.ZERO;
        for (DynamicObject kppkcRow : kppkcEntry) {
            sumThismatchqtyk = sumThismatchqtyk.add(kppkcRow.getBigDecimal("yem_thismatchqtyk"));
        }
        if (sumThismatchqtyk.compareTo(psaleqty) > 0) {
            view.showErrorNotification("\u6240\u9009\u672c\u6b21\u5339\u914d\u5e93\u5b58\u6570\u91cf\u5927\u4e8e\u9500\u552e\u6570\u91cf\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5!");
            args.setCancel(true);
        }
    }

    private void creatPpxxInfo(DynamicObject dataEntity, IDataModel model, Map<Integer, Long> entryMap, String name, DynamicObject yemPaCxppdjpzPpwd) {
        ArrayList<Integer> keysList = new ArrayList<Integer>(entryMap.keySet());
        if (null == keysList) {
            return;
        }
        Iterator iterator = keysList.iterator();
        while (iterator.hasNext()) {
            DynamicObject bill2;
            int key = (Integer)iterator.next();
            MatchInventoryUtils matchInventoryUtils = new MatchInventoryUtils();
            List<DynamicObject> billlist = MatchInventoryUtils.queryMatchRelation(false, name, (Long)dataEntity.getPkValue(), entryMap.get(key));
            if (billlist.size() > 1) {
                for (DynamicObject bill2 : billlist) {
                    int seq = model.createNewEntryRow("yem_pa_cxppph_ppxx");
                    this.setYemPaCxppdjpzPpwd(yemPaCxppdjpzPpwd, model, key, seq, dataEntity, 0L, "");
                    this.matchedInfo(bill2, model, seq, "", "yem_newmatchqty");
                }
                continue;
            }
            int seq = model.createNewEntryRow("yem_pa_cxppph_ppxx");
            this.setYemPaCxppdjpzPpwd(yemPaCxppdjpzPpwd, model, key, seq, dataEntity, 0L, "");
            if (billlist.size() != 1) continue;
            bill2 = billlist.get(0);
            this.matchedInfo(bill2, model, seq, "", "yem_newmatchqty");
        }
    }

    private Map<Long, Integer> creatMatchedResults(Map<Long, BigDecimal> addrow, Map<Integer, Long> entryMap) {
        HashMap<Long, Integer> matchedResults = new HashMap<Long, Integer>();
        block0: for (Map.Entry<Long, BigDecimal> addEntry : addrow.entrySet()) {
            Long addKey = addEntry.getKey();
            for (Map.Entry<Integer, Long> entry : entryMap.entrySet()) {
                if (!entry.getValue().equals(addKey)) continue;
                matchedResults.put(addKey, entry.getKey());
                continue block0;
            }
        }
        return matchedResults;
    }

    private Map<Long, BigDecimal> addrow(IDataModel model) {
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> maps = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> resultMap = new HashMap<Long, BigDecimal>();
        DynamicObjectCollection entryPpxx = model.getDataEntity(true).getDynamicObjectCollection("yem_pa_cxppph_ppxx");
        for (DynamicObject ppxx : entryPpxx) {
            long yemNodebillrowid = ppxx.getLong("yem_billentryid");
            BigDecimal qty = ppxx.getBigDecimal("yem_pqty");
            BigDecimal psaleqty = ppxx.getBigDecimal("yem_qty");
            maps.put(yemNodebillrowid, psaleqty);
            map.merge(yemNodebillrowid, qty, BigDecimal::add);
            if (qty.compareTo(BigDecimal.ZERO) <= 0) continue;
            model.setValue("yem_qty", (Object)qty, entryPpxx.indexOf((Object)ppxx));
        }
        for (Map.Entry entry : maps.entrySet()) {
            Long key = (Long)entry.getKey();
            BigDecimal psaleQty = (BigDecimal)entry.getValue();
            BigDecimal mapQty = map.getOrDefault(key, BigDecimal.ZERO);
            if (mapQty.compareTo(BigDecimal.ZERO) == 0 || psaleQty.subtract(mapQty).compareTo(BigDecimal.ZERO) == 0) continue;
            resultMap.put(key, psaleQty.subtract(mapQty));
        }
        return resultMap;
    }

    private void setYemPaCxppdjpzPpwd(DynamicObject yemPaInventorybills, IDataModel model, int i, int seq, DynamicObject dataEntity, long yemProcurebillrowid, String k) {
        List<Object> entityFieldKeyList = new ArrayList();
        if (StringUtils.isEmpty((String)k)) {
            entityFieldKeyList = DistributionBillPlugin.getEntityFieldKeyList("yem_pa_distribution", "yem_pa_cxppph_ppxx", null);
        } else if ("k".equals(k)) {
            entityFieldKeyList = DistributionBillPlugin.getEntityFieldKeyList("yem_pa_distribution", "yem_pa_cxppph_kppkc", null);
        }
        HashMap<String, String> fieldnum = new HashMap<String, String>();
        fieldnum.put(yemPaInventorybills.getString("yem_qtyfiledkeys"), "yem_qty" + k);
        fieldnum.put(yemPaInventorybills.getString("yem_srcnum"), "yem_srcbillkey_s" + k);
        fieldnum.put(yemPaInventorybills.getString("yem_srcbillnonum"), "yem_srcbillno_s" + k);
        fieldnum.put(yemPaInventorybills.getString("yem_srcidnum"), "yem_srcbillid_s" + k);
        fieldnum.put(yemPaInventorybills.getString("yem_srcentityidnum"), "yem_srcbillentryid_s" + k);
        fieldnum.put(yemPaInventorybills.getString("yem_mainbillnum"), "yem_mainbillkey_s" + k);
        fieldnum.put(yemPaInventorybills.getString("yem_mainbillnonum"), "yem_mainbillno_s" + k);
        fieldnum.put(yemPaInventorybills.getString("yem_mainbillidnum"), "yem_mainbillid_s" + k);
        fieldnum.put(yemPaInventorybills.getString("yem_maientityidnum"), "yem_mainbillentryid_s" + k);
        for (DynamicObject dynamicObject : yemPaInventorybills.getDynamicObjectCollection("yem_pa_cxppdjpz_ppwd")) {
            String yemQentityfieldid = dynamicObject.getString("yem_entityfieldid");
            String fieldkey = dynamicObject.getDynamicObject("yem_matchfieldlib").getString("number") + k;
            fieldnum.put(yemQentityfieldid, fieldkey);
        }
        for (String entityfield : fieldnum.keySet()) {
            String lastPart;
            String[] split = entityfield.split("\\.");
            String firstPart = split.length > 0 ? split[0] : null;
            String string = lastPart = split.length > 0 ? split[split.length - 1] : null;
            String fieldkey = (String)fieldnum.get(entityfield);
            if (!entityFieldKeyList.contains(fieldkey)) continue;
            if (!firstPart.equals(lastPart)) {
                DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection(firstPart);
                if (yemProcurebillrowid != 0L) {
                    i = this.getSuffix(entry, yemProcurebillrowid);
                }
                DynamicObject row = (DynamicObject)entry.get(i);
                model.setValue(fieldkey, row.get(lastPart), seq);
            }
            if (!firstPart.equals(lastPart)) continue;
            model.setValue(fieldkey, dataEntity.get(lastPart), seq);
        }
    }

    private int getSuffix(DynamicObjectCollection entry, Long longs) {
        int index = 0;
        for (DynamicObject dynamicObject : entry) {
            long id = dynamicObject.getLong("id");
            if (id != longs) continue;
            index = (Integer)dynamicObject.get("seq") - 1;
        }
        return index;
    }

    private Map<Integer, Long> getindex(IFormView View, DynamicObject yemPaInventorybills) {
        IDataModel model = View.getModel();
        String yemMatchentry = yemPaInventorybills.getString("yem_matchentry");
        EntryGrid control = (EntryGrid)View.getControl(yemMatchentry);
        if (null == control) {
            return null;
        }
        int[] selectRows = control.getSelectRows();
        HashMap<Integer, Long> map = new HashMap<Integer, Long>();
        DynamicObjectCollection entry = model.getDataEntity(true).getDynamicObjectCollection(yemMatchentry);
        ArrayList seqList = new ArrayList();
        if (selectRows.length == 0) {
            for (DynamicObject row : entry) {
                int i = row.getInt("seq") - 1;
                long id = row.getLong("id");
                map.put(i, id);
            }
            selectRows = seqList.stream().mapToInt(Integer::intValue).toArray();
        } else {
            for (int selectRow : selectRows) {
                long id = ((DynamicObject)entry.get(selectRow)).getLong("id");
                map.put(selectRow, id);
            }
            selectRows = seqList.stream().mapToInt(Integer::intValue).toArray();
        }
        return map;
    }

    private void queryUpstreamMatchQty(int row, BigDecimal yemReversaqty) {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entryPpxx = dataEntity.getDynamicObjectCollection("yem_pa_cxppph_ppxx");
        DynamicObjectCollection entryKppxx = dataEntity.getDynamicObjectCollection("yem_pa_cxppph_kppkc");
        DynamicObjectCollection entrySdsf = dataEntity.getDynamicObjectCollection("yem_pa_cxppph_sdsf");
        DynamicObject ppxx = (DynamicObject)entryPpxx.get(row);
        String yemSrcbillkey = ppxx.getString("yem_srcbillkey_s");
        Long yemSrcbillid = ppxx.getLong("yem_srcbillid_s");
        Long yemSrcentryid = ppxx.getLong("yem_srcbillentryid_s");
        MatchInventoryUtils matchInventoryUtils = new MatchInventoryUtils();
        List<DynamicObject> upstreamMatch = MatchInventoryUtils.queryMatchRelation(false, yemSrcbillkey, yemSrcbillid, yemSrcentryid);
        for (DynamicObject match : upstreamMatch) {
            int seq = model.createNewEntryRow("yem_pa_cxppph_kppkc");
            long yemProcurebillrowid = match.getLong("yem_procurebillrowid");
            long yemProcurebillid = match.getLong("yem_procurebillid");
            DynamicObject yemProcurebill = match.getDynamicObject("yem_procurebill");
            DynamicObject yemPaInventorybills = BusinessDataServiceHelper.loadSingle((String)"yem_pa_inventorybills", (QFilter[])new QFilter("id", "=", yemProcurebill.getPkValue()).toArray());
            String number = yemPaInventorybills.getString("number");
            DynamicObject purdataEntity = BusinessDataServiceHelper.loadSingle((String)number, (QFilter[])new QFilter("id", "=", (Object)yemProcurebillid).toArray());
            this.setYemPaCxppdjpzPpwd(yemPaInventorybills, model, 0, seq, purdataEntity, yemProcurebillrowid, "k");
            this.matchedInfo(match, model, seq, "k", "yem_newmatchqty");
            model.setValue("yem_inventorydatatype", (Object)"A", seq);
            if (yemReversaqty.compareTo(BigDecimal.ZERO) <= 0) continue;
            model.setValue("yem_qtyk", (Object)yemReversaqty, seq);
        }
    }

    private void Excludematchedinventory(DynamicObjectCollection entryPpxx, DynamicObjectCollection entryKppxx, DynamicObjectCollection entrySdsf) {
        HashMap<Long, BigDecimal> qtmap = new HashMap<Long, BigDecimal>();
        ArrayList<Integer> deleteRowList = new ArrayList<Integer>();
        HashSet<Long> haveSet = new HashSet<Long>();
        for (Object ppxx : entryPpxx) {
            BigDecimal yemPqty = ppxx.getBigDecimal("yem_pqty");
            long yemMainbillentryidp = ppxx.getLong("yem_procurebillrowid");
            String billName = this.getView().getParentView().getEntityId();
            Long billid = (Long)this.getView().getParentView().getModel().getValue("id");
            long billentryid = ppxx.getLong("yem_billentryid");
            List<DynamicObject> matchRelation = MatchInventoryUtils.queryMatchRelation(false, billName, billid, billentryid);
            for (DynamicObject relationSingle : matchRelation) {
                long procurebillrowid = relationSingle.getLong("yem_procurebillrowid");
                if (haveSet.contains(procurebillrowid)) continue;
                haveSet.add(procurebillrowid);
                BigDecimal existingValue2 = qtmap.getOrDefault(procurebillrowid, BigDecimal.ZERO);
                qtmap.put(procurebillrowid, existingValue2.subtract(relationSingle.getBigDecimal("yem_newmatchqty")));
            }
            if (qtmap.containsKey(yemMainbillentryidp)) {
                qtmap.compute(yemMainbillentryidp, (k, existingValue) -> existingValue.add(yemPqty));
                continue;
            }
            qtmap.put(yemMainbillentryidp, yemPqty);
        }
        HashMap<Long, BigDecimal> tjmap = new HashMap<Long, BigDecimal>();
        for (DynamicObject sdsf : entrySdsf) {
            BigDecimal yemPqty = sdsf.getBigDecimal("yem_reversaqty");
            long yemMainbillentryidp = sdsf.getLong("yem_matchingid");
            if (tjmap.containsKey(yemMainbillentryidp)) {
                BigDecimal existingValue3 = (BigDecimal)tjmap.get(yemMainbillentryidp);
                tjmap.put(yemMainbillentryidp, existingValue3.add(yemPqty));
                continue;
            }
            tjmap.put(yemMainbillentryidp, yemPqty);
        }
        for (DynamicObject kppxx : entryKppxx) {
            BigDecimal yemQtyk;
            int i = entryKppxx.indexOf((Object)kppxx);
            String type = kppxx.getString("yem_inventorydatatype");
            if ("B".equals(type)) {
                for (Long id : qtmap.keySet()) {
                    if (id.longValue() != kppxx.getLong("yem_procurebillrowidk")) continue;
                    yemQtyk = kppxx.getBigDecimal("yem_qtyk").subtract((BigDecimal)qtmap.get(id));
                    if (yemQtyk.compareTo(BigDecimal.ZERO) > 0) {
                        this.getModel().setValue("yem_qtyk", (Object)yemQtyk, i);
                        continue;
                    }
                    deleteRowList.add(i);
                }
            }
            if (!"A".equals(type)) continue;
            for (Long id : tjmap.keySet()) {
                if (id.longValue() != kppxx.getLong("yem_matchidk")) continue;
                yemQtyk = kppxx.getBigDecimal("yem_qtyk").subtract((BigDecimal)tjmap.get(id));
                if (yemQtyk.compareTo(BigDecimal.ZERO) > 0) {
                    this.getModel().setValue("yem_qtyk", (Object)yemQtyk, i);
                    continue;
                }
                deleteRowList.add(i);
            }
        }
        for (int i = deleteRowList.size() - 1; i >= 0; --i) {
            this.getModel().deleteEntryRow("yem_pa_cxppph_kppkc", ((Integer)deleteRowList.get(i)).intValue());
        }
    }

    private void matchedInfo(DynamicObject bill, IDataModel model, int i, String k, String qty) {
        if ("".equals(k)) {
            model.setValue("yem_pqty" + k, (Object)bill.getBigDecimal(qty), i);
            model.setValue("yem_pwarehouse" + k, (Object)bill.getDynamicObject("yem_warehouse"), i);
            model.setValue("yem_mainbillid_p" + k, (Object)bill.getLong("yem_mainbillid_p"), i);
            model.setValue("yem_mainbillentryid_p" + k, (Object)bill.getLong("yem_mainbillentryid_p"), i);
            model.setValue("yem_srcbillkey_p" + k, (Object)bill.getString("yem_srcbillkey_p"), i);
            model.setValue("yem_srcbillid_p" + k, (Object)bill.getLong("yem_srcbillid_p"), i);
            model.setValue("yem_srcbillno_p" + k, (Object)bill.getString("yem_srcbillno_p"), i);
            model.setValue("yem_srcbillentryid_p" + k, (Object)bill.getLong("yem_srcbillentryid_p"), i);
        }
        if ("k".equals(k)) {
            model.setValue("yem_qty" + k, (Object)bill.getBigDecimal(qty), i);
            model.setValue("yem_warehouse" + k, (Object)bill.getDynamicObject("yem_warehouse"), i);
            model.setValue("yem_mainbillid" + k, (Object)bill.getLong("yem_mainbillid_p"), i);
            model.setValue("yem_mainbillentryid" + k, (Object)bill.getLong("yem_mainbillentryid_p"), i);
        }
        model.setValue("yem_mainbillkey_p" + k, (Object)bill.getString("yem_mainbillkey_p"), i);
        model.setValue("yem_businessnode_p" + k, (Object)bill.getDynamicObject("yem_businessnode_p"), i);
        model.setValue("yem_batchno" + k, (Object)bill.getString("yem_batchno"), i);
        model.setValue("yem_mainbillno_p" + k, (Object)bill.getString("yem_mainbillno_p"), i);
        model.setValue("yem_procurebillno" + k, (Object)bill.getString("yem_procurebillno"), i);
        model.setValue("yem_procurebill" + k, (Object)bill.getDynamicObject("yem_procurebill"), i);
        model.setValue("yem_procurebillid" + k, (Object)bill.getLong("yem_procurebillid"), i);
        model.setValue("yem_procurebillrowid" + k, (Object)bill.getLong("yem_procurebillrowid"), i);
        model.setValue("yem_matchid" + k, (Object)bill.getLong("id"), i);
    }

    private void sodeDocumentAss(IDataModel model, DynamicObject yemPaInventorybills, IDataModel parentmodel, DynamicObjectCollection yemPaCxppdjpzPpwd) {
        String name = parentmodel.getDataEntity(true).getDataEntityType().getName();
        DynamicObject inventorybill = BusinessDataServiceHelper.loadSingle((String)"yem_pa_inventorybills", (QFilter[])new QFilter("number", "=", (Object)name).toArray());
        model.setValue("yem_nodeobject", (Object)name);
        model.setValue("yem_nodetype", (Object)yemPaInventorybills.getDynamicObject("group").getString("name"));
        model.setValue("yem_nodebillid", parentmodel.getValue("id"));
        model.setValue("yem_nodematchconfig", (Object)inventorybill);
        model.setValue("yem_businessnode", (Object)inventorybill.getDynamicObject("yem_inventorynode"));
        for (DynamicObject PaCxppdjpzPpwdrow : yemPaCxppdjpzPpwd) {
            int index = model.createNewEntryRow("yem_pa_cxppph_ppwd");
            model.setValue("yem_matchdimension", (Object)PaCxppdjpzPpwdrow.getDynamicObject("yem_matchfieldlib"), index);
            model.setValue("yem_key", (Object)PaCxppdjpzPpwdrow.getString("yem_entityfieldid"), index);
            model.setValue("yem_fieldtype", (Object)PaCxppdjpzPpwdrow.getString("yem_datatype"), index);
            model.setValue("yem_basedatatype", (Object)PaCxppdjpzPpwdrow.getDynamicObject("yem_basedatatype"), index);
            model.setValue("yem_isdimension", (Object)PaCxppdjpzPpwdrow.getBoolean("yem_isdimension"), index);
        }
    }

    public static List<String> getEntityFieldKeyList(String docEntityKey, String entryName, List<String> noUpFiles) {
        List<Object> resultList = new ArrayList();
        resultList = DynamicObjectUtil.addFieldKey((String)docEntityKey, (boolean)true);
        resultList = resultList.stream().filter(s -> s.contains(entryName)).collect(Collectors.toList());
        resultList = resultList.stream().map(s -> s.replace(entryName + ".", "")).collect(Collectors.toList());
        if (!YEM.isEmpty(noUpFiles)) {
            resultList = resultList.stream().filter(s -> !noUpFiles.contains(s)).collect(Collectors.toList());
        }
        return resultList.stream().filter(field -> !field.endsWith("_id")).collect(Collectors.toList());
    }

    private void checkInventory(BeforeDoOperationEventArgs e) {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("yem_pa_cxppph_ppxx");
        HashMap<String, Map<String, Long>> checkData = new HashMap<String, Map<String, Long>>();
        for (DynamicObject entity : entryEntity) {
            BigDecimal yemPqty;
            long yemMatchid = entity.getLong("yem_matchid");
            if (YEM.isNotEmpty((Object)yemMatchid) || YEM.isEmpty((Object)(yemPqty = entity.getBigDecimal("yem_pqty")))) continue;
            DynamicObject yemProcureBill = entity.getDynamicObject("yem_procurebill");
            Long yemProcureBillId = entity.getLong("yem_procurebillid");
            Long yemProcureBillRowId = entity.getLong("yem_procurebillrowid");
            if (YEM.isEmpty((Object)yemProcureBill) || YEM.isEmpty((Object)yemProcureBillId) || YEM.isEmpty((Object)yemProcureBillRowId)) continue;
            String mapKey = yemProcureBill.getString("number") + yemProcureBillId + yemProcureBillRowId;
            Map<String, Long> datas = new HashMap<String, String>();
            if (checkData.containsKey(mapKey)) {
                datas = (Map)checkData.get(mapKey);
            }
            datas.put("yemProcureBillKey", (Long)((Object)yemProcureBill.getString("number")));
            datas.put("yemProcureBillId", yemProcureBillId);
            datas.put("yemProcureBillRowId", yemProcureBillRowId);
            BigDecimal qty = BigDecimal.ZERO;
            if (datas.containsKey("qty")) {
                qty = (BigDecimal)datas.get("qty");
            }
            datas.put("qty", (Long)((Object)qty.add(yemPqty)));
            checkData.put(mapKey, datas);
            int i = entryEntity.indexOf((Object)entity);
            List<Integer> indexs = new ArrayList<Integer>();
            if (datas.containsKey("indexs")) {
                indexs = (List)datas.get("indexs");
            }
            indexs.add(i);
            datas.put("indexs", (Long)((Object)indexs));
            checkData.put(mapKey, datas);
        }
        Set checkDataKeys = checkData.keySet();
        ArrayList<String> rowIndex = new ArrayList<String>();
        for (String checkDataKey : checkDataKeys) {
            Long yemProcureBillRowId;
            Long yemProcureBillId;
            Map data = (Map)checkData.get(checkDataKey);
            BigDecimal qty = (BigDecimal)data.get("qty");
            String yemProcureBillKey = (String)data.get("yemProcureBillKey");
            Boolean availableInventory = MatchInventoryUtils.isAvailableInventory(yemProcureBillKey, yemProcureBillId = (Long)data.get("yemProcureBillId"), yemProcureBillRowId = (Long)data.get("yemProcureBillRowId"), qty);
            if (availableInventory.booleanValue()) continue;
            List indexs = (List)data.get("indexs");
            for (Integer index : indexs) {
                rowIndex.add(index + "");
            }
        }
        if (!rowIndex.isEmpty()) {
            e.setCancel(true);
            String join = String.join((CharSequence)"\u3001", rowIndex.toArray(new String[0]));
            view.showErrorNotification(String.format("\u5339\u914d\u4fe1\u606f\u7b2c%S \u884c\uff0c\u6240\u9009\u5e93\u5b58\u4fe1\u606f\u5df2\u88ab\u5176\u4ed6\u5355\u636e\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u53ef\u7528\u5e93\u5b58\uff01", join));
        }
    }

    private void confirmOp(AfterDoOperationEventArgs e) {
        OperationResult operationResult = e.getOperationResult();
        if (operationResult.isSuccess()) {
            Map<Long, BigDecimal> matchRelation = this.createMatchRelation();
            this.getView().returnDataToParent(matchRelation);
            this.getView().close();
        }
    }

    private Map<Long, BigDecimal> createMatchRelation() {
        OperationResult saveResult;
        OperationResult deleteResult;
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>();
        IDataModel model = this.getView().getModel();
        DynamicObject yemNodeMatchConfig = (DynamicObject)model.getValue("yem_nodematchconfig");
        String yemNodeObject = (String)model.getValue("yem_nodeobject");
        Long yemNodeBillId = (Long)model.getValue("yem_nodebillid");
        DynamicObject yemBusinessnode = (DynamicObject)model.getValue("yem_businessnode");
        DynamicObjectCollection entryEntity = model.getEntryEntity("yem_pa_cxppph_ppxx");
        HashMap data = new HashMap();
        for (DynamicObject entity : entryEntity) {
            long yemBillentryid = entity.getLong("yem_billentryid");
            ArrayList<DynamicObject> list = data.containsKey(yemBillentryid) ? (List)data.get(yemBillentryid) : new ArrayList<DynamicObject>();
            list.add(entity);
            data.put(yemBillentryid, list);
            BigDecimal yemPqty = entity.getBigDecimal("yem_pqty");
            if (result.containsKey(yemBillentryid)) {
                BigDecimal qty = (BigDecimal)result.get(yemBillentryid);
                result.put(yemBillentryid, qty.add(yemPqty));
                continue;
            }
            result.put(yemBillentryid, yemPqty);
        }
        DynamicObjectCollection releaseEntry = model.getEntryEntity("yem_pa_cxppph_sdsf");
        HashMap<Long, Object> release = new HashMap<Long, Object>();
        for (DynamicObject entry : releaseEntry) {
            long yemNodeBillEntryId = entry.getLong("yem_nodebillentryid");
            List<Object> list = release.containsKey(yemNodeBillEntryId) ? (List)release.get(yemNodeBillEntryId) : new ArrayList<DynamicObject>();
            list.add(entry);
            release.put(yemNodeBillEntryId, list);
        }
        ArrayList<DynamicObject> delMatchRelation = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> saveMatchRelation = new ArrayList<DynamicObject>();
        Set billEntryIds = data.keySet();
        List<String> yemPaDistribution = DistributionBillPlugin.getEntityFieldKeyList("yem_pa_distribution", "yem_pa_cxppph_ppxx", null);
        for (Long billEntryId : billEntryIds) {
            Object entryDatum2;
            List<DynamicObject> matchRelations = MatchInventoryUtils.queryMatchRelation(false, yemNodeMatchConfig.getString("number"), yemNodeBillId, billEntryId);
            delMatchRelation.addAll(matchRelations);
            List entryData = (List)data.get(billEntryId);
            HashMap<String, Object> entry = new HashMap<String, Object>();
            for (Object entryDatum2 : entryData) {
                DynamicObject yemProcureBill = entryDatum2.getDynamicObject("yem_procurebill");
                long yemProcurebillId = entryDatum2.getLong("yem_procurebillid");
                long yemProcureBillRowId = entryDatum2.getLong("yem_procurebillrowid");
                if (YEM.isEmpty((Object)yemProcureBill) || YEM.isEmpty((Object)yemProcureBillRowId) || YEM.isEmpty((Object)yemProcurebillId)) continue;
                String key = yemProcureBill.getString("number") + yemProcurebillId + yemProcureBillRowId;
                if (entry.containsKey(key)) {
                    DynamicObject object = (DynamicObject)entry.get(key);
                    BigDecimal yem_pqty = entryDatum2.getBigDecimal("yem_pqty");
                    BigDecimal yemPqty = object.getBigDecimal("yem_pqty");
                    object.set("yem_pqty", (Object)yem_pqty.add(yemPqty));
                    entry.put(key, object);
                    continue;
                }
                entry.put(key, entryDatum2);
            }
            Set entryKey = entry.keySet();
            entryDatum2 = entryKey.iterator();
            while (entryDatum2.hasNext()) {
                String s = (String)entryDatum2.next();
                DynamicObject object = (DynamicObject)entry.get(s);
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("yem_salebill", yemNodeMatchConfig);
                param.put("yem_department", model.getValue("yem_department"));
                param.put("yem_salebillno", this.getView().getParentView().getModel().getValue("billno"));
                param.put("yem_salebillid", yemNodeBillId);
                param.put("yem_salebillrowid", billEntryId);
                param.put("yem_businessnode_s", yemBusinessnode);
                for (String filedKey : yemPaDistribution) {
                    param.put(filedKey, object.get(filedKey));
                }
                DynamicObject xs = MatchInventoryUtils.createMatchRelation(param, "XS", "\u7528\u6237\u624b\u52a8\u5339\u914d\u3002");
                saveMatchRelation.add(xs);
            }
            if (!release.containsKey(billEntryId)) continue;
            List releaseData = (List)release.get(billEntryId);
            HashMap<Long, BigDecimal> releaseMap = new HashMap<Long, BigDecimal>();
            for (DynamicObject releaseDatum : releaseData) {
                long yemMatchingid = releaseDatum.getLong("yem_matchingid");
                BigDecimal qty = BigDecimal.ZERO;
                if (releaseMap.containsKey(yemMatchingid)) {
                    qty = (BigDecimal)releaseMap.get(yemMatchingid);
                }
                qty = qty.add(releaseDatum.getBigDecimal("yem_reversaqty"));
                releaseMap.put(yemMatchingid, qty);
            }
            Set matchingids = releaseMap.keySet();
            for (Long matchingid : matchingids) {
                BigDecimal qtys = (BigDecimal)releaseMap.get(matchingid);
                DynamicObject minusMatchRelation = MatchInventoryUtils.createMinusMatchRelation(false, matchingid, qtys, yemNodeObject, yemNodeBillId, billEntryId, "\u7528\u6237\u624b\u52a8\u5339\u914d\u3002");
                saveMatchRelation.add(minusMatchRelation);
            }
        }
        if (!delMatchRelation.isEmpty() && !(deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"yem_pa_matchrelation", (Object[])delMatchRelation.stream().map(DataEntityBase::getPkValue).toArray(), (OperateOption)OperateOption.create())).isSuccess()) {
            return null;
        }
        if (!saveMatchRelation.isEmpty() && !(saveResult = SaveServiceHelper.saveOperate((String)"save", (String)"yem_pa_matchrelation", (DynamicObject[])saveMatchRelation.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create())).isSuccess()) {
            return null;
        }
        return result;
    }

    private void availableStockMatchCheck(BeforeDoOperationEventArgs args) {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        DynamicObjectCollection ppxxEntry = model.getEntryEntity("yem_pa_cxppph_ppxx");
        Optional<BigDecimal> pqty = ppxxEntry.stream().map(row -> row.getBigDecimal("yem_pqty")).reduce(BigDecimal::add);
        if (pqty.isPresent() && pqty.get().compareTo(BigDecimal.ZERO) > 0) {
            return;
        }
        view.showTipNotification("\u8bf7\u5339\u914d\u53ef\u7528\u5e93\u5b58\uff01");
        args.setCancel(true);
    }

    private class EntryData {
        int index;
        BigDecimal quantity;
        BigDecimal qty;

        EntryData(int index, BigDecimal quantity, BigDecimal qty) {
            this.index = index;
            this.quantity = quantity;
            this.qty = qty;
        }
    }
}

